//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentImageError_h
#define _id3DocumentImageError_h

#include <id3Document/id3DocumentExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates possible error codes related to image management.
 */
typedef enum id3DocumentImageError {
	/**
	 * No error.
	 */
	id3DocumentImageError_Success = 0,
	/**
	 * The given buffer is too small.
	 */
	id3DocumentImageError_InsufficientBuffer = -1,
	/**
	 * The requested object does not exist; a 'null' should be returned if possible.
	 */
	id3DocumentImageError_ObjectDoesNotExist = -2,
	/**
	 * Base error code for Image module.
	 */
	id3DocumentImageError_Base = -3000,
	/**
	 * Minimum error code for Image module.
	 */
	id3DocumentImageError_Minimum = -3999,
	/**
	 * The handle is invalid.
	 */
	id3DocumentImageError_InvalidHandle = -3001,
	/**
	 * The parameter is invalid.
	 */
	id3DocumentImageError_InvalidParameter = -3002,
	/**
	 * The image sizes are not compatible for the requested operation.
	 */
	id3DocumentImageError_ImageSizeMismatch = -3003,
	/**
	 * The pixel formats are not compatible.
	 */
	id3DocumentImageError_PixelFormatMismatch = -3004,
	/**
	 * The given key is already used in the dictionary. Multiple values per key is not supported.
	 */
	id3DocumentImageError_KeyAlreadyExists = -3005,
	/**
	 * The given key is not present in the dictionary.
	 */
	id3DocumentImageError_KeyNotFound = -3006,
	/**
	 * The required pixel format is not correct.
	 */
	id3DocumentImageError_InvalidPixelFormat = -3007,
	/**
	 * An error as occured during python module initialization.
	 */
	id3DocumentImageError_PythonModule = -3008,
	/**
	 * Function not implemented.
	 */
	id3DocumentImageError_FunctionNotImplemented = -3009,
	/**
	 * TODO
	 */
	id3DocumentImageError_BackendError = -3010,
} id3DocumentImageError;

ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetImageErrorString(int value);
ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetImageErrorMessage(int value);

#ifdef __cplusplus
}
#endif

#endif
