//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentMrzType_h
#define _id3DocumentMrzType_h

#include <id3Document/id3DocumentExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates supported MRZ types.
 */
typedef enum id3DocumentMrzType {
	/**
	 * No MRZ. Default value.
	 */
	id3DocumentMrzType_None = 0,
	/**
	 * Document TD1 (ICAO 9303-5) - 3x30 lines MRZ.
	 */
	id3DocumentMrzType_Td1 = 1,
	/**
	 * Document TD2 (ICAO 9303-6) - 2x36 lines MRZ.
	 */
	id3DocumentMrzType_Td2 = 2,
	/**
	 * Document TD3 (Passports)(ICAO 9303-4) - 2x44 lines MRZ.
	 */
	id3DocumentMrzType_Td3 = 3,
	/**
	 * Driving licence (ISO-18013) - 1x30 line MRZ.
	 */
	id3DocumentMrzType_DrivingLicense = 4,
	/**
	 * Visa format A (ICAO 9303-7) - 2x44 lines MRZ.
	 */
	id3DocumentMrzType_MrvA = 5,
	/**
	 * Visa format B (ICAO 9303-7) - 2x36 lines MRZ.
	 */
	id3DocumentMrzType_MrvB = 6,
	/**
	 * Other MRZ Type, with a standard layout but unknown content.
	 */
	id3DocumentMrzType_Other = 100,
	/**
	 * Old french ID card (PRADO FRA-BO-02002). 2x36 lines MRZ.
	 */
	id3DocumentMrzType_FrenchId = 101,
} id3DocumentMrzType;

ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetMrzTypeString(int value);

#ifdef __cplusplus
}
#endif

#endif
