# Release notes

## Version 2.1.2 (2024-11-29)
- Fixed occasional crashes in DocumentReader

## Version 2.1.1 (2024-11-15)
- Fix AlignDocument not setting the Pixel Format 
- Catched misc OpenCV Exceptions and raise BackendError
- [Python] Added Python 3.10 package on Windows and Linux
- [Windows] Fixed ``cudart.dll`` dependency (which fixes [Python] ``ImportError: Missing DLL``)
- Internal tools update (codegen 3.38, image 3.13.1)

## Version 2.1.0 (2024-07-12)
**API changes**
- Added detailed options in ``ProcessingUnit`` enum for specific backends.

**New features**
- Automatic model selection (among those loaded) in all modules, removing the need to call `SetProcessingUnit` or ``SetModel``.
- Improvements of OCR algorithms
- New builds available for different new GPU backends: 
   - Windows/Linux : default (OpenCL) & CUDA
   - Android : default (CPU Only) & GPU (OpenCL, Vulkan)
   - Apple : default (Metal)
- All models now available for GPU use. Warning : This is experimental, some models might be unstable on some backends.
- Internal tools update (codegen 3.36.4, image 3.8.1)

**Bug fixes**
- Fixed minor bugs in DocumentReader 

## Version 2.0.1 (2023-12-22)
- Fixed invalidDocumentTemplateFormat error when loading documents templates for detector 2B.
- Fixed sporadic crash in DocumentReader

## Version 2.0.0 (2023-12-21)
- New unified multi-language documentation
- Python support added
- Swift support enhanced

**New features**

   - Model `DocumentDetector1B` renamed to `2A`
   - New fastest detector model `2B` for edge applications
   - New OCR model `2A`, faster and better
   - Deprecated model `DocumentDetector1A` removed
   - Deprecated model `MRZReader1A` removed
   - New organisation and naming for Document Templates

**API Changes**
   - `License` module renamed `DocumentLicense`.
   - `DocumentLibrary` license methods removed.
   - `DocumentLibrary.getVersionEx()` method added.
   - `Image` renamed `DocumentImage`.
   - `ReferenceDocument` renamed `DocumentTemplate`.
   - `DocumentPose` renamed `DocumentOrientation`.
   - `DocumentDetector.DetectAndClassifyDocument()` renamed `DetectDocument()`.
   - `DocumentDetector.DetectDocument()` renamed `DetectDocumentByName()`.
   - `DocumentInfo` class added.
   - `DocumentCategory` enumeration added.
   - `DocumentFormat` enumeration added.
   - Internal updates license v8.6.1, codegen v3.24.0 and image v3.7.1.
    
## Version 1.1.2 (2023-08-24)
- Added pattern correction for OCR
- Added field rotation [+90°, -90°, 180°] for OCR
- Internal tools update (codegen 3.21.1)


## Version 1.1.1 (2023-08-02)
- Fixed bugs in DocumentDetector
- Fixed bug when loading concatenated document template
- Updated new Python wrapper
- Fixed TextField bounds not implemented


## Version 1.1.0 (2023-06-19)
- Added Optical Character Recognition (OCR) feature
   - Added new model OCR v1A for latin alphabet and digits
   - Added module DocumentReader to read text fields on a document image


## Version 1.0.2 (2023-05-11)
- Internal tools update (codegen 3.13.1)

## Version 1.0.1 (2023-01-27)
- Fixed MRZ validity check for TD1 type with long document numbers


## Version 1.0.0 (2022-12-21)
- Initial release.
