library id3_document;

// %export-begin%
export 'src/image_buffer.dart';
export 'src/point_list.dart';
export 'src/detected_document.dart';
export 'src/document_detector.dart';
export 'src/document_reader.dart';
export 'src/document_image.dart';
export 'src/document_license.dart';
export 'src/document_library.dart';
export 'src/document_info_dictionary.dart';
export 'src/text_field_list.dart';
export 'src/text_field.dart';
export 'src/mrz_helper.dart';
export 'src/mrz_reader.dart';
export 'src/document_authenticator.dart';
export 'src/hologram_authentication_result_list.dart';
export 'src/hologram_authentication_result.dart';
export 'src/string_dict.dart';
export 'src/string_list.dart';
export 'src/mrz_reading_result.dart';
export 'src/document_info.dart';
export 'src/image_error.dart';
export 'src/image_format.dart';
export 'src/pixel_format.dart';
export 'src/license_hardware_code_type.dart';
export 'src/license_type.dart';
export 'src/license_error.dart';
export 'src/document_error.dart';
export 'src/processing_unit.dart';
export 'src/document_model.dart';
export 'src/document_format.dart';
export 'src/document_category.dart';
export 'src/mrz_type.dart';
export 'src/document_exception.dart';
export 'src/point.dart';
export 'src/rectangle.dart';
export 'src/document_orientation.dart';
export 'src/lib_version.dart';
// %export-end%

import 'dart:ffi';
import 'dart:math';
import 'dart:typed_data';

extension ArrayIntFill<T> on Array<Int32> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as int;
    }
  }

  List<int> toList(int length) {
    final list = List<int>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return list;
  }
}

extension ArrayLongFill<T> on Array<Int64> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as int;
    }
  }

  List<int> toList(int length) {
    final list = List<int>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return list;
  }
}

extension ArrayInt8Fill<T> on Array<Int8> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as int;
    }
  }

  Int8List toList(int length) {
    final list = List<int>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return Int8List.fromList(list);
  }
}

extension ArrayUInt8Fill<T> on Array<Uint8> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as int;
    }
  }

  Uint8List toList(int length) {
    final list = List<int>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return Uint8List.fromList(list);
  }
}

extension ArrayFloat32Fill<T> on Array<Float> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as double;
    }
  }

  List<double> toList(int length) {
    final list = List<double>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return list;
  }
}
