//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates document categories.
enum DocumentCategory {
	/// Unknown document category.
	unknown,
	/// Passport
	A,
	/// Identity card
	B,
	/// Visa
	C,
	/// Stamp
	D,
	/// Entry paper
	E,
	/// Driving licence
	F,
	/// Vehicle licence/ log book
	G,
	/// Residence-related document
	H,
	/// Seafarers' identity document
	I,
	/// Travel document issued to non-nationals
	J,
	/// Train driving licence
	K,
	/// Crew member certificate / pilot's licence
	L,
	/// Certificate for operators of pleasure crafts / captain's licence
	M,
	/// Civil status/ other official document
	P,
	/// Special authorisation card
	S,
	/// Travel document
	T,
	/// Authorisation to represent a company
	V,
	/// Work permit
	W,
	/// Other document
	X,
}

extension DocumentCategoryX on DocumentCategory {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created DocumentCategory.
  	static DocumentCategory fromValue(int value) {
    	switch (value) {
      	case 0:
        	return DocumentCategory.unknown;
      	case 1:
        	return DocumentCategory.A;
      	case 2:
        	return DocumentCategory.B;
      	case 3:
        	return DocumentCategory.C;
      	case 4:
        	return DocumentCategory.D;
      	case 5:
        	return DocumentCategory.E;
      	case 6:
        	return DocumentCategory.F;
      	case 7:
        	return DocumentCategory.G;
      	case 8:
        	return DocumentCategory.H;
      	case 9:
        	return DocumentCategory.I;
      	case 10:
        	return DocumentCategory.J;
      	case 11:
        	return DocumentCategory.K;
      	case 12:
        	return DocumentCategory.L;
      	case 13:
        	return DocumentCategory.M;
      	case 14:
        	return DocumentCategory.P;
      	case 15:
        	return DocumentCategory.S;
      	case 16:
        	return DocumentCategory.T;
      	case 17:
        	return DocumentCategory.V;
      	case 18:
        	return DocumentCategory.W;
      	case 19:
        	return DocumentCategory.X;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case DocumentCategory.unknown:
        	return 0;
      	case DocumentCategory.A:
        	return 1;
      	case DocumentCategory.B:
        	return 2;
      	case DocumentCategory.C:
        	return 3;
      	case DocumentCategory.D:
        	return 4;
      	case DocumentCategory.E:
        	return 5;
      	case DocumentCategory.F:
        	return 6;
      	case DocumentCategory.G:
        	return 7;
      	case DocumentCategory.H:
        	return 8;
      	case DocumentCategory.I:
        	return 9;
      	case DocumentCategory.J:
        	return 10;
      	case DocumentCategory.K:
        	return 11;
      	case DocumentCategory.L:
        	return 12;
      	case DocumentCategory.M:
        	return 13;
      	case DocumentCategory.P:
        	return 14;
      	case DocumentCategory.S:
        	return 15;
      	case DocumentCategory.T:
        	return 16;
      	case DocumentCategory.V:
        	return 17;
      	case DocumentCategory.W:
        	return 18;
      	case DocumentCategory.X:
        	return 19;
		}
  	}
}
