import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'document_native.dart';

class DocumentException implements Exception {
  final int _errorCode;
	
  DocumentException(this._errorCode);

  int get errorCode => _errorCode;

  String get message {
    final Pointer<Utf8> messagePtr = documentSDK.id3Document_GetDocumentErrorMessage(_errorCode) as Pointer<Utf8>;
    if (messagePtr.address == 0) {
      return "Undefined error";
    }
    return messagePtr.toDartString();
  }
}
