//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates document formats, according to ISO/IEC 7810.
enum DocumentFormat {
	/// Unknown document format.
	unknown,
	/// A4 format document
	a4,
	/// ID-1 format. Specifies a size of 85.60 by 53.98 millimetres. This format is commonly used for most banking cards and ID cards.
	id1,
	/// ID-2 format. Specifies a size of 105 by 74 millimetres. This format is used for visas, Romanian and other ID cards. Visas. 
	id2,
	/// ID-3 format. Specifies a size of 125 by 88 millimetres. This format is commonly used for passport booklets.
	id3,
}

extension DocumentFormatX on DocumentFormat {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created DocumentFormat.
  	static DocumentFormat fromValue(int value) {
    	switch (value) {
      	case 0:
        	return DocumentFormat.unknown;
      	case 1:
        	return DocumentFormat.a4;
      	case 2:
        	return DocumentFormat.id1;
      	case 3:
        	return DocumentFormat.id2;
      	case 4:
        	return DocumentFormat.id3;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case DocumentFormat.unknown:
        	return 0;
      	case DocumentFormat.a4:
        	return 1;
      	case DocumentFormat.id1:
        	return 2;
      	case DocumentFormat.id2:
        	return 3;
      	case DocumentFormat.id3:
        	return 4;
		}
  	}
}
