//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates the AI models available in this SDK.
enum DocumentModel {
	/// Document detector 2A. Best accuracy model.
	documentDetector2A,
	/// Document detector 2B. Fast detector for low-end mobiles.
	documentDetector2B,
	/// MRZ Reader 2A. Stand-alone reader (no document detection needed).
	mrzReader2A,
	/// OCR (Optical Character Recognition) model 2A for reading text fields in latin alphabet and digits.
	ocrLatin2A,
}

extension DocumentModelX on DocumentModel {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created DocumentModel.
  	static DocumentModel fromValue(int value) {
    	switch (value) {
      	case 1001:
        	return DocumentModel.documentDetector2A;
      	case 1002:
        	return DocumentModel.documentDetector2B;
      	case 1102:
        	return DocumentModel.mrzReader2A;
      	case 1202:
        	return DocumentModel.ocrLatin2A;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case DocumentModel.documentDetector2A:
        	return 1001;
      	case DocumentModel.documentDetector2B:
        	return 1002;
      	case DocumentModel.mrzReader2A:
        	return 1102;
      	case DocumentModel.ocrLatin2A:
        	return 1202;
		}
  	}
}
