// AUTO GENERATED FILE, DO NOT EDIT.
//
// Generated by `package:ffigen`.
// ignore_for_file: type=lint
import 'dart:ffi' as ffi;

class DocumentSDK {
  /// Holds the symbol lookup function.
  final ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
      _lookup;

  /// The symbols are looked up in [dynamicLibrary].
  DocumentSDK(ffi.DynamicLibrary dynamicLibrary)
      : _lookup = dynamicLibrary.lookup;

  /// The symbols are looked up with [lookup].
  DocumentSDK.fromLookup(
      ffi.Pointer<T> Function<T extends ffi.NativeType>(String symbolName)
          lookup)
      : _lookup = lookup;

  /// @brief Initializes a PointList object.
  /// @param phPointList [in] Handle to the PointList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentPointList_Initialize(
    ffi.Pointer<ID3_DOCUMENT_POINT_LIST> phPointList,
  ) {
    return _id3DocumentPointList_Initialize(
      phPointList,
    );
  }

  late final _id3DocumentPointList_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_POINT_LIST>)>>(
      'id3DocumentPointList_Initialize');
  late final _id3DocumentPointList_Initialize =
      _id3DocumentPointList_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_POINT_LIST>)>();

  /// @brief Releases the memory allocated for a PointList.
  /// @param phPointList [in] Handle to the PointList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentPointList_Dispose(
    ffi.Pointer<ID3_DOCUMENT_POINT_LIST> phPointList,
  ) {
    return _id3DocumentPointList_Dispose(
      phPointList,
    );
  }

  late final _id3DocumentPointList_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_POINT_LIST>)>>(
      'id3DocumentPointList_Dispose');
  late final _id3DocumentPointList_Dispose = _id3DocumentPointList_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_POINT_LIST>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hPointList [in] Handle to the PointList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentPointList_CheckHandle(
    ID3_DOCUMENT_POINT_LIST hPointList,
  ) {
    return _id3DocumentPointList_CheckHandle(
      hPointList,
    );
  }

  late final _id3DocumentPointList_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_POINT_LIST)>>(
          'id3DocumentPointList_CheckHandle');
  late final _id3DocumentPointList_CheckHandle =
      _id3DocumentPointList_CheckHandlePtr
          .asFunction<int Function(ID3_DOCUMENT_POINT_LIST)>();

  /// @brief Copies an instance of PointList object to another.
  /// @param hPointListSrc [in] Handle to the source PointList object.
  /// @param hPointListDst [in] Handle to the destination PointList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentPointList_CopyTo(
    ID3_DOCUMENT_POINT_LIST hPointListSrc,
    ID3_DOCUMENT_POINT_LIST hPointListDst,
  ) {
    return _id3DocumentPointList_CopyTo(
      hPointListSrc,
      hPointListDst,
    );
  }

  late final _id3DocumentPointList_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_POINT_LIST,
              ID3_DOCUMENT_POINT_LIST)>>('id3DocumentPointList_CopyTo');
  late final _id3DocumentPointList_CopyTo =
      _id3DocumentPointList_CopyToPtr.asFunction<
          int Function(ID3_DOCUMENT_POINT_LIST, ID3_DOCUMENT_POINT_LIST)>();

  /// Clears the PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentPointList_Clear(
    ID3_DOCUMENT_POINT_LIST hPointList,
  ) {
    return _id3DocumentPointList_Clear(
      hPointList,
    );
  }

  late final _id3DocumentPointList_ClearPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_POINT_LIST)>>(
          'id3DocumentPointList_Clear');
  late final _id3DocumentPointList_Clear = _id3DocumentPointList_ClearPtr
      .asFunction<int Function(ID3_DOCUMENT_POINT_LIST)>();

  /// Adds an item to the PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @param sPointItem [in] Point item to add.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentPointList_Add(
    ID3_DOCUMENT_POINT_LIST hPointList,
    ffi.Pointer<id3DocumentPoint> sPointItem,
  ) {
    return _id3DocumentPointList_Add(
      hPointList,
      sPointItem,
    );
  }

  late final _id3DocumentPointList_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_POINT_LIST,
              ffi.Pointer<id3DocumentPoint>)>>('id3DocumentPointList_Add');
  late final _id3DocumentPointList_Add =
      _id3DocumentPointList_AddPtr.asFunction<
          int Function(
              ID3_DOCUMENT_POINT_LIST, ffi.Pointer<id3DocumentPoint>)>();

  /// Gets an item of the PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @param index [in] Index of the Point item to get.
  /// @param sPointItem [out] Point item to get.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentPointList_Get(
    ID3_DOCUMENT_POINT_LIST hPointList,
    int index,
    ffi.Pointer<id3DocumentPoint> sPointItem,
  ) {
    return _id3DocumentPointList_Get(
      hPointList,
      index,
      sPointItem,
    );
  }

  late final _id3DocumentPointList_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_POINT_LIST, ffi.Int,
              ffi.Pointer<id3DocumentPoint>)>>('id3DocumentPointList_Get');
  late final _id3DocumentPointList_Get =
      _id3DocumentPointList_GetPtr.asFunction<
          int Function(
              ID3_DOCUMENT_POINT_LIST, int, ffi.Pointer<id3DocumentPoint>)>();

  /// Sets an item of the PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @param index [in] Index of the Point item to set.
  /// @param sPointItem [in] Point item to set.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentPointList_Set(
    ID3_DOCUMENT_POINT_LIST hPointList,
    int index,
    ffi.Pointer<id3DocumentPoint> sPointItem,
  ) {
    return _id3DocumentPointList_Set(
      hPointList,
      index,
      sPointItem,
    );
  }

  late final _id3DocumentPointList_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_POINT_LIST, ffi.Int,
              ffi.Pointer<id3DocumentPoint>)>>('id3DocumentPointList_Set');
  late final _id3DocumentPointList_Set =
      _id3DocumentPointList_SetPtr.asFunction<
          int Function(
              ID3_DOCUMENT_POINT_LIST, int, ffi.Pointer<id3DocumentPoint>)>();

  /// Gets the number of elements in the PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @param count [out] Number of elements in the Point object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentPointList_GetCount(
    ID3_DOCUMENT_POINT_LIST hPointList,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3DocumentPointList_GetCount(
      hPointList,
      count,
    );
  }

  late final _id3DocumentPointList_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_POINT_LIST,
              ffi.Pointer<ffi.Int>)>>('id3DocumentPointList_GetCount');
  late final _id3DocumentPointList_GetCount =
      _id3DocumentPointList_GetCountPtr.asFunction<
          int Function(ID3_DOCUMENT_POINT_LIST, ffi.Pointer<ffi.Int>)>();

  /// Removes an element of the PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @param index [in] Index of the Point item to remove.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentPointList_RemoveAt(
    ID3_DOCUMENT_POINT_LIST hPointList,
    int index,
  ) {
    return _id3DocumentPointList_RemoveAt(
      hPointList,
      index,
    );
  }

  late final _id3DocumentPointList_RemoveAtPtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_DOCUMENT_POINT_LIST, ffi.Int)>>(
      'id3DocumentPointList_RemoveAt');
  late final _id3DocumentPointList_RemoveAt = _id3DocumentPointList_RemoveAtPtr
      .asFunction<int Function(ID3_DOCUMENT_POINT_LIST, int)>();

  /// PointList object.
  /// @param hPointList [in] Handle to the PointList object.
  /// @param newSize [in] Point object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentPointList_Resize(
    ID3_DOCUMENT_POINT_LIST hPointList,
    int newSize,
  ) {
    return _id3DocumentPointList_Resize(
      hPointList,
      newSize,
    );
  }

  late final _id3DocumentPointList_ResizePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_DOCUMENT_POINT_LIST, ffi.Int)>>(
      'id3DocumentPointList_Resize');
  late final _id3DocumentPointList_Resize = _id3DocumentPointList_ResizePtr
      .asFunction<int Function(ID3_DOCUMENT_POINT_LIST, int)>();

  ffi.Pointer<ffi.Char> id3Document_GetDocumentCategoryString(
    int value,
  ) {
    return _id3Document_GetDocumentCategoryString(
      value,
    );
  }

  late final _id3Document_GetDocumentCategoryStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetDocumentCategoryString');
  late final _id3Document_GetDocumentCategoryString =
      _id3Document_GetDocumentCategoryStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Document_GetDocumentFormatString(
    int value,
  ) {
    return _id3Document_GetDocumentFormatString(
      value,
    );
  }

  late final _id3Document_GetDocumentFormatStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetDocumentFormatString');
  late final _id3Document_GetDocumentFormatString =
      _id3Document_GetDocumentFormatStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Document_GetMrzTypeString(
    int value,
  ) {
    return _id3Document_GetMrzTypeString(
      value,
    );
  }

  late final _id3Document_GetMrzTypeStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetMrzTypeString');
  late final _id3Document_GetMrzTypeString = _id3Document_GetMrzTypeStringPtr
      .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a DocumentInfo object.
  /// @param phDocumentInfo [in] Handle to the DocumentInfo object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfo_Initialize(
    ffi.Pointer<ID3_DOCUMENT_INFO> phDocumentInfo,
  ) {
    return _id3DocumentInfo_Initialize(
      phDocumentInfo,
    );
  }

  late final _id3DocumentInfo_InitializePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_INFO>)>>(
      'id3DocumentInfo_Initialize');
  late final _id3DocumentInfo_Initialize = _id3DocumentInfo_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_INFO>)>();

  /// @brief Releases the memory allocated for a DocumentInfo.
  /// @param phDocumentInfo [in] Handle to the DocumentInfo object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfo_Dispose(
    ffi.Pointer<ID3_DOCUMENT_INFO> phDocumentInfo,
  ) {
    return _id3DocumentInfo_Dispose(
      phDocumentInfo,
    );
  }

  late final _id3DocumentInfo_DisposePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_INFO>)>>(
      'id3DocumentInfo_Dispose');
  late final _id3DocumentInfo_Dispose = _id3DocumentInfo_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_INFO>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hDocumentInfo [in] Handle to the DocumentInfo object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfo_CheckHandle(
    ID3_DOCUMENT_INFO hDocumentInfo,
  ) {
    return _id3DocumentInfo_CheckHandle(
      hDocumentInfo,
    );
  }

  late final _id3DocumentInfo_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_INFO)>>(
          'id3DocumentInfo_CheckHandle');
  late final _id3DocumentInfo_CheckHandle = _id3DocumentInfo_CheckHandlePtr
      .asFunction<int Function(ID3_DOCUMENT_INFO)>();

  /// @brief Copies an instance of DocumentInfo object to another.
  /// @param hDocumentInfoSrc [in] Handle to the source DocumentInfo object.
  /// @param hDocumentInfoDst [in] Handle to the destination DocumentInfo object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfo_CopyTo(
    ID3_DOCUMENT_INFO hDocumentInfoSrc,
    ID3_DOCUMENT_INFO hDocumentInfoDst,
  ) {
    return _id3DocumentInfo_CopyTo(
      hDocumentInfoSrc,
      hDocumentInfoDst,
    );
  }

  late final _id3DocumentInfo_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_INFO, ID3_DOCUMENT_INFO)>>('id3DocumentInfo_CopyTo');
  late final _id3DocumentInfo_CopyTo = _id3DocumentInfo_CopyToPtr
      .asFunction<int Function(ID3_DOCUMENT_INFO, ID3_DOCUMENT_INFO)>();

  /// Gets the the document category.
  /// @param hDocumentInfo [in] Handle to the DocumentInfo object.
  /// @param eCategory [out] The document category.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfo_GetCategory(
    ID3_DOCUMENT_INFO hDocumentInfo,
    ffi.Pointer<ffi.Int32> eCategory,
  ) {
    return _id3DocumentInfo_GetCategory(
      hDocumentInfo,
      eCategory,
    );
  }

  late final _id3DocumentInfo_GetCategoryPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO,
              ffi.Pointer<ffi.Int32>)>>('id3DocumentInfo_GetCategory');
  late final _id3DocumentInfo_GetCategory = _id3DocumentInfo_GetCategoryPtr
      .asFunction<int Function(ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Int32>)>();

  /// Gets the the ISO 3166-1 alpha-3 code identifying the country issuing the document.
  /// @param hDocumentInfo [in] Handle to the DocumentInfo object.
  /// @param country [out] The ISO 3166-1 alpha-3 code identifying the country issuing the document.
  /// @param countrySize [in,out] Size of the 'country' buffer. Receives the minimum required buffer size to hold the 'country' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'country' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfo_GetCountry(
    ID3_DOCUMENT_INFO hDocumentInfo,
    ffi.Pointer<ffi.Char> country,
    ffi.Pointer<ffi.Int> countrySize,
  ) {
    return _id3DocumentInfo_GetCountry(
      hDocumentInfo,
      country,
      countrySize,
    );
  }

  late final _id3DocumentInfo_GetCountryPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentInfo_GetCountry');
  late final _id3DocumentInfo_GetCountry =
      _id3DocumentInfo_GetCountryPtr.asFunction<
          int Function(ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>();

  /// Gets the the document's date of first issue, in the form `YYYY-MM-DD`.
  /// @param hDocumentInfo [in] Handle to the DocumentInfo object.
  /// @param date [out] The document's date of first issue, in the form `YYYY-MM-DD`.
  /// @param dateSize [in,out] Size of the 'date' buffer. Receives the minimum required buffer size to hold the 'date' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'date' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfo_GetDate(
    ID3_DOCUMENT_INFO hDocumentInfo,
    ffi.Pointer<ffi.Char> date,
    ffi.Pointer<ffi.Int> dateSize,
  ) {
    return _id3DocumentInfo_GetDate(
      hDocumentInfo,
      date,
      dateSize,
    );
  }

  late final _id3DocumentInfo_GetDatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentInfo_GetDate');
  late final _id3DocumentInfo_GetDate = _id3DocumentInfo_GetDatePtr.asFunction<
      int Function(
          ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Gets the the document description.
  /// @param hDocumentInfo [in] Handle to the DocumentInfo object.
  /// @param description [out] The document description.
  /// @param descriptionSize [in,out] Size of the 'description' buffer. Receives the minimum required buffer size to hold the 'description' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'description' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfo_GetDescription(
    ID3_DOCUMENT_INFO hDocumentInfo,
    ffi.Pointer<ffi.Char> description,
    ffi.Pointer<ffi.Int> descriptionSize,
  ) {
    return _id3DocumentInfo_GetDescription(
      hDocumentInfo,
      description,
      descriptionSize,
    );
  }

  late final _id3DocumentInfo_GetDescriptionPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentInfo_GetDescription');
  late final _id3DocumentInfo_GetDescription =
      _id3DocumentInfo_GetDescriptionPtr.asFunction<
          int Function(ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>();

  /// Gets the the document format.
  /// @param hDocumentInfo [in] Handle to the DocumentInfo object.
  /// @param eFormat [out] The document format.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfo_GetFormat(
    ID3_DOCUMENT_INFO hDocumentInfo,
    ffi.Pointer<ffi.Int32> eFormat,
  ) {
    return _id3DocumentInfo_GetFormat(
      hDocumentInfo,
      eFormat,
    );
  }

  late final _id3DocumentInfo_GetFormatPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO,
              ffi.Pointer<ffi.Int32>)>>('id3DocumentInfo_GetFormat');
  late final _id3DocumentInfo_GetFormat = _id3DocumentInfo_GetFormatPtr
      .asFunction<int Function(ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Int32>)>();

  /// Gets the the document identifier.
  /// @param hDocumentInfo [in] Handle to the DocumentInfo object.
  /// @param identifier [out] The document identifier.
  /// @param identifierSize [in,out] Size of the 'identifier' buffer. Receives the minimum required buffer size to hold the 'identifier' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'identifier' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfo_GetIdentifier(
    ID3_DOCUMENT_INFO hDocumentInfo,
    ffi.Pointer<ffi.Char> identifier,
    ffi.Pointer<ffi.Int> identifierSize,
  ) {
    return _id3DocumentInfo_GetIdentifier(
      hDocumentInfo,
      identifier,
      identifierSize,
    );
  }

  late final _id3DocumentInfo_GetIdentifierPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentInfo_GetIdentifier');
  late final _id3DocumentInfo_GetIdentifier =
      _id3DocumentInfo_GetIdentifierPtr.asFunction<
          int Function(ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>();

  /// Gets the the type of machine-readable zone (MRZ), if applicable.
  /// @param hDocumentInfo [in] Handle to the DocumentInfo object.
  /// @param eMrzType [out] The type of machine-readable zone (MRZ), if applicable.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfo_GetMrzType(
    ID3_DOCUMENT_INFO hDocumentInfo,
    ffi.Pointer<ffi.Int32> eMrzType,
  ) {
    return _id3DocumentInfo_GetMrzType(
      hDocumentInfo,
      eMrzType,
    );
  }

  late final _id3DocumentInfo_GetMrzTypePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO,
              ffi.Pointer<ffi.Int32>)>>('id3DocumentInfo_GetMrzType');
  late final _id3DocumentInfo_GetMrzType = _id3DocumentInfo_GetMrzTypePtr
      .asFunction<int Function(ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Int32>)>();

  /// Gets the the document type name.
  /// @param hDocumentInfo [in] Handle to the DocumentInfo object.
  /// @param name [out] The document type name.
  /// @param nameSize [in,out] Size of the 'name' buffer. Receives the minimum required buffer size to hold the 'name' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'name' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfo_GetName(
    ID3_DOCUMENT_INFO hDocumentInfo,
    ffi.Pointer<ffi.Char> name,
    ffi.Pointer<ffi.Int> nameSize,
  ) {
    return _id3DocumentInfo_GetName(
      hDocumentInfo,
      name,
      nameSize,
    );
  }

  late final _id3DocumentInfo_GetNamePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentInfo_GetName');
  late final _id3DocumentInfo_GetName = _id3DocumentInfo_GetNamePtr.asFunction<
      int Function(
          ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Gets the the page number of the document.
  /// @param hDocumentInfo [in] Handle to the DocumentInfo object.
  /// @param pageNumber [out] The page number of the document.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfo_GetPageNumber(
    ID3_DOCUMENT_INFO hDocumentInfo,
    ffi.Pointer<ffi.Int> pageNumber,
  ) {
    return _id3DocumentInfo_GetPageNumber(
      hDocumentInfo,
      pageNumber,
    );
  }

  late final _id3DocumentInfo_GetPageNumberPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO,
              ffi.Pointer<ffi.Int>)>>('id3DocumentInfo_GetPageNumber');
  late final _id3DocumentInfo_GetPageNumber = _id3DocumentInfo_GetPageNumberPtr
      .asFunction<int Function(ID3_DOCUMENT_INFO, ffi.Pointer<ffi.Int>)>();

  /// @brief Initializes a DetectedDocument object.
  /// @param phDetectedDocument [in] Handle to the DetectedDocument object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DetectedDocument_Initialize(
    ffi.Pointer<ID3_DETECTED_DOCUMENT> phDetectedDocument,
  ) {
    return _id3DetectedDocument_Initialize(
      phDetectedDocument,
    );
  }

  late final _id3DetectedDocument_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DETECTED_DOCUMENT>)>>(
      'id3DetectedDocument_Initialize');
  late final _id3DetectedDocument_Initialize =
      _id3DetectedDocument_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_DETECTED_DOCUMENT>)>();

  /// @brief Releases the memory allocated for a DetectedDocument.
  /// @param phDetectedDocument [in] Handle to the DetectedDocument object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DetectedDocument_Dispose(
    ffi.Pointer<ID3_DETECTED_DOCUMENT> phDetectedDocument,
  ) {
    return _id3DetectedDocument_Dispose(
      phDetectedDocument,
    );
  }

  late final _id3DetectedDocument_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DETECTED_DOCUMENT>)>>(
      'id3DetectedDocument_Dispose');
  late final _id3DetectedDocument_Dispose = _id3DetectedDocument_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_DETECTED_DOCUMENT>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hDetectedDocument [in] Handle to the DetectedDocument object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DetectedDocument_CheckHandle(
    ID3_DETECTED_DOCUMENT hDetectedDocument,
  ) {
    return _id3DetectedDocument_CheckHandle(
      hDetectedDocument,
    );
  }

  late final _id3DetectedDocument_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DETECTED_DOCUMENT)>>(
          'id3DetectedDocument_CheckHandle');
  late final _id3DetectedDocument_CheckHandle =
      _id3DetectedDocument_CheckHandlePtr
          .asFunction<int Function(ID3_DETECTED_DOCUMENT)>();

  /// @brief Copies an instance of DetectedDocument object to another.
  /// @param hDetectedDocumentSrc [in] Handle to the source DetectedDocument object.
  /// @param hDetectedDocumentDst [in] Handle to the destination DetectedDocument object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DetectedDocument_CopyTo(
    ID3_DETECTED_DOCUMENT hDetectedDocumentSrc,
    ID3_DETECTED_DOCUMENT hDetectedDocumentDst,
  ) {
    return _id3DetectedDocument_CopyTo(
      hDetectedDocumentSrc,
      hDetectedDocumentDst,
    );
  }

  late final _id3DetectedDocument_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_DOCUMENT,
              ID3_DETECTED_DOCUMENT)>>('id3DetectedDocument_CopyTo');
  late final _id3DetectedDocument_CopyTo = _id3DetectedDocument_CopyToPtr
      .asFunction<int Function(ID3_DETECTED_DOCUMENT, ID3_DETECTED_DOCUMENT)>();

  /// Gets the boundaries of the document detected, in the following order: top-left, top-right, bottom-right, bottom-left.
  /// @param hDetectedDocument [in] Handle to the DetectedDocument object.
  /// @param hBounds [out] Boundaries of the document detected, in the following order: top-left, top-right, bottom-right, bottom-left.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DetectedDocument_GetBounds(
    ID3_DETECTED_DOCUMENT hDetectedDocument,
    ID3_DOCUMENT_POINT_LIST hBounds,
  ) {
    return _id3DetectedDocument_GetBounds(
      hDetectedDocument,
      hBounds,
    );
  }

  late final _id3DetectedDocument_GetBoundsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_DOCUMENT,
              ID3_DOCUMENT_POINT_LIST)>>('id3DetectedDocument_GetBounds');
  late final _id3DetectedDocument_GetBounds =
      _id3DetectedDocument_GetBoundsPtr.asFunction<
          int Function(ID3_DETECTED_DOCUMENT, ID3_DOCUMENT_POINT_LIST)>();

  /// Sets the boundaries of the document detected, in the following order: top-left, top-right, bottom-right, bottom-left.
  /// @param hDetectedDocument [in] Handle to the DetectedDocument object.
  /// @param hBounds [in] Boundaries of the document detected, in the following order: top-left, top-right, bottom-right, bottom-left.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DetectedDocument_SetBounds(
    ID3_DETECTED_DOCUMENT hDetectedDocument,
    ID3_DOCUMENT_POINT_LIST hBounds,
  ) {
    return _id3DetectedDocument_SetBounds(
      hDetectedDocument,
      hBounds,
    );
  }

  late final _id3DetectedDocument_SetBoundsPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_DOCUMENT,
              ID3_DOCUMENT_POINT_LIST)>>('id3DetectedDocument_SetBounds');
  late final _id3DetectedDocument_SetBounds =
      _id3DetectedDocument_SetBoundsPtr.asFunction<
          int Function(ID3_DETECTED_DOCUMENT, ID3_DOCUMENT_POINT_LIST)>();

  /// Gets the confidence score of the detected document, from 0 to 100.
  /// @param hDetectedDocument [in] Handle to the DetectedDocument object.
  /// @param confidence [out] Confidence score of the detected document, from 0 to 100.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DetectedDocument_GetConfidence(
    ID3_DETECTED_DOCUMENT hDetectedDocument,
    ffi.Pointer<ffi.Int> confidence,
  ) {
    return _id3DetectedDocument_GetConfidence(
      hDetectedDocument,
      confidence,
    );
  }

  late final _id3DetectedDocument_GetConfidencePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_DOCUMENT,
              ffi.Pointer<ffi.Int>)>>('id3DetectedDocument_GetConfidence');
  late final _id3DetectedDocument_GetConfidence =
      _id3DetectedDocument_GetConfidencePtr.asFunction<
          int Function(ID3_DETECTED_DOCUMENT, ffi.Pointer<ffi.Int>)>();

  /// Gets the document information.
  /// @param hDetectedDocument [in] Handle to the DetectedDocument object.
  /// @param hInfo [out] Document information.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DetectedDocument_GetInfo(
    ID3_DETECTED_DOCUMENT hDetectedDocument,
    ID3_DOCUMENT_INFO hInfo,
  ) {
    return _id3DetectedDocument_GetInfo(
      hDetectedDocument,
      hInfo,
    );
  }

  late final _id3DetectedDocument_GetInfoPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DETECTED_DOCUMENT,
              ID3_DOCUMENT_INFO)>>('id3DetectedDocument_GetInfo');
  late final _id3DetectedDocument_GetInfo = _id3DetectedDocument_GetInfoPtr
      .asFunction<int Function(ID3_DETECTED_DOCUMENT, ID3_DOCUMENT_INFO)>();

  /// Gets the document orientation in source image. [0,0,0] means the document is in front of the camera.
  /// @param hDetectedDocument [in] Handle to the DetectedDocument object.
  /// @param sOrientation [out] Document orientation in source image. [0,0,0] means the document is in front of the camera.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DetectedDocument_GetOrientation(
    ID3_DETECTED_DOCUMENT hDetectedDocument,
    ffi.Pointer<id3DocumentOrientation> sOrientation,
  ) {
    return _id3DetectedDocument_GetOrientation(
      hDetectedDocument,
      sOrientation,
    );
  }

  late final _id3DetectedDocument_GetOrientationPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DETECTED_DOCUMENT, ffi.Pointer<id3DocumentOrientation>)>>(
      'id3DetectedDocument_GetOrientation');
  late final _id3DetectedDocument_GetOrientation =
      _id3DetectedDocument_GetOrientationPtr.asFunction<
          int Function(
              ID3_DETECTED_DOCUMENT, ffi.Pointer<id3DocumentOrientation>)>();

  ffi.Pointer<ffi.Char> id3Document_GetPixelFormatString(
    int value,
  ) {
    return _id3Document_GetPixelFormatString(
      value,
    );
  }

  late final _id3Document_GetPixelFormatStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetPixelFormatString');
  late final _id3Document_GetPixelFormatString =
      _id3Document_GetPixelFormatStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Document_GetImageFormatString(
    int value,
  ) {
    return _id3Document_GetImageFormatString(
      value,
    );
  }

  late final _id3Document_GetImageFormatStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetImageFormatString');
  late final _id3Document_GetImageFormatString =
      _id3Document_GetImageFormatStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a ImageBuffer object.
  /// @param phImageBuffer [in] Handle to the ImageBuffer object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImageBuffer_Initialize(
    ffi.Pointer<ID3_DOCUMENT_IMAGE_BUFFER> phImageBuffer,
  ) {
    return _id3DocumentImageBuffer_Initialize(
      phImageBuffer,
    );
  }

  late final _id3DocumentImageBuffer_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_IMAGE_BUFFER>)>>(
      'id3DocumentImageBuffer_Initialize');
  late final _id3DocumentImageBuffer_Initialize =
      _id3DocumentImageBuffer_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_IMAGE_BUFFER>)>();

  /// @brief Releases the memory allocated for a ImageBuffer.
  /// @param phImageBuffer [in] Handle to the ImageBuffer object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImageBuffer_Dispose(
    ffi.Pointer<ID3_DOCUMENT_IMAGE_BUFFER> phImageBuffer,
  ) {
    return _id3DocumentImageBuffer_Dispose(
      phImageBuffer,
    );
  }

  late final _id3DocumentImageBuffer_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_IMAGE_BUFFER>)>>(
      'id3DocumentImageBuffer_Dispose');
  late final _id3DocumentImageBuffer_Dispose =
      _id3DocumentImageBuffer_DisposePtr
          .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_IMAGE_BUFFER>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hImageBuffer [in] Handle to the ImageBuffer object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImageBuffer_CheckHandle(
    ID3_DOCUMENT_IMAGE_BUFFER hImageBuffer,
  ) {
    return _id3DocumentImageBuffer_CheckHandle(
      hImageBuffer,
    );
  }

  late final _id3DocumentImageBuffer_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_IMAGE_BUFFER)>>(
          'id3DocumentImageBuffer_CheckHandle');
  late final _id3DocumentImageBuffer_CheckHandle =
      _id3DocumentImageBuffer_CheckHandlePtr
          .asFunction<int Function(ID3_DOCUMENT_IMAGE_BUFFER)>();

  /// @brief Copies an instance of ImageBuffer object to another.
  /// @param hImageBufferSrc [in] Handle to the source ImageBuffer object.
  /// @param hImageBufferDst [in] Handle to the destination ImageBuffer object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImageBuffer_CopyTo(
    ID3_DOCUMENT_IMAGE_BUFFER hImageBufferSrc,
    ID3_DOCUMENT_IMAGE_BUFFER hImageBufferDst,
  ) {
    return _id3DocumentImageBuffer_CopyTo(
      hImageBufferSrc,
      hImageBufferDst,
    );
  }

  late final _id3DocumentImageBuffer_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE_BUFFER,
              ID3_DOCUMENT_IMAGE_BUFFER)>>('id3DocumentImageBuffer_CopyTo');
  late final _id3DocumentImageBuffer_CopyTo =
      _id3DocumentImageBuffer_CopyToPtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE_BUFFER, ID3_DOCUMENT_IMAGE_BUFFER)>();

  /// Gets the image buffer data.
  /// @param hImageBuffer [in] Handle to the ImageBuffer object.
  /// @param data [out] Data of the image buffer object.
  /// @param dataSize [in,out] Size of the 'data' buffer. Receives the number of elements in the 'data' array.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImageBuffer_GetData(
    ID3_DOCUMENT_IMAGE_BUFFER hImageBuffer,
    ffi.Pointer<ffi.UnsignedChar> data,
    ffi.Pointer<ffi.Int> dataSize,
  ) {
    return _id3DocumentImageBuffer_GetData(
      hImageBuffer,
      data,
      dataSize,
    );
  }

  late final _id3DocumentImageBuffer_GetDataPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_IMAGE_BUFFER,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentImageBuffer_GetData');
  late final _id3DocumentImageBuffer_GetData =
      _id3DocumentImageBuffer_GetDataPtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE_BUFFER, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// Gets a pointer to the pixels of the image. Unsafe! The user must handle the pixels pointer carefully.
  /// @param hImageBuffer [in] Handle to the ImageBuffer object.
  /// @param pixels [out] Pointer to the pixels of the image.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImageBuffer_GetPixels(
    ID3_DOCUMENT_IMAGE_BUFFER hImageBuffer,
    ffi.Pointer<ffi.Pointer<ffi.Void>> pixels,
  ) {
    return _id3DocumentImageBuffer_GetPixels(
      hImageBuffer,
      pixels,
    );
  }

  late final _id3DocumentImageBuffer_GetPixelsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_IMAGE_BUFFER,
                  ffi.Pointer<ffi.Pointer<ffi.Void>>)>>(
      'id3DocumentImageBuffer_GetPixels');
  late final _id3DocumentImageBuffer_GetPixels =
      _id3DocumentImageBuffer_GetPixelsPtr.asFunction<
          int Function(
              ID3_DOCUMENT_IMAGE_BUFFER, ffi.Pointer<ffi.Pointer<ffi.Void>>)>();

  /// @brief Initializes a DocumentImage object.
  /// @param phDocumentImage [in] Handle to the DocumentImage object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_Initialize(
    ffi.Pointer<ID3_DOCUMENT_IMAGE> phDocumentImage,
  ) {
    return _id3DocumentImage_Initialize(
      phDocumentImage,
    );
  }

  late final _id3DocumentImage_InitializePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_IMAGE>)>>(
      'id3DocumentImage_Initialize');
  late final _id3DocumentImage_Initialize = _id3DocumentImage_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_IMAGE>)>();

  /// @brief Releases the memory allocated for a DocumentImage.
  /// @param phDocumentImage [in] Handle to the DocumentImage object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_Dispose(
    ffi.Pointer<ID3_DOCUMENT_IMAGE> phDocumentImage,
  ) {
    return _id3DocumentImage_Dispose(
      phDocumentImage,
    );
  }

  late final _id3DocumentImage_DisposePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_IMAGE>)>>(
      'id3DocumentImage_Dispose');
  late final _id3DocumentImage_Dispose = _id3DocumentImage_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_IMAGE>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_CheckHandle(
    ID3_DOCUMENT_IMAGE hDocumentImage,
  ) {
    return _id3DocumentImage_CheckHandle(
      hDocumentImage,
    );
  }

  late final _id3DocumentImage_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_IMAGE)>>(
          'id3DocumentImage_CheckHandle');
  late final _id3DocumentImage_CheckHandle = _id3DocumentImage_CheckHandlePtr
      .asFunction<int Function(ID3_DOCUMENT_IMAGE)>();

  /// @brief Copies an instance of DocumentImage object to another.
  /// @param hDocumentImageSrc [in] Handle to the source DocumentImage object.
  /// @param hDocumentImageDst [in] Handle to the destination DocumentImage object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_CopyTo(
    ID3_DOCUMENT_IMAGE hDocumentImageSrc,
    ID3_DOCUMENT_IMAGE hDocumentImageDst,
  ) {
    return _id3DocumentImage_CopyTo(
      hDocumentImageSrc,
      hDocumentImageDst,
    );
  }

  late final _id3DocumentImage_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE,
              ID3_DOCUMENT_IMAGE)>>('id3DocumentImage_CopyTo');
  late final _id3DocumentImage_CopyTo = _id3DocumentImage_CopyToPtr
      .asFunction<int Function(ID3_DOCUMENT_IMAGE, ID3_DOCUMENT_IMAGE)>();

  /// Gets the raw data buffer of the image.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param data [out] Raw data buffer of the image.
  /// @param dataSize [in,out] Size of the 'data' buffer. Receives the number of elements in the 'data' array.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_GetData(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<ffi.UnsignedChar> data,
    ffi.Pointer<ffi.Int> dataSize,
  ) {
    return _id3DocumentImage_GetData(
      hDocumentImage,
      data,
      dataSize,
    );
  }

  late final _id3DocumentImage_GetDataPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentImage_GetData');
  late final _id3DocumentImage_GetData =
      _id3DocumentImage_GetDataPtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// Gets the height in pixels.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param height [out] Height in pixels.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_GetHeight(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<ffi.Int> height,
  ) {
    return _id3DocumentImage_GetHeight(
      hDocumentImage,
      height,
    );
  }

  late final _id3DocumentImage_GetHeightPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Int>)>>('id3DocumentImage_GetHeight');
  late final _id3DocumentImage_GetHeight = _id3DocumentImage_GetHeightPtr
      .asFunction<int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.Int>)>();

  /// Gets the pixel depth.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param pixelDepth [out] Pixel depth.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_GetPixelDepth(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<ffi.Int> pixelDepth,
  ) {
    return _id3DocumentImage_GetPixelDepth(
      hDocumentImage,
      pixelDepth,
    );
  }

  late final _id3DocumentImage_GetPixelDepthPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Int>)>>('id3DocumentImage_GetPixelDepth');
  late final _id3DocumentImage_GetPixelDepth =
      _id3DocumentImage_GetPixelDepthPtr
          .asFunction<int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.Int>)>();

  /// Gets the pixel format.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param ePixelFormat [out] Pixel format.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_GetPixelFormat(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<ffi.Int32> ePixelFormat,
  ) {
    return _id3DocumentImage_GetPixelFormat(
      hDocumentImage,
      ePixelFormat,
    );
  }

  late final _id3DocumentImage_GetPixelFormatPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Int32>)>>('id3DocumentImage_GetPixelFormat');
  late final _id3DocumentImage_GetPixelFormat =
      _id3DocumentImage_GetPixelFormatPtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.Int32>)>();

  /// Gets the stride in bytes.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param stride [out] Stride in bytes.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_GetStride(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<ffi.Int> stride,
  ) {
    return _id3DocumentImage_GetStride(
      hDocumentImage,
      stride,
    );
  }

  late final _id3DocumentImage_GetStridePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Int>)>>('id3DocumentImage_GetStride');
  late final _id3DocumentImage_GetStride = _id3DocumentImage_GetStridePtr
      .asFunction<int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.Int>)>();

  /// Gets the width in pixels.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param width [out] Width in pixels.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_GetWidth(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<ffi.Int> width,
  ) {
    return _id3DocumentImage_GetWidth(
      hDocumentImage,
      width,
    );
  }

  late final _id3DocumentImage_GetWidthPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Int>)>>('id3DocumentImage_GetWidth');
  late final _id3DocumentImage_GetWidth = _id3DocumentImage_GetWidthPtr
      .asFunction<int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.Int>)>();

  /// Computes the difference with another image.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param hCmpDocumentImage [in] The image to compare.
  /// @param result [out] Comparison result in percent (0% is same, 100% is full different).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_Compare(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ID3_DOCUMENT_IMAGE hCmpDocumentImage,
    ffi.Pointer<ffi.Float> result,
  ) {
    return _id3DocumentImage_Compare(
      hDocumentImage,
      hCmpDocumentImage,
      result,
    );
  }

  late final _id3DocumentImage_ComparePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Float>)>>('id3DocumentImage_Compare');
  late final _id3DocumentImage_Compare =
      _id3DocumentImage_ComparePtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE, ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Float>)>();

  /// Applies a gamma correction to the image.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param contrast [in] Contrast coefficient, from -255 to 255, to be applied to the image.
  /// @param brightness [in] Brightness coefficient, from -255 to 255, to be applid to the image.
  /// @param gamma [in] Gamma coefficient, from 0.25 to 2.50, to be applied to the image.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_CorrectGamma(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    int contrast,
    int brightness,
    double gamma,
  ) {
    return _id3DocumentImage_CorrectGamma(
      hDocumentImage,
      contrast,
      brightness,
      gamma,
    );
  }

  late final _id3DocumentImage_CorrectGammaPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Int, ffi.Int,
              ffi.Float)>>('id3DocumentImage_CorrectGamma');
  late final _id3DocumentImage_CorrectGamma = _id3DocumentImage_CorrectGammaPtr
      .asFunction<int Function(ID3_DOCUMENT_IMAGE, int, int, double)>();

  /// Crop a rectangular region of interest in the image according to the given bounds.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param left [in] Left bound of the crop to extract.
  /// @param top [in] Top bound of the crop to extract.
  /// @param width [in] Width of the crop to extract.
  /// @param height [in] Height of the crop to extract.
  /// @param hDocumentImageCrop [out] The extracted region of interest.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_Crop(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    int left,
    int top,
    int width,
    int height,
    ID3_DOCUMENT_IMAGE hDocumentImageCrop,
  ) {
    return _id3DocumentImage_Crop(
      hDocumentImage,
      left,
      top,
      width,
      height,
      hDocumentImageCrop,
    );
  }

  late final _id3DocumentImage_CropPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Int, ffi.Int, ffi.Int,
              ffi.Int, ID3_DOCUMENT_IMAGE)>>('id3DocumentImage_Crop');
  late final _id3DocumentImage_Crop = _id3DocumentImage_CropPtr.asFunction<
      int Function(
          ID3_DOCUMENT_IMAGE, int, int, int, int, ID3_DOCUMENT_IMAGE)>();

  /// Downscales the image in-place so that its maximum dimension is equal to the given maximum size, while preserving the aspect ratio.
  /// Note: If the maximum dimension is already smaller than the given maximum size, the function does nothing and the scaling ration returned is 1.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param maxSize [in] Maximum image size, in pixels. The value must be greater than 0.
  /// @param scaleRatio [out] The scaling ratio applied to the image. Range is ]0:1].
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_Downscale(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    int maxSize,
    ffi.Pointer<ffi.Float> scaleRatio,
  ) {
    return _id3DocumentImage_Downscale(
      hDocumentImage,
      maxSize,
      scaleRatio,
    );
  }

  late final _id3DocumentImage_DownscalePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Int,
              ffi.Pointer<ffi.Float>)>>('id3DocumentImage_Downscale');
  late final _id3DocumentImage_Downscale =
      _id3DocumentImage_DownscalePtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE, int, ffi.Pointer<ffi.Float>)>();

  /// Downscales the image so that its maximum dimension equals the given maximum size, while preserving the aspect ratio.
  /// Note: If the maximum dimension is already smaller than the given maximum size, the function does nothing and the returned scale ratio is 1.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param hDstDocumentImage [in] Destination image.
  /// @param maxSize [in] Maximum image size, in pixels. The value must be greater than 0.
  /// @param scaleRatio [out] The scaling ratio applied to the image. Range is ]0:1].
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_DownscaleTo(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ID3_DOCUMENT_IMAGE hDstDocumentImage,
    int maxSize,
    ffi.Pointer<ffi.Float> scaleRatio,
  ) {
    return _id3DocumentImage_DownscaleTo(
      hDocumentImage,
      hDstDocumentImage,
      maxSize,
      scaleRatio,
    );
  }

  late final _id3DocumentImage_DownscaleToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ID3_DOCUMENT_IMAGE, ffi.Int,
              ffi.Pointer<ffi.Float>)>>('id3DocumentImage_DownscaleTo');
  late final _id3DocumentImage_DownscaleTo =
      _id3DocumentImage_DownscaleToPtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE, ID3_DOCUMENT_IMAGE, int,
              ffi.Pointer<ffi.Float>)>();

  /// Extracts a region of interest in the image according to the given bounds.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param sBounds [in] Bounds of the crop to extract.
  /// @param hDocumentImageRoi [out] The extracted region of interest.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_ExtractRoi(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<id3DocumentRectangle> sBounds,
    ID3_DOCUMENT_IMAGE hDocumentImageRoi,
  ) {
    return _id3DocumentImage_ExtractRoi(
      hDocumentImage,
      sBounds,
      hDocumentImageRoi,
    );
  }

  late final _id3DocumentImage_ExtractRoiPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_IMAGE,
              ffi.Pointer<id3DocumentRectangle>,
              ID3_DOCUMENT_IMAGE)>>('id3DocumentImage_ExtractRoi');
  late final _id3DocumentImage_ExtractRoi =
      _id3DocumentImage_ExtractRoiPtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<id3DocumentRectangle>,
              ID3_DOCUMENT_IMAGE)>();

  /// Extracts a region of interest in the image according to the given bounds.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param sBounds [in] Bounds of the crop to extract.
  /// @param colorRed [in] Background color red (from 0 to 255)
  /// @param colorGreen [in] Background color green (from 0 to 255)
  /// @param colorBlue [in] Background color blue (from 0 to 255)
  /// @param hDocumentImageRoi [out] The extracted region of interest.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_ExtractRoiWithColor(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<id3DocumentRectangle> sBounds,
    int colorRed,
    int colorGreen,
    int colorBlue,
    ID3_DOCUMENT_IMAGE hDocumentImageRoi,
  ) {
    return _id3DocumentImage_ExtractRoiWithColor(
      hDocumentImage,
      sBounds,
      colorRed,
      colorGreen,
      colorBlue,
      hDocumentImageRoi,
    );
  }

  late final _id3DocumentImage_ExtractRoiWithColorPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_IMAGE,
              ffi.Pointer<id3DocumentRectangle>,
              ffi.Int,
              ffi.Int,
              ffi.Int,
              ID3_DOCUMENT_IMAGE)>>('id3DocumentImage_ExtractRoiWithColor');
  late final _id3DocumentImage_ExtractRoiWithColor =
      _id3DocumentImage_ExtractRoiWithColorPtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<id3DocumentRectangle>,
              int, int, int, ID3_DOCUMENT_IMAGE)>();

  /// Flips the image in-place.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param flipHorizontally [in] Value indicating whether the image should be flipped horizontally.
  /// @param flipVertically [in] Value indicating whether the image should be flipped vertically.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_Flip(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    bool flipHorizontally,
    bool flipVertically,
  ) {
    return _id3DocumentImage_Flip(
      hDocumentImage,
      flipHorizontally,
      flipVertically,
    );
  }

  late final _id3DocumentImage_FlipPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Bool,
              ffi.Bool)>>('id3DocumentImage_Flip');
  late final _id3DocumentImage_Flip = _id3DocumentImage_FlipPtr
      .asFunction<int Function(ID3_DOCUMENT_IMAGE, bool, bool)>();

  /// Flips the image.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param flipHorizontally [in] Value indicating whether the image should be flipped horizontally.
  /// @param flipVertically [in] Value indicating whether the image should be flipped vertically.
  /// @param hDstDocumentImage [in] The destination Image object that receives the flipped image.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_FlipTo(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    bool flipHorizontally,
    bool flipVertically,
    ID3_DOCUMENT_IMAGE hDstDocumentImage,
  ) {
    return _id3DocumentImage_FlipTo(
      hDocumentImage,
      flipHorizontally,
      flipVertically,
      hDstDocumentImage,
    );
  }

  late final _id3DocumentImage_FlipToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Bool, ffi.Bool,
              ID3_DOCUMENT_IMAGE)>>('id3DocumentImage_FlipTo');
  late final _id3DocumentImage_FlipTo = _id3DocumentImage_FlipToPtr.asFunction<
      int Function(ID3_DOCUMENT_IMAGE, bool, bool, ID3_DOCUMENT_IMAGE)>();

  /// Creates an Image from the specified data buffer.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param data [in] A buffer that contains the image data.
  /// @param dataSize [in] Size of the 'data' buffer.
  /// @param ePixelFormat [in] The destination pixel format to convert the input to.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_FromBuffer(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<ffi.UnsignedChar> data,
    int dataSize,
    int ePixelFormat,
  ) {
    return _id3DocumentImage_FromBuffer(
      hDocumentImage,
      data,
      dataSize,
      ePixelFormat,
    );
  }

  late final _id3DocumentImage_FromBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int, ffi.Int32)>>('id3DocumentImage_FromBuffer');
  late final _id3DocumentImage_FromBuffer =
      _id3DocumentImage_FromBufferPtr.asFunction<
          int Function(
              ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.UnsignedChar>, int, int)>();

  /// Creates an Image from the specified file.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param filepath [in] A string that contains the name of the file from which to create the Image.
  /// @param ePixelFormat [in] The pixel format into which to convert the input image.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_FromFile(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<ffi.Char> filepath,
    int ePixelFormat,
  ) {
    return _id3DocumentImage_FromFile(
      hDocumentImage,
      filepath,
      ePixelFormat,
    );
  }

  late final _id3DocumentImage_FromFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.Char>,
              ffi.Int32)>>('id3DocumentImage_FromFile');
  late final _id3DocumentImage_FromFile =
      _id3DocumentImage_FromFilePtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.Char>, int)>();

  /// Creates an Image from the specified raw data buffer.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param pixels [in] A buffer that contains image pixels.
  /// @param pixelsSize [in] Size of the 'pixels' buffer.
  /// @param width [in] The width, in pixels, of the image.
  /// @param height [in] The height, in pixels, of the image.
  /// @param stride [in] The stride, in pixels, of the image.
  /// @param eSrcPixelFormat [in] The pixel format of the input image.
  /// @param eDstPixelFormat [in] The pixel format into which to convert the input image.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_FromRawBuffer(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<ffi.UnsignedChar> pixels,
    int pixelsSize,
    int width,
    int height,
    int stride,
    int eSrcPixelFormat,
    int eDstPixelFormat,
  ) {
    return _id3DocumentImage_FromRawBuffer(
      hDocumentImage,
      pixels,
      pixelsSize,
      width,
      height,
      stride,
      eSrcPixelFormat,
      eDstPixelFormat,
    );
  }

  late final _id3DocumentImage_FromRawBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int,
              ffi.Int,
              ffi.Int,
              ffi.Int,
              ffi.Int32,
              ffi.Int32)>>('id3DocumentImage_FromRawBuffer');
  late final _id3DocumentImage_FromRawBuffer =
      _id3DocumentImage_FromRawBufferPtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.UnsignedChar>, int,
              int, int, int, int, int)>();

  /// Creates an Image from the specified YUV planes.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param yPlane [in] A buffer that contains the Y plane.
  /// @param yPlaneSize [in] Size of the 'yPlane' buffer.
  /// @param uPlane [in] A buffer that contains the U plane.
  /// @param uPlaneSize [in] Size of the 'uPlane' buffer.
  /// @param vPlane [in] A buffer that contains the V plane.
  /// @param vPlaneSize [in] Size of the 'vPlane' buffer.
  /// @param yWidth [in] The width, in pixels, of the Y plane.
  /// @param yHeight [in] The height, in pixels, of the Y plane.
  /// @param uvPixelStride [in] The pixel-level stride, in pixels, of the U and V planes.
  /// @param uvRowStride [in] The row-level stride, in pixels, of the U and V planes.
  /// @param eDstPixelFormat [in] The pixel format into which to convert the input image.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_FromYuvPlanes(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<ffi.UnsignedChar> yPlane,
    int yPlaneSize,
    ffi.Pointer<ffi.UnsignedChar> uPlane,
    int uPlaneSize,
    ffi.Pointer<ffi.UnsignedChar> vPlane,
    int vPlaneSize,
    int yWidth,
    int yHeight,
    int uvPixelStride,
    int uvRowStride,
    int eDstPixelFormat,
  ) {
    return _id3DocumentImage_FromYuvPlanes(
      hDocumentImage,
      yPlane,
      yPlaneSize,
      uPlane,
      uPlaneSize,
      vPlane,
      vPlaneSize,
      yWidth,
      yHeight,
      uvPixelStride,
      uvRowStride,
      eDstPixelFormat,
    );
  }

  late final _id3DocumentImage_FromYuvPlanesPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int,
              ffi.Int,
              ffi.Int,
              ffi.Int,
              ffi.Int,
              ffi.Int32)>>('id3DocumentImage_FromYuvPlanes');
  late final _id3DocumentImage_FromYuvPlanes =
      _id3DocumentImage_FromYuvPlanesPtr.asFunction<
          int Function(
              ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.UnsignedChar>,
              int,
              ffi.Pointer<ffi.UnsignedChar>,
              int,
              ffi.Pointer<ffi.UnsignedChar>,
              int,
              int,
              int,
              int,
              int,
              int)>();

  /// Gets a pointer to the image pixels.
  /// Warning: This method is unsafe! The user must handle the pixels pointer carefully.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param pixels [out] Pointer to the image pixels.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_GetPixels(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<ffi.Pointer<ffi.Void>> pixels,
  ) {
    return _id3DocumentImage_GetPixels(
      hDocumentImage,
      pixels,
    );
  }

  late final _id3DocumentImage_GetPixelsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.Pointer<ffi.Void>>)>>(
      'id3DocumentImage_GetPixels');
  late final _id3DocumentImage_GetPixels =
      _id3DocumentImage_GetPixelsPtr.asFunction<
          int Function(
              ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.Pointer<ffi.Void>>)>();

  /// Add padding around the image
  /// Only works for BGR 24 bits, RGB 24 bits and Grayscale 8bits images.
  /// For grayscale image, the padding color is the red component.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param top [in] Padding on top.
  /// @param left [in] Padding on left.
  /// @param bottom [in] Padding on bottom.
  /// @param right [in] Padding on right.
  /// @param colorRed [in] Padding color red (from 0 to 255)
  /// @param colorGreen [in] Padding color green (from 0 to 255)
  /// @param colorBlue [in] Padding color blue (from 0 to 255)
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_Pad(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    int top,
    int left,
    int bottom,
    int right,
    int colorRed,
    int colorGreen,
    int colorBlue,
  ) {
    return _id3DocumentImage_Pad(
      hDocumentImage,
      top,
      left,
      bottom,
      right,
      colorRed,
      colorGreen,
      colorBlue,
    );
  }

  late final _id3DocumentImage_PadPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Int, ffi.Int, ffi.Int,
              ffi.Int, ffi.Int, ffi.Int, ffi.Int)>>('id3DocumentImage_Pad');
  late final _id3DocumentImage_Pad = _id3DocumentImage_PadPtr.asFunction<
      int Function(ID3_DOCUMENT_IMAGE, int, int, int, int, int, int, int)>();

  /// Reallocates the internal memory of the Image from parameters.
  /// Note: If the given parameters are the same as the ones of the object, then there is nothing done in this function.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param width [in] The new width, in pixels.
  /// @param height [in] The new height, in pixels.
  /// @param ePixelFormat [in] The new pixel format.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_Reallocate(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    int width,
    int height,
    int ePixelFormat,
  ) {
    return _id3DocumentImage_Reallocate(
      hDocumentImage,
      width,
      height,
      ePixelFormat,
    );
  }

  late final _id3DocumentImage_ReallocatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Int, ffi.Int,
              ffi.Int32)>>('id3DocumentImage_Reallocate');
  late final _id3DocumentImage_Reallocate = _id3DocumentImage_ReallocatePtr
      .asFunction<int Function(ID3_DOCUMENT_IMAGE, int, int, int)>();

  /// Resizes the image in-place to the required width and height.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param width [in] The new width, in pixels.
  /// @param height [in] The new height, in pixels.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_Resize(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    int width,
    int height,
  ) {
    return _id3DocumentImage_Resize(
      hDocumentImage,
      width,
      height,
    );
  }

  late final _id3DocumentImage_ResizePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Int,
              ffi.Int)>>('id3DocumentImage_Resize');
  late final _id3DocumentImage_Resize = _id3DocumentImage_ResizePtr
      .asFunction<int Function(ID3_DOCUMENT_IMAGE, int, int)>();

  /// Resizes the image to the specified width and height.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param width [in] The new width, in pixels.
  /// @param height [in] The new height, in pixels.
  /// @param hDstDocumentImage [in] The destination image that receives the resized image.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_ResizeTo(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    int width,
    int height,
    ID3_DOCUMENT_IMAGE hDstDocumentImage,
  ) {
    return _id3DocumentImage_ResizeTo(
      hDocumentImage,
      width,
      height,
      hDstDocumentImage,
    );
  }

  late final _id3DocumentImage_ResizeToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Int, ffi.Int,
              ID3_DOCUMENT_IMAGE)>>('id3DocumentImage_ResizeTo');
  late final _id3DocumentImage_ResizeTo =
      _id3DocumentImage_ResizeToPtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE, int, int, ID3_DOCUMENT_IMAGE)>();

  /// Rotates the image in-place to the specified angle.
  /// Note: The rotation is performed counter-clockwise.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param angle [in] The rotation angle, in degree. Supported values are [0, 90, 180, 270].
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_Rotate(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    int angle,
  ) {
    return _id3DocumentImage_Rotate(
      hDocumentImage,
      angle,
    );
  }

  late final _id3DocumentImage_RotatePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Int)>>(
      'id3DocumentImage_Rotate');
  late final _id3DocumentImage_Rotate = _id3DocumentImage_RotatePtr
      .asFunction<int Function(ID3_DOCUMENT_IMAGE, int)>();

  /// Rotates the image to the specified angle.
  /// Note: The rotation is performed counter-clockwise.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param angle [in] The rotation angle, in degree. Supported values are [0, 90, 180, 270].
  /// @param hDstDocumentImage [in] The destination Image that receives the rotated image.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_RotateTo(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    int angle,
    ID3_DOCUMENT_IMAGE hDstDocumentImage,
  ) {
    return _id3DocumentImage_RotateTo(
      hDocumentImage,
      angle,
      hDstDocumentImage,
    );
  }

  late final _id3DocumentImage_RotateToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Int,
              ID3_DOCUMENT_IMAGE)>>('id3DocumentImage_RotateTo');
  late final _id3DocumentImage_RotateTo = _id3DocumentImage_RotateToPtr
      .asFunction<int Function(ID3_DOCUMENT_IMAGE, int, ID3_DOCUMENT_IMAGE)>();

  /// Sets the Image object fields.
  /// Warning: This function does not allocate any memory and is unsafe! The user must handle the pixels pointer carefully.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param width [in] The width, in pixels, of the image.
  /// @param height [in] The height, in pixels, of the image.
  /// @param ePixelFormat [in] The pixel format of the image.
  /// @param pixels [in] A pointer to the image pixels of the image.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_Set(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    int width,
    int height,
    int ePixelFormat,
    ffi.Pointer<ffi.Void> pixels,
  ) {
    return _id3DocumentImage_Set(
      hDocumentImage,
      width,
      height,
      ePixelFormat,
      pixels,
    );
  }

  late final _id3DocumentImage_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Int, ffi.Int, ffi.Int32,
              ffi.Pointer<ffi.Void>)>>('id3DocumentImage_Set');
  late final _id3DocumentImage_Set = _id3DocumentImage_SetPtr.asFunction<
      int Function(ID3_DOCUMENT_IMAGE, int, int, int, ffi.Pointer<ffi.Void>)>();

  /// Exports the image to a buffer.
  /// The compression level meaning depends on the algorithm used:
  /// - For JPEG compression, the value is the expected quality and may vary from 1 to 100.
  /// - For JPEG2000 compression, the value is the compression rate and may vary from 1 to 512.
  /// - For PNG compression, the value is the compression rate and may vary from 1 to 10.
  /// - For all other formats, the value is ignored.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param eDocumentImageFormat [in] The image format to export the image to.
  /// @param compressionLevel [in] The compression level to be applied.
  /// @param data [out] Buffer that receives the image data.
  /// @param dataSize [in,out] Size of the 'data' buffer. Receives the number of elements in the 'data' array.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_ToBuffer(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    int eDocumentImageFormat,
    double compressionLevel,
    ffi.Pointer<ffi.UnsignedChar> data,
    ffi.Pointer<ffi.Int> dataSize,
  ) {
    return _id3DocumentImage_ToBuffer(
      hDocumentImage,
      eDocumentImageFormat,
      compressionLevel,
      data,
      dataSize,
    );
  }

  late final _id3DocumentImage_ToBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_IMAGE,
              ffi.Int32,
              ffi.Float,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentImage_ToBuffer');
  late final _id3DocumentImage_ToBuffer =
      _id3DocumentImage_ToBufferPtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE, int, double,
              ffi.Pointer<ffi.UnsignedChar>, ffi.Pointer<ffi.Int>)>();

  /// Copies the image to a buffer in the specified format.
  /// The compression level meaning depends on the algorithm used:
  /// - For JPEG compression, the value is the expected quality and may vary from 1 to 100.
  /// - For JPEG2000 compression, the value is the compression rate and may vary from 1 to 512.
  /// - For PNG compression, the value is the compression rate and may vary from 1 to 10.
  /// - For all other formats, the value is ignored.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param eDocumentImageFormat [in] The output image format.
  /// @param compressionLevel [in] The compression level to be applied.
  /// @param hBuffer [in] The image buffer that receives the image data.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_ToBufferObject(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    int eDocumentImageFormat,
    double compressionLevel,
    ID3_DOCUMENT_IMAGE_BUFFER hBuffer,
  ) {
    return _id3DocumentImage_ToBufferObject(
      hDocumentImage,
      eDocumentImageFormat,
      compressionLevel,
      hBuffer,
    );
  }

  late final _id3DocumentImage_ToBufferObjectPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Int32, ffi.Float,
              ID3_DOCUMENT_IMAGE_BUFFER)>>('id3DocumentImage_ToBufferObject');
  late final _id3DocumentImage_ToBufferObject =
      _id3DocumentImage_ToBufferObjectPtr.asFunction<
          int Function(
              ID3_DOCUMENT_IMAGE, int, double, ID3_DOCUMENT_IMAGE_BUFFER)>();

  /// Saves the image to the specified file.
  /// The compression level meaning depends on the algorithm used:
  /// - For JPEG compression, the value is the expected quality and may vary from 1 to 100.
  /// - For JPEG2000 compression, the value is the compression rate and may vary from 1 to 512.
  /// - For PNG compression, the value is the compression rate and may vary from 1 to 10.
  /// - For all other formats, the value is ignored.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param filepath [in] A string that contains the name of the file to which to save the image.
  /// @param compressionLevel [in] The compression level to be applied.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_ToFile(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    ffi.Pointer<ffi.Char> filepath,
    double compressionLevel,
  ) {
    return _id3DocumentImage_ToFile(
      hDocumentImage,
      filepath,
      compressionLevel,
    );
  }

  late final _id3DocumentImage_ToFilePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.Char>,
              ffi.Float)>>('id3DocumentImage_ToFile');
  late final _id3DocumentImage_ToFile = _id3DocumentImage_ToFilePtr.asFunction<
      int Function(ID3_DOCUMENT_IMAGE, ffi.Pointer<ffi.Char>, double)>();

  /// Copies image pixels in the specified format into a buffer.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @param ePixelFormat [in] The pixel format.
  /// @param hBuffer [in] Buffer that receives the raw image data.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_ToRawBuffer(
    ID3_DOCUMENT_IMAGE hDocumentImage,
    int ePixelFormat,
    ID3_DOCUMENT_IMAGE_BUFFER hBuffer,
  ) {
    return _id3DocumentImage_ToRawBuffer(
      hDocumentImage,
      ePixelFormat,
      hBuffer,
    );
  }

  late final _id3DocumentImage_ToRawBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_IMAGE, ffi.Int32,
              ID3_DOCUMENT_IMAGE_BUFFER)>>('id3DocumentImage_ToRawBuffer');
  late final _id3DocumentImage_ToRawBuffer =
      _id3DocumentImage_ToRawBufferPtr.asFunction<
          int Function(ID3_DOCUMENT_IMAGE, int, ID3_DOCUMENT_IMAGE_BUFFER)>();

  /// Transposes the image object.
  /// @param hDocumentImage [in] Handle to the DocumentImage object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentImage_Transpose(
    ID3_DOCUMENT_IMAGE hDocumentImage,
  ) {
    return _id3DocumentImage_Transpose(
      hDocumentImage,
    );
  }

  late final _id3DocumentImage_TransposePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_IMAGE)>>(
          'id3DocumentImage_Transpose');
  late final _id3DocumentImage_Transpose = _id3DocumentImage_TransposePtr
      .asFunction<int Function(ID3_DOCUMENT_IMAGE)>();

  /// @brief Initializes a HologramAuthenticationResult object.
  /// @param phHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResult_Initialize(
    ffi.Pointer<ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT>
        phHologramAuthenticationResult,
  ) {
    return _id3DocumentHologramAuthenticationResult_Initialize(
      phHologramAuthenticationResult,
    );
  }

  late final _id3DocumentHologramAuthenticationResult_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT>)>>(
      'id3DocumentHologramAuthenticationResult_Initialize');
  late final _id3DocumentHologramAuthenticationResult_Initialize =
      _id3DocumentHologramAuthenticationResult_InitializePtr.asFunction<
          int Function(
              ffi.Pointer<ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT>)>();

  /// @brief Releases the memory allocated for a HologramAuthenticationResult.
  /// @param phHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResult_Dispose(
    ffi.Pointer<ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT>
        phHologramAuthenticationResult,
  ) {
    return _id3DocumentHologramAuthenticationResult_Dispose(
      phHologramAuthenticationResult,
    );
  }

  late final _id3DocumentHologramAuthenticationResult_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT>)>>(
      'id3DocumentHologramAuthenticationResult_Dispose');
  late final _id3DocumentHologramAuthenticationResult_Dispose =
      _id3DocumentHologramAuthenticationResult_DisposePtr.asFunction<
          int Function(
              ffi.Pointer<ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResult_CheckHandle(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResult,
  ) {
    return _id3DocumentHologramAuthenticationResult_CheckHandle(
      hHologramAuthenticationResult,
    );
  }

  late final _id3DocumentHologramAuthenticationResult_CheckHandlePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT)>>(
      'id3DocumentHologramAuthenticationResult_CheckHandle');
  late final _id3DocumentHologramAuthenticationResult_CheckHandle =
      _id3DocumentHologramAuthenticationResult_CheckHandlePtr.asFunction<
          int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT)>();

  /// @brief Copies an instance of HologramAuthenticationResult object to another.
  /// @param hHologramAuthenticationResultSrc [in] Handle to the source HologramAuthenticationResult object.
  /// @param hHologramAuthenticationResultDst [in] Handle to the destination HologramAuthenticationResult object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResult_CopyTo(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT
        hHologramAuthenticationResultSrc,
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT
        hHologramAuthenticationResultDst,
  ) {
    return _id3DocumentHologramAuthenticationResult_CopyTo(
      hHologramAuthenticationResultSrc,
      hHologramAuthenticationResultDst,
    );
  }

  late final _id3DocumentHologramAuthenticationResult_CopyToPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT,
                  ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT)>>(
      'id3DocumentHologramAuthenticationResult_CopyTo');
  late final _id3DocumentHologramAuthenticationResult_CopyTo =
      _id3DocumentHologramAuthenticationResult_CopyToPtr.asFunction<
          int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT,
              ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT)>();

  /// Gets the exact bounds of the text in the image.
  /// @param hHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
  /// @param sBounds [out] Exact bounds of the text in the image.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResult_GetBounds(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResult,
    ffi.Pointer<id3DocumentRectangle> sBounds,
  ) {
    return _id3DocumentHologramAuthenticationResult_GetBounds(
      hHologramAuthenticationResult,
      sBounds,
    );
  }

  late final _id3DocumentHologramAuthenticationResult_GetBoundsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT,
                  ffi.Pointer<id3DocumentRectangle>)>>(
      'id3DocumentHologramAuthenticationResult_GetBounds');
  late final _id3DocumentHologramAuthenticationResult_GetBounds =
      _id3DocumentHologramAuthenticationResult_GetBoundsPtr.asFunction<
          int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT,
              ffi.Pointer<id3DocumentRectangle>)>();

  /// Gets the correlation of the variation to the background.
  /// @param hHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
  /// @param correlationScore [out] Correlation of the variation to the background.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResult_GetCorrelationScore(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResult,
    ffi.Pointer<ffi.Float> correlationScore,
  ) {
    return _id3DocumentHologramAuthenticationResult_GetCorrelationScore(
      hHologramAuthenticationResult,
      correlationScore,
    );
  }

  late final _id3DocumentHologramAuthenticationResult_GetCorrelationScorePtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT,
                      ffi.Pointer<ffi.Float>)>>(
          'id3DocumentHologramAuthenticationResult_GetCorrelationScore');
  late final _id3DocumentHologramAuthenticationResult_GetCorrelationScore =
      _id3DocumentHologramAuthenticationResult_GetCorrelationScorePtr
          .asFunction<
              int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT,
                  ffi.Pointer<ffi.Float>)>();

  /// Gets the name of the hologram.
  /// @param hHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
  /// @param hologramName [out] Name of the hologram.
  /// @param hologramNameSize [in,out] Size of the 'hologramName' buffer. Receives the minimum required buffer size to hold the 'hologramName' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'hologramName' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResult_GetHologramName(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResult,
    ffi.Pointer<ffi.Char> hologramName,
    ffi.Pointer<ffi.Int> hologramNameSize,
  ) {
    return _id3DocumentHologramAuthenticationResult_GetHologramName(
      hHologramAuthenticationResult,
      hologramName,
      hologramNameSize,
    );
  }

  late final _id3DocumentHologramAuthenticationResult_GetHologramNamePtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT,
                      ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>>(
          'id3DocumentHologramAuthenticationResult_GetHologramName');
  late final _id3DocumentHologramAuthenticationResult_GetHologramName =
      _id3DocumentHologramAuthenticationResult_GetHologramNamePtr.asFunction<
          int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT,
              ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Gets the variation of the OVI color.
  /// @param hHologramAuthenticationResult [in] Handle to the HologramAuthenticationResult object.
  /// @param variationScore [out] Variation of the OVI color.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResult_GetVariationScore(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResult,
    ffi.Pointer<ffi.Float> variationScore,
  ) {
    return _id3DocumentHologramAuthenticationResult_GetVariationScore(
      hHologramAuthenticationResult,
      variationScore,
    );
  }

  late final _id3DocumentHologramAuthenticationResult_GetVariationScorePtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT,
                      ffi.Pointer<ffi.Float>)>>(
          'id3DocumentHologramAuthenticationResult_GetVariationScore');
  late final _id3DocumentHologramAuthenticationResult_GetVariationScore =
      _id3DocumentHologramAuthenticationResult_GetVariationScorePtr.asFunction<
          int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT,
              ffi.Pointer<ffi.Float>)>();

  /// @brief Initializes a HologramAuthenticationResultList object.
  /// @param phHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResultList_Initialize(
    ffi.Pointer<ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST>
        phHologramAuthenticationResultList,
  ) {
    return _id3DocumentHologramAuthenticationResultList_Initialize(
      phHologramAuthenticationResultList,
    );
  }

  late final _id3DocumentHologramAuthenticationResultList_InitializePtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ffi.Pointer<
                          ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST>)>>(
          'id3DocumentHologramAuthenticationResultList_Initialize');
  late final _id3DocumentHologramAuthenticationResultList_Initialize =
      _id3DocumentHologramAuthenticationResultList_InitializePtr.asFunction<
          int Function(
              ffi.Pointer<ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST>)>();

  /// @brief Releases the memory allocated for a HologramAuthenticationResultList.
  /// @param phHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResultList_Dispose(
    ffi.Pointer<ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST>
        phHologramAuthenticationResultList,
  ) {
    return _id3DocumentHologramAuthenticationResultList_Dispose(
      phHologramAuthenticationResultList,
    );
  }

  late final _id3DocumentHologramAuthenticationResultList_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<
                      ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST>)>>(
      'id3DocumentHologramAuthenticationResultList_Dispose');
  late final _id3DocumentHologramAuthenticationResultList_Dispose =
      _id3DocumentHologramAuthenticationResultList_DisposePtr.asFunction<
          int Function(
              ffi.Pointer<ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResultList_CheckHandle(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST
        hHologramAuthenticationResultList,
  ) {
    return _id3DocumentHologramAuthenticationResultList_CheckHandle(
      hHologramAuthenticationResultList,
    );
  }

  late final _id3DocumentHologramAuthenticationResultList_CheckHandlePtr =
      _lookup<
              ffi.NativeFunction<
                  ffi.Int Function(
                      ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST)>>(
          'id3DocumentHologramAuthenticationResultList_CheckHandle');
  late final _id3DocumentHologramAuthenticationResultList_CheckHandle =
      _id3DocumentHologramAuthenticationResultList_CheckHandlePtr.asFunction<
          int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST)>();

  /// @brief Copies an instance of HologramAuthenticationResultList object to another.
  /// @param hHologramAuthenticationResultListSrc [in] Handle to the source HologramAuthenticationResultList object.
  /// @param hHologramAuthenticationResultListDst [in] Handle to the destination HologramAuthenticationResultList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResultList_CopyTo(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST
        hHologramAuthenticationResultListSrc,
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST
        hHologramAuthenticationResultListDst,
  ) {
    return _id3DocumentHologramAuthenticationResultList_CopyTo(
      hHologramAuthenticationResultListSrc,
      hHologramAuthenticationResultListDst,
    );
  }

  late final _id3DocumentHologramAuthenticationResultList_CopyToPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST,
                  ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST)>>(
      'id3DocumentHologramAuthenticationResultList_CopyTo');
  late final _id3DocumentHologramAuthenticationResultList_CopyTo =
      _id3DocumentHologramAuthenticationResultList_CopyToPtr.asFunction<
          int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST,
              ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST)>();

  /// Clears the HologramAuthenticationResultList object.
  /// @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResultList_Clear(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST
        hHologramAuthenticationResultList,
  ) {
    return _id3DocumentHologramAuthenticationResultList_Clear(
      hHologramAuthenticationResultList,
    );
  }

  late final _id3DocumentHologramAuthenticationResultList_ClearPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST)>>(
      'id3DocumentHologramAuthenticationResultList_Clear');
  late final _id3DocumentHologramAuthenticationResultList_Clear =
      _id3DocumentHologramAuthenticationResultList_ClearPtr.asFunction<
          int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST)>();

  /// Adds an item to the HologramAuthenticationResultList object.
  /// @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
  /// @param hHologramAuthenticationResultItem [in] HologramAuthenticationResult item to add.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResultList_Add(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST
        hHologramAuthenticationResultList,
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT
        hHologramAuthenticationResultItem,
  ) {
    return _id3DocumentHologramAuthenticationResultList_Add(
      hHologramAuthenticationResultList,
      hHologramAuthenticationResultItem,
    );
  }

  late final _id3DocumentHologramAuthenticationResultList_AddPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST,
                  ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT)>>(
      'id3DocumentHologramAuthenticationResultList_Add');
  late final _id3DocumentHologramAuthenticationResultList_Add =
      _id3DocumentHologramAuthenticationResultList_AddPtr.asFunction<
          int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST,
              ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT)>();

  /// Gets an item of the HologramAuthenticationResultList object.
  /// @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
  /// @param index [in] Index of the HologramAuthenticationResult item to get.
  /// @param hHologramAuthenticationResultItem [out] HologramAuthenticationResult item to get.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResultList_Get(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST
        hHologramAuthenticationResultList,
    int index,
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT
        hHologramAuthenticationResultItem,
  ) {
    return _id3DocumentHologramAuthenticationResultList_Get(
      hHologramAuthenticationResultList,
      index,
      hHologramAuthenticationResultItem,
    );
  }

  late final _id3DocumentHologramAuthenticationResultList_GetPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST,
                  ffi.Int, ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT)>>(
      'id3DocumentHologramAuthenticationResultList_Get');
  late final _id3DocumentHologramAuthenticationResultList_Get =
      _id3DocumentHologramAuthenticationResultList_GetPtr.asFunction<
          int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST, int,
              ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT)>();

  /// Sets an item of the HologramAuthenticationResultList object.
  /// @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
  /// @param index [in] Index of the HologramAuthenticationResult item to set.
  /// @param hHologramAuthenticationResultItem [in] HologramAuthenticationResult item to set.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResultList_Set(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST
        hHologramAuthenticationResultList,
    int index,
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT
        hHologramAuthenticationResultItem,
  ) {
    return _id3DocumentHologramAuthenticationResultList_Set(
      hHologramAuthenticationResultList,
      index,
      hHologramAuthenticationResultItem,
    );
  }

  late final _id3DocumentHologramAuthenticationResultList_SetPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST,
                  ffi.Int, ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT)>>(
      'id3DocumentHologramAuthenticationResultList_Set');
  late final _id3DocumentHologramAuthenticationResultList_Set =
      _id3DocumentHologramAuthenticationResultList_SetPtr.asFunction<
          int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST, int,
              ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT)>();

  /// Gets the number of elements in the HologramAuthenticationResultList object.
  /// @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
  /// @param count [out] Number of elements in the HologramAuthenticationResult object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResultList_GetCount(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST
        hHologramAuthenticationResultList,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3DocumentHologramAuthenticationResultList_GetCount(
      hHologramAuthenticationResultList,
      count,
    );
  }

  late final _id3DocumentHologramAuthenticationResultList_GetCountPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST,
                  ffi.Pointer<ffi.Int>)>>(
      'id3DocumentHologramAuthenticationResultList_GetCount');
  late final _id3DocumentHologramAuthenticationResultList_GetCount =
      _id3DocumentHologramAuthenticationResultList_GetCountPtr.asFunction<
          int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST,
              ffi.Pointer<ffi.Int>)>();

  /// Removes an element of the HologramAuthenticationResultList object.
  /// @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
  /// @param index [in] Index of the HologramAuthenticationResult item to remove.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResultList_RemoveAt(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST
        hHologramAuthenticationResultList,
    int index,
  ) {
    return _id3DocumentHologramAuthenticationResultList_RemoveAt(
      hHologramAuthenticationResultList,
      index,
    );
  }

  late final _id3DocumentHologramAuthenticationResultList_RemoveAtPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST, ffi.Int)>>(
      'id3DocumentHologramAuthenticationResultList_RemoveAt');
  late final _id3DocumentHologramAuthenticationResultList_RemoveAt =
      _id3DocumentHologramAuthenticationResultList_RemoveAtPtr.asFunction<
          int Function(
              ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST, int)>();

  /// HologramAuthenticationResultList object.
  /// @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
  /// @param newSize [in] HologramAuthenticationResult object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentHologramAuthenticationResultList_Resize(
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST
        hHologramAuthenticationResultList,
    int newSize,
  ) {
    return _id3DocumentHologramAuthenticationResultList_Resize(
      hHologramAuthenticationResultList,
      newSize,
    );
  }

  late final _id3DocumentHologramAuthenticationResultList_ResizePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST,
              ffi.Int)>>('id3DocumentHologramAuthenticationResultList_Resize');
  late final _id3DocumentHologramAuthenticationResultList_Resize =
      _id3DocumentHologramAuthenticationResultList_ResizePtr.asFunction<
          int Function(
              ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST, int)>();

  /// @brief Initializes a DocumentAuthenticator object.
  /// @param phDocumentAuthenticator [in] Handle to the DocumentAuthenticator object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentAuthenticator_Initialize(
    ffi.Pointer<ID3_DOCUMENT_AUTHENTICATOR> phDocumentAuthenticator,
  ) {
    return _id3DocumentAuthenticator_Initialize(
      phDocumentAuthenticator,
    );
  }

  late final _id3DocumentAuthenticator_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_AUTHENTICATOR>)>>(
      'id3DocumentAuthenticator_Initialize');
  late final _id3DocumentAuthenticator_Initialize =
      _id3DocumentAuthenticator_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_AUTHENTICATOR>)>();

  /// @brief Releases the memory allocated for a DocumentAuthenticator.
  /// @param phDocumentAuthenticator [in] Handle to the DocumentAuthenticator object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentAuthenticator_Dispose(
    ffi.Pointer<ID3_DOCUMENT_AUTHENTICATOR> phDocumentAuthenticator,
  ) {
    return _id3DocumentAuthenticator_Dispose(
      phDocumentAuthenticator,
    );
  }

  late final _id3DocumentAuthenticator_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_AUTHENTICATOR>)>>(
      'id3DocumentAuthenticator_Dispose');
  late final _id3DocumentAuthenticator_Dispose =
      _id3DocumentAuthenticator_DisposePtr
          .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_AUTHENTICATOR>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hDocumentAuthenticator [in] Handle to the DocumentAuthenticator object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentAuthenticator_CheckHandle(
    ID3_DOCUMENT_AUTHENTICATOR hDocumentAuthenticator,
  ) {
    return _id3DocumentAuthenticator_CheckHandle(
      hDocumentAuthenticator,
    );
  }

  late final _id3DocumentAuthenticator_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_AUTHENTICATOR)>>(
          'id3DocumentAuthenticator_CheckHandle');
  late final _id3DocumentAuthenticator_CheckHandle =
      _id3DocumentAuthenticator_CheckHandlePtr
          .asFunction<int Function(ID3_DOCUMENT_AUTHENTICATOR)>();

  /// Gets the document type to authenticate.
  /// @param hDocumentAuthenticator [in] Handle to the DocumentAuthenticator object.
  /// @param documentName [out] Document type to authenticate.
  /// @param documentNameSize [in,out] Size of the 'documentName' buffer. Receives the minimum required buffer size to hold the 'documentName' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'documentName' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentAuthenticator_GetDocumentName(
    ID3_DOCUMENT_AUTHENTICATOR hDocumentAuthenticator,
    ffi.Pointer<ffi.Char> documentName,
    ffi.Pointer<ffi.Int> documentNameSize,
  ) {
    return _id3DocumentAuthenticator_GetDocumentName(
      hDocumentAuthenticator,
      documentName,
      documentNameSize,
    );
  }

  late final _id3DocumentAuthenticator_GetDocumentNamePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_AUTHENTICATOR,
                  ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>>(
      'id3DocumentAuthenticator_GetDocumentName');
  late final _id3DocumentAuthenticator_GetDocumentName =
      _id3DocumentAuthenticator_GetDocumentNamePtr.asFunction<
          int Function(ID3_DOCUMENT_AUTHENTICATOR, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>();

  /// Sets the document type to authenticate.
  /// @param hDocumentAuthenticator [in] Handle to the DocumentAuthenticator object.
  /// @param documentName [in] Document type to authenticate.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentAuthenticator_SetDocumentName(
    ID3_DOCUMENT_AUTHENTICATOR hDocumentAuthenticator,
    ffi.Pointer<ffi.Char> documentName,
  ) {
    return _id3DocumentAuthenticator_SetDocumentName(
      hDocumentAuthenticator,
      documentName,
    );
  }

  late final _id3DocumentAuthenticator_SetDocumentNamePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DOCUMENT_AUTHENTICATOR, ffi.Pointer<ffi.Char>)>>(
      'id3DocumentAuthenticator_SetDocumentName');
  late final _id3DocumentAuthenticator_SetDocumentName =
      _id3DocumentAuthenticator_SetDocumentNamePtr.asFunction<
          int Function(ID3_DOCUMENT_AUTHENTICATOR, ffi.Pointer<ffi.Char>)>();

  /// Gets the size of the FIFO frame buffer, used for processing.
  /// @param hDocumentAuthenticator [in] Handle to the DocumentAuthenticator object.
  /// @param temporalWindowSize [out] Size of the FIFO frame buffer, used for processing.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentAuthenticator_GetTemporalWindowSize(
    ID3_DOCUMENT_AUTHENTICATOR hDocumentAuthenticator,
    ffi.Pointer<ffi.Int> temporalWindowSize,
  ) {
    return _id3DocumentAuthenticator_GetTemporalWindowSize(
      hDocumentAuthenticator,
      temporalWindowSize,
    );
  }

  late final _id3DocumentAuthenticator_GetTemporalWindowSizePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DOCUMENT_AUTHENTICATOR, ffi.Pointer<ffi.Int>)>>(
      'id3DocumentAuthenticator_GetTemporalWindowSize');
  late final _id3DocumentAuthenticator_GetTemporalWindowSize =
      _id3DocumentAuthenticator_GetTemporalWindowSizePtr.asFunction<
          int Function(ID3_DOCUMENT_AUTHENTICATOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the size of the FIFO frame buffer, used for processing.
  /// @param hDocumentAuthenticator [in] Handle to the DocumentAuthenticator object.
  /// @param temporalWindowSize [in] Size of the FIFO frame buffer, used for processing.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentAuthenticator_SetTemporalWindowSize(
    ID3_DOCUMENT_AUTHENTICATOR hDocumentAuthenticator,
    int temporalWindowSize,
  ) {
    return _id3DocumentAuthenticator_SetTemporalWindowSize(
      hDocumentAuthenticator,
      temporalWindowSize,
    );
  }

  late final _id3DocumentAuthenticator_SetTemporalWindowSizePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_AUTHENTICATOR,
              ffi.Int)>>('id3DocumentAuthenticator_SetTemporalWindowSize');
  late final _id3DocumentAuthenticator_SetTemporalWindowSize =
      _id3DocumentAuthenticator_SetTemporalWindowSizePtr
          .asFunction<int Function(ID3_DOCUMENT_AUTHENTICATOR, int)>();

  /// Appends a frame in the FIFO buffer.
  /// @param hDocumentAuthenticator [in] Handle to the DocumentAuthenticator object.
  /// @param hImage [in] Source image of the aligned document to append
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentAuthenticator_AppendFrame(
    ID3_DOCUMENT_AUTHENTICATOR hDocumentAuthenticator,
    ID3_DOCUMENT_IMAGE hImage,
  ) {
    return _id3DocumentAuthenticator_AppendFrame(
      hDocumentAuthenticator,
      hImage,
    );
  }

  late final _id3DocumentAuthenticator_AppendFramePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_AUTHENTICATOR,
              ID3_DOCUMENT_IMAGE)>>('id3DocumentAuthenticator_AppendFrame');
  late final _id3DocumentAuthenticator_AppendFrame =
      _id3DocumentAuthenticator_AppendFramePtr.asFunction<
          int Function(ID3_DOCUMENT_AUTHENTICATOR, ID3_DOCUMENT_IMAGE)>();

  /// Authenticates the holograms on the current frame buffer.
  /// Important: Buffer must be full to the temporal window size.
  /// @param hDocumentAuthenticator [in] Handle to the DocumentAuthenticator object.
  /// @param hScoreList [out] List of result for each hologram enrolled in document.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentAuthenticator_AuthenticateHolograms(
    ID3_DOCUMENT_AUTHENTICATOR hDocumentAuthenticator,
    ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST hScoreList,
  ) {
    return _id3DocumentAuthenticator_AuthenticateHolograms(
      hDocumentAuthenticator,
      hScoreList,
    );
  }

  late final _id3DocumentAuthenticator_AuthenticateHologramsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_AUTHENTICATOR,
                  ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST)>>(
      'id3DocumentAuthenticator_AuthenticateHolograms');
  late final _id3DocumentAuthenticator_AuthenticateHolograms =
      _id3DocumentAuthenticator_AuthenticateHologramsPtr.asFunction<
          int Function(ID3_DOCUMENT_AUTHENTICATOR,
              ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST)>();

  /// Checks if the frame buffer is full and ready to authenticate for all holograms.
  /// @param hDocumentAuthenticator [in] Handle to the DocumentAuthenticator object.
  /// @param result [out] A value indicating whether the frame buffer is full.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentAuthenticator_IsFull(
    ID3_DOCUMENT_AUTHENTICATOR hDocumentAuthenticator,
    ffi.Pointer<ffi.Bool> result,
  ) {
    return _id3DocumentAuthenticator_IsFull(
      hDocumentAuthenticator,
      result,
    );
  }

  late final _id3DocumentAuthenticator_IsFullPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_AUTHENTICATOR,
              ffi.Pointer<ffi.Bool>)>>('id3DocumentAuthenticator_IsFull');
  late final _id3DocumentAuthenticator_IsFull =
      _id3DocumentAuthenticator_IsFullPtr.asFunction<
          int Function(ID3_DOCUMENT_AUTHENTICATOR, ffi.Pointer<ffi.Bool>)>();

  ffi.Pointer<ffi.Char> id3Document_GetDocumentModelString(
    int value,
  ) {
    return _id3Document_GetDocumentModelString(
      value,
    );
  }

  late final _id3Document_GetDocumentModelStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetDocumentModelString');
  late final _id3Document_GetDocumentModelString =
      _id3Document_GetDocumentModelStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Document_GetProcessingUnitString(
    int value,
  ) {
    return _id3Document_GetProcessingUnitString(
      value,
    );
  }

  late final _id3Document_GetProcessingUnitStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetProcessingUnitString');
  late final _id3Document_GetProcessingUnitString =
      _id3Document_GetProcessingUnitStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a DocumentDetector object.
  /// @param phDocumentDetector [in] Handle to the DocumentDetector object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_Initialize(
    ffi.Pointer<ID3_DOCUMENT_DETECTOR> phDocumentDetector,
  ) {
    return _id3DocumentDetector_Initialize(
      phDocumentDetector,
    );
  }

  late final _id3DocumentDetector_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_DETECTOR>)>>(
      'id3DocumentDetector_Initialize');
  late final _id3DocumentDetector_Initialize =
      _id3DocumentDetector_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_DETECTOR>)>();

  /// @brief Releases the memory allocated for a DocumentDetector.
  /// @param phDocumentDetector [in] Handle to the DocumentDetector object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_Dispose(
    ffi.Pointer<ID3_DOCUMENT_DETECTOR> phDocumentDetector,
  ) {
    return _id3DocumentDetector_Dispose(
      phDocumentDetector,
    );
  }

  late final _id3DocumentDetector_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_DETECTOR>)>>(
      'id3DocumentDetector_Dispose');
  late final _id3DocumentDetector_Dispose = _id3DocumentDetector_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_DETECTOR>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_CheckHandle(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
  ) {
    return _id3DocumentDetector_CheckHandle(
      hDocumentDetector,
    );
  }

  late final _id3DocumentDetector_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_DETECTOR)>>(
          'id3DocumentDetector_CheckHandle');
  late final _id3DocumentDetector_CheckHandle =
      _id3DocumentDetector_CheckHandlePtr
          .asFunction<int Function(ID3_DOCUMENT_DETECTOR)>();

  /// Gets the confidence threshold, from 0 to 100+.
  /// Hint: Default value is 50. Lower threshold can increase number of false detection.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @param confidenceThreshold [out] Confidence threshold, from 0 to 100+.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_GetConfidenceThreshold(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
    ffi.Pointer<ffi.Int> confidenceThreshold,
  ) {
    return _id3DocumentDetector_GetConfidenceThreshold(
      hDocumentDetector,
      confidenceThreshold,
    );
  }

  late final _id3DocumentDetector_GetConfidenceThresholdPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_DETECTOR, ffi.Pointer<ffi.Int>)>>(
      'id3DocumentDetector_GetConfidenceThreshold');
  late final _id3DocumentDetector_GetConfidenceThreshold =
      _id3DocumentDetector_GetConfidenceThresholdPtr.asFunction<
          int Function(ID3_DOCUMENT_DETECTOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the confidence threshold, from 0 to 100+.
  /// Hint: Default value is 50. Lower threshold can increase number of false detection.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @param confidenceThreshold [in] Confidence threshold, from 0 to 100+.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_SetConfidenceThreshold(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
    int confidenceThreshold,
  ) {
    return _id3DocumentDetector_SetConfidenceThreshold(
      hDocumentDetector,
      confidenceThreshold,
    );
  }

  late final _id3DocumentDetector_SetConfidenceThresholdPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_DETECTOR, ffi.Int)>>(
      'id3DocumentDetector_SetConfidenceThreshold');
  late final _id3DocumentDetector_SetConfidenceThreshold =
      _id3DocumentDetector_SetConfidenceThresholdPtr
          .asFunction<int Function(ID3_DOCUMENT_DETECTOR, int)>();

  /// Gets the ratio of the estimated width of the searched document in the image.
  /// Hint: Default value is 1.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @param documentWidthRatio [out] Ratio of the estimated width of the searched document in the image.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_GetDocumentWidthRatio(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
    ffi.Pointer<ffi.Float> documentWidthRatio,
  ) {
    return _id3DocumentDetector_GetDocumentWidthRatio(
      hDocumentDetector,
      documentWidthRatio,
    );
  }

  late final _id3DocumentDetector_GetDocumentWidthRatioPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_DETECTOR, ffi.Pointer<ffi.Float>)>>(
      'id3DocumentDetector_GetDocumentWidthRatio');
  late final _id3DocumentDetector_GetDocumentWidthRatio =
      _id3DocumentDetector_GetDocumentWidthRatioPtr.asFunction<
          int Function(ID3_DOCUMENT_DETECTOR, ffi.Pointer<ffi.Float>)>();

  /// Sets the ratio of the estimated width of the searched document in the image.
  /// Hint: Default value is 1.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @param documentWidthRatio [in] Ratio of the estimated width of the searched document in the image.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_SetDocumentWidthRatio(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
    double documentWidthRatio,
  ) {
    return _id3DocumentDetector_SetDocumentWidthRatio(
      hDocumentDetector,
      documentWidthRatio,
    );
  }

  late final _id3DocumentDetector_SetDocumentWidthRatioPtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_DOCUMENT_DETECTOR, ffi.Float)>>(
      'id3DocumentDetector_SetDocumentWidthRatio');
  late final _id3DocumentDetector_SetDocumentWidthRatio =
      _id3DocumentDetector_SetDocumentWidthRatioPtr
          .asFunction<int Function(ID3_DOCUMENT_DETECTOR, double)>();

  /// Gets the model to be used for document detection.
  /// Hint: Default value is DocumentDetector2A.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @param eModel [out] Model to be used for document detection.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_GetModel(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
    ffi.Pointer<ffi.Int32> eModel,
  ) {
    return _id3DocumentDetector_GetModel(
      hDocumentDetector,
      eModel,
    );
  }

  late final _id3DocumentDetector_GetModelPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_DETECTOR,
              ffi.Pointer<ffi.Int32>)>>('id3DocumentDetector_GetModel');
  late final _id3DocumentDetector_GetModel =
      _id3DocumentDetector_GetModelPtr.asFunction<
          int Function(ID3_DOCUMENT_DETECTOR, ffi.Pointer<ffi.Int32>)>();

  /// Sets the model to be used for document detection.
  /// Hint: Default value is DocumentDetector2A.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @param eModel [in] Model to be used for document detection.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_SetModel(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
    int eModel,
  ) {
    return _id3DocumentDetector_SetModel(
      hDocumentDetector,
      eModel,
    );
  }

  late final _id3DocumentDetector_SetModelPtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_DOCUMENT_DETECTOR, ffi.Int32)>>(
      'id3DocumentDetector_SetModel');
  late final _id3DocumentDetector_SetModel = _id3DocumentDetector_SetModelPtr
      .asFunction<int Function(ID3_DOCUMENT_DETECTOR, int)>();

  /// Gets the processing unit where to run the detection process.
  /// Hint: Default value is CPU.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @param eProcessingUnit [out] Processing unit where to run the detection process.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_GetProcessingUnit(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
    ffi.Pointer<ffi.Int32> eProcessingUnit,
  ) {
    return _id3DocumentDetector_GetProcessingUnit(
      hDocumentDetector,
      eProcessingUnit,
    );
  }

  late final _id3DocumentDetector_GetProcessingUnitPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_DETECTOR, ffi.Pointer<ffi.Int32>)>>(
      'id3DocumentDetector_GetProcessingUnit');
  late final _id3DocumentDetector_GetProcessingUnit =
      _id3DocumentDetector_GetProcessingUnitPtr.asFunction<
          int Function(ID3_DOCUMENT_DETECTOR, ffi.Pointer<ffi.Int32>)>();

  /// Sets the processing unit where to run the detection process.
  /// Hint: Default value is CPU.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @param eProcessingUnit [in] Processing unit where to run the detection process.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_SetProcessingUnit(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
    int eProcessingUnit,
  ) {
    return _id3DocumentDetector_SetProcessingUnit(
      hDocumentDetector,
      eProcessingUnit,
    );
  }

  late final _id3DocumentDetector_SetProcessingUnitPtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_DOCUMENT_DETECTOR, ffi.Int32)>>(
      'id3DocumentDetector_SetProcessingUnit');
  late final _id3DocumentDetector_SetProcessingUnit =
      _id3DocumentDetector_SetProcessingUnitPtr
          .asFunction<int Function(ID3_DOCUMENT_DETECTOR, int)>();

  /// Gets the number of threads to use for detection.
  /// Hint: Default value is 1. Allocating more than 1 thread here can increase the speed of the process.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @param threadCount [out] Number of threads to use for detection.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_GetThreadCount(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
    ffi.Pointer<ffi.Int> threadCount,
  ) {
    return _id3DocumentDetector_GetThreadCount(
      hDocumentDetector,
      threadCount,
    );
  }

  late final _id3DocumentDetector_GetThreadCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_DETECTOR,
              ffi.Pointer<ffi.Int>)>>('id3DocumentDetector_GetThreadCount');
  late final _id3DocumentDetector_GetThreadCount =
      _id3DocumentDetector_GetThreadCountPtr.asFunction<
          int Function(ID3_DOCUMENT_DETECTOR, ffi.Pointer<ffi.Int>)>();

  /// Sets the number of threads to use for detection.
  /// Hint: Default value is 1. Allocating more than 1 thread here can increase the speed of the process.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @param threadCount [in] Number of threads to use for detection.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_SetThreadCount(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
    int threadCount,
  ) {
    return _id3DocumentDetector_SetThreadCount(
      hDocumentDetector,
      threadCount,
    );
  }

  late final _id3DocumentDetector_SetThreadCountPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_DETECTOR, ffi.Int)>>(
      'id3DocumentDetector_SetThreadCount');
  late final _id3DocumentDetector_SetThreadCount =
      _id3DocumentDetector_SetThreadCountPtr
          .asFunction<int Function(ID3_DOCUMENT_DETECTOR, int)>();

  /// Aligns and crops the specified document on the specified image and returns a new DocumentImage.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @param hSourceImage [in] The source image containing the document.
  /// @param hDetectedDocument [in] The detected document in the image.
  /// @param hAlignedImage [out] Realigned and cropped image of the document.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_AlignDocument(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
    ID3_DOCUMENT_IMAGE hSourceImage,
    ID3_DETECTED_DOCUMENT hDetectedDocument,
    ID3_DOCUMENT_IMAGE hAlignedImage,
  ) {
    return _id3DocumentDetector_AlignDocument(
      hDocumentDetector,
      hSourceImage,
      hDetectedDocument,
      hAlignedImage,
    );
  }

  late final _id3DocumentDetector_AlignDocumentPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_DETECTOR,
              ID3_DOCUMENT_IMAGE,
              ID3_DETECTED_DOCUMENT,
              ID3_DOCUMENT_IMAGE)>>('id3DocumentDetector_AlignDocument');
  late final _id3DocumentDetector_AlignDocument =
      _id3DocumentDetector_AlignDocumentPtr.asFunction<
          int Function(ID3_DOCUMENT_DETECTOR, ID3_DOCUMENT_IMAGE,
              ID3_DETECTED_DOCUMENT, ID3_DOCUMENT_IMAGE)>();

  /// Detects a document on a delimited area of the specified DocumentImage and returns a DetectedDocument.
  /// Important: Document templates must be loaded before calling this method.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @param hImage [in] Source image to process
  /// @param sDetectionZone [in] Crop in the image where to look for document. Default is the full image. Output corners are in the full image referential.
  /// @param hDetectedDocument [out] Detected document in the image
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_DetectDocument(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
    ID3_DOCUMENT_IMAGE hImage,
    ffi.Pointer<id3DocumentRectangle> sDetectionZone,
    ID3_DETECTED_DOCUMENT hDetectedDocument,
  ) {
    return _id3DocumentDetector_DetectDocument(
      hDocumentDetector,
      hImage,
      sDetectionZone,
      hDetectedDocument,
    );
  }

  late final _id3DocumentDetector_DetectDocumentPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_DETECTOR,
              ID3_DOCUMENT_IMAGE,
              ffi.Pointer<id3DocumentRectangle>,
              ID3_DETECTED_DOCUMENT)>>('id3DocumentDetector_DetectDocument');
  late final _id3DocumentDetector_DetectDocument =
      _id3DocumentDetector_DetectDocumentPtr.asFunction<
          int Function(ID3_DOCUMENT_DETECTOR, ID3_DOCUMENT_IMAGE,
              ffi.Pointer<id3DocumentRectangle>, ID3_DETECTED_DOCUMENT)>();

  /// Detects a document with specified name on a delimited area of the specified DocumentImage and returns a DetectedDocument.
  /// Important: The relevant document template must be loaded before calling this method.
  /// @param hDocumentDetector [in] Handle to the DocumentDetector object.
  /// @param hImage [in] The source image to process.
  /// @param documentName [in] The name of the document to be searched for. Must be a key loaded in DocumentLibrary.
  /// @param sDetectionZone [in] A delimited area in the image where to search for the document. Default is the full image. Output corners are in the full image referential.
  /// @param hDetectedDocument [out] Detected document in the image
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentDetector_DetectDocumentByName(
    ID3_DOCUMENT_DETECTOR hDocumentDetector,
    ID3_DOCUMENT_IMAGE hImage,
    ffi.Pointer<ffi.Char> documentName,
    ffi.Pointer<id3DocumentRectangle> sDetectionZone,
    ID3_DETECTED_DOCUMENT hDetectedDocument,
  ) {
    return _id3DocumentDetector_DetectDocumentByName(
      hDocumentDetector,
      hImage,
      documentName,
      sDetectionZone,
      hDetectedDocument,
    );
  }

  late final _id3DocumentDetector_DetectDocumentByNamePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DOCUMENT_DETECTOR,
                  ID3_DOCUMENT_IMAGE,
                  ffi.Pointer<ffi.Char>,
                  ffi.Pointer<id3DocumentRectangle>,
                  ID3_DETECTED_DOCUMENT)>>(
      'id3DocumentDetector_DetectDocumentByName');
  late final _id3DocumentDetector_DetectDocumentByName =
      _id3DocumentDetector_DetectDocumentByNamePtr.asFunction<
          int Function(
              ID3_DOCUMENT_DETECTOR,
              ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<id3DocumentRectangle>,
              ID3_DETECTED_DOCUMENT)>();

  ffi.Pointer<ffi.Char> id3Document_GetDocumentErrorString(
    int value,
  ) {
    return _id3Document_GetDocumentErrorString(
      value,
    );
  }

  late final _id3Document_GetDocumentErrorStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetDocumentErrorString');
  late final _id3Document_GetDocumentErrorString =
      _id3Document_GetDocumentErrorStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Document_GetDocumentErrorMessage(
    int value,
  ) {
    return _id3Document_GetDocumentErrorMessage(
      value,
    );
  }

  late final _id3Document_GetDocumentErrorMessagePtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetDocumentErrorMessage');
  late final _id3Document_GetDocumentErrorMessage =
      _id3Document_GetDocumentErrorMessagePtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Document_GetImageErrorString(
    int value,
  ) {
    return _id3Document_GetImageErrorString(
      value,
    );
  }

  late final _id3Document_GetImageErrorStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetImageErrorString');
  late final _id3Document_GetImageErrorString =
      _id3Document_GetImageErrorStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Document_GetImageErrorMessage(
    int value,
  ) {
    return _id3Document_GetImageErrorMessage(
      value,
    );
  }

  late final _id3Document_GetImageErrorMessagePtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetImageErrorMessage');
  late final _id3Document_GetImageErrorMessage =
      _id3Document_GetImageErrorMessagePtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a StringList object.
  /// @param phStringList [in] Handle to the StringList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringList_Initialize(
    ffi.Pointer<ID3_DOCUMENT_STRING_LIST> phStringList,
  ) {
    return _id3DocumentStringList_Initialize(
      phStringList,
    );
  }

  late final _id3DocumentStringList_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_STRING_LIST>)>>(
      'id3DocumentStringList_Initialize');
  late final _id3DocumentStringList_Initialize =
      _id3DocumentStringList_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_STRING_LIST>)>();

  /// @brief Releases the memory allocated for a StringList.
  /// @param phStringList [in] Handle to the StringList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringList_Dispose(
    ffi.Pointer<ID3_DOCUMENT_STRING_LIST> phStringList,
  ) {
    return _id3DocumentStringList_Dispose(
      phStringList,
    );
  }

  late final _id3DocumentStringList_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_STRING_LIST>)>>(
      'id3DocumentStringList_Dispose');
  late final _id3DocumentStringList_Dispose = _id3DocumentStringList_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_STRING_LIST>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hStringList [in] Handle to the StringList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringList_CheckHandle(
    ID3_DOCUMENT_STRING_LIST hStringList,
  ) {
    return _id3DocumentStringList_CheckHandle(
      hStringList,
    );
  }

  late final _id3DocumentStringList_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_STRING_LIST)>>(
          'id3DocumentStringList_CheckHandle');
  late final _id3DocumentStringList_CheckHandle =
      _id3DocumentStringList_CheckHandlePtr
          .asFunction<int Function(ID3_DOCUMENT_STRING_LIST)>();

  /// @brief Copies an instance of StringList object to another.
  /// @param hStringListSrc [in] Handle to the source StringList object.
  /// @param hStringListDst [in] Handle to the destination StringList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringList_CopyTo(
    ID3_DOCUMENT_STRING_LIST hStringListSrc,
    ID3_DOCUMENT_STRING_LIST hStringListDst,
  ) {
    return _id3DocumentStringList_CopyTo(
      hStringListSrc,
      hStringListDst,
    );
  }

  late final _id3DocumentStringList_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_STRING_LIST,
              ID3_DOCUMENT_STRING_LIST)>>('id3DocumentStringList_CopyTo');
  late final _id3DocumentStringList_CopyTo =
      _id3DocumentStringList_CopyToPtr.asFunction<
          int Function(ID3_DOCUMENT_STRING_LIST, ID3_DOCUMENT_STRING_LIST)>();

  /// Clears the StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringList_Clear(
    ID3_DOCUMENT_STRING_LIST hStringList,
  ) {
    return _id3DocumentStringList_Clear(
      hStringList,
    );
  }

  late final _id3DocumentStringList_ClearPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_STRING_LIST)>>(
          'id3DocumentStringList_Clear');
  late final _id3DocumentStringList_Clear = _id3DocumentStringList_ClearPtr
      .asFunction<int Function(ID3_DOCUMENT_STRING_LIST)>();

  /// Adds an item to the StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @param item [in]  item to add.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringList_Add(
    ID3_DOCUMENT_STRING_LIST hStringList,
    ffi.Pointer<ffi.Char> item,
  ) {
    return _id3DocumentStringList_Add(
      hStringList,
      item,
    );
  }

  late final _id3DocumentStringList_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_STRING_LIST,
              ffi.Pointer<ffi.Char>)>>('id3DocumentStringList_Add');
  late final _id3DocumentStringList_Add =
      _id3DocumentStringList_AddPtr.asFunction<
          int Function(ID3_DOCUMENT_STRING_LIST, ffi.Pointer<ffi.Char>)>();

  /// Gets an item of the StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @param index [in] Index of the  item to get.
  /// @param item [out]  item to get.
  /// @param itemSize [in,out] Size of the 'item' buffer. Receives the minimum required buffer size to hold the 'item' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'item' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringList_Get(
    ID3_DOCUMENT_STRING_LIST hStringList,
    int index,
    ffi.Pointer<ffi.Char> item,
    ffi.Pointer<ffi.Int> itemSize,
  ) {
    return _id3DocumentStringList_Get(
      hStringList,
      index,
      item,
      itemSize,
    );
  }

  late final _id3DocumentStringList_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_STRING_LIST,
              ffi.Int,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentStringList_Get');
  late final _id3DocumentStringList_Get =
      _id3DocumentStringList_GetPtr.asFunction<
          int Function(ID3_DOCUMENT_STRING_LIST, int, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>();

  /// Sets an item of the StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @param index [in] Index of the  item to set.
  /// @param item [in]  item to set.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringList_Set(
    ID3_DOCUMENT_STRING_LIST hStringList,
    int index,
    ffi.Pointer<ffi.Char> item,
  ) {
    return _id3DocumentStringList_Set(
      hStringList,
      index,
      item,
    );
  }

  late final _id3DocumentStringList_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_STRING_LIST, ffi.Int,
              ffi.Pointer<ffi.Char>)>>('id3DocumentStringList_Set');
  late final _id3DocumentStringList_Set =
      _id3DocumentStringList_SetPtr.asFunction<
          int Function(ID3_DOCUMENT_STRING_LIST, int, ffi.Pointer<ffi.Char>)>();

  /// Gets the number of elements in the StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @param count [out] Number of elements in the  object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringList_GetCount(
    ID3_DOCUMENT_STRING_LIST hStringList,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3DocumentStringList_GetCount(
      hStringList,
      count,
    );
  }

  late final _id3DocumentStringList_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_STRING_LIST,
              ffi.Pointer<ffi.Int>)>>('id3DocumentStringList_GetCount');
  late final _id3DocumentStringList_GetCount =
      _id3DocumentStringList_GetCountPtr.asFunction<
          int Function(ID3_DOCUMENT_STRING_LIST, ffi.Pointer<ffi.Int>)>();

  /// Removes an element of the StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @param index [in] Index of the  item to remove.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringList_RemoveAt(
    ID3_DOCUMENT_STRING_LIST hStringList,
    int index,
  ) {
    return _id3DocumentStringList_RemoveAt(
      hStringList,
      index,
    );
  }

  late final _id3DocumentStringList_RemoveAtPtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_DOCUMENT_STRING_LIST, ffi.Int)>>(
      'id3DocumentStringList_RemoveAt');
  late final _id3DocumentStringList_RemoveAt =
      _id3DocumentStringList_RemoveAtPtr
          .asFunction<int Function(ID3_DOCUMENT_STRING_LIST, int)>();

  /// StringList object.
  /// @param hStringList [in] Handle to the StringList object.
  /// @param newSize [in]  object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringList_Resize(
    ID3_DOCUMENT_STRING_LIST hStringList,
    int newSize,
  ) {
    return _id3DocumentStringList_Resize(
      hStringList,
      newSize,
    );
  }

  late final _id3DocumentStringList_ResizePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_DOCUMENT_STRING_LIST, ffi.Int)>>(
      'id3DocumentStringList_Resize');
  late final _id3DocumentStringList_Resize = _id3DocumentStringList_ResizePtr
      .asFunction<int Function(ID3_DOCUMENT_STRING_LIST, int)>();

  /// @brief Initializes a DocumentInfoDictionary object.
  /// @param phDocumentInfoDictionary [in] Handle to the DocumentInfoDictionary object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfoDictionary_Initialize(
    ffi.Pointer<ID3_DOCUMENT_INFO_DICTIONARY> phDocumentInfoDictionary,
  ) {
    return _id3DocumentInfoDictionary_Initialize(
      phDocumentInfoDictionary,
    );
  }

  late final _id3DocumentInfoDictionary_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_INFO_DICTIONARY>)>>(
      'id3DocumentInfoDictionary_Initialize');
  late final _id3DocumentInfoDictionary_Initialize =
      _id3DocumentInfoDictionary_InitializePtr.asFunction<
          int Function(ffi.Pointer<ID3_DOCUMENT_INFO_DICTIONARY>)>();

  /// @brief Releases the memory allocated for a DocumentInfoDictionary.
  /// @param phDocumentInfoDictionary [in] Handle to the DocumentInfoDictionary object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfoDictionary_Dispose(
    ffi.Pointer<ID3_DOCUMENT_INFO_DICTIONARY> phDocumentInfoDictionary,
  ) {
    return _id3DocumentInfoDictionary_Dispose(
      phDocumentInfoDictionary,
    );
  }

  late final _id3DocumentInfoDictionary_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_INFO_DICTIONARY>)>>(
      'id3DocumentInfoDictionary_Dispose');
  late final _id3DocumentInfoDictionary_Dispose =
      _id3DocumentInfoDictionary_DisposePtr.asFunction<
          int Function(ffi.Pointer<ID3_DOCUMENT_INFO_DICTIONARY>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hDocumentInfoDictionary [in] Handle to the DocumentInfoDictionary object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfoDictionary_CheckHandle(
    ID3_DOCUMENT_INFO_DICTIONARY hDocumentInfoDictionary,
  ) {
    return _id3DocumentInfoDictionary_CheckHandle(
      hDocumentInfoDictionary,
    );
  }

  late final _id3DocumentInfoDictionary_CheckHandlePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_INFO_DICTIONARY)>>(
      'id3DocumentInfoDictionary_CheckHandle');
  late final _id3DocumentInfoDictionary_CheckHandle =
      _id3DocumentInfoDictionary_CheckHandlePtr
          .asFunction<int Function(ID3_DOCUMENT_INFO_DICTIONARY)>();

  /// @brief Copies an instance of DocumentInfoDictionary object to another.
  /// @param hDocumentInfoDictionarySrc [in] Handle to the source DocumentInfoDictionary object.
  /// @param hDocumentInfoDictionaryDst [in] Handle to the destination DocumentInfoDictionary object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfoDictionary_CopyTo(
    ID3_DOCUMENT_INFO_DICTIONARY hDocumentInfoDictionarySrc,
    ID3_DOCUMENT_INFO_DICTIONARY hDocumentInfoDictionaryDst,
  ) {
    return _id3DocumentInfoDictionary_CopyTo(
      hDocumentInfoDictionarySrc,
      hDocumentInfoDictionaryDst,
    );
  }

  late final _id3DocumentInfoDictionary_CopyToPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DOCUMENT_INFO_DICTIONARY, ID3_DOCUMENT_INFO_DICTIONARY)>>(
      'id3DocumentInfoDictionary_CopyTo');
  late final _id3DocumentInfoDictionary_CopyTo =
      _id3DocumentInfoDictionary_CopyToPtr.asFunction<
          int Function(
              ID3_DOCUMENT_INFO_DICTIONARY, ID3_DOCUMENT_INFO_DICTIONARY)>();

  /// Gets the gets a string list containing the keys in the dict.
  /// @param hDocumentInfoDictionary [in] Handle to the DocumentInfoDictionary object.
  /// @param hKeys [out] Gets a string list containing the keys in the dict.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfoDictionary_GetKeys(
    ID3_DOCUMENT_INFO_DICTIONARY hDocumentInfoDictionary,
    ID3_DOCUMENT_STRING_LIST hKeys,
  ) {
    return _id3DocumentInfoDictionary_GetKeys(
      hDocumentInfoDictionary,
      hKeys,
    );
  }

  late final _id3DocumentInfoDictionary_GetKeysPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO_DICTIONARY,
              ID3_DOCUMENT_STRING_LIST)>>('id3DocumentInfoDictionary_GetKeys');
  late final _id3DocumentInfoDictionary_GetKeys =
      _id3DocumentInfoDictionary_GetKeysPtr.asFunction<
          int Function(
              ID3_DOCUMENT_INFO_DICTIONARY, ID3_DOCUMENT_STRING_LIST)>();

  /// Clears the DocumentInfoDictionary object.
  /// @param hDocumentInfoDictionary [in] Handle to the DocumentInfoDictionary object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfoDictionary_Clear(
    ID3_DOCUMENT_INFO_DICTIONARY hDocumentInfoDictionary,
  ) {
    return _id3DocumentInfoDictionary_Clear(
      hDocumentInfoDictionary,
    );
  }

  late final _id3DocumentInfoDictionary_ClearPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_INFO_DICTIONARY)>>(
      'id3DocumentInfoDictionary_Clear');
  late final _id3DocumentInfoDictionary_Clear =
      _id3DocumentInfoDictionary_ClearPtr
          .asFunction<int Function(ID3_DOCUMENT_INFO_DICTIONARY)>();

  /// Adds an item to the DocumentInfoDictionary object.
  /// @param hDocumentInfoDictionary [in] Handle to the DocumentInfoDictionary object.
  /// @param key [in] Unique key of the DocumentInfo item to add.
  /// @param hDocumentInfoItem [in] DocumentInfo item to add.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfoDictionary_Add(
    ID3_DOCUMENT_INFO_DICTIONARY hDocumentInfoDictionary,
    ffi.Pointer<ffi.Char> key,
    ID3_DOCUMENT_INFO hDocumentInfoItem,
  ) {
    return _id3DocumentInfoDictionary_Add(
      hDocumentInfoDictionary,
      key,
      hDocumentInfoItem,
    );
  }

  late final _id3DocumentInfoDictionary_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO_DICTIONARY, ffi.Pointer<ffi.Char>,
              ID3_DOCUMENT_INFO)>>('id3DocumentInfoDictionary_Add');
  late final _id3DocumentInfoDictionary_Add =
      _id3DocumentInfoDictionary_AddPtr.asFunction<
          int Function(ID3_DOCUMENT_INFO_DICTIONARY, ffi.Pointer<ffi.Char>,
              ID3_DOCUMENT_INFO)>();

  /// Gets an item of the DocumentInfoDictionary object.
  /// @param hDocumentInfoDictionary [in] Handle to the DocumentInfoDictionary object.
  /// @param key [in] Unique key of the DocumentInfo item to get.
  /// @param hDocumentInfoItem [out] DocumentInfo item to get.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfoDictionary_Get(
    ID3_DOCUMENT_INFO_DICTIONARY hDocumentInfoDictionary,
    ffi.Pointer<ffi.Char> key,
    ID3_DOCUMENT_INFO hDocumentInfoItem,
  ) {
    return _id3DocumentInfoDictionary_Get(
      hDocumentInfoDictionary,
      key,
      hDocumentInfoItem,
    );
  }

  late final _id3DocumentInfoDictionary_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO_DICTIONARY, ffi.Pointer<ffi.Char>,
              ID3_DOCUMENT_INFO)>>('id3DocumentInfoDictionary_Get');
  late final _id3DocumentInfoDictionary_Get =
      _id3DocumentInfoDictionary_GetPtr.asFunction<
          int Function(ID3_DOCUMENT_INFO_DICTIONARY, ffi.Pointer<ffi.Char>,
              ID3_DOCUMENT_INFO)>();

  /// Sets an item of the DocumentInfoDictionary object.
  /// @param hDocumentInfoDictionary [in] Handle to the DocumentInfoDictionary object.
  /// @param key [in] Unique key of the DocumentInfo item to set.
  /// @param hDocumentInfoItem [in] DocumentInfo item to set.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfoDictionary_Set(
    ID3_DOCUMENT_INFO_DICTIONARY hDocumentInfoDictionary,
    ffi.Pointer<ffi.Char> key,
    ID3_DOCUMENT_INFO hDocumentInfoItem,
  ) {
    return _id3DocumentInfoDictionary_Set(
      hDocumentInfoDictionary,
      key,
      hDocumentInfoItem,
    );
  }

  late final _id3DocumentInfoDictionary_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO_DICTIONARY, ffi.Pointer<ffi.Char>,
              ID3_DOCUMENT_INFO)>>('id3DocumentInfoDictionary_Set');
  late final _id3DocumentInfoDictionary_Set =
      _id3DocumentInfoDictionary_SetPtr.asFunction<
          int Function(ID3_DOCUMENT_INFO_DICTIONARY, ffi.Pointer<ffi.Char>,
              ID3_DOCUMENT_INFO)>();

  /// Gets the number of elements in the DocumentInfoDictionary object.
  /// @param hDocumentInfoDictionary [in] Handle to the DocumentInfoDictionary object.
  /// @param count [out] Number of elements in the DocumentInfo object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfoDictionary_GetCount(
    ID3_DOCUMENT_INFO_DICTIONARY hDocumentInfoDictionary,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3DocumentInfoDictionary_GetCount(
      hDocumentInfoDictionary,
      count,
    );
  }

  late final _id3DocumentInfoDictionary_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO_DICTIONARY,
              ffi.Pointer<ffi.Int>)>>('id3DocumentInfoDictionary_GetCount');
  late final _id3DocumentInfoDictionary_GetCount =
      _id3DocumentInfoDictionary_GetCountPtr.asFunction<
          int Function(ID3_DOCUMENT_INFO_DICTIONARY, ffi.Pointer<ffi.Int>)>();

  /// Determines whether the DocumentInfoDictionaryobject contains the specified key.
  /// @param hDocumentInfoDictionary [in] Handle to the DocumentInfoDictionary object.
  /// @param key [in] The key to locate in the DocumentInfo object.
  /// @param result [out] true if the DocumentInfo object contains an element with the specified key, otherwise false.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfoDictionary_ContainsKey(
    ID3_DOCUMENT_INFO_DICTIONARY hDocumentInfoDictionary,
    ffi.Pointer<ffi.Char> key,
    ffi.Pointer<ffi.Bool> result,
  ) {
    return _id3DocumentInfoDictionary_ContainsKey(
      hDocumentInfoDictionary,
      key,
      result,
    );
  }

  late final _id3DocumentInfoDictionary_ContainsKeyPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO_DICTIONARY, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Bool>)>>('id3DocumentInfoDictionary_ContainsKey');
  late final _id3DocumentInfoDictionary_ContainsKey =
      _id3DocumentInfoDictionary_ContainsKeyPtr.asFunction<
          int Function(ID3_DOCUMENT_INFO_DICTIONARY, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Bool>)>();

  /// Removes an element of the DocumentInfoDictionary object.
  /// @param hDocumentInfoDictionary [in] Handle to the DocumentInfoDictionary object.
  /// @param key [in] Unique key of the DocumentInfo item to remove.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentInfoDictionary_Remove(
    ID3_DOCUMENT_INFO_DICTIONARY hDocumentInfoDictionary,
    ffi.Pointer<ffi.Char> key,
  ) {
    return _id3DocumentInfoDictionary_Remove(
      hDocumentInfoDictionary,
      key,
    );
  }

  late final _id3DocumentInfoDictionary_RemovePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_INFO_DICTIONARY,
              ffi.Pointer<ffi.Char>)>>('id3DocumentInfoDictionary_Remove');
  late final _id3DocumentInfoDictionary_Remove =
      _id3DocumentInfoDictionary_RemovePtr.asFunction<
          int Function(ID3_DOCUMENT_INFO_DICTIONARY, ffi.Pointer<ffi.Char>)>();

  /// Retrieves the library version as a 'X.Y.Z' formatted string.
  /// @param libraryVersion [out] A string that identifies the library version.
  /// @param libraryVersionSize [in,out] Size of the 'libraryVersion' buffer. Receives the minimum required buffer size to hold the 'libraryVersion' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'libraryVersion' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLibrary_GetVersion(
    ffi.Pointer<ffi.Char> libraryVersion,
    ffi.Pointer<ffi.Int> libraryVersionSize,
  ) {
    return _id3DocumentLibrary_GetVersion(
      libraryVersion,
      libraryVersionSize,
    );
  }

  late final _id3DocumentLibrary_GetVersionPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentLibrary_GetVersion');
  late final _id3DocumentLibrary_GetVersion = _id3DocumentLibrary_GetVersionPtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the library version as a structure.
  /// @param sVersion [out] The version.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLibrary_GetVersionEx(
    ffi.Pointer<id3DocumentLibVersion> sVersion,
  ) {
    return _id3DocumentLibrary_GetVersionEx(
      sVersion,
    );
  }

  late final _id3DocumentLibrary_GetVersionExPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<id3DocumentLibVersion>)>>(
      'id3DocumentLibrary_GetVersionEx');
  late final _id3DocumentLibrary_GetVersionEx =
      _id3DocumentLibrary_GetVersionExPtr
          .asFunction<int Function(ffi.Pointer<id3DocumentLibVersion>)>();

  /// Loads the specified document template from a file.
  /// @param path [in] A string that contains the full path to the document template.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLibrary_LoadDocumentTemplate(
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3DocumentLibrary_LoadDocumentTemplate(
      path,
    );
  }

  late final _id3DocumentLibrary_LoadDocumentTemplatePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Char>)>>(
          'id3DocumentLibrary_LoadDocumentTemplate');
  late final _id3DocumentLibrary_LoadDocumentTemplate =
      _id3DocumentLibrary_LoadDocumentTemplatePtr
          .asFunction<int Function(ffi.Pointer<ffi.Char>)>();

  /// Loads a document template from a data buffer.
  /// @param buffer [in] A buffer containing the document template data.
  /// @param bufferSize [in] Size of the 'buffer' buffer.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLibrary_LoadDocumentTemplateBuffer(
    ffi.Pointer<ffi.UnsignedChar> buffer,
    int bufferSize,
  ) {
    return _id3DocumentLibrary_LoadDocumentTemplateBuffer(
      buffer,
      bufferSize,
    );
  }

  late final _id3DocumentLibrary_LoadDocumentTemplateBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int)>>('id3DocumentLibrary_LoadDocumentTemplateBuffer');
  late final _id3DocumentLibrary_LoadDocumentTemplateBuffer =
      _id3DocumentLibrary_LoadDocumentTemplateBufferPtr
          .asFunction<int Function(ffi.Pointer<ffi.UnsignedChar>, int)>();

  /// Loads a model into memory from the specified directory.
  /// @param modelPath [in] The path to directory containing the AI model files.
  /// @param eDocumentModel [in] The AI model to be loaded.
  /// @param eProcessingUnit [in] Processing unit to load the model into.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLibrary_LoadModel(
    ffi.Pointer<ffi.Char> modelPath,
    int eDocumentModel,
    int eProcessingUnit,
  ) {
    return _id3DocumentLibrary_LoadModel(
      modelPath,
      eDocumentModel,
      eProcessingUnit,
    );
  }

  late final _id3DocumentLibrary_LoadModelPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Int32,
              ffi.Int32)>>('id3DocumentLibrary_LoadModel');
  late final _id3DocumentLibrary_LoadModel = _id3DocumentLibrary_LoadModelPtr
      .asFunction<int Function(ffi.Pointer<ffi.Char>, int, int)>();

  /// Loads a model into memory from the specified buffer.
  /// @param modelBuffer [in] A buffer containing the AI model to be loaded.
  /// @param modelBufferSize [in] Size of the 'modelBuffer' buffer.
  /// @param eDocumentModel [in] Doc model to load.
  /// @param eProcessingUnit [in] The processing unit to use for the model.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLibrary_LoadModelBuffer(
    ffi.Pointer<ffi.UnsignedChar> modelBuffer,
    int modelBufferSize,
    int eDocumentModel,
    int eProcessingUnit,
  ) {
    return _id3DocumentLibrary_LoadModelBuffer(
      modelBuffer,
      modelBufferSize,
      eDocumentModel,
      eProcessingUnit,
    );
  }

  late final _id3DocumentLibrary_LoadModelBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.UnsignedChar>, ffi.Int, ffi.Int32,
              ffi.Int32)>>('id3DocumentLibrary_LoadModelBuffer');
  late final _id3DocumentLibrary_LoadModelBuffer =
      _id3DocumentLibrary_LoadModelBufferPtr.asFunction<
          int Function(ffi.Pointer<ffi.UnsignedChar>, int, int, int)>();

  /// Unloads a document template.
  /// @param documentName [in] The document name.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLibrary_UnloadDocumentTemplate(
    ffi.Pointer<ffi.Char> documentName,
  ) {
    return _id3DocumentLibrary_UnloadDocumentTemplate(
      documentName,
    );
  }

  late final _id3DocumentLibrary_UnloadDocumentTemplatePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Char>)>>(
          'id3DocumentLibrary_UnloadDocumentTemplate');
  late final _id3DocumentLibrary_UnloadDocumentTemplate =
      _id3DocumentLibrary_UnloadDocumentTemplatePtr
          .asFunction<int Function(ffi.Pointer<ffi.Char>)>();

  /// Unloads a model from memory.
  /// @param eDocumentModel [in] The AI model to be unloaded.
  /// @param eProcessingUnit [in] The processing unit used for the model.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLibrary_UnloadModel(
    int eDocumentModel,
    int eProcessingUnit,
  ) {
    return _id3DocumentLibrary_UnloadModel(
      eDocumentModel,
      eProcessingUnit,
    );
  }

  late final _id3DocumentLibrary_UnloadModelPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Int32, ffi.Int32)>>(
          'id3DocumentLibrary_UnloadModel');
  late final _id3DocumentLibrary_UnloadModel =
      _id3DocumentLibrary_UnloadModelPtr.asFunction<int Function(int, int)>();

  ffi.Pointer<ffi.Char> id3Document_GetLicenseHardwareCodeTypeString(
    int value,
  ) {
    return _id3Document_GetLicenseHardwareCodeTypeString(
      value,
    );
  }

  late final _id3Document_GetLicenseHardwareCodeTypeStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetLicenseHardwareCodeTypeString');
  late final _id3Document_GetLicenseHardwareCodeTypeString =
      _id3Document_GetLicenseHardwareCodeTypeStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Document_GetLicenseTypeString(
    int value,
  ) {
    return _id3Document_GetLicenseTypeString(
      value,
    );
  }

  late final _id3Document_GetLicenseTypeStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetLicenseTypeString');
  late final _id3Document_GetLicenseTypeString =
      _id3Document_GetLicenseTypeStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// Activates a license using customer credentials and a product reference and saves the license to a file.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param login [in] The id3 account login.
  /// @param password [in] The id3 account password.
  /// @param productReference [in] The requested product reference.
  /// @param commentary [in] Commentary associated to this license activation.
  /// @param path [in] Path to the retrieved license file.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_Activate(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> login,
    ffi.Pointer<ffi.Char> password,
    ffi.Pointer<ffi.Char> productReference,
    ffi.Pointer<ffi.Char> commentary,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3DocumentLicense_Activate(
      hardwareCode,
      login,
      password,
      productReference,
      commentary,
      path,
    );
  }

  late final _id3DocumentLicense_ActivatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('id3DocumentLicense_Activate');
  late final _id3DocumentLicense_Activate =
      _id3DocumentLicense_ActivatePtr.asFunction<
          int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>();

  /// Activates a license file using an activation key and saves the license to a file.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param activationKey [in] The activation key.
  /// @param commentary [in] Commentary associated to this license activation, generally the host name.
  /// @param path [in] Path to the retrieved license file.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_ActivateActivationKey(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> activationKey,
    ffi.Pointer<ffi.Char> commentary,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3DocumentLicense_ActivateActivationKey(
      hardwareCode,
      activationKey,
      commentary,
      path,
    );
  }

  late final _id3DocumentLicense_ActivateActivationKeyPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>)>>(
      'id3DocumentLicense_ActivateActivationKey');
  late final _id3DocumentLicense_ActivateActivationKey =
      _id3DocumentLicense_ActivateActivationKeyPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>)>();

  /// Activates a license using an activation key and returns the license in a data buffer.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param activationKey [in] The id3 activation key.
  /// @param commentary [in] Commentary associated to this license activation.
  /// @param licenseFileBuffer [out] The license data buffer.
  /// @param licenseFileBufferSize [in,out] Size of the 'licenseFileBuffer' buffer. Receives the number of elements in the 'licenseFileBuffer' array.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_ActivateActivationKeyBuffer(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> activationKey,
    ffi.Pointer<ffi.Char> commentary,
    ffi.Pointer<ffi.UnsignedChar> licenseFileBuffer,
    ffi.Pointer<ffi.Int> licenseFileBufferSize,
  ) {
    return _id3DocumentLicense_ActivateActivationKeyBuffer(
      hardwareCode,
      activationKey,
      commentary,
      licenseFileBuffer,
      licenseFileBufferSize,
    );
  }

  late final _id3DocumentLicense_ActivateActivationKeyBufferPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.UnsignedChar>,
                  ffi.Pointer<ffi.Int>)>>(
      'id3DocumentLicense_ActivateActivationKeyBuffer');
  late final _id3DocumentLicense_ActivateActivationKeyBuffer =
      _id3DocumentLicense_ActivateActivationKeyBufferPtr.asFunction<
          int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// Retrieves a license file buffer using customer credentials and a product reference and returns the license in a data buffer.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param login [in] The customer login.
  /// @param password [in] The customer password.
  /// @param productReference [in] The requested product reference.
  /// @param commentary [in] Commentary associated to this license activation, generally the host name.
  /// @param licenseFileBuffer [out] The license data.
  /// @param licenseFileBufferSize [in,out] Size of the 'licenseFileBuffer' buffer. Receives the number of elements in the 'licenseFileBuffer' array.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_ActivateBuffer(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> login,
    ffi.Pointer<ffi.Char> password,
    ffi.Pointer<ffi.Char> productReference,
    ffi.Pointer<ffi.Char> commentary,
    ffi.Pointer<ffi.UnsignedChar> licenseFileBuffer,
    ffi.Pointer<ffi.Int> licenseFileBufferSize,
  ) {
    return _id3DocumentLicense_ActivateBuffer(
      hardwareCode,
      login,
      password,
      productReference,
      commentary,
      licenseFileBuffer,
      licenseFileBufferSize,
    );
  }

  late final _id3DocumentLicense_ActivateBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentLicense_ActivateBuffer');
  late final _id3DocumentLicense_ActivateBuffer =
      _id3DocumentLicense_ActivateBufferPtr.asFunction<
          int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// Activates a license using a serial key and saves the license to a file.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param serialKey [in] The serial key to activate.
  /// @param commentary [in] Commentary associated to this license activation, generally the host name.
  /// @param path [in] Path to the license file.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_ActivateSerialKey(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> serialKey,
    ffi.Pointer<ffi.Char> commentary,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3DocumentLicense_ActivateSerialKey(
      hardwareCode,
      serialKey,
      commentary,
      path,
    );
  }

  late final _id3DocumentLicense_ActivateSerialKeyPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('id3DocumentLicense_ActivateSerialKey');
  late final _id3DocumentLicense_ActivateSerialKey =
      _id3DocumentLicense_ActivateSerialKeyPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>)>();

  /// Activates a license using a serial key and returns the license in a data buffer.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param serialKey [in] The id3 serial key.
  /// @param commentary [in] Commentary associated to this license activation.
  /// @param licenseFileBuffer [out] The license data buffer.
  /// @param licenseFileBufferSize [in,out] Size of the 'licenseFileBuffer' buffer. Receives the number of elements in the 'licenseFileBuffer' array.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_ActivateSerialKeyBuffer(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> serialKey,
    ffi.Pointer<ffi.Char> commentary,
    ffi.Pointer<ffi.UnsignedChar> licenseFileBuffer,
    ffi.Pointer<ffi.Int> licenseFileBufferSize,
  ) {
    return _id3DocumentLicense_ActivateSerialKeyBuffer(
      hardwareCode,
      serialKey,
      commentary,
      licenseFileBuffer,
      licenseFileBufferSize,
    );
  }

  late final _id3DocumentLicense_ActivateSerialKeyBufferPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.UnsignedChar>,
                  ffi.Pointer<ffi.Int>)>>(
      'id3DocumentLicense_ActivateSerialKeyBuffer');
  late final _id3DocumentLicense_ActivateSerialKeyBuffer =
      _id3DocumentLicense_ActivateSerialKeyBufferPtr.asFunction<
          int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// Checks a license from a file.
  /// This function does two things:
  /// - First it loads the license from a file using the given path
  /// - Then it checks the validity of the license regarding the host it is called on (Windows, Linux, Android ...)
  /// Important: Calling this function is required to get access to the license member getters.
  /// Note: The optional parameter is required on Android and must be the JNIEnv* pointer casted as a void*. It can be set as NULL for other devices.
  /// @param licensePath [in] Absolute or relative path to the license file.
  /// @param optionalParameter [in] Only used on Android: JNIEnv* pointer casted as a void*. Ignored for other devices.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_CheckLicense(
    ffi.Pointer<ffi.Char> licensePath,
    ffi.Pointer<ffi.Void> optionalParameter,
  ) {
    return _id3DocumentLicense_CheckLicense(
      licensePath,
      optionalParameter,
    );
  }

  late final _id3DocumentLicense_CheckLicensePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Void>)>>('id3DocumentLicense_CheckLicense');
  late final _id3DocumentLicense_CheckLicense =
      _id3DocumentLicense_CheckLicensePtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Void>)>();

  /// Checks a license from a buffer.
  /// This function does two things:
  /// - First it loads the license from a buffer
  /// - Then it checks the validity of the license regarding the host it is called on (Windows, Linux, Android ...)
  /// Important: Calling one of the license checking function is required to get access to all the license member getters.
  /// Note: The optional parameter is required on Android and must be the JNIEnv* pointer casted as a void*. It can be set as NULL for other devices.
  /// @param licenseData [in] A buffer containing the license file data.
  /// @param licenseDataSize [in] Size of the 'licenseData' buffer.
  /// @param optionalParameter [in] Only used on Android: JNIEnv* pointer casted as a void*. Ignored for other devices.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_CheckLicenseBuffer(
    ffi.Pointer<ffi.UnsignedChar> licenseData,
    int licenseDataSize,
    ffi.Pointer<ffi.Void> optionalParameter,
  ) {
    return _id3DocumentLicense_CheckLicenseBuffer(
      licenseData,
      licenseDataSize,
      optionalParameter,
    );
  }

  late final _id3DocumentLicense_CheckLicenseBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.UnsignedChar>, ffi.Int,
              ffi.Pointer<ffi.Void>)>>('id3DocumentLicense_CheckLicenseBuffer');
  late final _id3DocumentLicense_CheckLicenseBuffer =
      _id3DocumentLicense_CheckLicenseBufferPtr.asFunction<
          int Function(
              ffi.Pointer<ffi.UnsignedChar>, int, ffi.Pointer<ffi.Void>)>();

  /// Checks the license using a buffer containing the license data and a card-based verification process.
  /// It outputs a challenge response for further verification.
  /// @param licenseData [in] A buffer containing the license file data.
  /// @param licenseDataSize [in] Size of the 'licenseData' buffer.
  /// @param challengeR1 [out] An array to hold the challenge response generated by the host.
  /// @param challengeR1Size [in,out] Size of the 'challengeR1' buffer. Receives the number of elements in the 'challengeR1' array.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_CheckLicenseBufferWithCard(
    ffi.Pointer<ffi.UnsignedChar> licenseData,
    int licenseDataSize,
    ffi.Pointer<ffi.UnsignedChar> challengeR1,
    ffi.Pointer<ffi.Int> challengeR1Size,
  ) {
    return _id3DocumentLicense_CheckLicenseBufferWithCard(
      licenseData,
      licenseDataSize,
      challengeR1,
      challengeR1Size,
    );
  }

  late final _id3DocumentLicense_CheckLicenseBufferWithCardPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ffi.UnsignedChar>, ffi.Int,
                  ffi.Pointer<ffi.UnsignedChar>, ffi.Pointer<ffi.Int>)>>(
      'id3DocumentLicense_CheckLicenseBufferWithCard');
  late final _id3DocumentLicense_CheckLicenseBufferWithCard =
      _id3DocumentLicense_CheckLicenseBufferWithCardPtr.asFunction<
          int Function(ffi.Pointer<ffi.UnsignedChar>, int,
              ffi.Pointer<ffi.UnsignedChar>, ffi.Pointer<ffi.Int>)>();

  /// Checks the license by using a card-based verification process.
  /// It takes the path to the license file and outputs a challenge response for further verification.
  /// @param licensePath [in] The file path to the license that needs to be checked.
  /// @param challengeR1 [out] An array to hold the challenge response generated by the host.
  /// @param challengeR1Size [in,out] Size of the 'challengeR1' buffer. Receives the number of elements in the 'challengeR1' array.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_CheckLicenseWithCard(
    ffi.Pointer<ffi.Char> licensePath,
    ffi.Pointer<ffi.UnsignedChar> challengeR1,
    ffi.Pointer<ffi.Int> challengeR1Size,
  ) {
    return _id3DocumentLicense_CheckLicenseWithCard(
      licensePath,
      challengeR1,
      challengeR1Size,
    );
  }

  late final _id3DocumentLicense_CheckLicenseWithCardPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.UnsignedChar>, ffi.Pointer<ffi.Int>)>>(
      'id3DocumentLicense_CheckLicenseWithCard');
  late final _id3DocumentLicense_CheckLicenseWithCard =
      _id3DocumentLicense_CheckLicenseWithCardPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>();

  /// Checks if a module is present in the previously loaded license.
  /// @param moduleName [in] The module name.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_CheckModule(
    ffi.Pointer<ffi.Char> moduleName,
  ) {
    return _id3DocumentLicense_CheckModule(
      moduleName,
    );
  }

  late final _id3DocumentLicense_CheckModulePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Char>)>>(
          'id3DocumentLicense_CheckModule');
  late final _id3DocumentLicense_CheckModule =
      _id3DocumentLicense_CheckModulePtr
          .asFunction<int Function(ffi.Pointer<ffi.Char>)>();

  /// Finalizes the license check process using the provided cryptogram.
  /// It ensures the integrity and authenticity of the license verification.
  /// @param cryptogram [in] A 32-byte array containing the cryptogram used for final verification.
  /// @param cryptogramSize [in] Size of the 'cryptogram' buffer.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_FinalizeCheckLicenseWithCard(
    ffi.Pointer<ffi.UnsignedChar> cryptogram,
    int cryptogramSize,
  ) {
    return _id3DocumentLicense_FinalizeCheckLicenseWithCard(
      cryptogram,
      cryptogramSize,
    );
  }

  late final _id3DocumentLicense_FinalizeCheckLicenseWithCardPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.UnsignedChar>,
              ffi.Int)>>('id3DocumentLicense_FinalizeCheckLicenseWithCard');
  late final _id3DocumentLicense_FinalizeCheckLicenseWithCard =
      _id3DocumentLicense_FinalizeCheckLicenseWithCardPtr
          .asFunction<int Function(ffi.Pointer<ffi.UnsignedChar>, int)>();

  /// Retrieves the license expiry date.
  /// @param expiryDate [out] The license expiry date.
  /// @param expiryDateSize [in,out] Size of the 'expiryDate' buffer. Receives the minimum required buffer size to hold the 'expiryDate' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'expiryDate' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetExpiryDate(
    ffi.Pointer<ffi.Char> expiryDate,
    ffi.Pointer<ffi.Int> expiryDateSize,
  ) {
    return _id3DocumentLicense_GetExpiryDate(
      expiryDate,
      expiryDateSize,
    );
  }

  late final _id3DocumentLicense_GetExpiryDatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentLicense_GetExpiryDate');
  late final _id3DocumentLicense_GetExpiryDate =
      _id3DocumentLicense_GetExpiryDatePtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the hardware code of the external drive you run the library on. This function works on Windows only.
  /// @param eHardwareCodeType [in] The requested hardware code type. Must be windowsUsb.
  /// @param code [out] The device hardware code.
  /// @param codeSize [in,out] Size of the 'code' buffer. Receives the minimum required buffer size to hold the 'code' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'code' (excluding terminating NULL character).
  /// @param externalDrivePath [in] On Windows to activate a license on a USB device, it must contain the path to the requested USB drive (e.g 'G:\').
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetExternalDriveHardwareCode(
    int eHardwareCodeType,
    ffi.Pointer<ffi.Char> code,
    ffi.Pointer<ffi.Int> codeSize,
    ffi.Pointer<ffi.Char> externalDrivePath,
  ) {
    return _id3DocumentLicense_GetExternalDriveHardwareCode(
      eHardwareCodeType,
      code,
      codeSize,
      externalDrivePath,
    );
  }

  late final _id3DocumentLicense_GetExternalDriveHardwareCodePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Int32, ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.Int>, ffi.Pointer<ffi.Char>)>>(
      'id3DocumentLicense_GetExternalDriveHardwareCode');
  late final _id3DocumentLicense_GetExternalDriveHardwareCode =
      _id3DocumentLicense_GetExternalDriveHardwareCodePtr.asFunction<
          int Function(int, ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Char>)>();

  /// Retrieves the hardware code of the device using the requested hardware code type.
  /// This function retrieves the hardware code of the device you run the library on.
  /// The optional parameter is required:
  /// - On Android, it must be the JNIEnv* pointer cast as a void*.
  /// - In other cases, it must be set to NULL.
  /// @param eHardwareCodeType [in] The requested hardware code type.
  /// @param code [out] The device hardware code.
  /// @param codeSize [in,out] Size of the 'code' buffer. Receives the minimum required buffer size to hold the 'code' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'code' (excluding terminating NULL character).
  /// @param optionalParameter [in] Only used on Android for JNIEnv* pointer. Ignored for other devices (NULL).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetHostHardwareCode(
    int eHardwareCodeType,
    ffi.Pointer<ffi.Char> code,
    ffi.Pointer<ffi.Int> codeSize,
    ffi.Pointer<ffi.Void> optionalParameter,
  ) {
    return _id3DocumentLicense_GetHostHardwareCode(
      eHardwareCodeType,
      code,
      codeSize,
      optionalParameter,
    );
  }

  late final _id3DocumentLicense_GetHostHardwareCodePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Int32, ffi.Pointer<ffi.Char>,
                  ffi.Pointer<ffi.Int>, ffi.Pointer<ffi.Void>)>>(
      'id3DocumentLicense_GetHostHardwareCode');
  late final _id3DocumentLicense_GetHostHardwareCode =
      _id3DocumentLicense_GetHostHardwareCodePtr.asFunction<
          int Function(int, ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>,
              ffi.Pointer<ffi.Void>)>();

  /// Retrieves the hardware code of the previously loaded license.
  /// @param licenseFileHardwareCode [out] The license hardware code.
  /// @param licenseFileHardwareCodeSize [in,out] Size of the 'licenseFileHardwareCode' buffer. Receives the minimum required buffer size to hold the 'licenseFileHardwareCode' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'licenseFileHardwareCode' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetLicenseFileHardwareCode(
    ffi.Pointer<ffi.Char> licenseFileHardwareCode,
    ffi.Pointer<ffi.Int> licenseFileHardwareCodeSize,
  ) {
    return _id3DocumentLicense_GetLicenseFileHardwareCode(
      licenseFileHardwareCode,
      licenseFileHardwareCodeSize,
    );
  }

  late final _id3DocumentLicense_GetLicenseFileHardwareCodePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>>(
      'id3DocumentLicense_GetLicenseFileHardwareCode');
  late final _id3DocumentLicense_GetLicenseFileHardwareCode =
      _id3DocumentLicense_GetLicenseFileHardwareCodePtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the serial number of the previously loaded license.
  /// @param licenseFileSerial [out] The license serial number.
  /// @param licenseFileSerialSize [in,out] Size of the 'licenseFileSerial' buffer. Receives the minimum required buffer size to hold the 'licenseFileSerial' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'licenseFileSerial' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetLicenseFileSerial(
    ffi.Pointer<ffi.Char> licenseFileSerial,
    ffi.Pointer<ffi.Int> licenseFileSerialSize,
  ) {
    return _id3DocumentLicense_GetLicenseFileSerial(
      licenseFileSerial,
      licenseFileSerialSize,
    );
  }

  late final _id3DocumentLicense_GetLicenseFileSerialPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>>(
      'id3DocumentLicense_GetLicenseFileSerial');
  late final _id3DocumentLicense_GetLicenseFileSerial =
      _id3DocumentLicense_GetLicenseFileSerialPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the license name.
  /// @param licenseName [out] The license name.
  /// @param licenseNameSize [in,out] Size of the 'licenseName' buffer. Receives the minimum required buffer size to hold the 'licenseName' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'licenseName' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetLicenseName(
    ffi.Pointer<ffi.Char> licenseName,
    ffi.Pointer<ffi.Int> licenseNameSize,
  ) {
    return _id3DocumentLicense_GetLicenseName(
      licenseName,
      licenseNameSize,
    );
  }

  late final _id3DocumentLicense_GetLicenseNamePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentLicense_GetLicenseName');
  late final _id3DocumentLicense_GetLicenseName =
      _id3DocumentLicense_GetLicenseNamePtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the license owner.
  /// @param licenseOwner [out] The license owner.
  /// @param licenseOwnerSize [in,out] Size of the 'licenseOwner' buffer. Receives the minimum required buffer size to hold the 'licenseOwner' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'licenseOwner' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetLicenseOwner(
    ffi.Pointer<ffi.Char> licenseOwner,
    ffi.Pointer<ffi.Int> licenseOwnerSize,
  ) {
    return _id3DocumentLicense_GetLicenseOwner(
      licenseOwner,
      licenseOwnerSize,
    );
  }

  late final _id3DocumentLicense_GetLicenseOwnerPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentLicense_GetLicenseOwner');
  late final _id3DocumentLicense_GetLicenseOwner =
      _id3DocumentLicense_GetLicenseOwnerPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the license path.
  /// @param licensePath [out] The license path.
  /// @param licensePathSize [in,out] Size of the 'licensePath' buffer. Receives the minimum required buffer size to hold the 'licensePath' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'licensePath' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetLicensePath(
    ffi.Pointer<ffi.Char> licensePath,
    ffi.Pointer<ffi.Int> licensePathSize,
  ) {
    return _id3DocumentLicense_GetLicensePath(
      licensePath,
      licensePathSize,
    );
  }

  late final _id3DocumentLicense_GetLicensePathPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentLicense_GetLicensePath');
  late final _id3DocumentLicense_GetLicensePath =
      _id3DocumentLicense_GetLicensePathPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the license type.
  /// @param eDocumentLicenseType [out] The license type.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetLicenseType(
    ffi.Pointer<ffi.Int32> eDocumentLicenseType,
  ) {
    return _id3DocumentLicense_GetLicenseType(
      eDocumentLicenseType,
    );
  }

  late final _id3DocumentLicense_GetLicenseTypePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Int32>)>>(
          'id3DocumentLicense_GetLicenseType');
  late final _id3DocumentLicense_GetLicenseType =
      _id3DocumentLicense_GetLicenseTypePtr
          .asFunction<int Function(ffi.Pointer<ffi.Int32>)>();

  /// Retrieves the number of modules in the license.
  /// @param count [out] The number of modules in the license.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetModuleCount(
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3DocumentLicense_GetModuleCount(
      count,
    );
  }

  late final _id3DocumentLicense_GetModuleCountPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Int>)>>(
          'id3DocumentLicense_GetModuleCount');
  late final _id3DocumentLicense_GetModuleCount =
      _id3DocumentLicense_GetModuleCountPtr
          .asFunction<int Function(ffi.Pointer<ffi.Int>)>();

  /// Retrieves the name of the specified license module.
  /// @param index [in] Index of the module, starting from 0.
  /// @param name [out] The license module name.
  /// @param nameSize [in,out] Size of the 'name' buffer. Receives the minimum required buffer size to hold the 'name' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'name' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetModuleName(
    int index,
    ffi.Pointer<ffi.Char> name,
    ffi.Pointer<ffi.Int> nameSize,
  ) {
    return _id3DocumentLicense_GetModuleName(
      index,
      name,
      nameSize,
    );
  }

  late final _id3DocumentLicense_GetModuleNamePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Int, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentLicense_GetModuleName');
  late final _id3DocumentLicense_GetModuleName =
      _id3DocumentLicense_GetModuleNamePtr.asFunction<
          int Function(int, ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the value associated to the specified license module.
  /// @param name [in] Name of the requested module.
  /// @param value [out] The value associated to the licence module.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetModuleValue(
    ffi.Pointer<ffi.Char> name,
    ffi.Pointer<ffi.Int> value,
  ) {
    return _id3DocumentLicense_GetModuleValue(
      name,
      value,
    );
  }

  late final _id3DocumentLicense_GetModuleValuePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentLicense_GetModuleValue');
  late final _id3DocumentLicense_GetModuleValue =
      _id3DocumentLicense_GetModuleValuePtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the license product reference.
  /// @param productReference [out] The product reference.
  /// @param productReferenceSize [in,out] Size of the 'productReference' buffer. Receives the minimum required buffer size to hold the 'productReference' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'productReference' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetProductReference(
    ffi.Pointer<ffi.Char> productReference,
    ffi.Pointer<ffi.Int> productReferenceSize,
  ) {
    return _id3DocumentLicense_GetProductReference(
      productReference,
      productReferenceSize,
    );
  }

  late final _id3DocumentLicense_GetProductReferencePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentLicense_GetProductReference');
  late final _id3DocumentLicense_GetProductReference =
      _id3DocumentLicense_GetProductReferencePtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Retrieves the number of remaining days.
  /// @param remainingDays [out] The number of remaining days.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_GetRemainingDays(
    ffi.Pointer<ffi.Int> remainingDays,
  ) {
    return _id3DocumentLicense_GetRemainingDays(
      remainingDays,
    );
  }

  late final _id3DocumentLicense_GetRemainingDaysPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ffi.Int>)>>(
          'id3DocumentLicense_GetRemainingDays');
  late final _id3DocumentLicense_GetRemainingDays =
      _id3DocumentLicense_GetRemainingDaysPtr
          .asFunction<int Function(ffi.Pointer<ffi.Int>)>();

  /// Reactivates a license file using the host hardware code and the product reference.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param productReference [in] The product reference.
  /// @param path [in] Path to the license file.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_Reactivate(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> productReference,
    ffi.Pointer<ffi.Char> path,
  ) {
    return _id3DocumentLicense_Reactivate(
      hardwareCode,
      productReference,
      path,
    );
  }

  late final _id3DocumentLicense_ReactivatePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('id3DocumentLicense_Reactivate');
  late final _id3DocumentLicense_Reactivate =
      _id3DocumentLicense_ReactivatePtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>();

  /// Reactivates a license in a data buffer using the host hardware code and the product reference.
  /// @param hardwareCode [in] The hardware code on which the license file will be attached, to be retrieved using the GetHostHardwareCode function.
  /// @param productReference [in] The product reference.
  /// @param licenseFileBuffer [out] The new license data buffer.
  /// @param licenseFileBufferSize [in,out] Size of the 'licenseFileBuffer' buffer. Receives the number of elements in the 'licenseFileBuffer' array.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentLicense_ReactivateBuffer(
    ffi.Pointer<ffi.Char> hardwareCode,
    ffi.Pointer<ffi.Char> productReference,
    ffi.Pointer<ffi.UnsignedChar> licenseFileBuffer,
    ffi.Pointer<ffi.Int> licenseFileBufferSize,
  ) {
    return _id3DocumentLicense_ReactivateBuffer(
      hardwareCode,
      productReference,
      licenseFileBuffer,
      licenseFileBufferSize,
    );
  }

  late final _id3DocumentLicense_ReactivateBufferPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentLicense_ReactivateBuffer');
  late final _id3DocumentLicense_ReactivateBuffer =
      _id3DocumentLicense_ReactivateBufferPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.UnsignedChar>, ffi.Pointer<ffi.Int>)>();

  ffi.Pointer<ffi.Char> id3Document_GetLicenseErrorString(
    int value,
  ) {
    return _id3Document_GetLicenseErrorString(
      value,
    );
  }

  late final _id3Document_GetLicenseErrorStringPtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetLicenseErrorString');
  late final _id3Document_GetLicenseErrorString =
      _id3Document_GetLicenseErrorStringPtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  ffi.Pointer<ffi.Char> id3Document_GetLicenseErrorMessage(
    int value,
  ) {
    return _id3Document_GetLicenseErrorMessage(
      value,
    );
  }

  late final _id3Document_GetLicenseErrorMessagePtr =
      _lookup<ffi.NativeFunction<ffi.Pointer<ffi.Char> Function(ffi.Int)>>(
          'id3Document_GetLicenseErrorMessage');
  late final _id3Document_GetLicenseErrorMessage =
      _id3Document_GetLicenseErrorMessagePtr
          .asFunction<ffi.Pointer<ffi.Char> Function(int)>();

  /// @brief Initializes a StringDict object.
  /// @param phStringDict [in] Handle to the StringDict object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringDict_Initialize(
    ffi.Pointer<ID3_DOCUMENT_STRING_DICT> phStringDict,
  ) {
    return _id3DocumentStringDict_Initialize(
      phStringDict,
    );
  }

  late final _id3DocumentStringDict_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_STRING_DICT>)>>(
      'id3DocumentStringDict_Initialize');
  late final _id3DocumentStringDict_Initialize =
      _id3DocumentStringDict_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_STRING_DICT>)>();

  /// @brief Releases the memory allocated for a StringDict.
  /// @param phStringDict [in] Handle to the StringDict object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringDict_Dispose(
    ffi.Pointer<ID3_DOCUMENT_STRING_DICT> phStringDict,
  ) {
    return _id3DocumentStringDict_Dispose(
      phStringDict,
    );
  }

  late final _id3DocumentStringDict_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_STRING_DICT>)>>(
      'id3DocumentStringDict_Dispose');
  late final _id3DocumentStringDict_Dispose = _id3DocumentStringDict_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_STRING_DICT>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hStringDict [in] Handle to the StringDict object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringDict_CheckHandle(
    ID3_DOCUMENT_STRING_DICT hStringDict,
  ) {
    return _id3DocumentStringDict_CheckHandle(
      hStringDict,
    );
  }

  late final _id3DocumentStringDict_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_STRING_DICT)>>(
          'id3DocumentStringDict_CheckHandle');
  late final _id3DocumentStringDict_CheckHandle =
      _id3DocumentStringDict_CheckHandlePtr
          .asFunction<int Function(ID3_DOCUMENT_STRING_DICT)>();

  /// @brief Copies an instance of StringDict object to another.
  /// @param hStringDictSrc [in] Handle to the source StringDict object.
  /// @param hStringDictDst [in] Handle to the destination StringDict object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringDict_CopyTo(
    ID3_DOCUMENT_STRING_DICT hStringDictSrc,
    ID3_DOCUMENT_STRING_DICT hStringDictDst,
  ) {
    return _id3DocumentStringDict_CopyTo(
      hStringDictSrc,
      hStringDictDst,
    );
  }

  late final _id3DocumentStringDict_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_STRING_DICT,
              ID3_DOCUMENT_STRING_DICT)>>('id3DocumentStringDict_CopyTo');
  late final _id3DocumentStringDict_CopyTo =
      _id3DocumentStringDict_CopyToPtr.asFunction<
          int Function(ID3_DOCUMENT_STRING_DICT, ID3_DOCUMENT_STRING_DICT)>();

  /// Gets the gets a string list containing the keys in the dict.
  /// @param hStringDict [in] Handle to the StringDict object.
  /// @param hKeys [out] Gets a string list containing the keys in the dict.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringDict_GetKeys(
    ID3_DOCUMENT_STRING_DICT hStringDict,
    ID3_DOCUMENT_STRING_LIST hKeys,
  ) {
    return _id3DocumentStringDict_GetKeys(
      hStringDict,
      hKeys,
    );
  }

  late final _id3DocumentStringDict_GetKeysPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_STRING_DICT,
              ID3_DOCUMENT_STRING_LIST)>>('id3DocumentStringDict_GetKeys');
  late final _id3DocumentStringDict_GetKeys =
      _id3DocumentStringDict_GetKeysPtr.asFunction<
          int Function(ID3_DOCUMENT_STRING_DICT, ID3_DOCUMENT_STRING_LIST)>();

  /// Clears the StringDict object.
  /// @param hStringDict [in] Handle to the StringDict object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringDict_Clear(
    ID3_DOCUMENT_STRING_DICT hStringDict,
  ) {
    return _id3DocumentStringDict_Clear(
      hStringDict,
    );
  }

  late final _id3DocumentStringDict_ClearPtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_STRING_DICT)>>(
          'id3DocumentStringDict_Clear');
  late final _id3DocumentStringDict_Clear = _id3DocumentStringDict_ClearPtr
      .asFunction<int Function(ID3_DOCUMENT_STRING_DICT)>();

  /// Adds an item to the StringDict object.
  /// @param hStringDict [in] Handle to the StringDict object.
  /// @param key [in] Unique key of the  item to add.
  /// @param item [in]  item to add.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringDict_Add(
    ID3_DOCUMENT_STRING_DICT hStringDict,
    ffi.Pointer<ffi.Char> key,
    ffi.Pointer<ffi.Char> item,
  ) {
    return _id3DocumentStringDict_Add(
      hStringDict,
      key,
      item,
    );
  }

  late final _id3DocumentStringDict_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_STRING_DICT, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('id3DocumentStringDict_Add');
  late final _id3DocumentStringDict_Add =
      _id3DocumentStringDict_AddPtr.asFunction<
          int Function(ID3_DOCUMENT_STRING_DICT, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>();

  /// Gets an item of the StringDict object.
  /// @param hStringDict [in] Handle to the StringDict object.
  /// @param key [in] Unique key of the  item to get.
  /// @param item [out]  item to get.
  /// @param itemSize [in,out] Size of the 'item' buffer. Receives the minimum required buffer size to hold the 'item' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'item' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringDict_Get(
    ID3_DOCUMENT_STRING_DICT hStringDict,
    ffi.Pointer<ffi.Char> key,
    ffi.Pointer<ffi.Char> item,
    ffi.Pointer<ffi.Int> itemSize,
  ) {
    return _id3DocumentStringDict_Get(
      hStringDict,
      key,
      item,
      itemSize,
    );
  }

  late final _id3DocumentStringDict_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_STRING_DICT,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentStringDict_Get');
  late final _id3DocumentStringDict_Get =
      _id3DocumentStringDict_GetPtr.asFunction<
          int Function(ID3_DOCUMENT_STRING_DICT, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>, ffi.Pointer<ffi.Int>)>();

  /// Sets an item of the StringDict object.
  /// @param hStringDict [in] Handle to the StringDict object.
  /// @param key [in] Unique key of the  item to set.
  /// @param item [in]  item to set.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringDict_Set(
    ID3_DOCUMENT_STRING_DICT hStringDict,
    ffi.Pointer<ffi.Char> key,
    ffi.Pointer<ffi.Char> item,
  ) {
    return _id3DocumentStringDict_Set(
      hStringDict,
      key,
      item,
    );
  }

  late final _id3DocumentStringDict_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_STRING_DICT, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>>('id3DocumentStringDict_Set');
  late final _id3DocumentStringDict_Set =
      _id3DocumentStringDict_SetPtr.asFunction<
          int Function(ID3_DOCUMENT_STRING_DICT, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>)>();

  /// Gets the number of elements in the StringDict object.
  /// @param hStringDict [in] Handle to the StringDict object.
  /// @param count [out] Number of elements in the  object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringDict_GetCount(
    ID3_DOCUMENT_STRING_DICT hStringDict,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3DocumentStringDict_GetCount(
      hStringDict,
      count,
    );
  }

  late final _id3DocumentStringDict_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_STRING_DICT,
              ffi.Pointer<ffi.Int>)>>('id3DocumentStringDict_GetCount');
  late final _id3DocumentStringDict_GetCount =
      _id3DocumentStringDict_GetCountPtr.asFunction<
          int Function(ID3_DOCUMENT_STRING_DICT, ffi.Pointer<ffi.Int>)>();

  /// Determines whether the StringDictobject contains the specified key.
  /// @param hStringDict [in] Handle to the StringDict object.
  /// @param key [in] The key to locate in the  object.
  /// @param result [out] true if the  object contains an element with the specified key, otherwise false.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringDict_ContainsKey(
    ID3_DOCUMENT_STRING_DICT hStringDict,
    ffi.Pointer<ffi.Char> key,
    ffi.Pointer<ffi.Bool> result,
  ) {
    return _id3DocumentStringDict_ContainsKey(
      hStringDict,
      key,
      result,
    );
  }

  late final _id3DocumentStringDict_ContainsKeyPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_STRING_DICT, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Bool>)>>('id3DocumentStringDict_ContainsKey');
  late final _id3DocumentStringDict_ContainsKey =
      _id3DocumentStringDict_ContainsKeyPtr.asFunction<
          int Function(ID3_DOCUMENT_STRING_DICT, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Bool>)>();

  /// Removes an element of the StringDict object.
  /// @param hStringDict [in] Handle to the StringDict object.
  /// @param key [in] Unique key of the  item to remove.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentStringDict_Remove(
    ID3_DOCUMENT_STRING_DICT hStringDict,
    ffi.Pointer<ffi.Char> key,
  ) {
    return _id3DocumentStringDict_Remove(
      hStringDict,
      key,
    );
  }

  late final _id3DocumentStringDict_RemovePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_STRING_DICT,
              ffi.Pointer<ffi.Char>)>>('id3DocumentStringDict_Remove');
  late final _id3DocumentStringDict_Remove =
      _id3DocumentStringDict_RemovePtr.asFunction<
          int Function(ID3_DOCUMENT_STRING_DICT, ffi.Pointer<ffi.Char>)>();

  /// Checks the validity of a single line of an MRZ of a given type by checking the check digits.
  /// @param text [in] The input MRZ line.
  /// @param eType [in] The input MRZ type according to ICAO-9303 standard.
  /// @param validity [out] The result of the verification.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzHelper_Check(
    ffi.Pointer<ffi.Char> text,
    int eType,
    ffi.Pointer<ffi.Bool> validity,
  ) {
    return _id3DocumentMrzHelper_Check(
      text,
      eType,
      validity,
    );
  }

  late final _id3DocumentMrzHelper_CheckPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Int32,
              ffi.Pointer<ffi.Bool>)>>('id3DocumentMrzHelper_Check');
  late final _id3DocumentMrzHelper_Check =
      _id3DocumentMrzHelper_CheckPtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, int, ffi.Pointer<ffi.Bool>)>();

  /// Decodes an MRZ of a given type and returns the values of the various fields.
  /// @param text [in] The input MRZ.
  /// @param eType [in] The input MRZ type according to ICAO-9303 standard.
  /// @param hFields [out] A dictionary containing the fields and values decoded in the MRZ.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzHelper_Decode(
    ffi.Pointer<ffi.Char> text,
    int eType,
    ID3_DOCUMENT_STRING_DICT hFields,
  ) {
    return _id3DocumentMrzHelper_Decode(
      text,
      eType,
      hFields,
    );
  }

  late final _id3DocumentMrzHelper_DecodePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ffi.Pointer<ffi.Char>, ffi.Int32,
              ID3_DOCUMENT_STRING_DICT)>>('id3DocumentMrzHelper_Decode');
  late final _id3DocumentMrzHelper_Decode =
      _id3DocumentMrzHelper_DecodePtr.asFunction<
          int Function(ffi.Pointer<ffi.Char>, int, ID3_DOCUMENT_STRING_DICT)>();

  /// @brief Initializes a MrzReadingResult object.
  /// @param phMrzReadingResult [in] Handle to the MrzReadingResult object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReadingResult_Initialize(
    ffi.Pointer<ID3_DOCUMENT_MRZ_READING_RESULT> phMrzReadingResult,
  ) {
    return _id3DocumentMrzReadingResult_Initialize(
      phMrzReadingResult,
    );
  }

  late final _id3DocumentMrzReadingResult_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_MRZ_READING_RESULT>)>>(
      'id3DocumentMrzReadingResult_Initialize');
  late final _id3DocumentMrzReadingResult_Initialize =
      _id3DocumentMrzReadingResult_InitializePtr.asFunction<
          int Function(ffi.Pointer<ID3_DOCUMENT_MRZ_READING_RESULT>)>();

  /// @brief Releases the memory allocated for a MrzReadingResult.
  /// @param phMrzReadingResult [in] Handle to the MrzReadingResult object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReadingResult_Dispose(
    ffi.Pointer<ID3_DOCUMENT_MRZ_READING_RESULT> phMrzReadingResult,
  ) {
    return _id3DocumentMrzReadingResult_Dispose(
      phMrzReadingResult,
    );
  }

  late final _id3DocumentMrzReadingResult_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_MRZ_READING_RESULT>)>>(
      'id3DocumentMrzReadingResult_Dispose');
  late final _id3DocumentMrzReadingResult_Dispose =
      _id3DocumentMrzReadingResult_DisposePtr.asFunction<
          int Function(ffi.Pointer<ID3_DOCUMENT_MRZ_READING_RESULT>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hMrzReadingResult [in] Handle to the MrzReadingResult object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReadingResult_CheckHandle(
    ID3_DOCUMENT_MRZ_READING_RESULT hMrzReadingResult,
  ) {
    return _id3DocumentMrzReadingResult_CheckHandle(
      hMrzReadingResult,
    );
  }

  late final _id3DocumentMrzReadingResult_CheckHandlePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_DOCUMENT_MRZ_READING_RESULT)>>(
      'id3DocumentMrzReadingResult_CheckHandle');
  late final _id3DocumentMrzReadingResult_CheckHandle =
      _id3DocumentMrzReadingResult_CheckHandlePtr
          .asFunction<int Function(ID3_DOCUMENT_MRZ_READING_RESULT)>();

  /// @brief Copies an instance of MrzReadingResult object to another.
  /// @param hMrzReadingResultSrc [in] Handle to the source MrzReadingResult object.
  /// @param hMrzReadingResultDst [in] Handle to the destination MrzReadingResult object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReadingResult_CopyTo(
    ID3_DOCUMENT_MRZ_READING_RESULT hMrzReadingResultSrc,
    ID3_DOCUMENT_MRZ_READING_RESULT hMrzReadingResultDst,
  ) {
    return _id3DocumentMrzReadingResult_CopyTo(
      hMrzReadingResultSrc,
      hMrzReadingResultDst,
    );
  }

  late final _id3DocumentMrzReadingResult_CopyToPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_MRZ_READING_RESULT,
                  ID3_DOCUMENT_MRZ_READING_RESULT)>>(
      'id3DocumentMrzReadingResult_CopyTo');
  late final _id3DocumentMrzReadingResult_CopyTo =
      _id3DocumentMrzReadingResult_CopyToPtr.asFunction<
          int Function(ID3_DOCUMENT_MRZ_READING_RESULT,
              ID3_DOCUMENT_MRZ_READING_RESULT)>();

  /// Gets the boundaries of the MRZ detected, in following order: top-left, top-right, bottom-right, bottom-left.
  /// @param hMrzReadingResult [in] Handle to the MrzReadingResult object.
  /// @param hBounds [out] Boundaries of the MRZ detected, in following order: top-left, top-right, bottom-right, bottom-left.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReadingResult_GetBounds(
    ID3_DOCUMENT_MRZ_READING_RESULT hMrzReadingResult,
    ID3_DOCUMENT_POINT_LIST hBounds,
  ) {
    return _id3DocumentMrzReadingResult_GetBounds(
      hMrzReadingResult,
      hBounds,
    );
  }

  late final _id3DocumentMrzReadingResult_GetBoundsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DOCUMENT_MRZ_READING_RESULT, ID3_DOCUMENT_POINT_LIST)>>(
      'id3DocumentMrzReadingResult_GetBounds');
  late final _id3DocumentMrzReadingResult_GetBounds =
      _id3DocumentMrzReadingResult_GetBoundsPtr.asFunction<
          int Function(
              ID3_DOCUMENT_MRZ_READING_RESULT, ID3_DOCUMENT_POINT_LIST)>();

  /// Gets the confidence score for the MRZ detected.
  /// @param hMrzReadingResult [in] Handle to the MrzReadingResult object.
  /// @param confidence [out] Confidence score for the MRZ detected.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReadingResult_GetConfidence(
    ID3_DOCUMENT_MRZ_READING_RESULT hMrzReadingResult,
    ffi.Pointer<ffi.Float> confidence,
  ) {
    return _id3DocumentMrzReadingResult_GetConfidence(
      hMrzReadingResult,
      confidence,
    );
  }

  late final _id3DocumentMrzReadingResult_GetConfidencePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DOCUMENT_MRZ_READING_RESULT, ffi.Pointer<ffi.Float>)>>(
      'id3DocumentMrzReadingResult_GetConfidence');
  late final _id3DocumentMrzReadingResult_GetConfidence =
      _id3DocumentMrzReadingResult_GetConfidencePtr.asFunction<
          int Function(
              ID3_DOCUMENT_MRZ_READING_RESULT, ffi.Pointer<ffi.Float>)>();

  /// Gets the value of the MRZ detected.
  /// @param hMrzReadingResult [in] Handle to the MrzReadingResult object.
  /// @param mrz [out] Value of the MRZ detected.
  /// @param mrzSize [in,out] Size of the 'mrz' buffer. Receives the minimum required buffer size to hold the 'mrz' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'mrz' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReadingResult_GetMrz(
    ID3_DOCUMENT_MRZ_READING_RESULT hMrzReadingResult,
    ffi.Pointer<ffi.Char> mrz,
    ffi.Pointer<ffi.Int> mrzSize,
  ) {
    return _id3DocumentMrzReadingResult_GetMrz(
      hMrzReadingResult,
      mrz,
      mrzSize,
    );
  }

  late final _id3DocumentMrzReadingResult_GetMrzPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_MRZ_READING_RESULT,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentMrzReadingResult_GetMrz');
  late final _id3DocumentMrzReadingResult_GetMrz =
      _id3DocumentMrzReadingResult_GetMrzPtr.asFunction<
          int Function(ID3_DOCUMENT_MRZ_READING_RESULT, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>();

  /// Gets the type of the MRZ detected.
  /// @param hMrzReadingResult [in] Handle to the MrzReadingResult object.
  /// @param eMrzType [out] Type of the MRZ detected.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReadingResult_GetMrzType(
    ID3_DOCUMENT_MRZ_READING_RESULT hMrzReadingResult,
    ffi.Pointer<ffi.Int32> eMrzType,
  ) {
    return _id3DocumentMrzReadingResult_GetMrzType(
      hMrzReadingResult,
      eMrzType,
    );
  }

  late final _id3DocumentMrzReadingResult_GetMrzTypePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DOCUMENT_MRZ_READING_RESULT, ffi.Pointer<ffi.Int32>)>>(
      'id3DocumentMrzReadingResult_GetMrzType');
  late final _id3DocumentMrzReadingResult_GetMrzType =
      _id3DocumentMrzReadingResult_GetMrzTypePtr.asFunction<
          int Function(
              ID3_DOCUMENT_MRZ_READING_RESULT, ffi.Pointer<ffi.Int32>)>();

  /// @brief Initializes a MrzReader object.
  /// @param phMrzReader [in] Handle to the MrzReader object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReader_Initialize(
    ffi.Pointer<ID3_DOCUMENT_MRZ_READER> phMrzReader,
  ) {
    return _id3DocumentMrzReader_Initialize(
      phMrzReader,
    );
  }

  late final _id3DocumentMrzReader_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_MRZ_READER>)>>(
      'id3DocumentMrzReader_Initialize');
  late final _id3DocumentMrzReader_Initialize =
      _id3DocumentMrzReader_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_MRZ_READER>)>();

  /// @brief Releases the memory allocated for a MrzReader.
  /// @param phMrzReader [in] Handle to the MrzReader object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReader_Dispose(
    ffi.Pointer<ID3_DOCUMENT_MRZ_READER> phMrzReader,
  ) {
    return _id3DocumentMrzReader_Dispose(
      phMrzReader,
    );
  }

  late final _id3DocumentMrzReader_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_MRZ_READER>)>>(
      'id3DocumentMrzReader_Dispose');
  late final _id3DocumentMrzReader_Dispose = _id3DocumentMrzReader_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_MRZ_READER>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hMrzReader [in] Handle to the MrzReader object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReader_CheckHandle(
    ID3_DOCUMENT_MRZ_READER hMrzReader,
  ) {
    return _id3DocumentMrzReader_CheckHandle(
      hMrzReader,
    );
  }

  late final _id3DocumentMrzReader_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_MRZ_READER)>>(
          'id3DocumentMrzReader_CheckHandle');
  late final _id3DocumentMrzReader_CheckHandle =
      _id3DocumentMrzReader_CheckHandlePtr
          .asFunction<int Function(ID3_DOCUMENT_MRZ_READER)>();

  /// Gets the selection of the binarization method internally used in the algorithm.
  /// @param hMrzReader [in] Handle to the MrzReader object.
  /// @param binarizationMethod [out] Selection of the binarization method internally used in the algorithm.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReader_GetBinarizationMethod(
    ID3_DOCUMENT_MRZ_READER hMrzReader,
    ffi.Pointer<ffi.Int> binarizationMethod,
  ) {
    return _id3DocumentMrzReader_GetBinarizationMethod(
      hMrzReader,
      binarizationMethod,
    );
  }

  late final _id3DocumentMrzReader_GetBinarizationMethodPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_MRZ_READER, ffi.Pointer<ffi.Int>)>>(
      'id3DocumentMrzReader_GetBinarizationMethod');
  late final _id3DocumentMrzReader_GetBinarizationMethod =
      _id3DocumentMrzReader_GetBinarizationMethodPtr.asFunction<
          int Function(ID3_DOCUMENT_MRZ_READER, ffi.Pointer<ffi.Int>)>();

  /// Sets the selection of the binarization method internally used in the algorithm.
  /// @param hMrzReader [in] Handle to the MrzReader object.
  /// @param binarizationMethod [in] Selection of the binarization method internally used in the algorithm.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReader_SetBinarizationMethod(
    ID3_DOCUMENT_MRZ_READER hMrzReader,
    int binarizationMethod,
  ) {
    return _id3DocumentMrzReader_SetBinarizationMethod(
      hMrzReader,
      binarizationMethod,
    );
  }

  late final _id3DocumentMrzReader_SetBinarizationMethodPtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_DOCUMENT_MRZ_READER, ffi.Int)>>(
      'id3DocumentMrzReader_SetBinarizationMethod');
  late final _id3DocumentMrzReader_SetBinarizationMethod =
      _id3DocumentMrzReader_SetBinarizationMethodPtr
          .asFunction<int Function(ID3_DOCUMENT_MRZ_READER, int)>();

  /// Gets the AI model used to detect the MRZ.
  /// Hint: Default value is MrzDetector2A.
  /// @param hMrzReader [in] Handle to the MrzReader object.
  /// @param eModel [out] AI model used to detect the MRZ.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReader_GetModel(
    ID3_DOCUMENT_MRZ_READER hMrzReader,
    ffi.Pointer<ffi.Int32> eModel,
  ) {
    return _id3DocumentMrzReader_GetModel(
      hMrzReader,
      eModel,
    );
  }

  late final _id3DocumentMrzReader_GetModelPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_MRZ_READER,
              ffi.Pointer<ffi.Int32>)>>('id3DocumentMrzReader_GetModel');
  late final _id3DocumentMrzReader_GetModel =
      _id3DocumentMrzReader_GetModelPtr.asFunction<
          int Function(ID3_DOCUMENT_MRZ_READER, ffi.Pointer<ffi.Int32>)>();

  /// Sets the AI model used to detect the MRZ.
  /// Hint: Default value is MrzDetector2A.
  /// @param hMrzReader [in] Handle to the MrzReader object.
  /// @param eModel [in] AI model used to detect the MRZ.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReader_SetModel(
    ID3_DOCUMENT_MRZ_READER hMrzReader,
    int eModel,
  ) {
    return _id3DocumentMrzReader_SetModel(
      hMrzReader,
      eModel,
    );
  }

  late final _id3DocumentMrzReader_SetModelPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_MRZ_READER,
              ffi.Int32)>>('id3DocumentMrzReader_SetModel');
  late final _id3DocumentMrzReader_SetModel = _id3DocumentMrzReader_SetModelPtr
      .asFunction<int Function(ID3_DOCUMENT_MRZ_READER, int)>();

  /// Gets the processing unit where to run the detection process.
  /// Hint: Default value is CPU.
  /// @param hMrzReader [in] Handle to the MrzReader object.
  /// @param eProcessingUnit [out] Processing unit where to run the detection process.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReader_GetProcessingUnit(
    ID3_DOCUMENT_MRZ_READER hMrzReader,
    ffi.Pointer<ffi.Int32> eProcessingUnit,
  ) {
    return _id3DocumentMrzReader_GetProcessingUnit(
      hMrzReader,
      eProcessingUnit,
    );
  }

  late final _id3DocumentMrzReader_GetProcessingUnitPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DOCUMENT_MRZ_READER, ffi.Pointer<ffi.Int32>)>>(
      'id3DocumentMrzReader_GetProcessingUnit');
  late final _id3DocumentMrzReader_GetProcessingUnit =
      _id3DocumentMrzReader_GetProcessingUnitPtr.asFunction<
          int Function(ID3_DOCUMENT_MRZ_READER, ffi.Pointer<ffi.Int32>)>();

  /// Sets the processing unit where to run the detection process.
  /// Hint: Default value is CPU.
  /// @param hMrzReader [in] Handle to the MrzReader object.
  /// @param eProcessingUnit [in] Processing unit where to run the detection process.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReader_SetProcessingUnit(
    ID3_DOCUMENT_MRZ_READER hMrzReader,
    int eProcessingUnit,
  ) {
    return _id3DocumentMrzReader_SetProcessingUnit(
      hMrzReader,
      eProcessingUnit,
    );
  }

  late final _id3DocumentMrzReader_SetProcessingUnitPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_MRZ_READER,
              ffi.Int32)>>('id3DocumentMrzReader_SetProcessingUnit');
  late final _id3DocumentMrzReader_SetProcessingUnit =
      _id3DocumentMrzReader_SetProcessingUnitPtr
          .asFunction<int Function(ID3_DOCUMENT_MRZ_READER, int)>();

  /// Gets the number of threads to use for reading.
  /// Hint: Default value is 1. Allocating more than 1 thread here can increase the speed of the process.
  /// @param hMrzReader [in] Handle to the MrzReader object.
  /// @param threadCount [out] Number of threads to use for reading.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReader_GetThreadCount(
    ID3_DOCUMENT_MRZ_READER hMrzReader,
    ffi.Pointer<ffi.Int> threadCount,
  ) {
    return _id3DocumentMrzReader_GetThreadCount(
      hMrzReader,
      threadCount,
    );
  }

  late final _id3DocumentMrzReader_GetThreadCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_MRZ_READER,
              ffi.Pointer<ffi.Int>)>>('id3DocumentMrzReader_GetThreadCount');
  late final _id3DocumentMrzReader_GetThreadCount =
      _id3DocumentMrzReader_GetThreadCountPtr.asFunction<
          int Function(ID3_DOCUMENT_MRZ_READER, ffi.Pointer<ffi.Int>)>();

  /// Sets the number of threads to use for reading.
  /// Hint: Default value is 1. Allocating more than 1 thread here can increase the speed of the process.
  /// @param hMrzReader [in] Handle to the MrzReader object.
  /// @param threadCount [in] Number of threads to use for reading.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReader_SetThreadCount(
    ID3_DOCUMENT_MRZ_READER hMrzReader,
    int threadCount,
  ) {
    return _id3DocumentMrzReader_SetThreadCount(
      hMrzReader,
      threadCount,
    );
  }

  late final _id3DocumentMrzReader_SetThreadCountPtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ID3_DOCUMENT_MRZ_READER, ffi.Int)>>(
      'id3DocumentMrzReader_SetThreadCount');
  late final _id3DocumentMrzReader_SetThreadCount =
      _id3DocumentMrzReader_SetThreadCountPtr
          .asFunction<int Function(ID3_DOCUMENT_MRZ_READER, int)>();

  /// Detects and reads an MRZ in an image.
  /// @param hMrzReader [in] Handle to the MrzReader object.
  /// @param hImage [in] Source image to process
  /// @param hResult [out] MRZ reading output.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentMrzReader_ReadMrz(
    ID3_DOCUMENT_MRZ_READER hMrzReader,
    ID3_DOCUMENT_IMAGE hImage,
    ID3_DOCUMENT_MRZ_READING_RESULT hResult,
  ) {
    return _id3DocumentMrzReader_ReadMrz(
      hMrzReader,
      hImage,
      hResult,
    );
  }

  late final _id3DocumentMrzReader_ReadMrzPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ID3_DOCUMENT_MRZ_READER, ID3_DOCUMENT_IMAGE,
                  ID3_DOCUMENT_MRZ_READING_RESULT)>>(
      'id3DocumentMrzReader_ReadMrz');
  late final _id3DocumentMrzReader_ReadMrz =
      _id3DocumentMrzReader_ReadMrzPtr.asFunction<
          int Function(ID3_DOCUMENT_MRZ_READER, ID3_DOCUMENT_IMAGE,
              ID3_DOCUMENT_MRZ_READING_RESULT)>();

  /// @brief Initializes a TextField object.
  /// @param phTextField [in] Handle to the TextField object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextField_Initialize(
    ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD> phTextField,
  ) {
    return _id3DocumentTextField_Initialize(
      phTextField,
    );
  }

  late final _id3DocumentTextField_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD>)>>(
      'id3DocumentTextField_Initialize');
  late final _id3DocumentTextField_Initialize =
      _id3DocumentTextField_InitializePtr
          .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD>)>();

  /// @brief Releases the memory allocated for a TextField.
  /// @param phTextField [in] Handle to the TextField object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextField_Dispose(
    ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD> phTextField,
  ) {
    return _id3DocumentTextField_Dispose(
      phTextField,
    );
  }

  late final _id3DocumentTextField_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD>)>>(
      'id3DocumentTextField_Dispose');
  late final _id3DocumentTextField_Dispose = _id3DocumentTextField_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hTextField [in] Handle to the TextField object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextField_CheckHandle(
    ID3_DOCUMENT_TEXT_FIELD hTextField,
  ) {
    return _id3DocumentTextField_CheckHandle(
      hTextField,
    );
  }

  late final _id3DocumentTextField_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_TEXT_FIELD)>>(
          'id3DocumentTextField_CheckHandle');
  late final _id3DocumentTextField_CheckHandle =
      _id3DocumentTextField_CheckHandlePtr
          .asFunction<int Function(ID3_DOCUMENT_TEXT_FIELD)>();

  /// @brief Copies an instance of TextField object to another.
  /// @param hTextFieldSrc [in] Handle to the source TextField object.
  /// @param hTextFieldDst [in] Handle to the destination TextField object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextField_CopyTo(
    ID3_DOCUMENT_TEXT_FIELD hTextFieldSrc,
    ID3_DOCUMENT_TEXT_FIELD hTextFieldDst,
  ) {
    return _id3DocumentTextField_CopyTo(
      hTextFieldSrc,
      hTextFieldDst,
    );
  }

  late final _id3DocumentTextField_CopyToPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_TEXT_FIELD,
              ID3_DOCUMENT_TEXT_FIELD)>>('id3DocumentTextField_CopyTo');
  late final _id3DocumentTextField_CopyTo =
      _id3DocumentTextField_CopyToPtr.asFunction<
          int Function(ID3_DOCUMENT_TEXT_FIELD, ID3_DOCUMENT_TEXT_FIELD)>();

  /// Gets the boundaries of the text field in the image.
  /// @param hTextField [in] Handle to the TextField object.
  /// @param sBounds [out] Boundaries of the text field in the image.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextField_GetBounds(
    ID3_DOCUMENT_TEXT_FIELD hTextField,
    ffi.Pointer<id3DocumentRectangle> sBounds,
  ) {
    return _id3DocumentTextField_GetBounds(
      hTextField,
      sBounds,
    );
  }

  late final _id3DocumentTextField_GetBoundsPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DOCUMENT_TEXT_FIELD, ffi.Pointer<id3DocumentRectangle>)>>(
      'id3DocumentTextField_GetBounds');
  late final _id3DocumentTextField_GetBounds =
      _id3DocumentTextField_GetBoundsPtr.asFunction<
          int Function(
              ID3_DOCUMENT_TEXT_FIELD, ffi.Pointer<id3DocumentRectangle>)>();

  /// Gets the confidence score for the value read from the text field.
  /// @param hTextField [in] Handle to the TextField object.
  /// @param confidence [out] Confidence score for the value read from the text field.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextField_GetConfidence(
    ID3_DOCUMENT_TEXT_FIELD hTextField,
    ffi.Pointer<ffi.Float> confidence,
  ) {
    return _id3DocumentTextField_GetConfidence(
      hTextField,
      confidence,
    );
  }

  late final _id3DocumentTextField_GetConfidencePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_TEXT_FIELD,
              ffi.Pointer<ffi.Float>)>>('id3DocumentTextField_GetConfidence');
  late final _id3DocumentTextField_GetConfidence =
      _id3DocumentTextField_GetConfidencePtr.asFunction<
          int Function(ID3_DOCUMENT_TEXT_FIELD, ffi.Pointer<ffi.Float>)>();

  /// Gets the name of the text field.
  /// @param hTextField [in] Handle to the TextField object.
  /// @param name [out] Name of the text field.
  /// @param nameSize [in,out] Size of the 'name' buffer. Receives the minimum required buffer size to hold the 'name' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'name' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextField_GetName(
    ID3_DOCUMENT_TEXT_FIELD hTextField,
    ffi.Pointer<ffi.Char> name,
    ffi.Pointer<ffi.Int> nameSize,
  ) {
    return _id3DocumentTextField_GetName(
      hTextField,
      name,
      nameSize,
    );
  }

  late final _id3DocumentTextField_GetNamePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_TEXT_FIELD, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentTextField_GetName');
  late final _id3DocumentTextField_GetName =
      _id3DocumentTextField_GetNamePtr.asFunction<
          int Function(ID3_DOCUMENT_TEXT_FIELD, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>();

  /// Gets the value of the text field.
  /// @param hTextField [in] Handle to the TextField object.
  /// @param value [out] Value of the text field.
  /// @param valueSize [in,out] Size of the 'value' buffer. Receives the minimum required buffer size to hold the 'value' string if the given one is too small (including the terminating NULL character), otherwise receives the number of characters in 'value' (excluding terminating NULL character).
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextField_GetValue(
    ID3_DOCUMENT_TEXT_FIELD hTextField,
    ffi.Pointer<ffi.Char> value,
    ffi.Pointer<ffi.Int> valueSize,
  ) {
    return _id3DocumentTextField_GetValue(
      hTextField,
      value,
      valueSize,
    );
  }

  late final _id3DocumentTextField_GetValuePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_TEXT_FIELD, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>>('id3DocumentTextField_GetValue');
  late final _id3DocumentTextField_GetValue =
      _id3DocumentTextField_GetValuePtr.asFunction<
          int Function(ID3_DOCUMENT_TEXT_FIELD, ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Int>)>();

  /// @brief Initializes a TextFieldList object.
  /// @param phTextFieldList [in] Handle to the TextFieldList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextFieldList_Initialize(
    ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD_LIST> phTextFieldList,
  ) {
    return _id3DocumentTextFieldList_Initialize(
      phTextFieldList,
    );
  }

  late final _id3DocumentTextFieldList_InitializePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD_LIST>)>>(
      'id3DocumentTextFieldList_Initialize');
  late final _id3DocumentTextFieldList_Initialize =
      _id3DocumentTextFieldList_InitializePtr.asFunction<
          int Function(ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD_LIST>)>();

  /// @brief Releases the memory allocated for a TextFieldList.
  /// @param phTextFieldList [in] Handle to the TextFieldList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextFieldList_Dispose(
    ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD_LIST> phTextFieldList,
  ) {
    return _id3DocumentTextFieldList_Dispose(
      phTextFieldList,
    );
  }

  late final _id3DocumentTextFieldList_DisposePtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD_LIST>)>>(
      'id3DocumentTextFieldList_Dispose');
  late final _id3DocumentTextFieldList_Dispose =
      _id3DocumentTextFieldList_DisposePtr.asFunction<
          int Function(ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD_LIST>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hTextFieldList [in] Handle to the TextFieldList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextFieldList_CheckHandle(
    ID3_DOCUMENT_TEXT_FIELD_LIST hTextFieldList,
  ) {
    return _id3DocumentTextFieldList_CheckHandle(
      hTextFieldList,
    );
  }

  late final _id3DocumentTextFieldList_CheckHandlePtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_TEXT_FIELD_LIST)>>(
      'id3DocumentTextFieldList_CheckHandle');
  late final _id3DocumentTextFieldList_CheckHandle =
      _id3DocumentTextFieldList_CheckHandlePtr
          .asFunction<int Function(ID3_DOCUMENT_TEXT_FIELD_LIST)>();

  /// @brief Copies an instance of TextFieldList object to another.
  /// @param hTextFieldListSrc [in] Handle to the source TextFieldList object.
  /// @param hTextFieldListDst [in] Handle to the destination TextFieldList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextFieldList_CopyTo(
    ID3_DOCUMENT_TEXT_FIELD_LIST hTextFieldListSrc,
    ID3_DOCUMENT_TEXT_FIELD_LIST hTextFieldListDst,
  ) {
    return _id3DocumentTextFieldList_CopyTo(
      hTextFieldListSrc,
      hTextFieldListDst,
    );
  }

  late final _id3DocumentTextFieldList_CopyToPtr = _lookup<
          ffi.NativeFunction<
              ffi.Int Function(
                  ID3_DOCUMENT_TEXT_FIELD_LIST, ID3_DOCUMENT_TEXT_FIELD_LIST)>>(
      'id3DocumentTextFieldList_CopyTo');
  late final _id3DocumentTextFieldList_CopyTo =
      _id3DocumentTextFieldList_CopyToPtr.asFunction<
          int Function(
              ID3_DOCUMENT_TEXT_FIELD_LIST, ID3_DOCUMENT_TEXT_FIELD_LIST)>();

  /// Clears the TextFieldList object.
  /// @param hTextFieldList [in] Handle to the TextFieldList object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextFieldList_Clear(
    ID3_DOCUMENT_TEXT_FIELD_LIST hTextFieldList,
  ) {
    return _id3DocumentTextFieldList_Clear(
      hTextFieldList,
    );
  }

  late final _id3DocumentTextFieldList_ClearPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_TEXT_FIELD_LIST)>>(
      'id3DocumentTextFieldList_Clear');
  late final _id3DocumentTextFieldList_Clear =
      _id3DocumentTextFieldList_ClearPtr
          .asFunction<int Function(ID3_DOCUMENT_TEXT_FIELD_LIST)>();

  /// Adds an item to the TextFieldList object.
  /// @param hTextFieldList [in] Handle to the TextFieldList object.
  /// @param hTextFieldItem [in] TextField item to add.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextFieldList_Add(
    ID3_DOCUMENT_TEXT_FIELD_LIST hTextFieldList,
    ID3_DOCUMENT_TEXT_FIELD hTextFieldItem,
  ) {
    return _id3DocumentTextFieldList_Add(
      hTextFieldList,
      hTextFieldItem,
    );
  }

  late final _id3DocumentTextFieldList_AddPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_TEXT_FIELD_LIST,
              ID3_DOCUMENT_TEXT_FIELD)>>('id3DocumentTextFieldList_Add');
  late final _id3DocumentTextFieldList_Add =
      _id3DocumentTextFieldList_AddPtr.asFunction<
          int Function(
              ID3_DOCUMENT_TEXT_FIELD_LIST, ID3_DOCUMENT_TEXT_FIELD)>();

  /// Gets an item of the TextFieldList object.
  /// @param hTextFieldList [in] Handle to the TextFieldList object.
  /// @param index [in] Index of the TextField item to get.
  /// @param hTextFieldItem [out] TextField item to get.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextFieldList_Get(
    ID3_DOCUMENT_TEXT_FIELD_LIST hTextFieldList,
    int index,
    ID3_DOCUMENT_TEXT_FIELD hTextFieldItem,
  ) {
    return _id3DocumentTextFieldList_Get(
      hTextFieldList,
      index,
      hTextFieldItem,
    );
  }

  late final _id3DocumentTextFieldList_GetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_TEXT_FIELD_LIST, ffi.Int,
              ID3_DOCUMENT_TEXT_FIELD)>>('id3DocumentTextFieldList_Get');
  late final _id3DocumentTextFieldList_Get =
      _id3DocumentTextFieldList_GetPtr.asFunction<
          int Function(
              ID3_DOCUMENT_TEXT_FIELD_LIST, int, ID3_DOCUMENT_TEXT_FIELD)>();

  /// Sets an item of the TextFieldList object.
  /// @param hTextFieldList [in] Handle to the TextFieldList object.
  /// @param index [in] Index of the TextField item to set.
  /// @param hTextFieldItem [in] TextField item to set.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextFieldList_Set(
    ID3_DOCUMENT_TEXT_FIELD_LIST hTextFieldList,
    int index,
    ID3_DOCUMENT_TEXT_FIELD hTextFieldItem,
  ) {
    return _id3DocumentTextFieldList_Set(
      hTextFieldList,
      index,
      hTextFieldItem,
    );
  }

  late final _id3DocumentTextFieldList_SetPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_TEXT_FIELD_LIST, ffi.Int,
              ID3_DOCUMENT_TEXT_FIELD)>>('id3DocumentTextFieldList_Set');
  late final _id3DocumentTextFieldList_Set =
      _id3DocumentTextFieldList_SetPtr.asFunction<
          int Function(
              ID3_DOCUMENT_TEXT_FIELD_LIST, int, ID3_DOCUMENT_TEXT_FIELD)>();

  /// Gets the number of elements in the TextFieldList object.
  /// @param hTextFieldList [in] Handle to the TextFieldList object.
  /// @param count [out] Number of elements in the TextField object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextFieldList_GetCount(
    ID3_DOCUMENT_TEXT_FIELD_LIST hTextFieldList,
    ffi.Pointer<ffi.Int> count,
  ) {
    return _id3DocumentTextFieldList_GetCount(
      hTextFieldList,
      count,
    );
  }

  late final _id3DocumentTextFieldList_GetCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_TEXT_FIELD_LIST,
              ffi.Pointer<ffi.Int>)>>('id3DocumentTextFieldList_GetCount');
  late final _id3DocumentTextFieldList_GetCount =
      _id3DocumentTextFieldList_GetCountPtr.asFunction<
          int Function(ID3_DOCUMENT_TEXT_FIELD_LIST, ffi.Pointer<ffi.Int>)>();

  /// Removes an element of the TextFieldList object.
  /// @param hTextFieldList [in] Handle to the TextFieldList object.
  /// @param index [in] Index of the TextField item to remove.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextFieldList_RemoveAt(
    ID3_DOCUMENT_TEXT_FIELD_LIST hTextFieldList,
    int index,
  ) {
    return _id3DocumentTextFieldList_RemoveAt(
      hTextFieldList,
      index,
    );
  }

  late final _id3DocumentTextFieldList_RemoveAtPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_TEXT_FIELD_LIST,
              ffi.Int)>>('id3DocumentTextFieldList_RemoveAt');
  late final _id3DocumentTextFieldList_RemoveAt =
      _id3DocumentTextFieldList_RemoveAtPtr
          .asFunction<int Function(ID3_DOCUMENT_TEXT_FIELD_LIST, int)>();

  /// TextFieldList object.
  /// @param hTextFieldList [in] Handle to the TextFieldList object.
  /// @param newSize [in] TextField object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentTextFieldList_Resize(
    ID3_DOCUMENT_TEXT_FIELD_LIST hTextFieldList,
    int newSize,
  ) {
    return _id3DocumentTextFieldList_Resize(
      hTextFieldList,
      newSize,
    );
  }

  late final _id3DocumentTextFieldList_ResizePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_TEXT_FIELD_LIST,
              ffi.Int)>>('id3DocumentTextFieldList_Resize');
  late final _id3DocumentTextFieldList_Resize =
      _id3DocumentTextFieldList_ResizePtr
          .asFunction<int Function(ID3_DOCUMENT_TEXT_FIELD_LIST, int)>();

  /// @brief Initializes a DocumentReader object.
  /// @param phDocumentReader [in] Handle to the DocumentReader object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentReader_Initialize(
    ffi.Pointer<ID3_DOCUMENT_READER> phDocumentReader,
  ) {
    return _id3DocumentReader_Initialize(
      phDocumentReader,
    );
  }

  late final _id3DocumentReader_InitializePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_READER>)>>(
      'id3DocumentReader_Initialize');
  late final _id3DocumentReader_Initialize = _id3DocumentReader_InitializePtr
      .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_READER>)>();

  /// @brief Releases the memory allocated for a DocumentReader.
  /// @param phDocumentReader [in] Handle to the DocumentReader object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentReader_Dispose(
    ffi.Pointer<ID3_DOCUMENT_READER> phDocumentReader,
  ) {
    return _id3DocumentReader_Dispose(
      phDocumentReader,
    );
  }

  late final _id3DocumentReader_DisposePtr = _lookup<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_READER>)>>(
      'id3DocumentReader_Dispose');
  late final _id3DocumentReader_Dispose = _id3DocumentReader_DisposePtr
      .asFunction<int Function(ffi.Pointer<ID3_DOCUMENT_READER>)>();

  /// @brief Checks if the handle object is valid.
  /// @param hDocumentReader [in] Handle to the DocumentReader object.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentReader_CheckHandle(
    ID3_DOCUMENT_READER hDocumentReader,
  ) {
    return _id3DocumentReader_CheckHandle(
      hDocumentReader,
    );
  }

  late final _id3DocumentReader_CheckHandlePtr =
      _lookup<ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_READER)>>(
          'id3DocumentReader_CheckHandle');
  late final _id3DocumentReader_CheckHandle = _id3DocumentReader_CheckHandlePtr
      .asFunction<int Function(ID3_DOCUMENT_READER)>();

  /// Gets the number of threads to use for OCR.
  /// Hint: Default value is 1. Allocating more than 1 thread here can increase the speed of the process.
  /// @param hDocumentReader [in] Handle to the DocumentReader object.
  /// @param threadCount [out] Number of threads to use for OCR.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentReader_GetThreadCount(
    ID3_DOCUMENT_READER hDocumentReader,
    ffi.Pointer<ffi.Int> threadCount,
  ) {
    return _id3DocumentReader_GetThreadCount(
      hDocumentReader,
      threadCount,
    );
  }

  late final _id3DocumentReader_GetThreadCountPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(ID3_DOCUMENT_READER,
              ffi.Pointer<ffi.Int>)>>('id3DocumentReader_GetThreadCount');
  late final _id3DocumentReader_GetThreadCount =
      _id3DocumentReader_GetThreadCountPtr.asFunction<
          int Function(ID3_DOCUMENT_READER, ffi.Pointer<ffi.Int>)>();

  /// Sets the number of threads to use for OCR.
  /// Hint: Default value is 1. Allocating more than 1 thread here can increase the speed of the process.
  /// @param hDocumentReader [in] Handle to the DocumentReader object.
  /// @param threadCount [in] Number of threads to use for OCR.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentReader_SetThreadCount(
    ID3_DOCUMENT_READER hDocumentReader,
    int threadCount,
  ) {
    return _id3DocumentReader_SetThreadCount(
      hDocumentReader,
      threadCount,
    );
  }

  late final _id3DocumentReader_SetThreadCountPtr = _lookup<
          ffi.NativeFunction<ffi.Int Function(ID3_DOCUMENT_READER, ffi.Int)>>(
      'id3DocumentReader_SetThreadCount');
  late final _id3DocumentReader_SetThreadCount =
      _id3DocumentReader_SetThreadCountPtr
          .asFunction<int Function(ID3_DOCUMENT_READER, int)>();

  /// Extracts a crop of the face in a document.
  /// @param hDocumentReader [in] Handle to the DocumentReader object.
  /// @param hImage [in] The image that contains the document. Must be a realigned BGR image of the document.
  /// @param documentName [in] The name of the document to be searched. Must be a key loaded in DocumentLibrary.
  /// @param hCroppedFace [out] The cropped image of the face.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentReader_ExtractFace(
    ID3_DOCUMENT_READER hDocumentReader,
    ID3_DOCUMENT_IMAGE hImage,
    ffi.Pointer<ffi.Char> documentName,
    ID3_DOCUMENT_IMAGE hCroppedFace,
  ) {
    return _id3DocumentReader_ExtractFace(
      hDocumentReader,
      hImage,
      documentName,
      hCroppedFace,
    );
  }

  late final _id3DocumentReader_ExtractFacePtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_READER,
              ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Char>,
              ID3_DOCUMENT_IMAGE)>>('id3DocumentReader_ExtractFace');
  late final _id3DocumentReader_ExtractFace =
      _id3DocumentReader_ExtractFacePtr.asFunction<
          int Function(ID3_DOCUMENT_READER, ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Char>, ID3_DOCUMENT_IMAGE)>();

  /// Reads all the fields in a document.
  /// @param hDocumentReader [in] Handle to the DocumentReader object.
  /// @param hImage [in] The image that contains the document. Must be a realigned BGR image of the document.
  /// @param documentName [in] The name of the document to be searched. Must be a key loaded in DocumentLibrary.
  /// @param hReadTexts [out] A list of all the text fields read in the document.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentReader_ReadDocument(
    ID3_DOCUMENT_READER hDocumentReader,
    ID3_DOCUMENT_IMAGE hImage,
    ffi.Pointer<ffi.Char> documentName,
    ID3_DOCUMENT_TEXT_FIELD_LIST hReadTexts,
  ) {
    return _id3DocumentReader_ReadDocument(
      hDocumentReader,
      hImage,
      documentName,
      hReadTexts,
    );
  }

  late final _id3DocumentReader_ReadDocumentPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_READER,
              ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Char>,
              ID3_DOCUMENT_TEXT_FIELD_LIST)>>('id3DocumentReader_ReadDocument');
  late final _id3DocumentReader_ReadDocument =
      _id3DocumentReader_ReadDocumentPtr.asFunction<
          int Function(ID3_DOCUMENT_READER, ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Char>, ID3_DOCUMENT_TEXT_FIELD_LIST)>();

  /// Reads a single field in a document.
  /// @param hDocumentReader [in] Handle to the DocumentReader object.
  /// @param hImage [in] The image that contains the document. Must be a realigned BGR image of the document.
  /// @param documentName [in] The name of the document to be searched. Must be a key loaded in DocumentLibrary.
  /// @param fieldName [in] The name of the field to search.
  /// @param hReadText [out] Read Text in the specified field.
  /// @return An error code. See id3DocumentError file for the list of possible error codes.
  /// @retval id3DocumentError_Success The function succeeded.
  int id3DocumentReader_ReadField(
    ID3_DOCUMENT_READER hDocumentReader,
    ID3_DOCUMENT_IMAGE hImage,
    ffi.Pointer<ffi.Char> documentName,
    ffi.Pointer<ffi.Char> fieldName,
    ID3_DOCUMENT_TEXT_FIELD hReadText,
  ) {
    return _id3DocumentReader_ReadField(
      hDocumentReader,
      hImage,
      documentName,
      fieldName,
      hReadText,
    );
  }

  late final _id3DocumentReader_ReadFieldPtr = _lookup<
      ffi.NativeFunction<
          ffi.Int Function(
              ID3_DOCUMENT_READER,
              ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ID3_DOCUMENT_TEXT_FIELD)>>('id3DocumentReader_ReadField');
  late final _id3DocumentReader_ReadField =
      _id3DocumentReader_ReadFieldPtr.asFunction<
          int Function(
              ID3_DOCUMENT_READER,
              ID3_DOCUMENT_IMAGE,
              ffi.Pointer<ffi.Char>,
              ffi.Pointer<ffi.Char>,
              ID3_DOCUMENT_TEXT_FIELD)>();

  late final addresses = _SymbolAddresses(this);
}

class _SymbolAddresses {
  final DocumentSDK _library;
  _SymbolAddresses(this._library);
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_POINT_LIST>)>>
      get id3DocumentPointList_Dispose =>
          _library._id3DocumentPointList_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_INFO>)>>
      get id3DocumentInfo_Dispose => _library._id3DocumentInfo_DisposePtr;
  ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DETECTED_DOCUMENT>)>>
      get id3DetectedDocument_Dispose =>
          _library._id3DetectedDocument_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_IMAGE_BUFFER>)>>
      get id3DocumentImageBuffer_Dispose =>
          _library._id3DocumentImageBuffer_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_IMAGE>)>>
      get id3DocumentImage_Dispose => _library._id3DocumentImage_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT>)>>
      get id3DocumentHologramAuthenticationResult_Dispose =>
          _library._id3DocumentHologramAuthenticationResult_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(
                  ffi.Pointer<
                      ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST>)>>
      get id3DocumentHologramAuthenticationResultList_Dispose =>
          _library._id3DocumentHologramAuthenticationResultList_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_AUTHENTICATOR>)>>
      get id3DocumentAuthenticator_Dispose =>
          _library._id3DocumentAuthenticator_DisposePtr;
  ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_DETECTOR>)>>
      get id3DocumentDetector_Dispose =>
          _library._id3DocumentDetector_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_STRING_LIST>)>>
      get id3DocumentStringList_Dispose =>
          _library._id3DocumentStringList_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_INFO_DICTIONARY>)>>
      get id3DocumentInfoDictionary_Dispose =>
          _library._id3DocumentInfoDictionary_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_STRING_DICT>)>>
      get id3DocumentStringDict_Dispose =>
          _library._id3DocumentStringDict_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_MRZ_READING_RESULT>)>>
      get id3DocumentMrzReadingResult_Dispose =>
          _library._id3DocumentMrzReadingResult_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_MRZ_READER>)>>
      get id3DocumentMrzReader_Dispose =>
          _library._id3DocumentMrzReader_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD>)>>
      get id3DocumentTextField_Dispose =>
          _library._id3DocumentTextField_DisposePtr;
  ffi.Pointer<
          ffi.NativeFunction<
              ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_TEXT_FIELD_LIST>)>>
      get id3DocumentTextFieldList_Dispose =>
          _library._id3DocumentTextFieldList_DisposePtr;
  ffi.Pointer<
          ffi
          .NativeFunction<ffi.Int Function(ffi.Pointer<ID3_DOCUMENT_READER>)>>
      get id3DocumentReader_Dispose => _library._id3DocumentReader_DisposePtr;
}

/// Represents a point.
final class id3DocumentPoint extends ffi.Struct {
  /// X-coordinate of the point.
  @ffi.Int()
  external int X;

  /// Y-coordinate of the point.
  @ffi.Int()
  external int Y;
}

final class id3DocumentPointList extends ffi.Opaque {}

/// Handle to a PointList object of the Document module.
typedef ID3_DOCUMENT_POINT_LIST = ffi.Pointer<id3DocumentPointList>;

/// Enumerates document categories.
abstract class id3DocumentCategory {
  /// Unknown document category.
  static const int id3DocumentCategory_Unknown = 0;

  /// Passport
  static const int id3DocumentCategory_A = 1;

  /// Identity card
  static const int id3DocumentCategory_B = 2;

  /// Visa
  static const int id3DocumentCategory_C = 3;

  /// Stamp
  static const int id3DocumentCategory_D = 4;

  /// Entry paper
  static const int id3DocumentCategory_E = 5;

  /// Driving licence
  static const int id3DocumentCategory_F = 6;

  /// Vehicle licence/ log book
  static const int id3DocumentCategory_G = 7;

  /// Residence-related document
  static const int id3DocumentCategory_H = 8;

  /// Seafarers' identity document
  static const int id3DocumentCategory_I = 9;

  /// Travel document issued to non-nationals
  static const int id3DocumentCategory_J = 10;

  /// Train driving licence
  static const int id3DocumentCategory_K = 11;

  /// Crew member certificate / pilot's licence
  static const int id3DocumentCategory_L = 12;

  /// Certificate for operators of pleasure crafts / captain's licence
  static const int id3DocumentCategory_M = 13;

  /// Civil status/ other official document
  static const int id3DocumentCategory_P = 14;

  /// Special authorisation card
  static const int id3DocumentCategory_S = 15;

  /// Travel document
  static const int id3DocumentCategory_T = 16;

  /// Authorisation to represent a company
  static const int id3DocumentCategory_V = 17;

  /// Work permit
  static const int id3DocumentCategory_W = 18;

  /// Other document
  static const int id3DocumentCategory_X = 19;
}

/// Enumerates document formats, according to ISO/IEC 7810.
abstract class id3DocumentFormat {
  /// Unknown document format.
  static const int id3DocumentFormat_Unknown = 0;

  /// A4 format document
  static const int id3DocumentFormat_A4 = 1;

  /// ID-1 format. Specifies a size of 85.60 by 53.98 millimetres. This format is commonly used for most banking cards and ID cards.
  static const int id3DocumentFormat_Id1 = 2;

  /// ID-2 format. Specifies a size of 105 by 74 millimetres. This format is used for visas, Romanian and other ID cards. Visas.
  static const int id3DocumentFormat_Id2 = 3;

  /// ID-3 format. Specifies a size of 125 by 88 millimetres. This format is commonly used for passport booklets.
  static const int id3DocumentFormat_Id3 = 4;
}

/// Enumerates supported MRZ types.
abstract class id3DocumentMrzType {
  /// No MRZ. Default value.
  static const int id3DocumentMrzType_None = 0;

  /// Document TD1 (ICAO 9303-5) - 3x30 lines MRZ.
  static const int id3DocumentMrzType_Td1 = 1;

  /// Document TD2 (ICAO 9303-6) - 2x36 lines MRZ.
  static const int id3DocumentMrzType_Td2 = 2;

  /// Document TD3 (Passports)(ICAO 9303-4) - 2x44 lines MRZ.
  static const int id3DocumentMrzType_Td3 = 3;

  /// Driving licence (ISO-18013) - 1x30 line MRZ.
  static const int id3DocumentMrzType_DrivingLicense = 4;

  /// Visa format A (ICAO 9303-7) - 2x44 lines MRZ.
  static const int id3DocumentMrzType_MrvA = 5;

  /// Visa format B (ICAO 9303-7) - 2x36 lines MRZ.
  static const int id3DocumentMrzType_MrvB = 6;

  /// Other MRZ Type, with a standard layout but unknown content.
  static const int id3DocumentMrzType_Other = 100;

  /// Old french ID card (PRADO FRA-BO-02002). 2x36 lines MRZ.
  static const int id3DocumentMrzType_FrenchId = 101;
}

final class id3DocumentInfo extends ffi.Opaque {}

/// Handle to a DocumentInfo object of the Document module.
typedef ID3_DOCUMENT_INFO = ffi.Pointer<id3DocumentInfo>;

/// Represents the document orientation.
final class id3DocumentOrientation extends ffi.Struct {
  /// Pitch angle in degrees.
  @ffi.Float()
  external double Pitch;

  /// Roll angle in degrees.
  @ffi.Float()
  external double Roll;

  /// Yaw angle in degrees.
  @ffi.Float()
  external double Yaw;
}

final class id3DetectedDocument extends ffi.Opaque {}

/// Handle to a DetectedDocument object of the Document module.
typedef ID3_DETECTED_DOCUMENT = ffi.Pointer<id3DetectedDocument>;

/// Enumerates supported pixel formats.
abstract class id3DocumentPixelFormat {
  /// Undefined.
  static const int id3DocumentPixelFormat_Undefined = 0;

  /// 8-bits grayscale.
  static const int id3DocumentPixelFormat_Grayscale8Bits = 10;

  /// 16-bits grayscale.
  static const int id3DocumentPixelFormat_Grayscale16Bits = 20;

  /// Floating point grayscale.
  static const int id3DocumentPixelFormat_GrayscaleFloat = 25;

  /// 24 bits BGR.
  static const int id3DocumentPixelFormat_Bgr24Bits = 30;

  /// 24 bits RGB.
  static const int id3DocumentPixelFormat_Rgb24Bits = 31;

  /// 32 bits BGRA.
  static const int id3DocumentPixelFormat_Bgra = 32;

  /// 32 bits RGBA.
  static const int id3DocumentPixelFormat_Rgba = 33;

  /// NV12 (YUV semi-planar format).
  static const int id3DocumentPixelFormat_Nv12 = 40;

  /// I420 (YUV packed format).
  static const int id3DocumentPixelFormat_I420 = 41;

  /// YUY2 (YUV packed format).
  static const int id3DocumentPixelFormat_Yuy2 = 42;

  /// YV12 (YUV packed format).
  static const int id3DocumentPixelFormat_Yv12 = 43;
}

/// Represents a rectangle.
final class id3DocumentRectangle extends ffi.Struct {
  /// Bottom-left corner of the rectangle.
  external id3DocumentPoint BottomLeft;

  /// Bottom-right corner of the rectangle.
  external id3DocumentPoint BottomRight;

  /// Top-left corner of the rectangle.
  external id3DocumentPoint TopLeft;

  /// Top-right corner of the rectangle.
  external id3DocumentPoint TopRight;
}

/// Enumerates supported image formats.
abstract class id3DocumentImageFormat {
  /// BMP.
  static const int id3DocumentImageFormat_Bmp = 0;

  /// JPEG.
  static const int id3DocumentImageFormat_Jpeg = 2;

  /// PNG.
  static const int id3DocumentImageFormat_Png = 13;

  /// Tiff.
  static const int id3DocumentImageFormat_Tiff = 18;

  /// JPEG 2000.
  static const int id3DocumentImageFormat_Jpeg2000 = 30;

  /// WEBP.
  static const int id3DocumentImageFormat_Webp = 31;

  /// Raw.
  static const int id3DocumentImageFormat_Raw = 34;
}

final class id3DocumentImageBuffer extends ffi.Opaque {}

/// Handle to a ImageBuffer object of the Document module.
typedef ID3_DOCUMENT_IMAGE_BUFFER = ffi.Pointer<id3DocumentImageBuffer>;

final class id3DocumentImage extends ffi.Opaque {}

/// Handle to a DocumentImage object of the Document module.
typedef ID3_DOCUMENT_IMAGE = ffi.Pointer<id3DocumentImage>;

final class id3DocumentHologramAuthenticationResult extends ffi.Opaque {}

/// Handle to a HologramAuthenticationResult object of the Document module.
typedef ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT
    = ffi.Pointer<id3DocumentHologramAuthenticationResult>;

final class id3DocumentHologramAuthenticationResultList extends ffi.Opaque {}

/// Handle to a HologramAuthenticationResultList object of the Document module.
typedef ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST
    = ffi.Pointer<id3DocumentHologramAuthenticationResultList>;

final class id3DocumentAuthenticator extends ffi.Opaque {}

/// Handle to a DocumentAuthenticator object of the Document module.
typedef ID3_DOCUMENT_AUTHENTICATOR = ffi.Pointer<id3DocumentAuthenticator>;

/// Enumerates the AI models available in this SDK.
abstract class id3DocumentModel {
  /// Document detector 2A. Best accuracy model.
  static const int id3DocumentModel_DocumentDetector2A = 1001;

  /// Document detector 2B. Fast detector for low-end mobiles.
  static const int id3DocumentModel_DocumentDetector2B = 1002;

  /// MRZ Reader 2A. Stand-alone reader (no document detection needed).
  static const int id3DocumentModel_MrzReader2A = 1102;

  /// OCR (Optical Character Recognition) model 2A for reading text fields in latin alphabet and digits.
  static const int id3DocumentModel_OcrLatin2A = 1202;
}

/// Enumerates processing units.
abstract class id3DocumentProcessingUnit {
  /// CPU.
  static const int id3DocumentProcessingUnit_Cpu = 0;

  /// GPU (automatic backend selection).
  static const int id3DocumentProcessingUnit_Gpu = 1;

  /// OpenCL Backend.
  static const int id3DocumentProcessingUnit_Opencl = 2;

  /// CUDA Backend.
  static const int id3DocumentProcessingUnit_Cuda = 3;

  /// Metal Backend.
  static const int id3DocumentProcessingUnit_Metal = 4;

  /// Vulkan Backend.
  static const int id3DocumentProcessingUnit_Vulkan = 5;
}

final class id3DocumentDetector extends ffi.Opaque {}

/// Handle to a DocumentDetector object of the Document module.
typedef ID3_DOCUMENT_DETECTOR = ffi.Pointer<id3DocumentDetector>;

/// Enumerates possible error codes.
abstract class id3DocumentError {
  /// No error.
  static const int id3DocumentError_Success = 0;

  /// The given buffer is too small.
  static const int id3DocumentError_InsufficientBuffer = -1;

  /// The requested object does not exist; a 'null' should be returned if possible.
  static const int id3DocumentError_ObjectDoesNotExist = -2;

  /// Base error code of the Document module.
  static const int id3DocumentError_Base = -11000;

  /// Minimum error code of the Document module.
  static const int id3DocumentError_Minimum = -11999;

  /// The handle is invalid.
  static const int id3DocumentError_InvalidHandle = -11001;

  /// The parameter is invalid.
  static const int id3DocumentError_InvalidParameter = -11002;

  /// The image pixel format is invalid.
  static const int id3DocumentError_InvalidPixelFormat = -11004;

  /// The model could not be found in the given directory path.
  static const int id3DocumentError_InvalidModelPath = -11008;

  /// The document template could not be found at the given path.
  static const int id3DocumentError_InvalidDocumentTemplatePath = -11009;

  /// The model which is required for this operation has not been  loaded.
  static const int id3DocumentError_UnloadedModel = -11020;

  /// The document template required for this operation has not been loaded.
  static const int id3DocumentError_UnloadedDocumentTemplate = -11021;

  /// The required element is not present in the document annotation.
  static const int id3DocumentError_UnknownAnnotation = -11022;

  /// The format of the document template is invalid.
  static const int id3DocumentError_InvalidDocumentTemplateFormat = -11023;

  /// The frame buffer is not full, and computation is not allowed.
  static const int id3DocumentError_InsufficientFrameNumber = -11030;

  /// One of our computation backends failed for unknown reasons.
  static const int id3DocumentError_BackendError = -11039;

  /// The inference backend failed to infer, probably due to inconsistent input.
  static const int id3DocumentError_InferenceBackendError = -11040;

  /// The requested processing unit is not available in this build.
  static const int id3DocumentError_ProcessingUnitUnavailable = -11041;

  /// This function is not implemented.
  static const int id3DocumentError_FunctionNotImplemented = -11056;
}

/// Enumerates possible error codes related to image management.
abstract class id3DocumentImageError {
  /// No error.
  static const int id3DocumentImageError_Success = 0;

  /// The given buffer is too small.
  static const int id3DocumentImageError_InsufficientBuffer = -1;

  /// The requested object does not exist; a 'null' should be returned if possible.
  static const int id3DocumentImageError_ObjectDoesNotExist = -2;

  /// Base error code for Image module.
  static const int id3DocumentImageError_Base = -3000;

  /// Minimum error code for Image module.
  static const int id3DocumentImageError_Minimum = -3999;

  /// The handle is invalid.
  static const int id3DocumentImageError_InvalidHandle = -3001;

  /// The parameter is invalid.
  static const int id3DocumentImageError_InvalidParameter = -3002;

  /// The image sizes are not compatible for the requested operation.
  static const int id3DocumentImageError_ImageSizeMismatch = -3003;

  /// The pixel formats are not compatible.
  static const int id3DocumentImageError_PixelFormatMismatch = -3004;

  /// The given key is already used in the dictionary. Multiple values per key is not supported.
  static const int id3DocumentImageError_KeyAlreadyExists = -3005;

  /// The given key is not present in the dictionary.
  static const int id3DocumentImageError_KeyNotFound = -3006;

  /// The required pixel format is not correct.
  static const int id3DocumentImageError_InvalidPixelFormat = -3007;

  /// An error as occured during python module initialization.
  static const int id3DocumentImageError_PythonModule = -3008;

  /// Function not implemented.
  static const int id3DocumentImageError_FunctionNotImplemented = -3009;

  /// TODO
  static const int id3DocumentImageError_BackendError = -3010;
}

final class id3DocumentStringList extends ffi.Opaque {}

/// Handle to a StringList object of the Document module.
typedef ID3_DOCUMENT_STRING_LIST = ffi.Pointer<id3DocumentStringList>;

final class id3DocumentInfoDictionary extends ffi.Opaque {}

/// Handle to a DocumentInfoDictionary object of the Document module.
typedef ID3_DOCUMENT_INFO_DICTIONARY = ffi.Pointer<id3DocumentInfoDictionary>;

/// Contains data for LibVersion
final class id3DocumentLibVersion extends ffi.Struct {
  /// Version.
  @ffi.Int()
  external int Major;

  /// Release.
  @ffi.Int()
  external int Minor;

  /// Build.
  @ffi.Int()
  external int Build;
}

/// Enumerates the types of hardware codes.
abstract class id3DocumentLicenseHardwareCodeType {
  /// License locked on Windows OS.
  static const int id3DocumentLicenseHardwareCodeType_WindowsOs = 1;

  /// License locked on Linux OS.
  static const int id3DocumentLicenseHardwareCodeType_LinuxOs = 3;

  /// License locked on Android device.
  static const int id3DocumentLicenseHardwareCodeType_Android = 5;

  /// License locked on Android application package name.
  static const int id3DocumentLicenseHardwareCodeType_AndroidPackageName = 6;

  /// License locked on iOS device.
  static const int id3DocumentLicenseHardwareCodeType_Ios = 7;

  /// License locked on macOS.
  static const int id3DocumentLicenseHardwareCodeType_MacOs = 8;

  /// License locked on Jetson Nano.
  static const int id3DocumentLicenseHardwareCodeType_JetsonNano = 9;

  /// License locked on iOS application Bundle ID.
  static const int id3DocumentLicenseHardwareCodeType_IosBundleId = 10;

  /// License locked on Windows USB stick.
  static const int id3DocumentLicenseHardwareCodeType_WindowsUsb = 11;

  /// License locked on a smart card.
  static const int id3DocumentLicenseHardwareCodeType_SmartCard = 12;
}

/// Enumerates the license types.
abstract class id3DocumentLicenseType {
  /// Classic id3 license.
  static const int id3DocumentLicenseType_Classic = 1;

  /// Trial id3 license with a time limitation.
  static const int id3DocumentLicenseType_Trial = 2;

  /// Online id3 license with an online check.
  static const int id3DocumentLicenseType_Online = 3;
}

/// Enumerates the error codes related to license management.
abstract class id3DocumentLicenseError {
  /// No error.
  static const int id3DocumentLicenseError_Success = 0;

  /// The given buffer is too small.
  static const int id3DocumentLicenseError_InsufficientBuffer = -1;

  /// The requested object does not exist; a 'null' should be returned if possible.
  static const int id3DocumentLicenseError_ObjectDoesNotExist = -2;

  /// Base error code of the License module.
  static const int id3DocumentLicenseError_Base = -100;

  /// Minimum error code of the License module.
  static const int id3DocumentLicenseError_Minimum = -999;

  /// The handle is invalid.
  static const int id3DocumentLicenseError_InvalidHandle = -101;

  /// One of the parameters is incorrect.
  static const int id3DocumentLicenseError_InvalidParameter = -102;

  /// No license was found.
  static const int id3DocumentLicenseError_LicenseNotFound = -103;

  /// License is not valid or a required module is not licensed.
  static const int id3DocumentLicenseError_InvalidLicense = -104;

  /// The license has expired.
  static const int id3DocumentLicenseError_ExpiredLicense = -105;

  /// Installation code does not match hardware ID.
  static const int id3DocumentLicenseError_InvalidHardwareId = -106;

  /// The license is already fulfilled by another user (or computer).
  static const int id3DocumentLicenseError_AlreadyFulfilled = -107;

  /// A required module is not licensed or the usage limit has been reached.
  static const int id3DocumentLicenseError_ModuleError = -108;

  /// The license file cannot be accessed in write mode.
  static const int id3DocumentLicenseError_WriteError = -109;

  /// The number of available licenses has been reached. There isn't any available license remaining.
  static const int id3DocumentLicenseError_InsufficientLicenseCredits = -110;

  /// The serial is invalid.
  static const int id3DocumentLicenseError_InvalidSerial = -111;

  /// Invalid login or password.
  static const int id3DocumentLicenseError_InvalidCredentials = -112;

  /// The license is revoked or does not exist anymore.
  static const int id3DocumentLicenseError_RevokedLicense = -113;

  /// The license is blocked after a predefined period.
  static const int id3DocumentLicenseError_BlockedLicense = -114;

  /// The license server is currently unreachable.
  static const int id3DocumentLicenseError_UnreachableServer = -115;

  /// An unexpected error happened.
  static const int id3DocumentLicenseError_LicenseOtherError = -116;

  /// No license file was provided.
  static const int id3DocumentLicenseError_MissingFile = -117;

  /// This device is not compatible with id3 licensing system.
  static const int id3DocumentLicenseError_DeviceNotCompatible = -118;
}

final class id3DocumentStringDict extends ffi.Opaque {}

/// Handle to a StringDict object of the Document module.
typedef ID3_DOCUMENT_STRING_DICT = ffi.Pointer<id3DocumentStringDict>;

final class id3DocumentMrzReadingResult extends ffi.Opaque {}

/// Handle to a MrzReadingResult object of the Document module.
typedef ID3_DOCUMENT_MRZ_READING_RESULT
    = ffi.Pointer<id3DocumentMrzReadingResult>;

final class id3DocumentMrzReader extends ffi.Opaque {}

/// Handle to a MrzReader object of the Document module.
typedef ID3_DOCUMENT_MRZ_READER = ffi.Pointer<id3DocumentMrzReader>;

final class id3DocumentTextField extends ffi.Opaque {}

/// Handle to a TextField object of the Document module.
typedef ID3_DOCUMENT_TEXT_FIELD = ffi.Pointer<id3DocumentTextField>;

final class id3DocumentTextFieldList extends ffi.Opaque {}

/// Handle to a TextFieldList object of the Document module.
typedef ID3_DOCUMENT_TEXT_FIELD_LIST = ffi.Pointer<id3DocumentTextFieldList>;

final class id3DocumentReader extends ffi.Opaque {}

/// Handle to a DocumentReader object of the Document module.
typedef ID3_DOCUMENT_READER = ffi.Pointer<id3DocumentReader>;

const int true1 = 1;

const int false1 = 0;

const int __bool_true_false_are_defined = 1;

const int ID3DOCUMENT_VERSION_MAJOR = 2;

const int ID3DOCUMENT_VERSION_MINOR = 1;

const int ID3DOCUMENT_VERSION_BUILD = 2;

const int ID3DOCUMENT_TARGET_REFERENCE_FILE_VERSION_MAJOR = 2;

const int ID3DOCUMENT_TARGET_REFERENCE_FILE_VERSION_MINOR = 1;

const int ID3DOCUMENT_TARGET_REFERENCE_FILE_VERSION_BUILD = 0;
