//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:convert';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'document_sdk_generated_bindings.dart';
import 'document_native.dart';

import '../id3_document.dart';

final _finalizer = NativeFinalizer(documentSDK.addresses.id3DocumentHologramAuthenticationResult_Dispose.cast());

/// Represents the result of hologram authentication.
class HologramAuthenticationResult implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3DocumentHologramAuthenticationResult>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3DocumentHologramAuthenticationResult> get handle => _pHandle.value;

  /// Creates a new instance of the HologramAuthenticationResult class.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  HologramAuthenticationResult() {
    _pHandle = calloc();
    try {
      var err = documentSDK.id3DocumentHologramAuthenticationResult_Initialize(_pHandle);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the HologramAuthenticationResult class.
  ///
  /// param handle     Handle to the HologramAuthenticationResult.
  /// throws DocumentException An error has occurred during Document Library execution.
  HologramAuthenticationResult.fromHandle(Pointer<id3DocumentHologramAuthenticationResult> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this HologramAuthenticationResult.
  void dispose() {
    if (_disposable) {
      documentSDK.id3DocumentHologramAuthenticationResult_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  // Copyable methods

  /// Creates a copy of the HologramAuthenticationResult object.
  ///
  /// return The newly created HologramAuthenticationResult object.
  /// throws DocumentException An error has occurred during Document Library execution.
  HologramAuthenticationResult clone() {
    HologramAuthenticationResult clone = HologramAuthenticationResult();
    var err = documentSDK.id3DocumentHologramAuthenticationResult_CopyTo(_pHandle.value, clone.handle);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
    return clone;
  }


  ///
  /// Exact bounds of the text in the image.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  Rectangle get bounds => getBounds();

  ///
  /// Correlation of the variation to the background.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  double get correlationScore => getCorrelationScore();

  ///
  /// Name of the hologram.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  String get hologramName => getHologramName();

  ///
  /// Variation of the OVI color.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  double get variationScore => getVariationScore();

  // Public methods
  /// Gets the exact bounds of the text in the image.
  ///
  /// return Exact bounds of the text in the image.
  /// throws DocumentException An error has occurred during Document Library execution.
  Rectangle getBounds() {
    Pointer<id3DocumentRectangle> pBounds = calloc();
    var err = documentSDK.id3DocumentHologramAuthenticationResult_GetBounds(_pHandle.value, pBounds);
    if (err != DocumentError.success.value) {
    	calloc.free(pBounds);
    	throw DocumentException(err);
    }
    return Rectangle(pBounds);
  }

  /// Gets the correlation of the variation to the background.
  ///
  /// return Correlation of the variation to the background.
  /// throws DocumentException An error has occurred during Document Library execution.
  double getCorrelationScore() {
    Pointer<Float> pCorrelationScore = calloc();
    try {
      var err = documentSDK.id3DocumentHologramAuthenticationResult_GetCorrelationScore(_pHandle.value, pCorrelationScore);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
      final vCorrelationScore = pCorrelationScore.value;
      return vCorrelationScore;
    } finally {
      calloc.free(pCorrelationScore);
    }
  }

  /// Gets the name of the hologram.
  ///
  /// return Name of the hologram.
  /// throws DocumentException An error has occurred during Document Library execution.
  String getHologramName() {
    Pointer<Char> pHologramName = nullptr;
    Pointer<Int> pHologramNameSize = calloc.allocate(1);
    pHologramNameSize[0] = -1;
    try {
      var err = documentSDK.id3DocumentHologramAuthenticationResult_GetHologramName(_pHandle.value, pHologramName, pHologramNameSize);
      if (err == DocumentError.insufficientBuffer.value) {
        pHologramName = calloc.allocate(pHologramNameSize.value);
        err = documentSDK.id3DocumentHologramAuthenticationResult_GetHologramName(_pHandle.value, pHologramName, pHologramNameSize);
        if (err != DocumentError.success.value) {
          throw DocumentException(err);
        }
      }
      final vHologramName = utf8.decode(Uint8List.fromList(pHologramName.cast<Uint8>().asTypedList(pHologramNameSize.value)));
      return vHologramName;
    } finally {
      calloc.free(pHologramName);
      calloc.free(pHologramNameSize);
    }
  }

  /// Gets the variation of the OVI color.
  ///
  /// return Variation of the OVI color.
  /// throws DocumentException An error has occurred during Document Library execution.
  double getVariationScore() {
    Pointer<Float> pVariationScore = calloc();
    try {
      var err = documentSDK.id3DocumentHologramAuthenticationResult_GetVariationScore(_pHandle.value, pVariationScore);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
      final vVariationScore = pVariationScore.value;
      return vVariationScore;
    } finally {
      calloc.free(pVariationScore);
    }
  }

}

