//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'document_sdk_generated_bindings.dart';
import 'document_native.dart';

import '../id3_document.dart';

final _finalizer = NativeFinalizer(documentSDK.addresses.id3DocumentHologramAuthenticationResultList_Dispose.cast());

/// Represents a list of hologram authentication results.
class HologramAuthenticationResultList extends Object with IterableMixin<HologramAuthenticationResult> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3DocumentHologramAuthenticationResultList>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3DocumentHologramAuthenticationResultList> get handle => _pHandle.value;

  /// Creates a new instance of the HologramAuthenticationResultList class.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  HologramAuthenticationResultList() {
    _pHandle = calloc();
    try {
      var err = documentSDK.id3DocumentHologramAuthenticationResultList_Initialize(_pHandle);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the HologramAuthenticationResultList class.
  ///
  /// param handle     Handle to the HologramAuthenticationResultList.
  /// throws DocumentException An error has occurred during Document Library execution.
  HologramAuthenticationResultList.fromHandle(Pointer<id3DocumentHologramAuthenticationResultList> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this HologramAuthenticationResultList.
  void dispose() {
    if (_disposable) {
      documentSDK.id3DocumentHologramAuthenticationResultList_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  // Copyable methods

  /// Creates a copy of the HologramAuthenticationResultList object.
  ///
  /// return The newly created HologramAuthenticationResultList object.
  /// throws DocumentException An error has occurred during Document Library execution.
  HologramAuthenticationResultList clone() {
    HologramAuthenticationResultList clone = HologramAuthenticationResultList();
    var err = documentSDK.id3DocumentHologramAuthenticationResultList_CopyTo(_pHandle.value, clone.handle);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
    return clone;
  }

  /// Gets or sets the element at the specified index.
  operator [](int key) => get(key);
  operator []=(int key, HologramAuthenticationResult item) => set(key, item);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<HologramAuthenticationResult> get iterator => HologramAuthenticationResultListIterator(this);

  // Public methods
  /// Clears the HologramAuthenticationResultList object.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  void clear() {
    var err = documentSDK.id3DocumentHologramAuthenticationResultList_Clear(_pHandle.value);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// Adds an item to the HologramAuthenticationResultList object.
  ///
  /// param hologramAuthenticationResultItem HologramAuthenticationResult item to add.
  /// throws DocumentException An error has occurred during Document Library execution.
  void add(HologramAuthenticationResult hologramAuthenticationResultItem) {
    var err = documentSDK.id3DocumentHologramAuthenticationResultList_Add(_pHandle.value, hologramAuthenticationResultItem.handle);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// Gets an item of the HologramAuthenticationResultList object.
  ///
  /// param index Index of the HologramAuthenticationResult item to get.
  /// return HologramAuthenticationResult item to get.
  /// throws DocumentException An error has occurred during Document Library execution.
  HologramAuthenticationResult get(int index) {
    HologramAuthenticationResult hologramAuthenticationResultItem = HologramAuthenticationResult();
    var err = documentSDK.id3DocumentHologramAuthenticationResultList_Get(_pHandle.value, index, hologramAuthenticationResultItem.handle);
    if (err != DocumentError.success.value) {
      hologramAuthenticationResultItem.dispose();
      throw DocumentException(err);
    }
    return hologramAuthenticationResultItem;
  }

  /// Sets an item of the HologramAuthenticationResultList object.
  ///
  /// param index Index of the HologramAuthenticationResult item to set.
  /// param hologramAuthenticationResultItem HologramAuthenticationResult item to set.
  /// throws DocumentException An error has occurred during Document Library execution.
  void set(int index, HologramAuthenticationResult hologramAuthenticationResultItem) {
    var err = documentSDK.id3DocumentHologramAuthenticationResultList_Set(_pHandle.value, index, hologramAuthenticationResultItem.handle);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// Gets the number of elements in the HologramAuthenticationResultList object.
  ///
  /// return Number of elements in the HologramAuthenticationResult object.
  /// throws DocumentException An error has occurred during Document Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = documentSDK.id3DocumentHologramAuthenticationResultList_GetCount(_pHandle.value, pCount);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

  /// Removes an element of the HologramAuthenticationResultList object.
  ///
  /// param index Index of the HologramAuthenticationResult item to remove.
  /// throws DocumentException An error has occurred during Document Library execution.
  void removeAt(int index) {
    var err = documentSDK.id3DocumentHologramAuthenticationResultList_RemoveAt(_pHandle.value, index);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// HologramAuthenticationResultList object.
  ///
  /// param newSize HologramAuthenticationResult object.
  /// throws DocumentException An error has occurred during Document Library execution.
  void resize(int newSize) {
    var err = documentSDK.id3DocumentHologramAuthenticationResultList_Resize(_pHandle.value, newSize);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

}

class HologramAuthenticationResultListIterator implements Iterator<HologramAuthenticationResult> {
  HologramAuthenticationResultListIterator(this._list) : _count = _list.getCount();
  final HologramAuthenticationResultList _list;
  final int _count;
  int _index = -1;

  @override
  HologramAuthenticationResult get current => _list.get(_index);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
