//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'document_sdk_generated_bindings.dart';
import 'document_native.dart';

import '../id3_document.dart';

final _finalizer = NativeFinalizer(documentSDK.addresses.id3DocumentImageBuffer_Dispose.cast());

/// Represents an image buffer.
class ImageBuffer implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3DocumentImageBuffer>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3DocumentImageBuffer> get handle => _pHandle.value;

  /// Creates a new instance of the ImageBuffer class.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  ImageBuffer() {
    _pHandle = calloc();
    try {
      var err = documentSDK.id3DocumentImageBuffer_Initialize(_pHandle);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the ImageBuffer class.
  ///
  /// param handle     Handle to the ImageBuffer.
  /// throws DocumentException An error has occurred during Document Library execution.
  ImageBuffer.fromHandle(Pointer<id3DocumentImageBuffer> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this ImageBuffer.
  void dispose() {
    if (_disposable) {
      documentSDK.id3DocumentImageBuffer_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  // Copyable methods

  /// Creates a copy of the ImageBuffer object.
  ///
  /// return The newly created ImageBuffer object.
  /// throws DocumentException An error has occurred during Document Library execution.
  ImageBuffer clone() {
    ImageBuffer clone = ImageBuffer();
    var err = documentSDK.id3DocumentImageBuffer_CopyTo(_pHandle.value, clone.handle);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
    return clone;
  }


  // Public methods
  /// Gets the image buffer data.
  ///
  /// return Data of the image buffer object.
  /// throws DocumentException An error has occurred during Document Library execution.
  Uint8List getData() {
    Pointer<UnsignedChar> pData = nullptr;
    Pointer<Int> pDataSize = calloc();
    pDataSize[0] = -1;
    try {
      var err = documentSDK.id3DocumentImageBuffer_GetData(_pHandle.value, pData, pDataSize);
      if (err == DocumentError.insufficientBuffer.value) {
        pData = calloc.allocate(pDataSize.value);
        err = documentSDK.id3DocumentImageBuffer_GetData(_pHandle.value, pData, pDataSize);
      }
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
      final vData = Uint8List.fromList(pData.cast<Uint8>().asTypedList(pDataSize.value));
      return vData;
    } finally {
      calloc.free(pData);
      calloc.free(pDataSize);
    }
  }

}

