//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'document_sdk_generated_bindings.dart';

/// Represents a point.
class Point {
  final Pointer<id3DocumentPoint> _handle;

  static final Finalizer<Pointer<id3DocumentPoint>> _finalizer = Finalizer((handle) => calloc.free(handle));

  Pointer<id3DocumentPoint> get handle => _handle;

  id3DocumentPoint get struct => _handle.ref;

  /// Initializes a new instance of the Point class from its members.
  Point(this._handle);

  /// Create a new instance of the Point.
  Point.create() : _handle = calloc() {
    _finalizer.attach(this, _handle, detach: this);
  }

  /// Create a new instance of the Point from the native struct
  Point.createFromStruct(id3DocumentPoint value) : _handle = calloc() {
    _handle.ref.X = value.X;
    _handle.ref.Y = value.Y;
    _finalizer.attach(this, _handle, detach: this);
  }

  void dispose() {
    calloc.free(_handle);
    _finalizer.detach(this);
  }

  // Accessors
  
  /// 
  /// X-coordinate of the point.
  /// 
  /// throws DocumentException An error has occurred during Document Library execution.
  int get x => _handle.ref.X;
  set x(int value) => _handle.ref.X = value;

  /// 
  /// Y-coordinate of the point.
  /// 
  /// throws DocumentException An error has occurred during Document Library execution.
  int get y => _handle.ref.Y;
  set y(int value) => _handle.ref.Y = value;


  Map<String, dynamic> toMap() {
    return {
        'x': x,
        'y': y,
    };
  }
}
