//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'document_sdk_generated_bindings.dart';
import 'document_native.dart';

import '../id3_document.dart';

final _finalizer = NativeFinalizer(documentSDK.addresses.id3DocumentPointList_Dispose.cast());

/// Represents a point list.
class PointList extends Object with IterableMixin<Point> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3DocumentPointList>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3DocumentPointList> get handle => _pHandle.value;

  /// Creates a new instance of the PointList class.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  PointList() {
    _pHandle = calloc();
    try {
      var err = documentSDK.id3DocumentPointList_Initialize(_pHandle);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the PointList class.
  ///
  /// param handle     Handle to the PointList.
  /// throws DocumentException An error has occurred during Document Library execution.
  PointList.fromHandle(Pointer<id3DocumentPointList> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this PointList.
  void dispose() {
    if (_disposable) {
      documentSDK.id3DocumentPointList_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  // Copyable methods

  /// Creates a copy of the PointList object.
  ///
  /// return The newly created PointList object.
  /// throws DocumentException An error has occurred during Document Library execution.
  PointList clone() {
    PointList clone = PointList();
    var err = documentSDK.id3DocumentPointList_CopyTo(_pHandle.value, clone.handle);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
    return clone;
  }

  /// Gets or sets the element at the specified index.
  operator [](int key) => get(key);
  operator []=(int key, Point item) => set(key, item);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<Point> get iterator => PointListIterator(this);

  // Public methods
  /// Clears the PointList object.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  void clear() {
    var err = documentSDK.id3DocumentPointList_Clear(_pHandle.value);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// Adds an item to the PointList object.
  ///
  /// param pointItem Point item to add.
  /// throws DocumentException An error has occurred during Document Library execution.
  void add(Point pointItem) {
    var err = documentSDK.id3DocumentPointList_Add(_pHandle.value, pointItem.handle);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// Gets an item of the PointList object.
  ///
  /// param index Index of the Point item to get.
  /// return Point item to get.
  /// throws DocumentException An error has occurred during Document Library execution.
  Point get(int index) {
    Pointer<id3DocumentPoint> pPointItem = calloc();
    var err = documentSDK.id3DocumentPointList_Get(_pHandle.value, index, pPointItem);
    if (err != DocumentError.success.value) {
    	calloc.free(pPointItem);
    	throw DocumentException(err);
    }
    return Point(pPointItem);
  }

  /// Sets an item of the PointList object.
  ///
  /// param index Index of the Point item to set.
  /// param pointItem Point item to set.
  /// throws DocumentException An error has occurred during Document Library execution.
  void set(int index, Point pointItem) {
    var err = documentSDK.id3DocumentPointList_Set(_pHandle.value, index, pointItem.handle);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// Gets the number of elements in the PointList object.
  ///
  /// return Number of elements in the Point object.
  /// throws DocumentException An error has occurred during Document Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = documentSDK.id3DocumentPointList_GetCount(_pHandle.value, pCount);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

  /// Removes an element of the PointList object.
  ///
  /// param index Index of the Point item to remove.
  /// throws DocumentException An error has occurred during Document Library execution.
  void removeAt(int index) {
    var err = documentSDK.id3DocumentPointList_RemoveAt(_pHandle.value, index);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// PointList object.
  ///
  /// param newSize Point object.
  /// throws DocumentException An error has occurred during Document Library execution.
  void resize(int newSize) {
    var err = documentSDK.id3DocumentPointList_Resize(_pHandle.value, newSize);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

}

class PointListIterator implements Iterator<Point> {
  PointListIterator(this._list) : _count = _list.getCount();
  final PointList _list;
  final int _count;
  int _index = -1;

  @override
  Point get current => _list.get(_index);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
