//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------

/// Enumerates processing units.
enum ProcessingUnit {
	/// CPU.
	cpu,
	/// GPU (automatic backend selection).
	gpu,
	/// OpenCL Backend.
	opencl,
	/// CUDA Backend.
	cuda,
	/// Metal Backend.
	metal,
	/// Vulkan Backend.
	vulkan,
}

extension ProcessingUnitX on ProcessingUnit {
	/// Creates an enumeration value from int.
	/// param value The int value.
	/// return The created ProcessingUnit.
  	static ProcessingUnit fromValue(int value) {
    	switch (value) {
      	case 0:
        	return ProcessingUnit.cpu;
      	case 1:
        	return ProcessingUnit.gpu;
      	case 2:
        	return ProcessingUnit.opencl;
      	case 3:
        	return ProcessingUnit.cuda;
      	case 4:
        	return ProcessingUnit.metal;
      	case 5:
        	return ProcessingUnit.vulkan;
	    default:
        	throw Exception("Unable to find the specified enum value for $value");
    	}
  	}

	/// Gets the enumeration value as int.
	/// return The value.
  	int get value {
    	switch (this) {
      	case ProcessingUnit.cpu:
        	return 0;
      	case ProcessingUnit.gpu:
        	return 1;
      	case ProcessingUnit.opencl:
        	return 2;
      	case ProcessingUnit.cuda:
        	return 3;
      	case ProcessingUnit.metal:
        	return 4;
      	case ProcessingUnit.vulkan:
        	return 5;
		}
  	}
}
