//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
import 'dart:ffi';
import 'package:ffi/ffi.dart';
import 'package:id3_document/src/point.dart';
import 'document_sdk_generated_bindings.dart';

/// Represents a rectangle.
class Rectangle {
  final Pointer<id3DocumentRectangle> _handle;

  static final Finalizer<Pointer<id3DocumentRectangle>> _finalizer = Finalizer((handle) => calloc.free(handle));

  Pointer<id3DocumentRectangle> get handle => _handle;

  id3DocumentRectangle get struct => _handle.ref;

  /// Initializes a new instance of the Rectangle class from its members.
  Rectangle(this._handle);

  /// Create a new instance of the Rectangle.
  Rectangle.create() : _handle = calloc() {
    _finalizer.attach(this, _handle, detach: this);
  }

  /// Create a new instance of the Rectangle from the native struct
  Rectangle.createFromStruct(id3DocumentRectangle value) : _handle = calloc() {
    _handle.ref.BottomLeft = value.BottomLeft;
    _handle.ref.BottomRight = value.BottomRight;
    _handle.ref.TopLeft = value.TopLeft;
    _handle.ref.TopRight = value.TopRight;
    _finalizer.attach(this, _handle, detach: this);
  }

  void dispose() {
    calloc.free(_handle);
    _finalizer.detach(this);
  }

  // Accessors
  
  /// 
  /// Bottom-left corner of the rectangle.
  /// 
  /// throws DocumentException An error has occurred during Document Library execution.
  Point get bottomLeft => Point.createFromStruct(_handle.ref.BottomLeft);
  set bottomLeft(Point value) => _handle.ref.BottomLeft = value.struct;

  /// 
  /// Bottom-right corner of the rectangle.
  /// 
  /// throws DocumentException An error has occurred during Document Library execution.
  Point get bottomRight => Point.createFromStruct(_handle.ref.BottomRight);
  set bottomRight(Point value) => _handle.ref.BottomRight = value.struct;

  /// 
  /// Top-left corner of the rectangle.
  /// 
  /// throws DocumentException An error has occurred during Document Library execution.
  Point get topLeft => Point.createFromStruct(_handle.ref.TopLeft);
  set topLeft(Point value) => _handle.ref.TopLeft = value.struct;

  /// 
  /// Top-right corner of the rectangle.
  /// 
  /// throws DocumentException An error has occurred during Document Library execution.
  Point get topRight => Point.createFromStruct(_handle.ref.TopRight);
  set topRight(Point value) => _handle.ref.TopRight = value.struct;


  Map<String, dynamic> toMap() {
    return {
        'bottomLeft': bottomLeft.toMap(),
        'bottomRight': bottomRight.toMap(),
        'topLeft': topLeft.toMap(),
        'topRight': topRight.toMap(),
    };
  }
}
