//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:convert';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'document_sdk_generated_bindings.dart';
import 'document_native.dart';

import '../id3_document.dart';

final _finalizer = NativeFinalizer(documentSDK.addresses.id3DocumentStringList_Dispose.cast());

/// Represents a string lists.
class StringList extends Object with IterableMixin<String> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3DocumentStringList>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3DocumentStringList> get handle => _pHandle.value;

  /// Creates a new instance of the StringList class.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  StringList() {
    _pHandle = calloc();
    try {
      var err = documentSDK.id3DocumentStringList_Initialize(_pHandle);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the StringList class.
  ///
  /// param handle     Handle to the StringList.
  /// throws DocumentException An error has occurred during Document Library execution.
  StringList.fromHandle(Pointer<id3DocumentStringList> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this StringList.
  void dispose() {
    if (_disposable) {
      documentSDK.id3DocumentStringList_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  // Copyable methods

  /// Creates a copy of the StringList object.
  ///
  /// return The newly created StringList object.
  /// throws DocumentException An error has occurred during Document Library execution.
  StringList clone() {
    StringList clone = StringList();
    var err = documentSDK.id3DocumentStringList_CopyTo(_pHandle.value, clone.handle);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
    return clone;
  }

  /// Gets or sets the element at the specified index.
  operator [](int key) => get(key);
  operator []=(int key, String item) => set(key, item);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<String> get iterator => StringListIterator(this);

  // Public methods
  /// Clears the StringList object.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  void clear() {
    var err = documentSDK.id3DocumentStringList_Clear(_pHandle.value);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// Adds an item to the StringList object.
  ///
  /// param item  item to add.
  /// throws DocumentException An error has occurred during Document Library execution.
  void add(String? item) {
    Pointer<Char>? pItem = item?.toNativeUtf8().cast<Char>();
    try {
      var err = documentSDK.id3DocumentStringList_Add(_pHandle.value, pItem ?? nullptr);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
    } finally {
      if (pItem != null) {
        calloc.free(pItem);
      }
    }
  }

  /// Gets an item of the StringList object.
  ///
  /// param index Index of the  item to get.
  /// return  item to get.
  /// throws DocumentException An error has occurred during Document Library execution.
  String get(int index) {
    Pointer<Char> pItem = nullptr;
    Pointer<Int> pItemSize = calloc.allocate(1);
    pItemSize[0] = -1;
    try {
      var err = documentSDK.id3DocumentStringList_Get(_pHandle.value, index, pItem, pItemSize);
      if (err == DocumentError.insufficientBuffer.value) {
        pItem = calloc.allocate(pItemSize.value);
        err = documentSDK.id3DocumentStringList_Get(_pHandle.value, index, pItem, pItemSize);
        if (err != DocumentError.success.value) {
          throw DocumentException(err);
        }
      }
      final vItem = utf8.decode(Uint8List.fromList(pItem.cast<Uint8>().asTypedList(pItemSize.value)));
      return vItem;
    } finally {
      calloc.free(pItem);
      calloc.free(pItemSize);
    }
  }

  /// Sets an item of the StringList object.
  ///
  /// param index Index of the  item to set.
  /// param item  item to set.
  /// throws DocumentException An error has occurred during Document Library execution.
  void set(int index, String? item) {
    Pointer<Char>? pItem = item?.toNativeUtf8().cast<Char>();
    try {
      var err = documentSDK.id3DocumentStringList_Set(_pHandle.value, index, pItem ?? nullptr);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
    } finally {
      if (pItem != null) {
        calloc.free(pItem);
      }
    }
  }

  /// Gets the number of elements in the StringList object.
  ///
  /// return Number of elements in the  object.
  /// throws DocumentException An error has occurred during Document Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = documentSDK.id3DocumentStringList_GetCount(_pHandle.value, pCount);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

  /// Removes an element of the StringList object.
  ///
  /// param index Index of the  item to remove.
  /// throws DocumentException An error has occurred during Document Library execution.
  void removeAt(int index) {
    var err = documentSDK.id3DocumentStringList_RemoveAt(_pHandle.value, index);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// StringList object.
  ///
  /// param newSize  object.
  /// throws DocumentException An error has occurred during Document Library execution.
  void resize(int newSize) {
    var err = documentSDK.id3DocumentStringList_Resize(_pHandle.value, newSize);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

}

class StringListIterator implements Iterator<String> {
  StringListIterator(this._list) : _count = _list.getCount();
  final StringList _list;
  final int _count;
  int _index = -1;

  @override
  String get current => _list.get(_index);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
