//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
// ignore_for_file: unused_import
import 'dart:collection';
import 'dart:ffi';
import 'dart:typed_data';
import 'package:ffi/ffi.dart';
import 'document_sdk_generated_bindings.dart';
import 'document_native.dart';

import '../id3_document.dart';

final _finalizer = NativeFinalizer(documentSDK.addresses.id3DocumentTextFieldList_Dispose.cast());

/// Represents a list of text fields extracted from a document.
class TextFieldList extends Object with IterableMixin<TextField> implements Finalizable {
  /// Native handle.
  late Pointer<Pointer<id3DocumentTextFieldList>> _pHandle;
  bool _disposable = true;

  /// Gets the native handle.
  /// return The native handle.
  Pointer<id3DocumentTextFieldList> get handle => _pHandle.value;

  /// Creates a new instance of the TextFieldList class.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  TextFieldList() {
    _pHandle = calloc();
    try {
      var err = documentSDK.id3DocumentTextFieldList_Initialize(_pHandle);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
      _finalizer.attach(this, _pHandle.cast(), detach: this);
    } finally {}
  }

  /// Creates a new instance of the TextFieldList class.
  ///
  /// param handle     Handle to the TextFieldList.
  /// throws DocumentException An error has occurred during Document Library execution.
  TextFieldList.fromHandle(Pointer<id3DocumentTextFieldList> handle) {
    _pHandle = calloc();
    _pHandle.value = handle;
    _disposable = false;
  }

  /// Releases all resources used by this TextFieldList.
  void dispose() {
    if (_disposable) {
      documentSDK.id3DocumentTextFieldList_Dispose(_pHandle);
      calloc.free(_pHandle);
      _finalizer.detach(this);
    }
  }

  // Copyable methods

  /// Creates a copy of the TextFieldList object.
  ///
  /// return The newly created TextFieldList object.
  /// throws DocumentException An error has occurred during Document Library execution.
  TextFieldList clone() {
    TextFieldList clone = TextFieldList();
    var err = documentSDK.id3DocumentTextFieldList_CopyTo(_pHandle.value, clone.handle);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
    return clone;
  }

  /// Gets or sets the element at the specified index.
  operator [](int key) => get(key);
  operator []=(int key, TextField item) => set(key, item);

  /// Gets the number of elements contained in the list or dictionary.
  int get count => getCount();

  @override
  Iterator<TextField> get iterator => TextFieldListIterator(this);

  // Public methods
  /// Clears the TextFieldList object.
  ///
  /// throws DocumentException An error has occurred during Document Library execution.
  void clear() {
    var err = documentSDK.id3DocumentTextFieldList_Clear(_pHandle.value);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// Adds an item to the TextFieldList object.
  ///
  /// param textFieldItem TextField item to add.
  /// throws DocumentException An error has occurred during Document Library execution.
  void add(TextField textFieldItem) {
    var err = documentSDK.id3DocumentTextFieldList_Add(_pHandle.value, textFieldItem.handle);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// Gets an item of the TextFieldList object.
  ///
  /// param index Index of the TextField item to get.
  /// return TextField item to get.
  /// throws DocumentException An error has occurred during Document Library execution.
  TextField get(int index) {
    TextField textFieldItem = TextField();
    var err = documentSDK.id3DocumentTextFieldList_Get(_pHandle.value, index, textFieldItem.handle);
    if (err != DocumentError.success.value) {
      textFieldItem.dispose();
      throw DocumentException(err);
    }
    return textFieldItem;
  }

  /// Sets an item of the TextFieldList object.
  ///
  /// param index Index of the TextField item to set.
  /// param textFieldItem TextField item to set.
  /// throws DocumentException An error has occurred during Document Library execution.
  void set(int index, TextField textFieldItem) {
    var err = documentSDK.id3DocumentTextFieldList_Set(_pHandle.value, index, textFieldItem.handle);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// Gets the number of elements in the TextFieldList object.
  ///
  /// return Number of elements in the TextField object.
  /// throws DocumentException An error has occurred during Document Library execution.
  int getCount() {
    Pointer<Int> pCount = calloc();
    try {
      var err = documentSDK.id3DocumentTextFieldList_GetCount(_pHandle.value, pCount);
      if (err != DocumentError.success.value) {
        throw DocumentException(err);
      }
      final vCount = pCount.value;
      return vCount;
    } finally {
      calloc.free(pCount);
    }
  }

  /// Removes an element of the TextFieldList object.
  ///
  /// param index Index of the TextField item to remove.
  /// throws DocumentException An error has occurred during Document Library execution.
  void removeAt(int index) {
    var err = documentSDK.id3DocumentTextFieldList_RemoveAt(_pHandle.value, index);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

  /// TextFieldList object.
  ///
  /// param newSize TextField object.
  /// throws DocumentException An error has occurred during Document Library execution.
  void resize(int newSize) {
    var err = documentSDK.id3DocumentTextFieldList_Resize(_pHandle.value, newSize);
    if (err != DocumentError.success.value) {
      throw DocumentException(err);
    }
  }

}

class TextFieldListIterator implements Iterator<TextField> {
  TextFieldListIterator(this._list) : _count = _list.getCount();
  final TextFieldList _list;
  final int _count;
  int _index = -1;

  @override
  TextField get current => _list.get(_index);

  @override
  bool moveNext() {
    _index++;
    return _index < _count;
  }
}
