//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentHologramAuthenticationResultList_h
#define _id3DocumentHologramAuthenticationResultList_h

#include <id3Document/id3DocumentExports.h>
#include <id3Document/id3DocumentHologramAuthenticationResult.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents a list of hologram authentication results.
 */

/**
 * Handle to a HologramAuthenticationResultList object of the Document module.
 */
typedef struct id3DocumentHologramAuthenticationResultList *ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST;

/**
 * @brief Initializes a HologramAuthenticationResultList object.
 * @param phHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResultList_Initialize(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST *phHologramAuthenticationResultList);

/**
 * @brief Releases the memory allocated for a HologramAuthenticationResultList.
 * @param phHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResultList_Dispose(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST *phHologramAuthenticationResultList);

/**
 * @brief Checks if the handle object is valid.
 * @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResultList_CheckHandle(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST hHologramAuthenticationResultList);

/**
 * @brief Copies an instance of HologramAuthenticationResultList object to another.
 * @param hHologramAuthenticationResultListSrc [in] Handle to the source HologramAuthenticationResultList object.
 * @param hHologramAuthenticationResultListDst [in] Handle to the destination HologramAuthenticationResultList object.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResultList_CopyTo(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST hHologramAuthenticationResultListSrc, ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST hHologramAuthenticationResultListDst);

/**
 * Clears the HologramAuthenticationResultList object.
 * @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResultList_Clear(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST hHologramAuthenticationResultList);

/**
 * Adds an item to the HologramAuthenticationResultList object.
 * @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
 * @param hHologramAuthenticationResultItem [in] HologramAuthenticationResult item to add.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResultList_Add(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST hHologramAuthenticationResultList, ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResultItem);

/**
 * Gets an item of the HologramAuthenticationResultList object.
 * @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
 * @param index [in] Index of the HologramAuthenticationResult item to get.
 * @param hHologramAuthenticationResultItem [out] HologramAuthenticationResult item to get.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResultList_Get(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST hHologramAuthenticationResultList, int index, ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResultItem);

/**
 * Sets an item of the HologramAuthenticationResultList object.
 * @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
 * @param index [in] Index of the HologramAuthenticationResult item to set.
 * @param hHologramAuthenticationResultItem [in] HologramAuthenticationResult item to set.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResultList_Set(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST hHologramAuthenticationResultList, int index, ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT hHologramAuthenticationResultItem);

/**
 * Gets the number of elements in the HologramAuthenticationResultList object.
 * @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
 * @param count [out] Number of elements in the HologramAuthenticationResult object.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResultList_GetCount(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST hHologramAuthenticationResultList, int *count);

/**
 * Removes an element of the HologramAuthenticationResultList object.
 * @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
 * @param index [in] Index of the HologramAuthenticationResult item to remove.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResultList_RemoveAt(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST hHologramAuthenticationResultList, int index);

/**
 * HologramAuthenticationResultList object.
 * @param hHologramAuthenticationResultList [in] Handle to the HologramAuthenticationResultList object.
 * @param newSize [in] HologramAuthenticationResult object.
 * @return An error code. See id3DocumentError file for the list of possible error codes.
 * @retval id3DocumentError_Success The function succeeded.
 */
ID3DOCUMENT_C_API int ID3_CDECL id3DocumentHologramAuthenticationResultList_Resize(ID3_DOCUMENT_HOLOGRAM_AUTHENTICATION_RESULT_LIST hHologramAuthenticationResultList, int newSize);

#ifdef __cplusplus
}
#endif

#endif
