//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentLicenseHardwareCodeType_h
#define _id3DocumentLicenseHardwareCodeType_h

#include <id3Document/id3DocumentExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the types of hardware codes.
 */
typedef enum id3DocumentLicenseHardwareCodeType {
	/**
	 * License locked on Windows OS.
	 */
	id3DocumentLicenseHardwareCodeType_WindowsOs = 1,
	/**
	 * License locked on Linux OS.
	 */
	id3DocumentLicenseHardwareCodeType_LinuxOs = 3,
	/**
	 * License locked on Android device.
	 */
	id3DocumentLicenseHardwareCodeType_Android = 5,
	/**
	 * License locked on Android application package name.
	 */
	id3DocumentLicenseHardwareCodeType_AndroidPackageName = 6,
	/**
	 * License locked on iOS device.
	 */
	id3DocumentLicenseHardwareCodeType_Ios = 7,
	/**
	 * License locked on macOS.
	 */
	id3DocumentLicenseHardwareCodeType_MacOs = 8,
	/**
	 * License locked on Jetson Nano.
	 */
	id3DocumentLicenseHardwareCodeType_JetsonNano = 9,
	/**
	 * License locked on iOS application Bundle ID.
	 */
	id3DocumentLicenseHardwareCodeType_IosBundleId = 10,
	/**
	 * License locked on Windows USB stick.
	 */
	id3DocumentLicenseHardwareCodeType_WindowsUsb = 11,
	/**
	 * License locked on a smart card.
	 */
	id3DocumentLicenseHardwareCodeType_SmartCard = 12,
} id3DocumentLicenseHardwareCodeType;

ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetLicenseHardwareCodeTypeString(int value);

#ifdef __cplusplus
}
#endif

#endif
