//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentLicenseType_h
#define _id3DocumentLicenseType_h

#include <id3Document/id3DocumentExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the license types.
 */
typedef enum id3DocumentLicenseType {
	/**
	 * Classic id3 license.
	 */
	id3DocumentLicenseType_Classic = 1,
	/**
	 * Trial id3 license with a time limitation.
	 */
	id3DocumentLicenseType_Trial = 2,
	/**
	 * Online id3 license with an online check.
	 */
	id3DocumentLicenseType_Online = 3,
} id3DocumentLicenseType;

ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetLicenseTypeString(int value);

#ifdef __cplusplus
}
#endif

#endif
