//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentModel_h
#define _id3DocumentModel_h

#include <id3Document/id3DocumentExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates the AI models available in this SDK.
 */
typedef enum id3DocumentModel {
	/**
	 * Document detector 2A. Best accuracy model.
	 */
	id3DocumentModel_DocumentDetector2A = 1001,
	/**
	 * Document detector 2B. Fast detector for low-end mobiles.
	 */
	id3DocumentModel_DocumentDetector2B = 1002,
	/**
	 * MRZ Reader 2A. Stand-alone reader (no document detection needed).
	 */
	id3DocumentModel_MrzReader2A = 1102,
	/**
	 * OCR (Optical Character Recognition) model 2A for reading text fields in latin alphabet and digits.
	 */
	id3DocumentModel_OcrLatin2A = 1202,
} id3DocumentModel;

ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetDocumentModelString(int value);

#ifdef __cplusplus
}
#endif

#endif
