//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentPixelFormat_h
#define _id3DocumentPixelFormat_h

#include <id3Document/id3DocumentExports.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Enumerates supported pixel formats.
 */
typedef enum id3DocumentPixelFormat {
	/**
	 * Undefined.
	 */
	id3DocumentPixelFormat_Undefined = 0,
	/**
	 * 8-bits grayscale.
	 */
	id3DocumentPixelFormat_Grayscale8Bits = 10,
	/**
	 * 16-bits grayscale.
	 */
	id3DocumentPixelFormat_Grayscale16Bits = 20,
	/**
	 * Floating point grayscale.
	 */
	id3DocumentPixelFormat_GrayscaleFloat = 25,
	/**
	 * 24 bits BGR.
	 */
	id3DocumentPixelFormat_Bgr24Bits = 30,
	/**
	 * 24 bits RGB.
	 */
	id3DocumentPixelFormat_Rgb24Bits = 31,
	/**
	 * 32 bits BGRA.
	 */
	id3DocumentPixelFormat_Bgra = 32,
	/**
	 * 32 bits RGBA.
	 */
	id3DocumentPixelFormat_Rgba = 33,
	/**
	 * NV12 (YUV semi-planar format).
	 */
	id3DocumentPixelFormat_Nv12 = 40,
	/**
	 * I420 (YUV packed format).
	 */
	id3DocumentPixelFormat_I420 = 41,
	/**
	 * YUY2 (YUV packed format).
	 */
	id3DocumentPixelFormat_Yuy2 = 42,
	/**
	 * YV12 (YUV packed format).
	 */
	id3DocumentPixelFormat_Yv12 = 43,
} id3DocumentPixelFormat;

ID3DOCUMENT_C_API const char * ID3_CDECL id3Document_GetPixelFormatString(int value);

#ifdef __cplusplus
}
#endif

#endif
