//--------------------------------------------------------------------------------------------------
// Copyright (c) id3 Technologies
// All Rights Reserved.
//--------------------------------------------------------------------------------------------------
#ifndef _id3DocumentRectangle_h
#define _id3DocumentRectangle_h

#include <id3Document/id3DocumentExports.h>
#include <id3Document/id3DocumentPoint.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * Represents a rectangle.
 */
typedef struct id3DocumentRectangle {
	/**
	 * Bottom-left corner of the rectangle.
	 */
    id3DocumentPoint BottomLeft;
	/**
	 * Bottom-right corner of the rectangle.
	 */
    id3DocumentPoint BottomRight;
	/**
	 * Top-left corner of the rectangle.
	 */
    id3DocumentPoint TopLeft;
	/**
	 * Top-right corner of the rectangle.
	 */
    id3DocumentPoint TopRight;
} id3DocumentRectangle;

#ifdef __cplusplus
}
#endif

#endif
