/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import eu.id3.face.Image;
import eu.id3.face.Point;
import eu.id3.face.PointList;
import eu.id3.face.Rectangle;
import java.io.Serializable;

public class DetectedFace
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public DetectedFace() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = DetectedFace.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public DetectedFace(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            DetectedFace.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public DetectedFace clone() throws FaceException {
        DetectedFace clone = new DetectedFace();
        int err = DetectedFace.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public Rectangle getBounds() throws FaceException {
        Rectangle bounds = new Rectangle();
        int err = DetectedFace.nGetBounds(this.handle, bounds);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return bounds;
    }

    public void setBounds(Rectangle bounds) throws FaceException {
        int err = DetectedFace.nSetBounds(this.handle, bounds);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getDetectionScore() throws FaceException {
        int[] detectionScoreArray = new int[1];
        int err = DetectedFace.nGetDetectionScore(this.handle, detectionScoreArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return detectionScoreArray[0];
    }

    public int getId() throws FaceException {
        int[] idArray = new int[1];
        int err = DetectedFace.nGetId(this.handle, idArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return idArray[0];
    }

    public void setId(int id) throws FaceException {
        int err = DetectedFace.nSetId(this.handle, id);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public PointList getLandmarks() throws FaceException {
        PointList landmarks = new PointList();
        int err = DetectedFace.nGetLandmarks(this.handle, landmarks.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return landmarks;
    }

    public void setLandmarks(PointList landmarks) throws FaceException {
        int err = DetectedFace.nSetLandmarks(this.handle, landmarks.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static DetectedFace create(Rectangle bounds, int detectionScore, int id, PointList landmarks) throws FaceException {
        DetectedFace detectedFace = new DetectedFace();
        int err = DetectedFace.nCreate(detectedFace.getHandle(), bounds, detectionScore, id, landmarks.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return detectedFace;
    }

    public static DetectedFace fromBuffer(byte[] data) throws FaceException {
        DetectedFace detectedFace = new DetectedFace();
        int err = DetectedFace.nFromBuffer(detectedFace.getHandle(), data);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return detectedFace;
    }

    public static DetectedFace fromFile(String path) throws FaceException {
        DetectedFace detectedFace = new DetectedFace();
        int err = DetectedFace.nFromFile(detectedFace.getHandle(), path);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return detectedFace;
    }

    public int getDistanceToCamera(Image depthImage) throws FaceException {
        int[] distanceToCameraArray = new int[1];
        int err = DetectedFace.nGetDistanceToCamera(this.handle, depthImage.getHandle(), distanceToCameraArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return distanceToCameraArray[0];
    }

    public Rectangle getExpandedBounds(float aspectRatio, float margin) throws FaceException {
        Rectangle portraitBounds = new Rectangle();
        int err = DetectedFace.nGetExpandedBounds(this.handle, aspectRatio, margin, portraitBounds);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return portraitBounds;
    }

    public int getInterocularDistance() throws FaceException {
        int[] iodArray = new int[1];
        int err = DetectedFace.nGetInterocularDistance(this.handle, iodArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return iodArray[0];
    }

    public Rectangle getPortraitBounds(float eyeImageWidthRatio, float eyeImageHeightRatio, float imageRatio) throws FaceException {
        Rectangle portraitBounds = new Rectangle();
        int err = DetectedFace.nGetPortraitBounds(this.handle, eyeImageWidthRatio, eyeImageHeightRatio, imageRatio, portraitBounds);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return portraitBounds;
    }

    public void rescale(float scale) throws FaceException {
        int err = DetectedFace.nRescale(this.handle, scale);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void rotate(int angle, Point center) throws FaceException {
        int err = DetectedFace.nRotate(this.handle, angle, center);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public byte[] toBuffer() throws FaceException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = DetectedFace.nToBuffer(this.handle, data, dataSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = DetectedFace.nToBuffer(this.handle, data, dataSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return data;
    }

    public void toFile(String path) throws FaceException {
        int err = DetectedFace.nToFile(this.handle, path);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void translate(int tx, int ty) throws FaceException {
        int err = DetectedFace.nTranslate(this.handle, tx, ty);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetBounds(long var0, Rectangle var2);

    static native int nSetBounds(long var0, Rectangle var2);

    static native int nGetDetectionScore(long var0, int[] var2);

    static native int nGetId(long var0, int[] var2);

    static native int nSetId(long var0, int var2);

    static native int nGetLandmarks(long var0, long var2);

    static native int nSetLandmarks(long var0, long var2);

    static native int nCreate(long var0, Rectangle var2, int var3, int var4, long var5);

    static native int nFromBuffer(long var0, byte[] var2);

    static native int nFromFile(long var0, String var2);

    static native int nGetDistanceToCamera(long var0, long var2, int[] var4);

    static native int nGetExpandedBounds(long var0, float var2, float var3, Rectangle var4);

    static native int nGetInterocularDistance(long var0, int[] var2);

    static native int nGetPortraitBounds(long var0, float var2, float var3, float var4, Rectangle var5);

    static native int nRescale(long var0, float var2);

    static native int nRotate(long var0, int var2, Point var3);

    static native int nToBuffer(long var0, byte[] var2, int[] var3);

    static native int nToFile(long var0, String var2);

    static native int nTranslate(long var0, int var2, int var3);

    static {
        FaceNative.loadLibraries();
    }
}

