/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.DetectedFace;
import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DetectedFaceList
implements AutoCloseable,
Serializable,
Iterable<DetectedFace> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public DetectedFaceList() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = DetectedFaceList.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public DetectedFaceList(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            DetectedFaceList.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public DetectedFaceList clone() throws FaceException {
        DetectedFaceList clone = new DetectedFaceList();
        int err = DetectedFaceList.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public void clear() throws FaceException {
        int err = DetectedFaceList.nClear(this.handle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void add(DetectedFace detectedFaceItem) throws FaceException {
        int err = DetectedFaceList.nAdd(this.handle, detectedFaceItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public DetectedFace get(int index) throws FaceException {
        DetectedFace detectedFaceItem = new DetectedFace();
        int err = DetectedFaceList.nGet(this.handle, index, detectedFaceItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return detectedFaceItem;
    }

    public void set(int index, DetectedFace detectedFaceItem) throws FaceException {
        int err = DetectedFaceList.nSet(this.handle, index, detectedFaceItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getCount() throws FaceException {
        int[] countArray = new int[1];
        int err = DetectedFaceList.nGetCount(this.handle, countArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return countArray[0];
    }

    public void removeAt(int index) throws FaceException {
        int err = DetectedFaceList.nRemoveAt(this.handle, index);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void resize(int newSize) throws FaceException {
        int err = DetectedFaceList.nResize(this.handle, newSize);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public DetectedFace findDetectedFace(int id) throws FaceException {
        DetectedFace detectedFace = new DetectedFace();
        int err = DetectedFaceList.nFindDetectedFace(this.handle, id, detectedFace.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return detectedFace;
    }

    public int[] getIdList() throws FaceException {
        int[] ids = null;
        int[] idsSizeArray = new int[]{-1};
        int err = DetectedFaceList.nGetIdList(this.handle, ids, idsSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            ids = new int[idsSizeArray[0]];
            err = DetectedFaceList.nGetIdList(this.handle, ids, idsSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return ids;
    }

    public DetectedFace getLargestFace() throws FaceException {
        DetectedFace largestFace = new DetectedFace();
        int err = DetectedFaceList.nGetLargestFace(this.handle, largestFace.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return largestFace;
    }

    public void rescaleAll(float scale) throws FaceException {
        int err = DetectedFaceList.nRescaleAll(this.handle, scale);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nClear(long var0);

    static native int nAdd(long var0, long var2);

    static native int nGet(long var0, int var2, long var3);

    static native int nSet(long var0, int var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nRemoveAt(long var0, int var2);

    static native int nResize(long var0, int var2);

    static native int nFindDetectedFace(long var0, int var2, long var3);

    static native int nGetIdList(long var0, int[] var2, int[] var3);

    static native int nGetLargestFace(long var0, long var2);

    static native int nRescaleAll(long var0, float var2);

    @Override
    public Iterator<DetectedFace> iterator() {
        return new Iterator<DetectedFace>(){
            private int index = 0;
            private final int size = DetectedFaceList.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public DetectedFace next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return DetectedFaceList.this.get(this.index++);
            }
        };
    }

    static {
        FaceNative.loadLibraries();
    }
}

