/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.BackgroundUniformity;
import eu.id3.face.DetectedFace;
import eu.id3.face.EyeGaze;
import eu.id3.face.FaceAttributes;
import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceExpression;
import eu.id3.face.FaceNative;
import eu.id3.face.FaceOcclusionScores;
import eu.id3.face.FacePose;
import eu.id3.face.GeometricAttributes;
import eu.id3.face.GlassesAttributes;
import eu.id3.face.Image;
import eu.id3.face.PhotographicAttributes;
import eu.id3.face.PointList;
import java.io.Serializable;
import java.util.Arrays;

public class FaceAnalyser
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public FaceAnalyser() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = FaceAnalyser.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public FaceAnalyser(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            FaceAnalyser.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public int getExpressionSensibility() throws FaceException {
        int[] expressionSensibilityArray = new int[1];
        int err = FaceAnalyser.nGetExpressionSensibility(this.handle, expressionSensibilityArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return expressionSensibilityArray[0];
    }

    public void setExpressionSensibility(int expressionSensibility) throws FaceException {
        int err = FaceAnalyser.nSetExpressionSensibility(this.handle, expressionSensibility);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getOverExposureSensibility() throws FaceException {
        int[] overExposureSensibilityArray = new int[1];
        int err = FaceAnalyser.nGetOverExposureSensibility(this.handle, overExposureSensibilityArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return overExposureSensibilityArray[0];
    }

    public void setOverExposureSensibility(int overExposureSensibility) throws FaceException {
        int err = FaceAnalyser.nSetOverExposureSensibility(this.handle, overExposureSensibility);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getThreadCount() throws FaceException {
        int[] threadCountArray = new int[1];
        int err = FaceAnalyser.nGetThreadCount(this.handle, threadCountArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return threadCountArray[0];
    }

    public void setThreadCount(int threadCount) throws FaceException {
        int err = FaceAnalyser.nSetThreadCount(this.handle, threadCount);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getUnderExposureSensibility() throws FaceException {
        int[] underExposureSensibilityArray = new int[1];
        int err = FaceAnalyser.nGetUnderExposureSensibility(this.handle, underExposureSensibilityArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return underExposureSensibilityArray[0];
    }

    public void setUnderExposureSensibility(int underExposureSensibility) throws FaceException {
        int err = FaceAnalyser.nSetUnderExposureSensibility(this.handle, underExposureSensibility);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public Image applyAlphaMask(Image image, Image mask) throws FaceException {
        Image segmentedFace = new Image();
        int err = FaceAnalyser.nApplyAlphaMask(this.handle, image.getHandle(), mask.getHandle(), segmentedFace.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return segmentedFace;
    }

    public Image applyMask(Image image, Image mask, int red, int green, int blue) throws FaceException {
        Image segmentedFace = new Image();
        int err = FaceAnalyser.nApplyMask(this.handle, image.getHandle(), mask.getHandle(), red, green, blue, segmentedFace.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return segmentedFace;
    }

    public boolean checkColorizedImage(Image image) throws FaceException {
        boolean[] isColorizedArray = new boolean[1];
        int err = FaceAnalyser.nCheckColorizedImage(this.handle, image.getHandle(), isColorizedArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return isColorizedArray[0];
    }

    public int computeAge(Image image, DetectedFace detectedFace) throws FaceException {
        int[] ageArray = new int[1];
        int err = FaceAnalyser.nComputeAge(this.handle, image.getHandle(), detectedFace.getHandle(), ageArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return ageArray[0];
    }

    public FaceAttributes computeAttributes(Image image, DetectedFace detectedFace) throws FaceException {
        FaceAttributes attributes = new FaceAttributes();
        int err = FaceAnalyser.nComputeAttributes(this.handle, image.getHandle(), detectedFace.getHandle(), attributes);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return attributes;
    }

    public BackgroundUniformity computeBackgroundUniformity(Image image, DetectedFace detectedFace) throws FaceException {
        BackgroundUniformity backgroundUniformity = new BackgroundUniformity();
        int err = FaceAnalyser.nComputeBackgroundUniformity(this.handle, image.getHandle(), detectedFace.getHandle(), backgroundUniformity);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return backgroundUniformity;
    }

    public FaceExpression computeExpression(Image image, DetectedFace detectedFace) throws FaceException {
        int[] expressionArray = new int[1];
        int err = FaceAnalyser.nComputeExpression(this.handle, image.getHandle(), detectedFace.getHandle(), expressionArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return FaceExpression.fromValue(expressionArray[0]);
    }

    public EyeGaze computeEyeGaze(Image image, DetectedFace detectedFace, PointList landmarks) throws FaceException {
        EyeGaze eyeGaze = new EyeGaze();
        int err = FaceAnalyser.nComputeEyeGaze(this.handle, image.getHandle(), detectedFace.getHandle(), landmarks.getHandle(), eyeGaze);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return eyeGaze;
    }

    public int[] computeEyeOpenness(Image image, DetectedFace detectedFace, PointList landmarks) throws FaceException {
        int[] eyeOpennessScores = new int[2];
        int[] eyeOpennessScoresSizeArray = new int[]{2};
        int err = FaceAnalyser.nComputeEyeOpenness(this.handle, image.getHandle(), detectedFace.getHandle(), landmarks.getHandle(), eyeOpennessScores, eyeOpennessScoresSizeArray);
        if (err == FaceError.SUCCESS.getValue()) {
            return Arrays.copyOf(eyeOpennessScores, eyeOpennessScoresSizeArray[0]);
        }
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            eyeOpennessScores = new int[eyeOpennessScoresSizeArray[0]];
            err = FaceAnalyser.nComputeEyeOpenness(this.handle, image.getHandle(), detectedFace.getHandle(), landmarks.getHandle(), eyeOpennessScores, eyeOpennessScoresSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return eyeOpennessScores;
    }

    public int[] computeEyeRedness(Image image, DetectedFace detectedFace, PointList landmarks) throws FaceException {
        int[] eyeRednessScores = new int[2];
        int[] eyeRednessScoresSizeArray = new int[]{2};
        int err = FaceAnalyser.nComputeEyeRedness(this.handle, image.getHandle(), detectedFace.getHandle(), landmarks.getHandle(), eyeRednessScores, eyeRednessScoresSizeArray);
        if (err == FaceError.SUCCESS.getValue()) {
            return Arrays.copyOf(eyeRednessScores, eyeRednessScoresSizeArray[0]);
        }
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            eyeRednessScores = new int[eyeRednessScoresSizeArray[0]];
            err = FaceAnalyser.nComputeEyeRedness(this.handle, image.getHandle(), detectedFace.getHandle(), landmarks.getHandle(), eyeRednessScores, eyeRednessScoresSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return eyeRednessScores;
    }

    public GeometricAttributes computeGeometricAttributes(Image image, DetectedFace detectedFace, PointList landmarks) throws FaceException {
        GeometricAttributes geometricAttributes = new GeometricAttributes();
        int err = FaceAnalyser.nComputeGeometricAttributes(this.handle, image.getHandle(), detectedFace.getHandle(), landmarks.getHandle(), geometricAttributes);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return geometricAttributes;
    }

    public GlassesAttributes computeGlassesAttributes(Image image, DetectedFace detectedFace, PointList landmarks) throws FaceException {
        GlassesAttributes glassesAttributes = new GlassesAttributes();
        int err = FaceAnalyser.nComputeGlassesAttributes(this.handle, image.getHandle(), detectedFace.getHandle(), landmarks.getHandle(), glassesAttributes);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return glassesAttributes;
    }

    public PointList computeLandmarks(Image image, DetectedFace detectedFace) throws FaceException {
        PointList landmarks = new PointList();
        int err = FaceAnalyser.nComputeLandmarks(this.handle, image.getHandle(), detectedFace.getHandle(), landmarks.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return landmarks;
    }

    public int computeNoise(Image image) throws FaceException {
        int[] noiseScoreArray = new int[1];
        int err = FaceAnalyser.nComputeNoise(this.handle, image.getHandle(), noiseScoreArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return noiseScoreArray[0];
    }

    public PhotographicAttributes computePhotographicAttributes(Image image, DetectedFace detectedFace, PointList landmarks) throws FaceException {
        PhotographicAttributes photographicAttributes = new PhotographicAttributes();
        int err = FaceAnalyser.nComputePhotographicAttributes(this.handle, image.getHandle(), detectedFace.getHandle(), landmarks.getHandle(), photographicAttributes);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return photographicAttributes;
    }

    public FacePose computePose(DetectedFace detectedFace) throws FaceException {
        FacePose pose = new FacePose();
        int err = FaceAnalyser.nComputePose(this.handle, detectedFace.getHandle(), pose);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return pose;
    }

    public FacePose computePoseWithLandmarks(DetectedFace detectedFace, PointList landmarks) throws FaceException {
        FacePose pose = new FacePose();
        int err = FaceAnalyser.nComputePoseWithLandmarks(this.handle, detectedFace.getHandle(), landmarks.getHandle(), pose);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return pose;
    }

    public int detectFaceMask(Image image, DetectedFace detectedFace) throws FaceException {
        int[] scoreArray = new int[1];
        int err = FaceAnalyser.nDetectFaceMask(this.handle, image.getHandle(), detectedFace.getHandle(), scoreArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return scoreArray[0];
    }

    public FaceOcclusionScores detectOcclusions(Image image, DetectedFace detectedFace) throws FaceException {
        FaceOcclusionScores scores = new FaceOcclusionScores();
        int err = FaceAnalyser.nDetectOcclusions(this.handle, image.getHandle(), detectedFace.getHandle(), scores);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return scores;
    }

    public Image removeCompressionArtifacts(Image image) throws FaceException {
        Image enhancedImage = new Image();
        int err = FaceAnalyser.nRemoveCompressionArtifacts(this.handle, image.getHandle(), enhancedImage.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return enhancedImage;
    }

    public Image segmentBackground(Image image) throws FaceException {
        Image segmentationMask = new Image();
        int err = FaceAnalyser.nSegmentBackground(this.handle, image.getHandle(), segmentationMask.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return segmentationMask;
    }

    public Image segmentFace(Image image) throws FaceException {
        Image segmentationMap = new Image();
        int err = FaceAnalyser.nSegmentFace(this.handle, image.getHandle(), segmentationMap.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return segmentationMap;
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetExpressionSensibility(long var0, int[] var2);

    static native int nSetExpressionSensibility(long var0, int var2);

    static native int nGetOverExposureSensibility(long var0, int[] var2);

    static native int nSetOverExposureSensibility(long var0, int var2);

    static native int nGetThreadCount(long var0, int[] var2);

    static native int nSetThreadCount(long var0, int var2);

    static native int nGetUnderExposureSensibility(long var0, int[] var2);

    static native int nSetUnderExposureSensibility(long var0, int var2);

    static native int nApplyAlphaMask(long var0, long var2, long var4, long var6);

    static native int nApplyMask(long var0, long var2, long var4, int var6, int var7, int var8, long var9);

    static native int nCheckColorizedImage(long var0, long var2, boolean[] var4);

    static native int nComputeAge(long var0, long var2, long var4, int[] var6);

    static native int nComputeAttributes(long var0, long var2, long var4, FaceAttributes var6);

    static native int nComputeBackgroundUniformity(long var0, long var2, long var4, BackgroundUniformity var6);

    static native int nComputeExpression(long var0, long var2, long var4, int[] var6);

    static native int nComputeEyeGaze(long var0, long var2, long var4, long var6, EyeGaze var8);

    static native int nComputeEyeOpenness(long var0, long var2, long var4, long var6, int[] var8, int[] var9);

    static native int nComputeEyeRedness(long var0, long var2, long var4, long var6, int[] var8, int[] var9);

    static native int nComputeGeometricAttributes(long var0, long var2, long var4, long var6, GeometricAttributes var8);

    static native int nComputeGlassesAttributes(long var0, long var2, long var4, long var6, GlassesAttributes var8);

    static native int nComputeLandmarks(long var0, long var2, long var4, long var6);

    static native int nComputeNoise(long var0, long var2, int[] var4);

    static native int nComputePhotographicAttributes(long var0, long var2, long var4, long var6, PhotographicAttributes var8);

    static native int nComputePose(long var0, long var2, FacePose var4);

    static native int nComputePoseWithLandmarks(long var0, long var2, long var4, FacePose var6);

    static native int nDetectFaceMask(long var0, long var2, long var4, int[] var6);

    static native int nDetectOcclusions(long var0, long var2, long var4, FaceOcclusionScores var6);

    static native int nRemoveCompressionArtifacts(long var0, long var2, long var4);

    static native int nSegmentBackground(long var0, long var2, long var4);

    static native int nSegmentFace(long var0, long var2, long var4);

    static {
        FaceNative.loadLibraries();
    }
}

