/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import java.io.Serializable;
import java.nio.charset.Charset;

public class FaceCandidate
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public FaceCandidate() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = FaceCandidate.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public FaceCandidate(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            FaceCandidate.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public FaceCandidate clone() throws FaceException {
        FaceCandidate clone = new FaceCandidate();
        int err = FaceCandidate.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public String getId() throws FaceException {
        byte[] id = null;
        int[] idSizeArray = new int[]{-1};
        int err = FaceCandidate.nGetId(this.handle, id, idSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            id = new byte[idSizeArray[0]];
            err = FaceCandidate.nGetId(this.handle, id, idSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return new String(id, 0, idSizeArray[0], Charset.defaultCharset());
    }

    public int getScore() throws FaceException {
        int[] scoreArray = new int[1];
        int err = FaceCandidate.nGetScore(this.handle, scoreArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return scoreArray[0];
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetId(long var0, byte[] var2, int[] var3);

    static native int nGetScore(long var0, int[] var2);

    static {
        FaceNative.loadLibraries();
    }
}

