/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceCandidate;
import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FaceCandidateList
implements AutoCloseable,
Serializable,
Iterable<FaceCandidate> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public FaceCandidateList() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = FaceCandidateList.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public FaceCandidateList(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            FaceCandidateList.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public FaceCandidateList clone() throws FaceException {
        FaceCandidateList clone = new FaceCandidateList();
        int err = FaceCandidateList.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public void clear() throws FaceException {
        int err = FaceCandidateList.nClear(this.handle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void add(FaceCandidate faceCandidateItem) throws FaceException {
        int err = FaceCandidateList.nAdd(this.handle, faceCandidateItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public FaceCandidate get(int index) throws FaceException {
        FaceCandidate faceCandidateItem = new FaceCandidate();
        int err = FaceCandidateList.nGet(this.handle, index, faceCandidateItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceCandidateItem;
    }

    public void set(int index, FaceCandidate faceCandidateItem) throws FaceException {
        int err = FaceCandidateList.nSet(this.handle, index, faceCandidateItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getCount() throws FaceException {
        int[] countArray = new int[1];
        int err = FaceCandidateList.nGetCount(this.handle, countArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return countArray[0];
    }

    public void removeAt(int index) throws FaceException {
        int err = FaceCandidateList.nRemoveAt(this.handle, index);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void resize(int newSize) throws FaceException {
        int err = FaceCandidateList.nResize(this.handle, newSize);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nClear(long var0);

    static native int nAdd(long var0, long var2);

    static native int nGet(long var0, int var2, long var3);

    static native int nSet(long var0, int var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nRemoveAt(long var0, int var2);

    static native int nResize(long var0, int var2);

    @Override
    public Iterator<FaceCandidate> iterator() {
        return new Iterator<FaceCandidate>(){
            private int index = 0;
            private final int size = FaceCandidateList.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public FaceCandidate next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return FaceCandidateList.this.get(this.index++);
            }
        };
    }

    static {
        FaceNative.loadLibraries();
    }
}

