/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.DetectedFaceList;
import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceModel;
import eu.id3.face.FaceNative;
import eu.id3.face.Image;
import eu.id3.face.ProcessingUnit;
import java.io.Serializable;

public class FaceDetector
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public FaceDetector() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = FaceDetector.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public FaceDetector(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            FaceDetector.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public int getConfidenceThreshold() throws FaceException {
        int[] confidenceThresholdArray = new int[1];
        int err = FaceDetector.nGetConfidenceThreshold(this.handle, confidenceThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return confidenceThresholdArray[0];
    }

    public void setConfidenceThreshold(int confidenceThreshold) throws FaceException {
        int err = FaceDetector.nSetConfidenceThreshold(this.handle, confidenceThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public FaceModel getModel() throws FaceException {
        int[] modelArray = new int[1];
        int err = FaceDetector.nGetModel(this.handle, modelArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return FaceModel.fromValue(modelArray[0]);
    }

    public void setModel(FaceModel model) throws FaceException {
        int err = FaceDetector.nSetModel(this.handle, model.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getNmsIouThreshold() throws FaceException {
        int[] nmsIouThresholdArray = new int[1];
        int err = FaceDetector.nGetNmsIouThreshold(this.handle, nmsIouThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return nmsIouThresholdArray[0];
    }

    public void setNmsIouThreshold(int nmsIouThreshold) throws FaceException {
        int err = FaceDetector.nSetNmsIouThreshold(this.handle, nmsIouThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public ProcessingUnit getProcessingUnit() throws FaceException {
        int[] processingUnitArray = new int[1];
        int err = FaceDetector.nGetProcessingUnit(this.handle, processingUnitArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return ProcessingUnit.fromValue(processingUnitArray[0]);
    }

    public void setProcessingUnit(ProcessingUnit processingUnit) throws FaceException {
        int err = FaceDetector.nSetProcessingUnit(this.handle, processingUnit.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getThreadCount() throws FaceException {
        int[] threadCountArray = new int[1];
        int err = FaceDetector.nGetThreadCount(this.handle, threadCountArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return threadCountArray[0];
    }

    public void setThreadCount(int threadCount) throws FaceException {
        int err = FaceDetector.nSetThreadCount(this.handle, threadCount);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public DetectedFaceList detectFaces(Image image) throws FaceException {
        DetectedFaceList detectedFaceList = new DetectedFaceList();
        int err = FaceDetector.nDetectFaces(this.handle, image.getHandle(), detectedFaceList.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return detectedFaceList;
    }

    public void trackFaces(Image image, DetectedFaceList detectedFaceList) throws FaceException {
        int err = FaceDetector.nTrackFaces(this.handle, image.getHandle(), detectedFaceList.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void warmUp(int imageWidth, int imageHeight) throws FaceException {
        int err = FaceDetector.nWarmUp(this.handle, imageWidth, imageHeight);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetConfidenceThreshold(long var0, int[] var2);

    static native int nSetConfidenceThreshold(long var0, int var2);

    static native int nGetModel(long var0, int[] var2);

    static native int nSetModel(long var0, int var2);

    static native int nGetNmsIouThreshold(long var0, int[] var2);

    static native int nSetNmsIouThreshold(long var0, int var2);

    static native int nGetProcessingUnit(long var0, int[] var2);

    static native int nSetProcessingUnit(long var0, int var2);

    static native int nGetThreadCount(long var0, int[] var2);

    static native int nSetThreadCount(long var0, int var2);

    static native int nDetectFaces(long var0, long var2, long var4);

    static native int nTrackFaces(long var0, long var2, long var4);

    static native int nWarmUp(long var0, int var2, int var3);

    static {
        FaceNative.loadLibraries();
    }
}

