/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.DetectedFace;
import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceModel;
import eu.id3.face.FaceNative;
import eu.id3.face.FaceTemplate;
import eu.id3.face.Image;
import eu.id3.face.ProcessingUnit;
import java.io.Serializable;

public class FaceEncoder
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public FaceEncoder() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = FaceEncoder.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public FaceEncoder(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            FaceEncoder.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public int getMinimalIod() throws FaceException {
        int[] minimalIodArray = new int[1];
        int err = FaceEncoder.nGetMinimalIod(this.handle, minimalIodArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return minimalIodArray[0];
    }

    public void setMinimalIod(int minimalIod) throws FaceException {
        int err = FaceEncoder.nSetMinimalIod(this.handle, minimalIod);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public FaceModel getModel() throws FaceException {
        int[] modelArray = new int[1];
        int err = FaceEncoder.nGetModel(this.handle, modelArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return FaceModel.fromValue(modelArray[0]);
    }

    public void setModel(FaceModel model) throws FaceException {
        int err = FaceEncoder.nSetModel(this.handle, model.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public ProcessingUnit getProcessingUnit() throws FaceException {
        int[] processingUnitArray = new int[1];
        int err = FaceEncoder.nGetProcessingUnit(this.handle, processingUnitArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return ProcessingUnit.fromValue(processingUnitArray[0]);
    }

    public void setProcessingUnit(ProcessingUnit processingUnit) throws FaceException {
        int err = FaceEncoder.nSetProcessingUnit(this.handle, processingUnit.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getThreadCount() throws FaceException {
        int[] threadCountArray = new int[1];
        int err = FaceEncoder.nGetThreadCount(this.handle, threadCountArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return threadCountArray[0];
    }

    public void setThreadCount(int threadCount) throws FaceException {
        int err = FaceEncoder.nSetThreadCount(this.handle, threadCount);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int computeQuality(Image image, DetectedFace detectedFace) throws FaceException {
        int[] qualityArray = new int[1];
        int err = FaceEncoder.nComputeQuality(this.handle, image.getHandle(), detectedFace.getHandle(), qualityArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return qualityArray[0];
    }

    public FaceTemplate createTemplate(Image image, DetectedFace detectedFace) throws FaceException {
        FaceTemplate faceTemplate = new FaceTemplate();
        int err = FaceEncoder.nCreateTemplate(this.handle, image.getHandle(), detectedFace.getHandle(), faceTemplate.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceTemplate;
    }

    public void warmUp() throws FaceException {
        int err = FaceEncoder.nWarmUp(this.handle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetMinimalIod(long var0, int[] var2);

    static native int nSetMinimalIod(long var0, int var2);

    static native int nGetModel(long var0, int[] var2);

    static native int nSetModel(long var0, int var2);

    static native int nGetProcessingUnit(long var0, int[] var2);

    static native int nSetProcessingUnit(long var0, int var2);

    static native int nGetThreadCount(long var0, int[] var2);

    static native int nSetThreadCount(long var0, int var2);

    static native int nComputeQuality(long var0, long var2, long var4, int[] var6);

    static native int nCreateTemplate(long var0, long var2, long var4, long var6);

    static native int nWarmUp(long var0);

    static {
        FaceNative.loadLibraries();
    }
}

