/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceCandidateList;
import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import eu.id3.face.FaceTemplate;
import eu.id3.face.FaceTemplateFormat;
import java.io.Serializable;

public class FaceIndexer
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public FaceIndexer() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = FaceIndexer.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public FaceIndexer(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            FaceIndexer.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public FaceTemplateFormat getFormat() throws FaceException {
        int[] formatArray = new int[1];
        int err = FaceIndexer.nGetFormat(this.handle, formatArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return FaceTemplateFormat.fromValue(formatArray[0]);
    }

    public int getMaximumTemplateCount() throws FaceException {
        int[] maximumTemplateCountArray = new int[1];
        int err = FaceIndexer.nGetMaximumTemplateCount(this.handle, maximumTemplateCountArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return maximumTemplateCountArray[0];
    }

    public int getTemplateCount() throws FaceException {
        int[] templateCountArray = new int[1];
        int err = FaceIndexer.nGetTemplateCount(this.handle, templateCountArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return templateCountArray[0];
    }

    public void addTemplate(FaceTemplate faceTemplate, String id) throws FaceException {
        int err = FaceIndexer.nAddTemplate(this.handle, faceTemplate.getHandle(), id);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static FaceIndexer create(int maximumTemplateCount, FaceTemplateFormat format) throws FaceException {
        FaceIndexer faceIndexer = new FaceIndexer();
        int err = FaceIndexer.nCreate(faceIndexer.getHandle(), maximumTemplateCount, format.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceIndexer;
    }

    public void deleteTemplate(String id) throws FaceException {
        int err = FaceIndexer.nDeleteTemplate(this.handle, id);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static FaceIndexer fromFile(String path) throws FaceException {
        FaceIndexer faceIndexer = new FaceIndexer();
        int err = FaceIndexer.nFromFile(faceIndexer.getHandle(), path);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceIndexer;
    }

    public FaceTemplate getTemplate(String id) throws FaceException {
        FaceTemplate faceTemplate = new FaceTemplate();
        int err = FaceIndexer.nGetTemplate(this.handle, id, faceTemplate.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceTemplate;
    }

    public void resize(int maximumCount) throws FaceException {
        int err = FaceIndexer.nResize(this.handle, maximumCount);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public FaceCandidateList searchTemplate(FaceTemplate probe, int maxCandidates) throws FaceException {
        FaceCandidateList candidates = new FaceCandidateList();
        int err = FaceIndexer.nSearchTemplate(this.handle, probe.getHandle(), maxCandidates, candidates.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return candidates;
    }

    public void toFile(String path) throws FaceException {
        int err = FaceIndexer.nToFile(this.handle, path);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetFormat(long var0, int[] var2);

    static native int nGetMaximumTemplateCount(long var0, int[] var2);

    static native int nGetTemplateCount(long var0, int[] var2);

    static native int nAddTemplate(long var0, long var2, String var4);

    static native int nCreate(long var0, int var2, int var3);

    static native int nDeleteTemplate(long var0, String var2);

    static native int nFromFile(long var0, String var2);

    static native int nGetTemplate(long var0, String var2, long var3);

    static native int nResize(long var0, int var2);

    static native int nSearchTemplate(long var0, long var2, int var4, long var5);

    static native int nToFile(long var0, String var2);

    static {
        FaceNative.loadLibraries();
    }
}

