/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceModel;
import eu.id3.face.FaceNative;
import eu.id3.face.LibVersion;
import eu.id3.face.ProcessingUnit;
import java.nio.charset.Charset;

public class FaceLibrary {
    public static String getModelFileName(FaceModel model) throws FaceException {
        byte[] fileName = null;
        int[] fileNameSizeArray = new int[]{-1};
        int err = FaceLibrary.nGetModelFileName(model.getValue(), fileName, fileNameSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            fileName = new byte[fileNameSizeArray[0]];
            err = FaceLibrary.nGetModelFileName(model.getValue(), fileName, fileNameSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return new String(fileName, 0, fileNameSizeArray[0], Charset.defaultCharset());
    }

    public static String getVersion() throws FaceException {
        byte[] libraryVersion = new byte[8];
        int[] libraryVersionSizeArray = new int[]{8};
        int err = FaceLibrary.nGetVersion(libraryVersion, libraryVersionSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            libraryVersion = new byte[libraryVersionSizeArray[0]];
            err = FaceLibrary.nGetVersion(libraryVersion, libraryVersionSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return new String(libraryVersion, 0, libraryVersionSizeArray[0], Charset.defaultCharset());
    }

    public static LibVersion getVersionEx() throws FaceException {
        LibVersion version = new LibVersion();
        int err = FaceLibrary.nGetVersionEx(version);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return version;
    }

    public static void loadModel(String modelPath, FaceModel faceModel, ProcessingUnit processingUnit) throws FaceException {
        int err = FaceLibrary.nLoadModel(modelPath, faceModel.getValue(), processingUnit.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static void loadModelBuffer(byte[] modelBuffer, FaceModel faceModel, ProcessingUnit processingUnit) throws FaceException {
        int err = FaceLibrary.nLoadModelBuffer(modelBuffer, faceModel.getValue(), processingUnit.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static void unloadModel(FaceModel faceModel, ProcessingUnit processingUnit) throws FaceException {
        int err = FaceLibrary.nUnloadModel(faceModel.getValue(), processingUnit.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nGetModelFileName(int var0, byte[] var1, int[] var2);

    static native int nGetVersion(byte[] var0, int[] var1);

    static native int nGetVersionEx(LibVersion var0);

    static native int nLoadModel(String var0, int var1, int var2);

    static native int nLoadModelBuffer(byte[] var0, int var1, int var2);

    static native int nUnloadModel(int var0, int var1);

    static {
        FaceNative.loadLibraries();
    }
}

