/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import eu.id3.face.LicenseHardwareCodeType;
import eu.id3.face.LicenseType;
import java.nio.charset.Charset;
import java.util.Arrays;

public class FaceLicense {
    public static void activate(String hardwareCode, String login, String password, String productReference, String commentary, String path) throws FaceException {
        int err = FaceLicense.nActivate(hardwareCode, login, password, productReference, commentary, path);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static void activateActivationKey(String hardwareCode, String activationKey, String commentary, String path) throws FaceException {
        int err = FaceLicense.nActivateActivationKey(hardwareCode, activationKey, commentary, path);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static byte[] activateActivationKeyBuffer(String hardwareCode, String activationKey, String commentary) throws FaceException {
        byte[] licenseFileBuffer = new byte[2048];
        int[] licenseFileBufferSizeArray = new int[]{2048};
        int err = FaceLicense.nActivateActivationKeyBuffer(hardwareCode, activationKey, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        if (err == FaceError.SUCCESS.getValue()) {
            return Arrays.copyOf(licenseFileBuffer, licenseFileBufferSizeArray[0]);
        }
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileBuffer = new byte[licenseFileBufferSizeArray[0]];
            err = FaceLicense.nActivateActivationKeyBuffer(hardwareCode, activationKey, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return licenseFileBuffer;
    }

    public static byte[] activateBuffer(String hardwareCode, String login, String password, String productReference, String commentary) throws FaceException {
        byte[] licenseFileBuffer = new byte[2048];
        int[] licenseFileBufferSizeArray = new int[]{2048};
        int err = FaceLicense.nActivateBuffer(hardwareCode, login, password, productReference, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        if (err == FaceError.SUCCESS.getValue()) {
            return Arrays.copyOf(licenseFileBuffer, licenseFileBufferSizeArray[0]);
        }
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileBuffer = new byte[licenseFileBufferSizeArray[0]];
            err = FaceLicense.nActivateBuffer(hardwareCode, login, password, productReference, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return licenseFileBuffer;
    }

    public static void activateSerialKey(String hardwareCode, String serialKey, String commentary, String path) throws FaceException {
        int err = FaceLicense.nActivateSerialKey(hardwareCode, serialKey, commentary, path);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static byte[] activateSerialKeyBuffer(String hardwareCode, String serialKey, String commentary) throws FaceException {
        byte[] licenseFileBuffer = new byte[2048];
        int[] licenseFileBufferSizeArray = new int[]{2048};
        int err = FaceLicense.nActivateSerialKeyBuffer(hardwareCode, serialKey, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        if (err == FaceError.SUCCESS.getValue()) {
            return Arrays.copyOf(licenseFileBuffer, licenseFileBufferSizeArray[0]);
        }
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileBuffer = new byte[licenseFileBufferSizeArray[0]];
            err = FaceLicense.nActivateSerialKeyBuffer(hardwareCode, serialKey, commentary, licenseFileBuffer, licenseFileBufferSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return licenseFileBuffer;
    }

    public static void checkLicense(String licensePath) throws FaceException {
        int err = FaceLicense.nCheckLicense(licensePath);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static void checkLicenseBuffer(byte[] licenseData) throws FaceException {
        int err = FaceLicense.nCheckLicenseBuffer(licenseData);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static byte[] checkLicenseBufferWithCard(byte[] licenseData) throws FaceException {
        byte[] challengeR1 = new byte[16];
        int[] challengeR1SizeArray = new int[]{16};
        int err = FaceLicense.nCheckLicenseBufferWithCard(licenseData, challengeR1, challengeR1SizeArray);
        if (err == FaceError.SUCCESS.getValue()) {
            return Arrays.copyOf(challengeR1, challengeR1SizeArray[0]);
        }
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            challengeR1 = new byte[challengeR1SizeArray[0]];
            err = FaceLicense.nCheckLicenseBufferWithCard(licenseData, challengeR1, challengeR1SizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return challengeR1;
    }

    public static byte[] checkLicenseWithCard(String licensePath) throws FaceException {
        byte[] challengeR1 = new byte[16];
        int[] challengeR1SizeArray = new int[]{16};
        int err = FaceLicense.nCheckLicenseWithCard(licensePath, challengeR1, challengeR1SizeArray);
        if (err == FaceError.SUCCESS.getValue()) {
            return Arrays.copyOf(challengeR1, challengeR1SizeArray[0]);
        }
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            challengeR1 = new byte[challengeR1SizeArray[0]];
            err = FaceLicense.nCheckLicenseWithCard(licensePath, challengeR1, challengeR1SizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return challengeR1;
    }

    public static void checkModule(String moduleName) throws FaceException {
        int err = FaceLicense.nCheckModule(moduleName);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static void finalizeCheckLicenseWithCard(byte[] cryptogram) throws FaceException {
        int err = FaceLicense.nFinalizeCheckLicenseWithCard(cryptogram);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static String getExpiryDate() throws FaceException {
        byte[] expiryDate = new byte[256];
        int[] expiryDateSizeArray = new int[]{256};
        int err = FaceLicense.nGetExpiryDate(expiryDate, expiryDateSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            expiryDate = new byte[expiryDateSizeArray[0]];
            err = FaceLicense.nGetExpiryDate(expiryDate, expiryDateSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return new String(expiryDate, 0, expiryDateSizeArray[0], Charset.defaultCharset());
    }

    public static String getExternalDriveHardwareCode(LicenseHardwareCodeType hardwareCodeType, String externalDrivePath) throws FaceException {
        byte[] code = new byte[256];
        int[] codeSizeArray = new int[]{256};
        int err = FaceLicense.nGetExternalDriveHardwareCode(hardwareCodeType.getValue(), code, codeSizeArray, externalDrivePath);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            code = new byte[codeSizeArray[0]];
            err = FaceLicense.nGetExternalDriveHardwareCode(hardwareCodeType.getValue(), code, codeSizeArray, externalDrivePath);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return new String(code, 0, codeSizeArray[0], Charset.defaultCharset());
    }

    public static String getHostHardwareCode(LicenseHardwareCodeType hardwareCodeType) throws FaceException {
        byte[] code = new byte[256];
        int[] codeSizeArray = new int[]{256};
        int err = FaceLicense.nGetHostHardwareCode(hardwareCodeType.getValue(), code, codeSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            code = new byte[codeSizeArray[0]];
            err = FaceLicense.nGetHostHardwareCode(hardwareCodeType.getValue(), code, codeSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return new String(code, 0, codeSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicenseFileHardwareCode() throws FaceException {
        byte[] licenseFileHardwareCode = new byte[256];
        int[] licenseFileHardwareCodeSizeArray = new int[]{256};
        int err = FaceLicense.nGetLicenseFileHardwareCode(licenseFileHardwareCode, licenseFileHardwareCodeSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileHardwareCode = new byte[licenseFileHardwareCodeSizeArray[0]];
            err = FaceLicense.nGetLicenseFileHardwareCode(licenseFileHardwareCode, licenseFileHardwareCodeSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return new String(licenseFileHardwareCode, 0, licenseFileHardwareCodeSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicenseFileSerial() throws FaceException {
        byte[] licenseFileSerial = new byte[256];
        int[] licenseFileSerialSizeArray = new int[]{256};
        int err = FaceLicense.nGetLicenseFileSerial(licenseFileSerial, licenseFileSerialSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileSerial = new byte[licenseFileSerialSizeArray[0]];
            err = FaceLicense.nGetLicenseFileSerial(licenseFileSerial, licenseFileSerialSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return new String(licenseFileSerial, 0, licenseFileSerialSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicenseName() throws FaceException {
        byte[] licenseName = new byte[256];
        int[] licenseNameSizeArray = new int[]{256};
        int err = FaceLicense.nGetLicenseName(licenseName, licenseNameSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            licenseName = new byte[licenseNameSizeArray[0]];
            err = FaceLicense.nGetLicenseName(licenseName, licenseNameSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return new String(licenseName, 0, licenseNameSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicenseOwner() throws FaceException {
        byte[] licenseOwner = new byte[256];
        int[] licenseOwnerSizeArray = new int[]{256};
        int err = FaceLicense.nGetLicenseOwner(licenseOwner, licenseOwnerSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            licenseOwner = new byte[licenseOwnerSizeArray[0]];
            err = FaceLicense.nGetLicenseOwner(licenseOwner, licenseOwnerSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return new String(licenseOwner, 0, licenseOwnerSizeArray[0], Charset.defaultCharset());
    }

    public static String getLicensePath() throws FaceException {
        byte[] licensePath = new byte[256];
        int[] licensePathSizeArray = new int[]{256};
        int err = FaceLicense.nGetLicensePath(licensePath, licensePathSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            licensePath = new byte[licensePathSizeArray[0]];
            err = FaceLicense.nGetLicensePath(licensePath, licensePathSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return new String(licensePath, 0, licensePathSizeArray[0], Charset.defaultCharset());
    }

    public static LicenseType getLicenseType() throws FaceException {
        int[] faceLicenseTypeArray = new int[1];
        int err = FaceLicense.nGetLicenseType(faceLicenseTypeArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return LicenseType.fromValue(faceLicenseTypeArray[0]);
    }

    public static int getModuleCount() throws FaceException {
        int[] countArray = new int[1];
        int err = FaceLicense.nGetModuleCount(countArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return countArray[0];
    }

    public static String getModuleName(int index) throws FaceException {
        byte[] name = new byte[256];
        int[] nameSizeArray = new int[]{256};
        int err = FaceLicense.nGetModuleName(index, name, nameSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            name = new byte[nameSizeArray[0]];
            err = FaceLicense.nGetModuleName(index, name, nameSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return new String(name, 0, nameSizeArray[0], Charset.defaultCharset());
    }

    public static int getModuleValue(String name) throws FaceException {
        int[] valueArray = new int[1];
        int err = FaceLicense.nGetModuleValue(name, valueArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return valueArray[0];
    }

    public static String getProductReference() throws FaceException {
        byte[] productReference = new byte[256];
        int[] productReferenceSizeArray = new int[]{256};
        int err = FaceLicense.nGetProductReference(productReference, productReferenceSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            productReference = new byte[productReferenceSizeArray[0]];
            err = FaceLicense.nGetProductReference(productReference, productReferenceSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return new String(productReference, 0, productReferenceSizeArray[0], Charset.defaultCharset());
    }

    public static int getRemainingDays() throws FaceException {
        int[] remainingDaysArray = new int[1];
        int err = FaceLicense.nGetRemainingDays(remainingDaysArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return remainingDaysArray[0];
    }

    public static void reactivate(String hardwareCode, String productReference, String path) throws FaceException {
        int err = FaceLicense.nReactivate(hardwareCode, productReference, path);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static byte[] reactivateBuffer(String hardwareCode, String productReference) throws FaceException {
        byte[] licenseFileBuffer = new byte[2048];
        int[] licenseFileBufferSizeArray = new int[]{2048};
        int err = FaceLicense.nReactivateBuffer(hardwareCode, productReference, licenseFileBuffer, licenseFileBufferSizeArray);
        if (err == FaceError.SUCCESS.getValue()) {
            return Arrays.copyOf(licenseFileBuffer, licenseFileBufferSizeArray[0]);
        }
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            licenseFileBuffer = new byte[licenseFileBufferSizeArray[0]];
            err = FaceLicense.nReactivateBuffer(hardwareCode, productReference, licenseFileBuffer, licenseFileBufferSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return licenseFileBuffer;
    }

    static native int nActivate(String var0, String var1, String var2, String var3, String var4, String var5);

    static native int nActivateActivationKey(String var0, String var1, String var2, String var3);

    static native int nActivateActivationKeyBuffer(String var0, String var1, String var2, byte[] var3, int[] var4);

    static native int nActivateBuffer(String var0, String var1, String var2, String var3, String var4, byte[] var5, int[] var6);

    static native int nActivateSerialKey(String var0, String var1, String var2, String var3);

    static native int nActivateSerialKeyBuffer(String var0, String var1, String var2, byte[] var3, int[] var4);

    static native int nCheckLicense(String var0);

    static native int nCheckLicenseBuffer(byte[] var0);

    static native int nCheckLicenseBufferWithCard(byte[] var0, byte[] var1, int[] var2);

    static native int nCheckLicenseWithCard(String var0, byte[] var1, int[] var2);

    static native int nCheckModule(String var0);

    static native int nFinalizeCheckLicenseWithCard(byte[] var0);

    static native int nGetExpiryDate(byte[] var0, int[] var1);

    static native int nGetExternalDriveHardwareCode(int var0, byte[] var1, int[] var2, String var3);

    static native int nGetHostHardwareCode(int var0, byte[] var1, int[] var2);

    static native int nGetLicenseFileHardwareCode(byte[] var0, int[] var1);

    static native int nGetLicenseFileSerial(byte[] var0, int[] var1);

    static native int nGetLicenseName(byte[] var0, int[] var1);

    static native int nGetLicenseOwner(byte[] var0, int[] var1);

    static native int nGetLicensePath(byte[] var0, int[] var1);

    static native int nGetLicenseType(int[] var0);

    static native int nGetModuleCount(int[] var0);

    static native int nGetModuleName(int var0, byte[] var1, int[] var2);

    static native int nGetModuleValue(String var0, int[] var1);

    static native int nGetProductReference(byte[] var0, int[] var1);

    static native int nGetRemainingDays(int[] var0);

    static native int nReactivate(String var0, String var1, String var2);

    static native int nReactivateBuffer(String var0, String var1, byte[] var2, int[] var3);

    static {
        FaceNative.loadLibraries();
    }
}

