/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceCandidateList;
import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import eu.id3.face.FaceTemplate;
import eu.id3.face.FaceTemplateDict;
import eu.id3.face.FaceTemplateList;
import eu.id3.face.PoolingMethod;
import java.io.Serializable;

public class FaceMatcher
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public FaceMatcher() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = FaceMatcher.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public FaceMatcher(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            FaceMatcher.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public int compareTemplateLists(FaceTemplateList referenceList, FaceTemplateList probeList, PoolingMethod poolingMethod) throws FaceException {
        int[] scoreArray = new int[1];
        int err = FaceMatcher.nCompareTemplateLists(this.handle, referenceList.getHandle(), probeList.getHandle(), poolingMethod.getValue(), scoreArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return scoreArray[0];
    }

    public int compareTemplates(FaceTemplate reference, FaceTemplate probe) throws FaceException {
        int[] scoreArray = new int[1];
        int err = FaceMatcher.nCompareTemplates(this.handle, reference.getHandle(), probe.getHandle(), scoreArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return scoreArray[0];
    }

    public void searchTemplate(FaceTemplateDict referenceDict, FaceTemplate probe, int maxCandidates, FaceCandidateList candidateList) throws FaceException {
        int err = FaceMatcher.nSearchTemplate(this.handle, referenceDict.getHandle(), probe.getHandle(), maxCandidates, candidateList.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCompareTemplateLists(long var0, long var2, long var4, int var6, int[] var7);

    static native int nCompareTemplates(long var0, long var2, long var4, int[] var6);

    static native int nSearchTemplate(long var0, long var2, long var4, int var6, long var7);

    static {
        FaceNative.loadLibraries();
    }
}

