/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.ColorBasedPadResult;
import eu.id3.face.DetectedFace;
import eu.id3.face.DetectedFaceAttackSupport;
import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import eu.id3.face.Image;
import java.io.Serializable;

public class FacePad
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public FacePad() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = FacePad.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public FacePad(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            FacePad.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public int getAttackSupportDetectorConfidenceThreshold() throws FaceException {
        int[] attackSupportDetectorConfidenceThresholdArray = new int[1];
        int err = FacePad.nGetAttackSupportDetectorConfidenceThreshold(this.handle, attackSupportDetectorConfidenceThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return attackSupportDetectorConfidenceThresholdArray[0];
    }

    public void setAttackSupportDetectorConfidenceThreshold(int attackSupportDetectorConfidenceThreshold) throws FaceException {
        int err = FacePad.nSetAttackSupportDetectorConfidenceThreshold(this.handle, attackSupportDetectorConfidenceThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int computeBlurrinessScore(Image image, DetectedFace detectedFace) throws FaceException {
        int[] scoreArray = new int[1];
        int err = FacePad.nComputeBlurrinessScore(this.handle, image.getHandle(), detectedFace.getHandle(), scoreArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return scoreArray[0];
    }

    public ColorBasedPadResult computeColorBasedScore(Image image, DetectedFace detectedFace) throws FaceException {
        ColorBasedPadResult colorBasedPadResult = new ColorBasedPadResult();
        int err = FacePad.nComputeColorBasedScore(this.handle, image.getHandle(), detectedFace.getHandle(), colorBasedPadResult);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return colorBasedPadResult;
    }

    public int computeDepthBasedScore(Image image, DetectedFace detectedFace) throws FaceException {
        int[] scoreArray = new int[1];
        int err = FacePad.nComputeDepthBasedScore(this.handle, image.getHandle(), detectedFace.getHandle(), scoreArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return scoreArray[0];
    }

    public DetectedFaceAttackSupport detectAttackSupport(Image image, DetectedFace detectedFace) throws FaceException {
        DetectedFaceAttackSupport detectedFaceAttackSupport = new DetectedFaceAttackSupport();
        int err = FacePad.nDetectAttackSupport(this.handle, image.getHandle(), detectedFace.getHandle(), detectedFaceAttackSupport);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return detectedFaceAttackSupport;
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetAttackSupportDetectorConfidenceThreshold(long var0, int[] var2);

    static native int nSetAttackSupportDetectorConfidenceThreshold(long var0, int var2);

    static native int nComputeBlurrinessScore(long var0, long var2, long var4, int[] var6);

    static native int nComputeColorBasedScore(long var0, long var2, long var4, ColorBasedPadResult var6);

    static native int nComputeDepthBasedScore(long var0, long var2, long var4, int[] var6);

    static native int nDetectAttackSupport(long var0, long var2, long var4, DetectedFaceAttackSupport var6);

    static {
        FaceNative.loadLibraries();
    }
}

