/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import eu.id3.face.FaceTemplateFormat;
import java.io.Serializable;

public class FaceTemplate
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public FaceTemplate() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = FaceTemplate.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public FaceTemplate(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            FaceTemplate.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public FaceTemplate clone() throws FaceException {
        FaceTemplate clone = new FaceTemplate();
        int err = FaceTemplate.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public FaceTemplateFormat getFormat() throws FaceException {
        int[] formatArray = new int[1];
        int err = FaceTemplate.nGetFormat(this.handle, formatArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return FaceTemplateFormat.fromValue(formatArray[0]);
    }

    public int getQuality() throws FaceException {
        int[] qualityArray = new int[1];
        int err = FaceTemplate.nGetQuality(this.handle, qualityArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return qualityArray[0];
    }

    public static FaceTemplate fromBuffer(byte[] data) throws FaceException {
        FaceTemplate faceTemplate = new FaceTemplate();
        int err = FaceTemplate.nFromBuffer(faceTemplate.getHandle(), data);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceTemplate;
    }

    public static FaceTemplate fromFile(String path) throws FaceException {
        FaceTemplate faceTemplate = new FaceTemplate();
        int err = FaceTemplate.nFromFile(faceTemplate.getHandle(), path);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceTemplate;
    }

    public byte[] toBdt() throws FaceException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = FaceTemplate.nToBdt(this.handle, data, dataSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = FaceTemplate.nToBdt(this.handle, data, dataSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return data;
    }

    public byte[] toBit(int threshold, int referenceDataQualifier) throws FaceException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = FaceTemplate.nToBit(this.handle, threshold, referenceDataQualifier, data, dataSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = FaceTemplate.nToBit(this.handle, threshold, referenceDataQualifier, data, dataSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return data;
    }

    public byte[] toBuffer() throws FaceException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = FaceTemplate.nToBuffer(this.handle, data, dataSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = FaceTemplate.nToBuffer(this.handle, data, dataSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return data;
    }

    public void toFile(String path) throws FaceException {
        int err = FaceTemplate.nToFile(this.handle, path);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void update(FaceTemplate newFaceTemplate) throws FaceException {
        int err = FaceTemplate.nUpdate(this.handle, newFaceTemplate.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetFormat(long var0, int[] var2);

    static native int nGetQuality(long var0, int[] var2);

    static native int nFromBuffer(long var0, byte[] var2);

    static native int nFromFile(long var0, String var2);

    static native int nToBdt(long var0, byte[] var2, int[] var3);

    static native int nToBit(long var0, int var2, int var3, byte[] var4, int[] var5);

    static native int nToBuffer(long var0, byte[] var2, int[] var3);

    static native int nToFile(long var0, String var2);

    static native int nUpdate(long var0, long var2);

    static {
        FaceNative.loadLibraries();
    }
}

