/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import eu.id3.face.FaceTemplate;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class FaceTemplateList
implements AutoCloseable,
Serializable,
Iterable<FaceTemplate> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public FaceTemplateList() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = FaceTemplateList.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public FaceTemplateList(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            FaceTemplateList.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public FaceTemplateList clone() throws FaceException {
        FaceTemplateList clone = new FaceTemplateList();
        int err = FaceTemplateList.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public void clear() throws FaceException {
        int err = FaceTemplateList.nClear(this.handle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void add(FaceTemplate faceTemplateItem) throws FaceException {
        int err = FaceTemplateList.nAdd(this.handle, faceTemplateItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public FaceTemplate get(int index) throws FaceException {
        FaceTemplate faceTemplateItem = new FaceTemplate();
        int err = FaceTemplateList.nGet(this.handle, index, faceTemplateItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceTemplateItem;
    }

    public void set(int index, FaceTemplate faceTemplateItem) throws FaceException {
        int err = FaceTemplateList.nSet(this.handle, index, faceTemplateItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getCount() throws FaceException {
        int[] countArray = new int[1];
        int err = FaceTemplateList.nGetCount(this.handle, countArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return countArray[0];
    }

    public void removeAt(int index) throws FaceException {
        int err = FaceTemplateList.nRemoveAt(this.handle, index);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void resize(int newSize) throws FaceException {
        int err = FaceTemplateList.nResize(this.handle, newSize);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nClear(long var0);

    static native int nAdd(long var0, long var2);

    static native int nGet(long var0, int var2, long var3);

    static native int nSet(long var0, int var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nRemoveAt(long var0, int var2);

    static native int nResize(long var0, int var2);

    @Override
    public Iterator<FaceTemplate> iterator() {
        return new Iterator<FaceTemplate>(){
            private int index = 0;
            private final int size = FaceTemplateList.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public FaceTemplate next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return FaceTemplateList.this.get(this.index++);
            }
        };
    }

    static {
        FaceNative.loadLibraries();
    }
}

