/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceModel;
import eu.id3.face.FaceNative;
import eu.id3.face.Image;
import eu.id3.face.TrackedFaceList;
import java.io.Serializable;

public class FaceTracker
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public FaceTracker() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = FaceTracker.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public FaceTracker(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            FaceTracker.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public int getConfidenceThreshold() throws FaceException {
        int[] confidenceThresholdArray = new int[1];
        int err = FaceTracker.nGetConfidenceThreshold(this.handle, confidenceThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return confidenceThresholdArray[0];
    }

    public void setConfidenceThreshold(int confidenceThreshold) throws FaceException {
        int err = FaceTracker.nSetConfidenceThreshold(this.handle, confidenceThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public FaceModel getDetectionModel() throws FaceException {
        int[] detectionModelArray = new int[1];
        int err = FaceTracker.nGetDetectionModel(this.handle, detectionModelArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return FaceModel.fromValue(detectionModelArray[0]);
    }

    public void setDetectionModel(FaceModel detectionModel) throws FaceException {
        int err = FaceTracker.nSetDetectionModel(this.handle, detectionModel.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public FaceModel getEncodingModel() throws FaceException {
        int[] encodingModelArray = new int[1];
        int err = FaceTracker.nGetEncodingModel(this.handle, encodingModelArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return FaceModel.fromValue(encodingModelArray[0]);
    }

    public void setEncodingModel(FaceModel encodingModel) throws FaceException {
        int err = FaceTracker.nSetEncodingModel(this.handle, encodingModel.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMatchThreshold() throws FaceException {
        int[] matchThresholdArray = new int[1];
        int err = FaceTracker.nGetMatchThreshold(this.handle, matchThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return matchThresholdArray[0];
    }

    public void setMatchThreshold(int matchThreshold) throws FaceException {
        int err = FaceTracker.nSetMatchThreshold(this.handle, matchThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMaximumTrackedFaceAge() throws FaceException {
        int[] maximumTrackedFaceAgeArray = new int[1];
        int err = FaceTracker.nGetMaximumTrackedFaceAge(this.handle, maximumTrackedFaceAgeArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return maximumTrackedFaceAgeArray[0];
    }

    public void setMaximumTrackedFaceAge(int maximumTrackedFaceAge) throws FaceException {
        int err = FaceTracker.nSetMaximumTrackedFaceAge(this.handle, maximumTrackedFaceAge);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMinimumTrackedFaceAge() throws FaceException {
        int[] minimumTrackedFaceAgeArray = new int[1];
        int err = FaceTracker.nGetMinimumTrackedFaceAge(this.handle, minimumTrackedFaceAgeArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return minimumTrackedFaceAgeArray[0];
    }

    public void setMinimumTrackedFaceAge(int minimumTrackedFaceAge) throws FaceException {
        int err = FaceTracker.nSetMinimumTrackedFaceAge(this.handle, minimumTrackedFaceAge);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getNmsIouThreshold() throws FaceException {
        int[] nmsIouThresholdArray = new int[1];
        int err = FaceTracker.nGetNmsIouThreshold(this.handle, nmsIouThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return nmsIouThresholdArray[0];
    }

    public void setNmsIouThreshold(int nmsIouThreshold) throws FaceException {
        int err = FaceTracker.nSetNmsIouThreshold(this.handle, nmsIouThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getThreadCount() throws FaceException {
        int[] threadCountArray = new int[1];
        int err = FaceTracker.nGetThreadCount(this.handle, threadCountArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return threadCountArray[0];
    }

    public void setThreadCount(int threadCount) throws FaceException {
        int err = FaceTracker.nSetThreadCount(this.handle, threadCount);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void detectFaces(Image image, TrackedFaceList trackedFaceList) throws FaceException {
        int err = FaceTracker.nDetectFaces(this.handle, image.getHandle(), trackedFaceList.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void trackFaces(Image image, TrackedFaceList trackedFaceList) throws FaceException {
        int err = FaceTracker.nTrackFaces(this.handle, image.getHandle(), trackedFaceList.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void warmUp(int imageWidth, int imageHeight) throws FaceException {
        int err = FaceTracker.nWarmUp(this.handle, imageWidth, imageHeight);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetConfidenceThreshold(long var0, int[] var2);

    static native int nSetConfidenceThreshold(long var0, int var2);

    static native int nGetDetectionModel(long var0, int[] var2);

    static native int nSetDetectionModel(long var0, int var2);

    static native int nGetEncodingModel(long var0, int[] var2);

    static native int nSetEncodingModel(long var0, int var2);

    static native int nGetMatchThreshold(long var0, int[] var2);

    static native int nSetMatchThreshold(long var0, int var2);

    static native int nGetMaximumTrackedFaceAge(long var0, int[] var2);

    static native int nSetMaximumTrackedFaceAge(long var0, int var2);

    static native int nGetMinimumTrackedFaceAge(long var0, int[] var2);

    static native int nSetMinimumTrackedFaceAge(long var0, int var2);

    static native int nGetNmsIouThreshold(long var0, int[] var2);

    static native int nSetNmsIouThreshold(long var0, int var2);

    static native int nGetThreadCount(long var0, int[] var2);

    static native int nSetThreadCount(long var0, int var2);

    static native int nDetectFaces(long var0, long var2, long var4);

    static native int nTrackFaces(long var0, long var2, long var4);

    static native int nWarmUp(long var0, int var2, int var3);

    static {
        FaceNative.loadLibraries();
    }
}

