/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import eu.id3.face.ImageBuffer;
import eu.id3.face.ImageFormat;
import eu.id3.face.PixelFormat;
import eu.id3.face.Rectangle;
import java.io.Serializable;

public class Image
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public Image() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = Image.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public Image(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            Image.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public Image clone() throws FaceException {
        Image clone = new Image();
        int err = Image.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public byte[] getData() throws FaceException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = Image.nGetData(this.handle, data, dataSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = Image.nGetData(this.handle, data, dataSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return data;
    }

    public int getHeight() throws FaceException {
        int[] heightArray = new int[1];
        int err = Image.nGetHeight(this.handle, heightArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return heightArray[0];
    }

    public int getPixelDepth() throws FaceException {
        int[] pixelDepthArray = new int[1];
        int err = Image.nGetPixelDepth(this.handle, pixelDepthArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return pixelDepthArray[0];
    }

    public PixelFormat getPixelFormat() throws FaceException {
        int[] pixelFormatArray = new int[1];
        int err = Image.nGetPixelFormat(this.handle, pixelFormatArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return PixelFormat.fromValue(pixelFormatArray[0]);
    }

    public int getStride() throws FaceException {
        int[] strideArray = new int[1];
        int err = Image.nGetStride(this.handle, strideArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return strideArray[0];
    }

    public int getWidth() throws FaceException {
        int[] widthArray = new int[1];
        int err = Image.nGetWidth(this.handle, widthArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return widthArray[0];
    }

    public float compare(Image cmpImage) throws FaceException {
        float[] resultArray = new float[1];
        int err = Image.nCompare(this.handle, cmpImage.getHandle(), resultArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return resultArray[0];
    }

    public void correctGamma(int contrast, int brightness, float gamma) throws FaceException {
        int err = Image.nCorrectGamma(this.handle, contrast, brightness, gamma);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public Image crop(int left, int top, int width, int height) throws FaceException {
        Image imageCrop = new Image();
        int err = Image.nCrop(this.handle, left, top, width, height, imageCrop.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return imageCrop;
    }

    public float downscale(int maxSize) throws FaceException {
        float[] scaleRatioArray = new float[1];
        int err = Image.nDownscale(this.handle, maxSize, scaleRatioArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return scaleRatioArray[0];
    }

    public float downscaleTo(Image dstImage, int maxSize) throws FaceException {
        float[] scaleRatioArray = new float[1];
        int err = Image.nDownscaleTo(this.handle, dstImage.getHandle(), maxSize, scaleRatioArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return scaleRatioArray[0];
    }

    public Image extractRoi(Rectangle bounds) throws FaceException {
        Image imageRoi = new Image();
        int err = Image.nExtractRoi(this.handle, bounds, imageRoi.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return imageRoi;
    }

    public Image extractRoiWithColor(Rectangle bounds, int colorRed, int colorGreen, int colorBlue) throws FaceException {
        Image imageRoi = new Image();
        int err = Image.nExtractRoiWithColor(this.handle, bounds, colorRed, colorGreen, colorBlue, imageRoi.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return imageRoi;
    }

    public void flip(boolean flipHorizontally, boolean flipVertically) throws FaceException {
        int err = Image.nFlip(this.handle, flipHorizontally, flipVertically);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void flipTo(boolean flipHorizontally, boolean flipVertically, Image dstImage) throws FaceException {
        int err = Image.nFlipTo(this.handle, flipHorizontally, flipVertically, dstImage.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static Image fromBuffer(byte[] data, PixelFormat pixelFormat) throws FaceException {
        Image image = new Image();
        int err = Image.nFromBuffer(image.getHandle(), data, pixelFormat.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return image;
    }

    public static Image fromFile(String filepath, PixelFormat pixelFormat) throws FaceException {
        Image image = new Image();
        int err = Image.nFromFile(image.getHandle(), filepath, pixelFormat.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return image;
    }

    public static Image fromRawBuffer(byte[] pixels, int width, int height, int stride, PixelFormat srcPixelFormat, PixelFormat dstPixelFormat) throws FaceException {
        Image image = new Image();
        int err = Image.nFromRawBuffer(image.getHandle(), pixels, width, height, stride, srcPixelFormat.getValue(), dstPixelFormat.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return image;
    }

    public static Image fromYuvPlanes(byte[] yPlane, byte[] uPlane, byte[] vPlane, int yWidth, int yHeight, int uvPixelStride, int uvRowStride, PixelFormat dstPixelFormat) throws FaceException {
        Image image = new Image();
        int err = Image.nFromYuvPlanes(image.getHandle(), yPlane, uPlane, vPlane, yWidth, yHeight, uvPixelStride, uvRowStride, dstPixelFormat.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return image;
    }

    public void pad(int top, int left, int bottom, int right, int colorRed, int colorGreen, int colorBlue) throws FaceException {
        int err = Image.nPad(this.handle, top, left, bottom, right, colorRed, colorGreen, colorBlue);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void reallocate(int width, int height, PixelFormat pixelFormat) throws FaceException {
        int err = Image.nReallocate(this.handle, width, height, pixelFormat.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void resize(int width, int height) throws FaceException {
        int err = Image.nResize(this.handle, width, height);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void resizeTo(int width, int height, Image dstImage) throws FaceException {
        int err = Image.nResizeTo(this.handle, width, height, dstImage.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void rotate(int angle) throws FaceException {
        int err = Image.nRotate(this.handle, angle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void rotateTo(int angle, Image dstImage) throws FaceException {
        int err = Image.nRotateTo(this.handle, angle, dstImage.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public byte[] toBuffer(ImageFormat imageFormat, float compressionLevel) throws FaceException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = Image.nToBuffer(this.handle, imageFormat.getValue(), compressionLevel, data, dataSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = Image.nToBuffer(this.handle, imageFormat.getValue(), compressionLevel, data, dataSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return data;
    }

    public void toBufferObject(ImageFormat imageFormat, float compressionLevel, ImageBuffer buffer) throws FaceException {
        int err = Image.nToBufferObject(this.handle, imageFormat.getValue(), compressionLevel, buffer.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void toFile(String filepath, float compressionLevel) throws FaceException {
        int err = Image.nToFile(this.handle, filepath, compressionLevel);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void toRawBuffer(PixelFormat pixelFormat, ImageBuffer buffer) throws FaceException {
        int err = Image.nToRawBuffer(this.handle, pixelFormat.getValue(), buffer.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void transpose() throws FaceException {
        int err = Image.nTranspose(this.handle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetData(long var0, byte[] var2, int[] var3);

    static native int nGetHeight(long var0, int[] var2);

    static native int nGetPixelDepth(long var0, int[] var2);

    static native int nGetPixelFormat(long var0, int[] var2);

    static native int nGetStride(long var0, int[] var2);

    static native int nGetWidth(long var0, int[] var2);

    static native int nCompare(long var0, long var2, float[] var4);

    static native int nCorrectGamma(long var0, int var2, int var3, float var4);

    static native int nCrop(long var0, int var2, int var3, int var4, int var5, long var6);

    static native int nDownscale(long var0, int var2, float[] var3);

    static native int nDownscaleTo(long var0, long var2, int var4, float[] var5);

    static native int nExtractRoi(long var0, Rectangle var2, long var3);

    static native int nExtractRoiWithColor(long var0, Rectangle var2, int var3, int var4, int var5, long var6);

    static native int nFlip(long var0, boolean var2, boolean var3);

    static native int nFlipTo(long var0, boolean var2, boolean var3, long var4);

    static native int nFromBuffer(long var0, byte[] var2, int var3);

    static native int nFromFile(long var0, String var2, int var3);

    static native int nFromRawBuffer(long var0, byte[] var2, int var3, int var4, int var5, int var6, int var7);

    static native int nFromYuvPlanes(long var0, byte[] var2, byte[] var3, byte[] var4, int var5, int var6, int var7, int var8, int var9);

    static native int nPad(long var0, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    static native int nReallocate(long var0, int var2, int var3, int var4);

    static native int nResize(long var0, int var2, int var3);

    static native int nResizeTo(long var0, int var2, int var3, long var4);

    static native int nRotate(long var0, int var2);

    static native int nRotateTo(long var0, int var2, long var3);

    static native int nToBuffer(long var0, int var2, float var3, byte[] var4, int[] var5);

    static native int nToBufferObject(long var0, int var2, float var3, long var4);

    static native int nToFile(long var0, String var2, float var3);

    static native int nToRawBuffer(long var0, int var2, long var3);

    static native int nTranspose(long var0);

    static {
        FaceNative.loadLibraries();
    }
}

