/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import java.io.Serializable;

public class ImageBuffer
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public ImageBuffer() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = ImageBuffer.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public ImageBuffer(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            ImageBuffer.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public ImageBuffer clone() throws FaceException {
        ImageBuffer clone = new ImageBuffer();
        int err = ImageBuffer.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public byte[] getData() throws FaceException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = ImageBuffer.nGetData(this.handle, data, dataSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = ImageBuffer.nGetData(this.handle, data, dataSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return data;
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetData(long var0, byte[] var2, int[] var3);

    static {
        FaceNative.loadLibraries();
    }
}

