/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import eu.id3.face.Image;
import eu.id3.face.StringList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ImageDict
implements AutoCloseable,
Serializable,
Iterable<Image> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public ImageDict() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = ImageDict.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public ImageDict(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            ImageDict.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public ImageDict clone() throws FaceException {
        ImageDict clone = new ImageDict();
        int err = ImageDict.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public StringList getKeys() throws FaceException {
        StringList keys = new StringList();
        int err = ImageDict.nGetKeys(this.handle, keys.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return keys;
    }

    public void clear() throws FaceException {
        int err = ImageDict.nClear(this.handle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void add(String key, Image imageItem) throws FaceException {
        int err = ImageDict.nAdd(this.handle, key, imageItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public Image get(String key) throws FaceException {
        Image imageItem = new Image();
        int err = ImageDict.nGet(this.handle, key, imageItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return imageItem;
    }

    public void set(String key, Image imageItem) throws FaceException {
        int err = ImageDict.nSet(this.handle, key, imageItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getCount() throws FaceException {
        int[] countArray = new int[1];
        int err = ImageDict.nGetCount(this.handle, countArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return countArray[0];
    }

    public boolean containsKey(String key) throws FaceException {
        boolean[] resultArray = new boolean[1];
        int err = ImageDict.nContainsKey(this.handle, key, resultArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return resultArray[0];
    }

    public void remove(String key) throws FaceException {
        int err = ImageDict.nRemove(this.handle, key);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetKeys(long var0, long var2);

    static native int nClear(long var0);

    static native int nAdd(long var0, String var2, long var3);

    static native int nGet(long var0, String var2, long var3);

    static native int nSet(long var0, String var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nContainsKey(long var0, String var2, boolean[] var3);

    static native int nRemove(long var0, String var2);

    @Override
    public Iterator<Image> iterator() {
        return new Iterator<Image>(){
            private int index = 0;
            private final StringList keyList = ImageDict.this.getKeys();
            private final int size = ImageDict.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Image next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ImageDict.this.get(this.keyList.get(this.index++));
            }
        };
    }

    static {
        FaceNative.loadLibraries();
    }
}

