/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

public enum ImageFormat {
    BMP(0),
    JPEG(2),
    PNG(13),
    TIFF(18),
    JPEG_2000(30),
    WEBP(31),
    RAW(34);

    private final int value;

    private ImageFormat(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ImageFormat fromValue(int value) {
        ImageFormat[] types;
        for (ImageFormat type : types = ImageFormat.values()) {
            if (type.getValue() != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Unable to find the specified enum value for " + value);
    }

    String getMessage() {
        return ImageFormat.nGetFaceErrorMessage(this.value);
    }

    static native String nGetFaceErrorMessage(int var0);
}

