/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import eu.id3.face.Image;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ImageList
implements AutoCloseable,
Serializable,
Iterable<Image> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public ImageList() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = ImageList.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public ImageList(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            ImageList.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public ImageList clone() throws FaceException {
        ImageList clone = new ImageList();
        int err = ImageList.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public void clear() throws FaceException {
        int err = ImageList.nClear(this.handle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void add(Image imageItem) throws FaceException {
        int err = ImageList.nAdd(this.handle, imageItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public Image get(int index) throws FaceException {
        Image imageItem = new Image();
        int err = ImageList.nGet(this.handle, index, imageItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return imageItem;
    }

    public void set(int index, Image imageItem) throws FaceException {
        int err = ImageList.nSet(this.handle, index, imageItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getCount() throws FaceException {
        int[] countArray = new int[1];
        int err = ImageList.nGetCount(this.handle, countArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return countArray[0];
    }

    public void removeAt(int index) throws FaceException {
        int err = ImageList.nRemoveAt(this.handle, index);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void resize(int newSize) throws FaceException {
        int err = ImageList.nResize(this.handle, newSize);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nClear(long var0);

    static native int nAdd(long var0, long var2);

    static native int nGet(long var0, int var2, long var3);

    static native int nSet(long var0, int var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nRemoveAt(long var0, int var2);

    static native int nResize(long var0, int var2);

    @Override
    public Iterator<Image> iterator() {
        return new Iterator<Image>(){
            private int index = 0;
            private final int size = ImageList.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Image next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ImageList.this.get(this.index++);
            }
        };
    }

    static {
        FaceNative.loadLibraries();
    }
}

