/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import eu.id3.face.Point;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PointList
implements AutoCloseable,
Serializable,
Iterable<Point> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public PointList() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = PointList.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public PointList(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            PointList.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public PointList clone() throws FaceException {
        PointList clone = new PointList();
        int err = PointList.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public void clear() throws FaceException {
        int err = PointList.nClear(this.handle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void add(Point pointItem) throws FaceException {
        int err = PointList.nAdd(this.handle, pointItem);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public Point get(int index) throws FaceException {
        Point pointItem = new Point();
        int err = PointList.nGet(this.handle, index, pointItem);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return pointItem;
    }

    public void set(int index, Point pointItem) throws FaceException {
        int err = PointList.nSet(this.handle, index, pointItem);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getCount() throws FaceException {
        int[] countArray = new int[1];
        int err = PointList.nGetCount(this.handle, countArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return countArray[0];
    }

    public void removeAt(int index) throws FaceException {
        int err = PointList.nRemoveAt(this.handle, index);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void resize(int newSize) throws FaceException {
        int err = PointList.nResize(this.handle, newSize);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nClear(long var0);

    static native int nAdd(long var0, Point var2);

    static native int nGet(long var0, int var2, Point var3);

    static native int nSet(long var0, int var2, Point var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nRemoveAt(long var0, int var2);

    static native int nResize(long var0, int var2);

    @Override
    public Iterator<Point> iterator() {
        return new Iterator<Point>(){
            private int index = 0;
            private final int size = PointList.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Point next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return PointList.this.get(this.index++);
            }
        };
    }

    static {
        FaceNative.loadLibraries();
    }
}

