/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.BackgroundUniformity;
import eu.id3.face.EyeGaze;
import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceExpression;
import eu.id3.face.FaceNative;
import eu.id3.face.FacePose;
import eu.id3.face.FaceTemplate;
import eu.id3.face.GeometricAttributes;
import eu.id3.face.Image;
import eu.id3.face.PadStatus;
import eu.id3.face.PhotographicAttributes;
import eu.id3.face.Point;
import eu.id3.face.PointList;
import eu.id3.face.PortraitInstruction;
import eu.id3.face.PortraitQualityCheckpoints;
import eu.id3.face.PortraitStatus;
import eu.id3.face.TrackedFace;
import java.io.Serializable;

public class Portrait
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public Portrait() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = Portrait.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public Portrait(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            Portrait.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public Portrait clone() throws FaceException {
        Portrait clone = new Portrait();
        int err = Portrait.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public int getAge() throws FaceException {
        int[] ageArray = new int[1];
        int err = Portrait.nGetAge(this.handle, ageArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return ageArray[0];
    }

    public BackgroundUniformity getBackgroundUniformity() throws FaceException {
        BackgroundUniformity backgroundUniformity = new BackgroundUniformity();
        int err = Portrait.nGetBackgroundUniformity(this.handle, backgroundUniformity);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return backgroundUniformity;
    }

    public FaceExpression getExpression() throws FaceException {
        int[] expressionArray = new int[1];
        int err = Portrait.nGetExpression(this.handle, expressionArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return FaceExpression.fromValue(expressionArray[0]);
    }

    public EyeGaze getEyeGaze() throws FaceException {
        EyeGaze eyeGaze = new EyeGaze();
        int err = Portrait.nGetEyeGaze(this.handle, eyeGaze);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return eyeGaze;
    }

    public int getFaceId() throws FaceException {
        int[] faceIdArray = new int[1];
        int err = Portrait.nGetFaceId(this.handle, faceIdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceIdArray[0];
    }

    public int getFaceMask() throws FaceException {
        int[] faceMaskArray = new int[1];
        int err = Portrait.nGetFaceMask(this.handle, faceMaskArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceMaskArray[0];
    }

    public FaceTemplate getFaceTemplate() throws FaceException {
        FaceTemplate faceTemplate = new FaceTemplate();
        int err = Portrait.nGetFaceTemplate(this.handle, faceTemplate.getHandle());
        if (err == FaceError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceTemplate;
    }

    public int getGenderMale() throws FaceException {
        int[] genderMaleArray = new int[1];
        int err = Portrait.nGetGenderMale(this.handle, genderMaleArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return genderMaleArray[0];
    }

    public GeometricAttributes getGeometricAttributes() throws FaceException {
        GeometricAttributes geometricAttributes = new GeometricAttributes();
        int err = Portrait.nGetGeometricAttributes(this.handle, geometricAttributes);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return geometricAttributes;
    }

    public int getGlasses() throws FaceException {
        int[] glassesArray = new int[1];
        int err = Portrait.nGetGlasses(this.handle, glassesArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return glassesArray[0];
    }

    public int getHat() throws FaceException {
        int[] hatArray = new int[1];
        int err = Portrait.nGetHat(this.handle, hatArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return hatArray[0];
    }

    public Image getImage() throws FaceException {
        Image image = new Image();
        int err = Portrait.nGetImage(this.handle, image.getHandle());
        if (err == FaceError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return image;
    }

    public Point getImageCenter() throws FaceException {
        Point imageCenter = new Point();
        int err = Portrait.nGetImageCenter(this.handle, imageCenter);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return imageCenter;
    }

    public float getImageScale() throws FaceException {
        float[] imageScaleArray = new float[1];
        int err = Portrait.nGetImageScale(this.handle, imageScaleArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return imageScaleArray[0];
    }

    public Point getImageTranslation() throws FaceException {
        Point imageTranslation = new Point();
        int err = Portrait.nGetImageTranslation(this.handle, imageTranslation);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return imageTranslation;
    }

    public PortraitInstruction getInstruction() throws FaceException {
        int[] instructionArray = new int[1];
        int err = Portrait.nGetInstruction(this.handle, instructionArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return PortraitInstruction.fromValue(instructionArray[0]);
    }

    public PointList getLandmarks() throws FaceException {
        PointList landmarks = new PointList();
        int err = Portrait.nGetLandmarks(this.handle, landmarks.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return landmarks;
    }

    public int getLeftEyeOpening() throws FaceException {
        int[] leftEyeOpeningArray = new int[1];
        int err = Portrait.nGetLeftEyeOpening(this.handle, leftEyeOpeningArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return leftEyeOpeningArray[0];
    }

    public int getLeftEyeVisibility() throws FaceException {
        int[] leftEyeVisibilityArray = new int[1];
        int err = Portrait.nGetLeftEyeVisibility(this.handle, leftEyeVisibilityArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return leftEyeVisibilityArray[0];
    }

    public int getLookStraightScore() throws FaceException {
        int[] lookStraightScoreArray = new int[1];
        int err = Portrait.nGetLookStraightScore(this.handle, lookStraightScoreArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return lookStraightScoreArray[0];
    }

    public int getMakeup() throws FaceException {
        int[] makeupArray = new int[1];
        int err = Portrait.nGetMakeup(this.handle, makeupArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return makeupArray[0];
    }

    public int getMouthOpening() throws FaceException {
        int[] mouthOpeningArray = new int[1];
        int err = Portrait.nGetMouthOpening(this.handle, mouthOpeningArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return mouthOpeningArray[0];
    }

    public int getMouthVisibility() throws FaceException {
        int[] mouthVisibilityArray = new int[1];
        int err = Portrait.nGetMouthVisibility(this.handle, mouthVisibilityArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return mouthVisibilityArray[0];
    }

    public int getNoseVisibility() throws FaceException {
        int[] noseVisibilityArray = new int[1];
        int err = Portrait.nGetNoseVisibility(this.handle, noseVisibilityArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return noseVisibilityArray[0];
    }

    public int getPadScore() throws FaceException {
        int[] padScoreArray = new int[1];
        int err = Portrait.nGetPadScore(this.handle, padScoreArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return padScoreArray[0];
    }

    public PadStatus getPadStatus() throws FaceException {
        int[] padStatusArray = new int[1];
        int err = Portrait.nGetPadStatus(this.handle, padStatusArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return PadStatus.fromValue(padStatusArray[0]);
    }

    public PhotographicAttributes getPhotographicAttributes() throws FaceException {
        PhotographicAttributes photographicAttributes = new PhotographicAttributes();
        int err = Portrait.nGetPhotographicAttributes(this.handle, photographicAttributes);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return photographicAttributes;
    }

    public FacePose getPose() throws FaceException {
        FacePose pose = new FacePose();
        int err = Portrait.nGetPose(this.handle, pose);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return pose;
    }

    public PortraitQualityCheckpoints getQualityCheckpoints() throws FaceException {
        PortraitQualityCheckpoints qualityCheckpoints = new PortraitQualityCheckpoints();
        int err = Portrait.nGetQualityCheckpoints(this.handle, qualityCheckpoints);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return qualityCheckpoints;
    }

    public int getQualityScore() throws FaceException {
        int[] qualityScoreArray = new int[1];
        int err = Portrait.nGetQualityScore(this.handle, qualityScoreArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return qualityScoreArray[0];
    }

    public int getRightEyeOpening() throws FaceException {
        int[] rightEyeOpeningArray = new int[1];
        int err = Portrait.nGetRightEyeOpening(this.handle, rightEyeOpeningArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return rightEyeOpeningArray[0];
    }

    public int getRightEyeVisibility() throws FaceException {
        int[] rightEyeVisibilityArray = new int[1];
        int err = Portrait.nGetRightEyeVisibility(this.handle, rightEyeVisibilityArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return rightEyeVisibilityArray[0];
    }

    public int getSmile() throws FaceException {
        int[] smileArray = new int[1];
        int err = Portrait.nGetSmile(this.handle, smileArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return smileArray[0];
    }

    public PortraitStatus getStatus() throws FaceException {
        int[] statusArray = new int[1];
        int err = Portrait.nGetStatus(this.handle, statusArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return PortraitStatus.fromValue(statusArray[0]);
    }

    public int getSubjectPosition() throws FaceException {
        int[] subjectPositionArray = new int[1];
        int err = Portrait.nGetSubjectPosition(this.handle, subjectPositionArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return subjectPositionArray[0];
    }

    public TrackedFace getTrackedFace() throws FaceException {
        TrackedFace trackedFace = new TrackedFace();
        int err = Portrait.nGetTrackedFace(this.handle, trackedFace.getHandle());
        if (err == FaceError.OBJECT_DOES_NOT_EXIST.getValue()) {
            return null;
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return trackedFace;
    }

    public void clear() throws FaceException {
        int err = Portrait.nClear(this.handle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public static Portrait fromBuffer(byte[] data) throws FaceException {
        Portrait portrait = new Portrait();
        int err = Portrait.nFromBuffer(portrait.getHandle(), data);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return portrait;
    }

    public byte[] toBuffer() throws FaceException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = Portrait.nToBuffer(this.handle, data, dataSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = Portrait.nToBuffer(this.handle, data, dataSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return data;
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetAge(long var0, int[] var2);

    static native int nGetBackgroundUniformity(long var0, BackgroundUniformity var2);

    static native int nGetExpression(long var0, int[] var2);

    static native int nGetEyeGaze(long var0, EyeGaze var2);

    static native int nGetFaceId(long var0, int[] var2);

    static native int nGetFaceMask(long var0, int[] var2);

    static native int nGetFaceTemplate(long var0, long var2);

    static native int nGetGenderMale(long var0, int[] var2);

    static native int nGetGeometricAttributes(long var0, GeometricAttributes var2);

    static native int nGetGlasses(long var0, int[] var2);

    static native int nGetHat(long var0, int[] var2);

    static native int nGetImage(long var0, long var2);

    static native int nGetImageCenter(long var0, Point var2);

    static native int nGetImageScale(long var0, float[] var2);

    static native int nGetImageTranslation(long var0, Point var2);

    static native int nGetInstruction(long var0, int[] var2);

    static native int nGetLandmarks(long var0, long var2);

    static native int nGetLeftEyeOpening(long var0, int[] var2);

    static native int nGetLeftEyeVisibility(long var0, int[] var2);

    static native int nGetLookStraightScore(long var0, int[] var2);

    static native int nGetMakeup(long var0, int[] var2);

    static native int nGetMouthOpening(long var0, int[] var2);

    static native int nGetMouthVisibility(long var0, int[] var2);

    static native int nGetNoseVisibility(long var0, int[] var2);

    static native int nGetPadScore(long var0, int[] var2);

    static native int nGetPadStatus(long var0, int[] var2);

    static native int nGetPhotographicAttributes(long var0, PhotographicAttributes var2);

    static native int nGetPose(long var0, FacePose var2);

    static native int nGetQualityCheckpoints(long var0, PortraitQualityCheckpoints var2);

    static native int nGetQualityScore(long var0, int[] var2);

    static native int nGetRightEyeOpening(long var0, int[] var2);

    static native int nGetRightEyeVisibility(long var0, int[] var2);

    static native int nGetSmile(long var0, int[] var2);

    static native int nGetStatus(long var0, int[] var2);

    static native int nGetSubjectPosition(long var0, int[] var2);

    static native int nGetTrackedFace(long var0, long var2);

    static native int nClear(long var0);

    static native int nFromBuffer(long var0, byte[] var2);

    static native int nToBuffer(long var0, byte[] var2, int[] var3);

    static {
        FaceNative.loadLibraries();
    }
}

