/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceModel;
import eu.id3.face.FaceNative;
import eu.id3.face.Image;
import eu.id3.face.Portrait;
import java.io.Serializable;

public class PortraitProcessor
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public PortraitProcessor() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = PortraitProcessor.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public PortraitProcessor(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            PortraitProcessor.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public int getBackgroundColorUniformityThreshold() throws FaceException {
        int[] backgroundColorUniformityThresholdArray = new int[1];
        int err = PortraitProcessor.nGetBackgroundColorUniformityThreshold(this.handle, backgroundColorUniformityThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return backgroundColorUniformityThresholdArray[0];
    }

    public void setBackgroundColorUniformityThreshold(int backgroundColorUniformityThreshold) throws FaceException {
        int err = PortraitProcessor.nSetBackgroundColorUniformityThreshold(this.handle, backgroundColorUniformityThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getBackgroundStructureUniformityThreshold() throws FaceException {
        int[] backgroundStructureUniformityThresholdArray = new int[1];
        int err = PortraitProcessor.nGetBackgroundStructureUniformityThreshold(this.handle, backgroundStructureUniformityThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return backgroundStructureUniformityThresholdArray[0];
    }

    public void setBackgroundStructureUniformityThreshold(int backgroundStructureUniformityThreshold) throws FaceException {
        int err = PortraitProcessor.nSetBackgroundStructureUniformityThreshold(this.handle, backgroundStructureUniformityThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public float getCropAspectRatio() throws FaceException {
        float[] cropAspectRatioArray = new float[1];
        int err = PortraitProcessor.nGetCropAspectRatio(this.handle, cropAspectRatioArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return cropAspectRatioArray[0];
    }

    public void setCropAspectRatio(float cropAspectRatio) throws FaceException {
        int err = PortraitProcessor.nSetCropAspectRatio(this.handle, cropAspectRatio);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public float getCropEyePositionRatio() throws FaceException {
        float[] cropEyePositionRatioArray = new float[1];
        int err = PortraitProcessor.nGetCropEyePositionRatio(this.handle, cropEyePositionRatioArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return cropEyePositionRatioArray[0];
    }

    public void setCropEyePositionRatio(float cropEyePositionRatio) throws FaceException {
        int err = PortraitProcessor.nSetCropEyePositionRatio(this.handle, cropEyePositionRatio);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public float getCropIodRatio() throws FaceException {
        float[] cropIodRatioArray = new float[1];
        int err = PortraitProcessor.nGetCropIodRatio(this.handle, cropIodRatioArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return cropIodRatioArray[0];
    }

    public void setCropIodRatio(float cropIodRatio) throws FaceException {
        int err = PortraitProcessor.nSetCropIodRatio(this.handle, cropIodRatio);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public float getCropMargin() throws FaceException {
        float[] cropMarginArray = new float[1];
        int err = PortraitProcessor.nGetCropMargin(this.handle, cropMarginArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return cropMarginArray[0];
    }

    public void setCropMargin(float cropMargin) throws FaceException {
        int err = PortraitProcessor.nSetCropMargin(this.handle, cropMargin);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getDynamicRangeThreshold() throws FaceException {
        int[] dynamicRangeThresholdArray = new int[1];
        int err = PortraitProcessor.nGetDynamicRangeThreshold(this.handle, dynamicRangeThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return dynamicRangeThresholdArray[0];
    }

    public void setDynamicRangeThreshold(int dynamicRangeThreshold) throws FaceException {
        int err = PortraitProcessor.nSetDynamicRangeThreshold(this.handle, dynamicRangeThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getEqualBrightnessThreshold() throws FaceException {
        int[] equalBrightnessThresholdArray = new int[1];
        int err = PortraitProcessor.nGetEqualBrightnessThreshold(this.handle, equalBrightnessThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return equalBrightnessThresholdArray[0];
    }

    public void setEqualBrightnessThreshold(int equalBrightnessThreshold) throws FaceException {
        int err = PortraitProcessor.nSetEqualBrightnessThreshold(this.handle, equalBrightnessThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getExpressionSensibility() throws FaceException {
        int[] expressionSensibilityArray = new int[1];
        int err = PortraitProcessor.nGetExpressionSensibility(this.handle, expressionSensibilityArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return expressionSensibilityArray[0];
    }

    public void setExpressionSensibility(int expressionSensibility) throws FaceException {
        int err = PortraitProcessor.nSetExpressionSensibility(this.handle, expressionSensibility);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getEyeOcclusionThreshold() throws FaceException {
        int[] eyeOcclusionThresholdArray = new int[1];
        int err = PortraitProcessor.nGetEyeOcclusionThreshold(this.handle, eyeOcclusionThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return eyeOcclusionThresholdArray[0];
    }

    public void setEyeOcclusionThreshold(int eyeOcclusionThreshold) throws FaceException {
        int err = PortraitProcessor.nSetEyeOcclusionThreshold(this.handle, eyeOcclusionThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getEyeOpeningThreshold() throws FaceException {
        int[] eyeOpeningThresholdArray = new int[1];
        int err = PortraitProcessor.nGetEyeOpeningThreshold(this.handle, eyeOpeningThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return eyeOpeningThresholdArray[0];
    }

    public void setEyeOpeningThreshold(int eyeOpeningThreshold) throws FaceException {
        int err = PortraitProcessor.nSetEyeOpeningThreshold(this.handle, eyeOpeningThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getFaceDetectionImageSize() throws FaceException {
        int[] faceDetectionImageSizeArray = new int[1];
        int err = PortraitProcessor.nGetFaceDetectionImageSize(this.handle, faceDetectionImageSizeArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceDetectionImageSizeArray[0];
    }

    public void setFaceDetectionImageSize(int faceDetectionImageSize) throws FaceException {
        int err = PortraitProcessor.nSetFaceDetectionImageSize(this.handle, faceDetectionImageSize);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public FaceModel getFaceDetectionModel() throws FaceException {
        int[] faceDetectionModelArray = new int[1];
        int err = PortraitProcessor.nGetFaceDetectionModel(this.handle, faceDetectionModelArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return FaceModel.fromValue(faceDetectionModelArray[0]);
    }

    public void setFaceDetectionModel(FaceModel faceDetectionModel) throws FaceException {
        int err = PortraitProcessor.nSetFaceDetectionModel(this.handle, faceDetectionModel.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getFaceDetectionThreshold() throws FaceException {
        int[] faceDetectionThresholdArray = new int[1];
        int err = PortraitProcessor.nGetFaceDetectionThreshold(this.handle, faceDetectionThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceDetectionThresholdArray[0];
    }

    public void setFaceDetectionThreshold(int faceDetectionThreshold) throws FaceException {
        int err = PortraitProcessor.nSetFaceDetectionThreshold(this.handle, faceDetectionThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public FaceModel getFaceEncodingModel() throws FaceException {
        int[] faceEncodingModelArray = new int[1];
        int err = PortraitProcessor.nGetFaceEncodingModel(this.handle, faceEncodingModelArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return FaceModel.fromValue(faceEncodingModelArray[0]);
    }

    public void setFaceEncodingModel(FaceModel faceEncodingModel) throws FaceException {
        int err = PortraitProcessor.nSetFaceEncodingModel(this.handle, faceEncodingModel.getValue());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getFaceMaskThreshold() throws FaceException {
        int[] faceMaskThresholdArray = new int[1];
        int err = PortraitProcessor.nGetFaceMaskThreshold(this.handle, faceMaskThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceMaskThresholdArray[0];
    }

    public void setFaceMaskThreshold(int faceMaskThreshold) throws FaceException {
        int err = PortraitProcessor.nSetFaceMaskThreshold(this.handle, faceMaskThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getGlassesThreshold() throws FaceException {
        int[] glassesThresholdArray = new int[1];
        int err = PortraitProcessor.nGetGlassesThreshold(this.handle, glassesThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return glassesThresholdArray[0];
    }

    public void setGlassesThreshold(int glassesThreshold) throws FaceException {
        int err = PortraitProcessor.nSetGlassesThreshold(this.handle, glassesThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getHatThreshold() throws FaceException {
        int[] hatThresholdArray = new int[1];
        int err = PortraitProcessor.nGetHatThreshold(this.handle, hatThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return hatThresholdArray[0];
    }

    public void setHatThreshold(int hatThreshold) throws FaceException {
        int err = PortraitProcessor.nSetHatThreshold(this.handle, hatThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMakeupThreshold() throws FaceException {
        int[] makeupThresholdArray = new int[1];
        int err = PortraitProcessor.nGetMakeupThreshold(this.handle, makeupThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return makeupThresholdArray[0];
    }

    public void setMakeupThreshold(int makeupThreshold) throws FaceException {
        int err = PortraitProcessor.nSetMakeupThreshold(this.handle, makeupThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMaleThreshold() throws FaceException {
        int[] maleThresholdArray = new int[1];
        int err = PortraitProcessor.nGetMaleThreshold(this.handle, maleThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return maleThresholdArray[0];
    }

    public void setMaleThreshold(int maleThreshold) throws FaceException {
        int err = PortraitProcessor.nSetMaleThreshold(this.handle, maleThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMaximumEyeGazeX() throws FaceException {
        int[] maximumEyeGazeXArray = new int[1];
        int err = PortraitProcessor.nGetMaximumEyeGazeX(this.handle, maximumEyeGazeXArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return maximumEyeGazeXArray[0];
    }

    public void setMaximumEyeGazeX(int maximumEyeGazeX) throws FaceException {
        int err = PortraitProcessor.nSetMaximumEyeGazeX(this.handle, maximumEyeGazeX);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMaximumEyeGazeY() throws FaceException {
        int[] maximumEyeGazeYArray = new int[1];
        int err = PortraitProcessor.nGetMaximumEyeGazeY(this.handle, maximumEyeGazeYArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return maximumEyeGazeYArray[0];
    }

    public void setMaximumEyeGazeY(int maximumEyeGazeY) throws FaceException {
        int err = PortraitProcessor.nSetMaximumEyeGazeY(this.handle, maximumEyeGazeY);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMaximumHeadHeightRatio() throws FaceException {
        int[] maximumHeadHeightRatioArray = new int[1];
        int err = PortraitProcessor.nGetMaximumHeadHeightRatio(this.handle, maximumHeadHeightRatioArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return maximumHeadHeightRatioArray[0];
    }

    public void setMaximumHeadHeightRatio(int maximumHeadHeightRatio) throws FaceException {
        int err = PortraitProcessor.nSetMaximumHeadHeightRatio(this.handle, maximumHeadHeightRatio);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMaximumHeadWidthRatio() throws FaceException {
        int[] maximumHeadWidthRatioArray = new int[1];
        int err = PortraitProcessor.nGetMaximumHeadWidthRatio(this.handle, maximumHeadWidthRatioArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return maximumHeadWidthRatioArray[0];
    }

    public void setMaximumHeadWidthRatio(int maximumHeadWidthRatio) throws FaceException {
        int err = PortraitProcessor.nSetMaximumHeadWidthRatio(this.handle, maximumHeadWidthRatio);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMaximumHorizontalPosition() throws FaceException {
        int[] maximumHorizontalPositionArray = new int[1];
        int err = PortraitProcessor.nGetMaximumHorizontalPosition(this.handle, maximumHorizontalPositionArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return maximumHorizontalPositionArray[0];
    }

    public void setMaximumHorizontalPosition(int maximumHorizontalPosition) throws FaceException {
        int err = PortraitProcessor.nSetMaximumHorizontalPosition(this.handle, maximumHorizontalPosition);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMaximumIod() throws FaceException {
        int[] maximumIodArray = new int[1];
        int err = PortraitProcessor.nGetMaximumIod(this.handle, maximumIodArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return maximumIodArray[0];
    }

    public void setMaximumIod(int maximumIod) throws FaceException {
        int err = PortraitProcessor.nSetMaximumIod(this.handle, maximumIod);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public float getMaximumPitchAngle() throws FaceException {
        float[] maximumPitchAngleArray = new float[1];
        int err = PortraitProcessor.nGetMaximumPitchAngle(this.handle, maximumPitchAngleArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return maximumPitchAngleArray[0];
    }

    public void setMaximumPitchAngle(float maximumPitchAngle) throws FaceException {
        int err = PortraitProcessor.nSetMaximumPitchAngle(this.handle, maximumPitchAngle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public float getMaximumRollAngle() throws FaceException {
        float[] maximumRollAngleArray = new float[1];
        int err = PortraitProcessor.nGetMaximumRollAngle(this.handle, maximumRollAngleArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return maximumRollAngleArray[0];
    }

    public void setMaximumRollAngle(float maximumRollAngle) throws FaceException {
        int err = PortraitProcessor.nSetMaximumRollAngle(this.handle, maximumRollAngle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMaximumVerticalPosition() throws FaceException {
        int[] maximumVerticalPositionArray = new int[1];
        int err = PortraitProcessor.nGetMaximumVerticalPosition(this.handle, maximumVerticalPositionArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return maximumVerticalPositionArray[0];
    }

    public void setMaximumVerticalPosition(int maximumVerticalPosition) throws FaceException {
        int err = PortraitProcessor.nSetMaximumVerticalPosition(this.handle, maximumVerticalPosition);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public float getMaximumYawAngle() throws FaceException {
        float[] maximumYawAngleArray = new float[1];
        int err = PortraitProcessor.nGetMaximumYawAngle(this.handle, maximumYawAngleArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return maximumYawAngleArray[0];
    }

    public void setMaximumYawAngle(float maximumYawAngle) throws FaceException {
        int err = PortraitProcessor.nSetMaximumYawAngle(this.handle, maximumYawAngle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMinimumHeadHeightRatio() throws FaceException {
        int[] minimumHeadHeightRatioArray = new int[1];
        int err = PortraitProcessor.nGetMinimumHeadHeightRatio(this.handle, minimumHeadHeightRatioArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return minimumHeadHeightRatioArray[0];
    }

    public void setMinimumHeadHeightRatio(int minimumHeadHeightRatio) throws FaceException {
        int err = PortraitProcessor.nSetMinimumHeadHeightRatio(this.handle, minimumHeadHeightRatio);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMinimumHeadWidthRatio() throws FaceException {
        int[] minimumHeadWidthRatioArray = new int[1];
        int err = PortraitProcessor.nGetMinimumHeadWidthRatio(this.handle, minimumHeadWidthRatioArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return minimumHeadWidthRatioArray[0];
    }

    public void setMinimumHeadWidthRatio(int minimumHeadWidthRatio) throws FaceException {
        int err = PortraitProcessor.nSetMinimumHeadWidthRatio(this.handle, minimumHeadWidthRatio);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMinimumHorizontalPosition() throws FaceException {
        int[] minimumHorizontalPositionArray = new int[1];
        int err = PortraitProcessor.nGetMinimumHorizontalPosition(this.handle, minimumHorizontalPositionArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return minimumHorizontalPositionArray[0];
    }

    public void setMinimumHorizontalPosition(int minimumHorizontalPosition) throws FaceException {
        int err = PortraitProcessor.nSetMinimumHorizontalPosition(this.handle, minimumHorizontalPosition);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMinimumIod() throws FaceException {
        int[] minimumIodArray = new int[1];
        int err = PortraitProcessor.nGetMinimumIod(this.handle, minimumIodArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return minimumIodArray[0];
    }

    public void setMinimumIod(int minimumIod) throws FaceException {
        int err = PortraitProcessor.nSetMinimumIod(this.handle, minimumIod);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMinimumVerticalPosition() throws FaceException {
        int[] minimumVerticalPositionArray = new int[1];
        int err = PortraitProcessor.nGetMinimumVerticalPosition(this.handle, minimumVerticalPositionArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return minimumVerticalPositionArray[0];
    }

    public void setMinimumVerticalPosition(int minimumVerticalPosition) throws FaceException {
        int err = PortraitProcessor.nSetMinimumVerticalPosition(this.handle, minimumVerticalPosition);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMouthOcclusionThreshold() throws FaceException {
        int[] mouthOcclusionThresholdArray = new int[1];
        int err = PortraitProcessor.nGetMouthOcclusionThreshold(this.handle, mouthOcclusionThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return mouthOcclusionThresholdArray[0];
    }

    public void setMouthOcclusionThreshold(int mouthOcclusionThreshold) throws FaceException {
        int err = PortraitProcessor.nSetMouthOcclusionThreshold(this.handle, mouthOcclusionThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getMouthOpenThreshold() throws FaceException {
        int[] mouthOpenThresholdArray = new int[1];
        int err = PortraitProcessor.nGetMouthOpenThreshold(this.handle, mouthOpenThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return mouthOpenThresholdArray[0];
    }

    public void setMouthOpenThreshold(int mouthOpenThreshold) throws FaceException {
        int err = PortraitProcessor.nSetMouthOpenThreshold(this.handle, mouthOpenThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getNaturalSkinColorThreshold() throws FaceException {
        int[] naturalSkinColorThresholdArray = new int[1];
        int err = PortraitProcessor.nGetNaturalSkinColorThreshold(this.handle, naturalSkinColorThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return naturalSkinColorThresholdArray[0];
    }

    public void setNaturalSkinColorThreshold(int naturalSkinColorThreshold) throws FaceException {
        int err = PortraitProcessor.nSetNaturalSkinColorThreshold(this.handle, naturalSkinColorThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getNoFlashReflectionThreshold() throws FaceException {
        int[] noFlashReflectionThresholdArray = new int[1];
        int err = PortraitProcessor.nGetNoFlashReflectionThreshold(this.handle, noFlashReflectionThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return noFlashReflectionThresholdArray[0];
    }

    public void setNoFlashReflectionThreshold(int noFlashReflectionThreshold) throws FaceException {
        int err = PortraitProcessor.nSetNoFlashReflectionThreshold(this.handle, noFlashReflectionThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getNoiseThreshold() throws FaceException {
        int[] noiseThresholdArray = new int[1];
        int err = PortraitProcessor.nGetNoiseThreshold(this.handle, noiseThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return noiseThresholdArray[0];
    }

    public void setNoiseThreshold(int noiseThreshold) throws FaceException {
        int err = PortraitProcessor.nSetNoiseThreshold(this.handle, noiseThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getNoseOcclusionThreshold() throws FaceException {
        int[] noseOcclusionThresholdArray = new int[1];
        int err = PortraitProcessor.nGetNoseOcclusionThreshold(this.handle, noseOcclusionThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return noseOcclusionThresholdArray[0];
    }

    public void setNoseOcclusionThreshold(int noseOcclusionThreshold) throws FaceException {
        int err = PortraitProcessor.nSetNoseOcclusionThreshold(this.handle, noseOcclusionThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getOverExposureThreshold() throws FaceException {
        int[] overExposureThresholdArray = new int[1];
        int err = PortraitProcessor.nGetOverExposureThreshold(this.handle, overExposureThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return overExposureThresholdArray[0];
    }

    public void setOverExposureThreshold(int overExposureThreshold) throws FaceException {
        int err = PortraitProcessor.nSetOverExposureThreshold(this.handle, overExposureThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getPadThreshold() throws FaceException {
        int[] padThresholdArray = new int[1];
        int err = PortraitProcessor.nGetPadThreshold(this.handle, padThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return padThresholdArray[0];
    }

    public void setPadThreshold(int padThreshold) throws FaceException {
        int err = PortraitProcessor.nSetPadThreshold(this.handle, padThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getPixelationThreshold() throws FaceException {
        int[] pixelationThresholdArray = new int[1];
        int err = PortraitProcessor.nGetPixelationThreshold(this.handle, pixelationThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return pixelationThresholdArray[0];
    }

    public void setPixelationThreshold(int pixelationThreshold) throws FaceException {
        int err = PortraitProcessor.nSetPixelationThreshold(this.handle, pixelationThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getRedEyeThreshold() throws FaceException {
        int[] redEyeThresholdArray = new int[1];
        int err = PortraitProcessor.nGetRedEyeThreshold(this.handle, redEyeThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return redEyeThresholdArray[0];
    }

    public void setRedEyeThreshold(int redEyeThreshold) throws FaceException {
        int err = PortraitProcessor.nSetRedEyeThreshold(this.handle, redEyeThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getResolutionThreshold() throws FaceException {
        int[] resolutionThresholdArray = new int[1];
        int err = PortraitProcessor.nGetResolutionThreshold(this.handle, resolutionThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return resolutionThresholdArray[0];
    }

    public void setResolutionThreshold(int resolutionThreshold) throws FaceException {
        int err = PortraitProcessor.nSetResolutionThreshold(this.handle, resolutionThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getSharpnessThreshold() throws FaceException {
        int[] sharpnessThresholdArray = new int[1];
        int err = PortraitProcessor.nGetSharpnessThreshold(this.handle, sharpnessThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return sharpnessThresholdArray[0];
    }

    public void setSharpnessThreshold(int sharpnessThreshold) throws FaceException {
        int err = PortraitProcessor.nSetSharpnessThreshold(this.handle, sharpnessThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getSmileThreshold() throws FaceException {
        int[] smileThresholdArray = new int[1];
        int err = PortraitProcessor.nGetSmileThreshold(this.handle, smileThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return smileThresholdArray[0];
    }

    public void setSmileThreshold(int smileThreshold) throws FaceException {
        int err = PortraitProcessor.nSetSmileThreshold(this.handle, smileThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getThreadCount() throws FaceException {
        int[] threadCountArray = new int[1];
        int err = PortraitProcessor.nGetThreadCount(this.handle, threadCountArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return threadCountArray[0];
    }

    public void setThreadCount(int threadCount) throws FaceException {
        int err = PortraitProcessor.nSetThreadCount(this.handle, threadCount);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getTintedGlassThreshold() throws FaceException {
        int[] tintedGlassThresholdArray = new int[1];
        int err = PortraitProcessor.nGetTintedGlassThreshold(this.handle, tintedGlassThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return tintedGlassThresholdArray[0];
    }

    public void setTintedGlassThreshold(int tintedGlassThreshold) throws FaceException {
        int err = PortraitProcessor.nSetTintedGlassThreshold(this.handle, tintedGlassThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getTrackerMatchingThreshold() throws FaceException {
        int[] trackerMatchingThresholdArray = new int[1];
        int err = PortraitProcessor.nGetTrackerMatchingThreshold(this.handle, trackerMatchingThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return trackerMatchingThresholdArray[0];
    }

    public void setTrackerMatchingThreshold(int trackerMatchingThreshold) throws FaceException {
        int err = PortraitProcessor.nSetTrackerMatchingThreshold(this.handle, trackerMatchingThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getTrackerMaximumFaceAge() throws FaceException {
        int[] trackerMaximumFaceAgeArray = new int[1];
        int err = PortraitProcessor.nGetTrackerMaximumFaceAge(this.handle, trackerMaximumFaceAgeArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return trackerMaximumFaceAgeArray[0];
    }

    public void setTrackerMaximumFaceAge(int trackerMaximumFaceAge) throws FaceException {
        int err = PortraitProcessor.nSetTrackerMaximumFaceAge(this.handle, trackerMaximumFaceAge);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getTrackerMinimumFaceAge() throws FaceException {
        int[] trackerMinimumFaceAgeArray = new int[1];
        int err = PortraitProcessor.nGetTrackerMinimumFaceAge(this.handle, trackerMinimumFaceAgeArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return trackerMinimumFaceAgeArray[0];
    }

    public void setTrackerMinimumFaceAge(int trackerMinimumFaceAge) throws FaceException {
        int err = PortraitProcessor.nSetTrackerMinimumFaceAge(this.handle, trackerMinimumFaceAge);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getTrackerNmsIouThreshold() throws FaceException {
        int[] trackerNmsIouThresholdArray = new int[1];
        int err = PortraitProcessor.nGetTrackerNmsIouThreshold(this.handle, trackerNmsIouThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return trackerNmsIouThresholdArray[0];
    }

    public void setTrackerNmsIouThreshold(int trackerNmsIouThreshold) throws FaceException {
        int err = PortraitProcessor.nSetTrackerNmsIouThreshold(this.handle, trackerNmsIouThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getUnderExposureThreshold() throws FaceException {
        int[] underExposureThresholdArray = new int[1];
        int err = PortraitProcessor.nGetUnderExposureThreshold(this.handle, underExposureThresholdArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return underExposureThresholdArray[0];
    }

    public void setUnderExposureThreshold(int underExposureThreshold) throws FaceException {
        int err = PortraitProcessor.nSetUnderExposureThreshold(this.handle, underExposureThreshold);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public Portrait createPortrait(Image image) throws FaceException {
        Portrait portrait = new Portrait();
        int err = PortraitProcessor.nCreatePortrait(this.handle, image.getHandle(), portrait.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return portrait;
    }

    public Image cropIcaoPortrait(Portrait portrait) throws FaceException {
        Image image = new Image();
        int err = PortraitProcessor.nCropIcaoPortrait(this.handle, portrait.getHandle(), image.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return image;
    }

    public Image cropPortrait(Portrait portrait) throws FaceException {
        Image image = new Image();
        int err = PortraitProcessor.nCropPortrait(this.handle, portrait.getHandle(), image.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return image;
    }

    public void detectOcclusions(Portrait portrait) throws FaceException {
        int err = PortraitProcessor.nDetectOcclusions(this.handle, portrait.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void detectPresentationAttack(Portrait portrait) throws FaceException {
        int err = PortraitProcessor.nDetectPresentationAttack(this.handle, portrait.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void estimateAge(Portrait portrait) throws FaceException {
        int err = PortraitProcessor.nEstimateAge(this.handle, portrait.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void estimateBackgroundUniformity(Portrait portrait) throws FaceException {
        int err = PortraitProcessor.nEstimateBackgroundUniformity(this.handle, portrait.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void estimateExpression(Portrait portrait) throws FaceException {
        int err = PortraitProcessor.nEstimateExpression(this.handle, portrait.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void estimateFaceAttributes(Portrait portrait) throws FaceException {
        int err = PortraitProcessor.nEstimateFaceAttributes(this.handle, portrait.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void estimateGeometryQuality(Portrait portrait) throws FaceException {
        int err = PortraitProcessor.nEstimateGeometryQuality(this.handle, portrait.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void estimatePhotographicQuality(Portrait portrait) throws FaceException {
        int err = PortraitProcessor.nEstimatePhotographicQuality(this.handle, portrait.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void removeBackground(Image image, int red, int green, int blue) throws FaceException {
        int err = PortraitProcessor.nRemoveBackground(this.handle, image.getHandle(), red, green, blue);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void reset() throws FaceException {
        int err = PortraitProcessor.nReset(this.handle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void updatePortrait(Portrait portrait, Image image) throws FaceException {
        int err = PortraitProcessor.nUpdatePortrait(this.handle, portrait.getHandle(), image.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nGetBackgroundColorUniformityThreshold(long var0, int[] var2);

    static native int nSetBackgroundColorUniformityThreshold(long var0, int var2);

    static native int nGetBackgroundStructureUniformityThreshold(long var0, int[] var2);

    static native int nSetBackgroundStructureUniformityThreshold(long var0, int var2);

    static native int nGetCropAspectRatio(long var0, float[] var2);

    static native int nSetCropAspectRatio(long var0, float var2);

    static native int nGetCropEyePositionRatio(long var0, float[] var2);

    static native int nSetCropEyePositionRatio(long var0, float var2);

    static native int nGetCropIodRatio(long var0, float[] var2);

    static native int nSetCropIodRatio(long var0, float var2);

    static native int nGetCropMargin(long var0, float[] var2);

    static native int nSetCropMargin(long var0, float var2);

    static native int nGetDynamicRangeThreshold(long var0, int[] var2);

    static native int nSetDynamicRangeThreshold(long var0, int var2);

    static native int nGetEqualBrightnessThreshold(long var0, int[] var2);

    static native int nSetEqualBrightnessThreshold(long var0, int var2);

    static native int nGetExpressionSensibility(long var0, int[] var2);

    static native int nSetExpressionSensibility(long var0, int var2);

    static native int nGetEyeOcclusionThreshold(long var0, int[] var2);

    static native int nSetEyeOcclusionThreshold(long var0, int var2);

    static native int nGetEyeOpeningThreshold(long var0, int[] var2);

    static native int nSetEyeOpeningThreshold(long var0, int var2);

    static native int nGetFaceDetectionImageSize(long var0, int[] var2);

    static native int nSetFaceDetectionImageSize(long var0, int var2);

    static native int nGetFaceDetectionModel(long var0, int[] var2);

    static native int nSetFaceDetectionModel(long var0, int var2);

    static native int nGetFaceDetectionThreshold(long var0, int[] var2);

    static native int nSetFaceDetectionThreshold(long var0, int var2);

    static native int nGetFaceEncodingModel(long var0, int[] var2);

    static native int nSetFaceEncodingModel(long var0, int var2);

    static native int nGetFaceMaskThreshold(long var0, int[] var2);

    static native int nSetFaceMaskThreshold(long var0, int var2);

    static native int nGetGlassesThreshold(long var0, int[] var2);

    static native int nSetGlassesThreshold(long var0, int var2);

    static native int nGetHatThreshold(long var0, int[] var2);

    static native int nSetHatThreshold(long var0, int var2);

    static native int nGetMakeupThreshold(long var0, int[] var2);

    static native int nSetMakeupThreshold(long var0, int var2);

    static native int nGetMaleThreshold(long var0, int[] var2);

    static native int nSetMaleThreshold(long var0, int var2);

    static native int nGetMaximumEyeGazeX(long var0, int[] var2);

    static native int nSetMaximumEyeGazeX(long var0, int var2);

    static native int nGetMaximumEyeGazeY(long var0, int[] var2);

    static native int nSetMaximumEyeGazeY(long var0, int var2);

    static native int nGetMaximumHeadHeightRatio(long var0, int[] var2);

    static native int nSetMaximumHeadHeightRatio(long var0, int var2);

    static native int nGetMaximumHeadWidthRatio(long var0, int[] var2);

    static native int nSetMaximumHeadWidthRatio(long var0, int var2);

    static native int nGetMaximumHorizontalPosition(long var0, int[] var2);

    static native int nSetMaximumHorizontalPosition(long var0, int var2);

    static native int nGetMaximumIod(long var0, int[] var2);

    static native int nSetMaximumIod(long var0, int var2);

    static native int nGetMaximumPitchAngle(long var0, float[] var2);

    static native int nSetMaximumPitchAngle(long var0, float var2);

    static native int nGetMaximumRollAngle(long var0, float[] var2);

    static native int nSetMaximumRollAngle(long var0, float var2);

    static native int nGetMaximumVerticalPosition(long var0, int[] var2);

    static native int nSetMaximumVerticalPosition(long var0, int var2);

    static native int nGetMaximumYawAngle(long var0, float[] var2);

    static native int nSetMaximumYawAngle(long var0, float var2);

    static native int nGetMinimumHeadHeightRatio(long var0, int[] var2);

    static native int nSetMinimumHeadHeightRatio(long var0, int var2);

    static native int nGetMinimumHeadWidthRatio(long var0, int[] var2);

    static native int nSetMinimumHeadWidthRatio(long var0, int var2);

    static native int nGetMinimumHorizontalPosition(long var0, int[] var2);

    static native int nSetMinimumHorizontalPosition(long var0, int var2);

    static native int nGetMinimumIod(long var0, int[] var2);

    static native int nSetMinimumIod(long var0, int var2);

    static native int nGetMinimumVerticalPosition(long var0, int[] var2);

    static native int nSetMinimumVerticalPosition(long var0, int var2);

    static native int nGetMouthOcclusionThreshold(long var0, int[] var2);

    static native int nSetMouthOcclusionThreshold(long var0, int var2);

    static native int nGetMouthOpenThreshold(long var0, int[] var2);

    static native int nSetMouthOpenThreshold(long var0, int var2);

    static native int nGetNaturalSkinColorThreshold(long var0, int[] var2);

    static native int nSetNaturalSkinColorThreshold(long var0, int var2);

    static native int nGetNoFlashReflectionThreshold(long var0, int[] var2);

    static native int nSetNoFlashReflectionThreshold(long var0, int var2);

    static native int nGetNoiseThreshold(long var0, int[] var2);

    static native int nSetNoiseThreshold(long var0, int var2);

    static native int nGetNoseOcclusionThreshold(long var0, int[] var2);

    static native int nSetNoseOcclusionThreshold(long var0, int var2);

    static native int nGetOverExposureThreshold(long var0, int[] var2);

    static native int nSetOverExposureThreshold(long var0, int var2);

    static native int nGetPadThreshold(long var0, int[] var2);

    static native int nSetPadThreshold(long var0, int var2);

    static native int nGetPixelationThreshold(long var0, int[] var2);

    static native int nSetPixelationThreshold(long var0, int var2);

    static native int nGetRedEyeThreshold(long var0, int[] var2);

    static native int nSetRedEyeThreshold(long var0, int var2);

    static native int nGetResolutionThreshold(long var0, int[] var2);

    static native int nSetResolutionThreshold(long var0, int var2);

    static native int nGetSharpnessThreshold(long var0, int[] var2);

    static native int nSetSharpnessThreshold(long var0, int var2);

    static native int nGetSmileThreshold(long var0, int[] var2);

    static native int nSetSmileThreshold(long var0, int var2);

    static native int nGetThreadCount(long var0, int[] var2);

    static native int nSetThreadCount(long var0, int var2);

    static native int nGetTintedGlassThreshold(long var0, int[] var2);

    static native int nSetTintedGlassThreshold(long var0, int var2);

    static native int nGetTrackerMatchingThreshold(long var0, int[] var2);

    static native int nSetTrackerMatchingThreshold(long var0, int var2);

    static native int nGetTrackerMaximumFaceAge(long var0, int[] var2);

    static native int nSetTrackerMaximumFaceAge(long var0, int var2);

    static native int nGetTrackerMinimumFaceAge(long var0, int[] var2);

    static native int nSetTrackerMinimumFaceAge(long var0, int var2);

    static native int nGetTrackerNmsIouThreshold(long var0, int[] var2);

    static native int nSetTrackerNmsIouThreshold(long var0, int var2);

    static native int nGetUnderExposureThreshold(long var0, int[] var2);

    static native int nSetUnderExposureThreshold(long var0, int var2);

    static native int nCreatePortrait(long var0, long var2, long var4);

    static native int nCropIcaoPortrait(long var0, long var2, long var4);

    static native int nCropPortrait(long var0, long var2, long var4);

    static native int nDetectOcclusions(long var0, long var2);

    static native int nDetectPresentationAttack(long var0, long var2);

    static native int nEstimateAge(long var0, long var2);

    static native int nEstimateBackgroundUniformity(long var0, long var2);

    static native int nEstimateExpression(long var0, long var2);

    static native int nEstimateFaceAttributes(long var0, long var2);

    static native int nEstimateGeometryQuality(long var0, long var2);

    static native int nEstimatePhotographicQuality(long var0, long var2);

    static native int nRemoveBackground(long var0, long var2, int var4, int var5, int var6);

    static native int nReset(long var0);

    static native int nUpdatePortrait(long var0, long var2, long var4);

    static {
        FaceNative.loadLibraries();
    }
}

