/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.DetectedFace;
import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import eu.id3.face.FaceTemplate;
import eu.id3.face.Image;
import eu.id3.face.Point;
import eu.id3.face.PointList;
import eu.id3.face.Rectangle;
import eu.id3.face.TrackingStatus;
import java.io.Serializable;

public class TrackedFace
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public TrackedFace() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = TrackedFace.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public TrackedFace(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            TrackedFace.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public TrackedFace clone() throws FaceException {
        TrackedFace clone = new TrackedFace();
        int err = TrackedFace.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public Rectangle getBounds() throws FaceException {
        Rectangle bounds = new Rectangle();
        int err = TrackedFace.nGetBounds(this.handle, bounds);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return bounds;
    }

    public void setBounds(Rectangle bounds) throws FaceException {
        int err = TrackedFace.nSetBounds(this.handle, bounds);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getDetectionScore() throws FaceException {
        int[] detectionScoreArray = new int[1];
        int err = TrackedFace.nGetDetectionScore(this.handle, detectionScoreArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return detectionScoreArray[0];
    }

    public FaceTemplate getFaceTemplate() throws FaceException {
        FaceTemplate faceTemplate = new FaceTemplate();
        int err = TrackedFace.nGetFaceTemplate(this.handle, faceTemplate.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return faceTemplate;
    }

    public int getId() throws FaceException {
        int[] idArray = new int[1];
        int err = TrackedFace.nGetId(this.handle, idArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return idArray[0];
    }

    public void setId(int id) throws FaceException {
        int err = TrackedFace.nSetId(this.handle, id);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public PointList getLandmarks() throws FaceException {
        PointList landmarks = new PointList();
        int err = TrackedFace.nGetLandmarks(this.handle, landmarks.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return landmarks;
    }

    public void setLandmarks(PointList landmarks) throws FaceException {
        int err = TrackedFace.nSetLandmarks(this.handle, landmarks.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public Rectangle getPredictedBounds() throws FaceException {
        Rectangle predictedBounds = new Rectangle();
        int err = TrackedFace.nGetPredictedBounds(this.handle, predictedBounds);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return predictedBounds;
    }

    public TrackingStatus getTrackingStatus() throws FaceException {
        int[] trackingStatusArray = new int[1];
        int err = TrackedFace.nGetTrackingStatus(this.handle, trackingStatusArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return TrackingStatus.fromValue(trackingStatusArray[0]);
    }

    public static TrackedFace create(Rectangle bounds, int detectionScore, int id, PointList landmarks) throws FaceException {
        TrackedFace trackedFace = new TrackedFace();
        int err = TrackedFace.nCreate(trackedFace.getHandle(), bounds, detectionScore, id, landmarks.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return trackedFace;
    }

    public static TrackedFace fromBuffer(byte[] data) throws FaceException {
        TrackedFace trackedFace = new TrackedFace();
        int err = TrackedFace.nFromBuffer(trackedFace.getHandle(), data);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return trackedFace;
    }

    public static TrackedFace fromFile(String path) throws FaceException {
        TrackedFace trackedFace = new TrackedFace();
        int err = TrackedFace.nFromFile(trackedFace.getHandle(), path);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return trackedFace;
    }

    public DetectedFace getAsDetectedFace() throws FaceException {
        DetectedFace detectedFace = new DetectedFace();
        int err = TrackedFace.nGetAsDetectedFace(this.handle, detectedFace.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return detectedFace;
    }

    public int getDistanceToCamera(Image depthImage) throws FaceException {
        int[] distanceToCameraArray = new int[1];
        int err = TrackedFace.nGetDistanceToCamera(this.handle, depthImage.getHandle(), distanceToCameraArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return distanceToCameraArray[0];
    }

    public Rectangle getExpandedBounds(float aspectRatio, float margin) throws FaceException {
        Rectangle portraitBounds = new Rectangle();
        int err = TrackedFace.nGetExpandedBounds(this.handle, aspectRatio, margin, portraitBounds);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return portraitBounds;
    }

    public int getInterocularDistance() throws FaceException {
        int[] iodArray = new int[1];
        int err = TrackedFace.nGetInterocularDistance(this.handle, iodArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return iodArray[0];
    }

    public Rectangle getPortraitBounds(float eyeImageWidthRatio, float eyeImageHeightRatio, float imageRatio) throws FaceException {
        Rectangle portraitBounds = new Rectangle();
        int err = TrackedFace.nGetPortraitBounds(this.handle, eyeImageWidthRatio, eyeImageHeightRatio, imageRatio, portraitBounds);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return portraitBounds;
    }

    public void rescale(float scale) throws FaceException {
        int err = TrackedFace.nRescale(this.handle, scale);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void rotate(int angle, Point center) throws FaceException {
        int err = TrackedFace.nRotate(this.handle, angle, center);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public byte[] toBuffer() throws FaceException {
        byte[] data = null;
        int[] dataSizeArray = new int[]{-1};
        int err = TrackedFace.nToBuffer(this.handle, data, dataSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            data = new byte[dataSizeArray[0]];
            err = TrackedFace.nToBuffer(this.handle, data, dataSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return data;
    }

    public void toFile(String path) throws FaceException {
        int err = TrackedFace.nToFile(this.handle, path);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void translate(int tx, int ty) throws FaceException {
        int err = TrackedFace.nTranslate(this.handle, tx, ty);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nGetBounds(long var0, Rectangle var2);

    static native int nSetBounds(long var0, Rectangle var2);

    static native int nGetDetectionScore(long var0, int[] var2);

    static native int nGetFaceTemplate(long var0, long var2);

    static native int nGetId(long var0, int[] var2);

    static native int nSetId(long var0, int var2);

    static native int nGetLandmarks(long var0, long var2);

    static native int nSetLandmarks(long var0, long var2);

    static native int nGetPredictedBounds(long var0, Rectangle var2);

    static native int nGetTrackingStatus(long var0, int[] var2);

    static native int nCreate(long var0, Rectangle var2, int var3, int var4, long var5);

    static native int nFromBuffer(long var0, byte[] var2);

    static native int nFromFile(long var0, String var2);

    static native int nGetAsDetectedFace(long var0, long var2);

    static native int nGetDistanceToCamera(long var0, long var2, int[] var4);

    static native int nGetExpandedBounds(long var0, float var2, float var3, Rectangle var4);

    static native int nGetInterocularDistance(long var0, int[] var2);

    static native int nGetPortraitBounds(long var0, float var2, float var3, float var4, Rectangle var5);

    static native int nRescale(long var0, float var2);

    static native int nRotate(long var0, int var2, Point var3);

    static native int nToBuffer(long var0, byte[] var2, int[] var3);

    static native int nToFile(long var0, String var2);

    static native int nTranslate(long var0, int var2, int var3);

    static {
        FaceNative.loadLibraries();
    }
}

