/*
 * Decompiled with CFR 0.152.
 */
package eu.id3.face;

import eu.id3.face.FaceError;
import eu.id3.face.FaceException;
import eu.id3.face.FaceNative;
import eu.id3.face.TrackedFace;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TrackedFaceList
implements AutoCloseable,
Serializable,
Iterable<TrackedFace> {
    private static final long serialVersionUID = 1L;
    private long handle;
    private boolean disposable = true;

    public TrackedFaceList() throws FaceException {
        long[] pHandle = new long[]{0L};
        int err = TrackedFaceList.nInitialize(pHandle);
        if (err != 0) {
            throw new FaceException(err);
        }
        this.handle = pHandle[0];
    }

    public TrackedFaceList(long handle) throws FaceException {
        this.handle = handle;
        this.disposable = false;
    }

    @Override
    public void close() {
        if (this.disposable) {
            long[] pHandle = new long[]{0L};
            pHandle[0] = this.handle;
            TrackedFaceList.nDispose(pHandle);
            this.handle = pHandle[0];
        }
    }

    protected void finalize() {
        this.close();
    }

    public long getHandle() {
        return this.handle;
    }

    public TrackedFaceList clone() throws FaceException {
        TrackedFaceList clone = new TrackedFaceList();
        int err = TrackedFaceList.nCopyTo(this.handle, clone.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            return null;
        }
        return clone;
    }

    public void clear() throws FaceException {
        int err = TrackedFaceList.nClear(this.handle);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void add(TrackedFace trackedFaceItem) throws FaceException {
        int err = TrackedFaceList.nAdd(this.handle, trackedFaceItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public TrackedFace get(int index) throws FaceException {
        TrackedFace trackedFaceItem = new TrackedFace();
        int err = TrackedFaceList.nGet(this.handle, index, trackedFaceItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return trackedFaceItem;
    }

    public void set(int index, TrackedFace trackedFaceItem) throws FaceException {
        int err = TrackedFaceList.nSet(this.handle, index, trackedFaceItem.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public int getCount() throws FaceException {
        int[] countArray = new int[1];
        int err = TrackedFaceList.nGetCount(this.handle, countArray);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return countArray[0];
    }

    public void removeAt(int index) throws FaceException {
        int err = TrackedFaceList.nRemoveAt(this.handle, index);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public void resize(int newSize) throws FaceException {
        int err = TrackedFaceList.nResize(this.handle, newSize);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    public TrackedFace findTrackedFace(int id) throws FaceException {
        TrackedFace trackedFace = new TrackedFace();
        int err = TrackedFaceList.nFindTrackedFace(this.handle, id, trackedFace.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return trackedFace;
    }

    public int[] getIdList() throws FaceException {
        int[] ids = null;
        int[] idsSizeArray = new int[]{-1};
        int err = TrackedFaceList.nGetIdList(this.handle, ids, idsSizeArray);
        if (err == FaceError.INSUFFICIENT_BUFFER.getValue()) {
            ids = new int[idsSizeArray[0]];
            err = TrackedFaceList.nGetIdList(this.handle, ids, idsSizeArray);
        }
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return ids;
    }

    public TrackedFace getLargestFace() throws FaceException {
        TrackedFace largestFace = new TrackedFace();
        int err = TrackedFaceList.nGetLargestFace(this.handle, largestFace.getHandle());
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
        return largestFace;
    }

    public void rescaleAll(float scale) throws FaceException {
        int err = TrackedFaceList.nRescaleAll(this.handle, scale);
        if (err != FaceError.SUCCESS.getValue()) {
            throw new FaceException(err);
        }
    }

    static native int nInitialize(long[] var0);

    static native int nDispose(long[] var0);

    static native int nCopyTo(long var0, long var2);

    static native int nClear(long var0);

    static native int nAdd(long var0, long var2);

    static native int nGet(long var0, int var2, long var3);

    static native int nSet(long var0, int var2, long var3);

    static native int nGetCount(long var0, int[] var2);

    static native int nRemoveAt(long var0, int var2);

    static native int nResize(long var0, int var2);

    static native int nFindTrackedFace(long var0, int var2, long var3);

    static native int nGetIdList(long var0, int[] var2, int[] var3);

    static native int nGetLargestFace(long var0, long var2);

    static native int nRescaleAll(long var0, float var2);

    @Override
    public Iterator<TrackedFace> iterator() {
        return new Iterator<TrackedFace>(){
            private int index = 0;
            private final int size = TrackedFaceList.this.getCount();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public TrackedFace next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return TrackedFaceList.this.get(this.index++);
            }
        };
    }

    static {
        FaceNative.loadLibraries();
    }
}

