library id3_face;

// %export-begin%
export 'src/image.dart';
export 'src/image_buffer.dart';
export 'src/point_list.dart';
export 'src/image_dict.dart';
export 'src/image_list.dart';
export 'src/detected_face.dart';
export 'src/tracked_face.dart';
export 'src/detected_face_list.dart';
export 'src/face_analyser.dart';
export 'src/face_candidate.dart';
export 'src/face_candidate_list.dart';
export 'src/face_detector.dart';
export 'src/face_encoder.dart';
export 'src/face_license.dart';
export 'src/face_library.dart';
export 'src/face_matcher.dart';
export 'src/face_pad.dart';
export 'src/face_template.dart';
export 'src/string_list.dart';
export 'src/face_template_dict.dart';
export 'src/face_template_list.dart';
export 'src/face_indexer.dart';
export 'src/face_tracker.dart';
export 'src/tracked_face_list.dart';
export 'src/portrait.dart';
export 'src/portrait_processor.dart';
export 'src/image_error.dart';
export 'src/image_format.dart';
export 'src/pixel_format.dart';
export 'src/license_hardware_code_type.dart';
export 'src/license_type.dart';
export 'src/license_error.dart';
export 'src/face_attack_support.dart';
export 'src/pad_status.dart';
export 'src/face_error.dart';
export 'src/face_expression.dart';
export 'src/face_matcher_threshold.dart';
export 'src/face_model.dart';
export 'src/face_template_format.dart';
export 'src/pooling_method.dart';
export 'src/processing_unit.dart';
export 'src/tracking_status.dart';
export 'src/subject_position.dart';
export 'src/portrait_status.dart';
export 'src/face_segmentation_label.dart';
export 'src/face_exception.dart';
export 'src/point.dart';
export 'src/rectangle.dart';
export 'src/background_uniformity.dart';
export 'src/color_based_pad_result.dart';
export 'src/detected_face_attack_support.dart';
export 'src/eye_gaze.dart';
export 'src/face_attributes.dart';
export 'src/face_occlusion_scores.dart';
export 'src/face_pose.dart';
export 'src/geometric_attributes.dart';
export 'src/glasses_attributes.dart';
export 'src/photographic_attributes.dart';
export 'src/lib_version.dart';
export 'src/portrait_instruction.dart';
export 'src/portrait_quality_checkpoints.dart';
// %export-end%

import 'dart:ffi';
import 'dart:math';
import 'dart:typed_data';

extension ArrayIntFill<T> on Array<Int32> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as int;
    }
  }

  List<int> toList(int length) {
    final list = List<int>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return list;
  }
}

extension ArrayLongFill<T> on Array<Int64> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as int;
    }
  }

  List<int> toList(int length) {
    final list = List<int>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return list;
  }
}

extension ArrayInt8Fill<T> on Array<Int8> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as int;
    }
  }

  Int8List toList(int length) {
    final list = List<int>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return Int8List.fromList(list);
  }
}

extension ArrayUInt8Fill<T> on Array<Uint8> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as int;
    }
  }

  Uint8List toList(int length) {
    final list = List<int>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return Uint8List.fromList(list);
  }
}

extension ArrayFloat32Fill<T> on Array<Float> {
  void fromList(List<T> list, int len) {
    final length = min(list.length, len);
    for (var i = 0; i < length; i++) {
      this[i] = list[i] as double;
    }
  }

  List<double> toList(int length) {
    final list = List<double>.filled(length, 0);
    for (var i = 0; i < length; i++) {
      list[i] = this[i];
    }
    return list;
  }
}
